/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.crlf;

import com.oracle.cie.common.util.FileEncodingHelper;
import com.oracle.cie.common.util.crlf.CRLFException;
import com.oracle.cie.common.util.crlf.CRLFFileFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixCRLF {
    protected static final Logger s_logger = Logger.getLogger(FixCRLF.class.getName());
    private static final int UNDEF = -1;
    private static final int NOTJAVA = 0;
    private static final int LOOKING = 1;
    private static final int IN_CHAR_CONST = 2;
    private static final int IN_STR_CONST = 3;
    private static final int IN_SINGLE_COMMENT = 4;
    private static final int IN_MULTI_COMMENT = 5;
    private static final int ASIS = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CRLF = 3;
    private static final int ADD = 1;
    private static final int REMOVE = -1;
    private static final int SPACES = -1;
    private static final int TABS = 1;
    private static final int INBUFLEN = 8192;
    private static final int LINEBUFLEN = 200;
    private static final char CTRLZ = '\u001a';
    private int tablength = 8;
    private String spaces = "        ";
    private StringBuffer linebuf = new StringBuffer(1024);
    private StringBuffer linebuf2 = new StringBuffer(1024);
    private int eol;
    private String eolstr;
    private int ctrlz;
    private int tabs;
    private boolean javafiles = false;
    private File srcDir;
    private File destDir = null;
    private String wildcard = null;
    private boolean recurse = true;
    private ArrayList filesArray = new ArrayList();

    public FixCRLF(String srcDir, String destDir, String wildcard) {
        this.srcDir = new File(srcDir);
        this.destDir = new File(destDir);
        this.wildcard = wildcard;
        this.tabs = 0;
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").indexOf("Mac") > -1 && !System.getProperty("os.name").equals("Mac OS X")) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public FixCRLF(String srcDir, String wildcard) {
        this.srcDir = new File(srcDir);
        this.tabs = 0;
        this.wildcard = wildcard;
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").indexOf("Mac") > -1 && !System.getProperty("os.name").equals("Mac OS X")) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public FixCRLF() {
        this.tabs = 0;
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").indexOf("Mac") > -1 && !System.getProperty("os.name").equals("Mac OS X")) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setRecurse(String recurse) {
        this.recurse = !recurse.equalsIgnoreCase("false");
    }

    public void setJavafiles(boolean javafiles) {
        this.javafiles = javafiles;
    }

    public void setEol(String attr) {
        String option = attr;
        if (option.equals("asis")) {
            this.eol = 0;
        } else if (option.equals("cr")) {
            this.eol = 1;
            this.eolstr = "\r";
        } else if (option.equals("lf")) {
            this.eol = 2;
            this.eolstr = "\n";
        } else {
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setTab(String attr) {
        String option = attr;
        this.tabs = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void setTablength(int tlength) throws CRLFException {
        if (tlength < 2 || tlength > 80) {
            throw new CRLFException("tablength must be between 2 and 80");
        }
        this.tablength = tlength;
        StringBuffer sp = new StringBuffer();
        for (int i = 0; i < this.tablength; ++i) {
            sp.append(' ');
        }
        this.spaces = sp.toString();
    }

    public void setEof(String attr) {
        String option = attr;
        this.ctrlz = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void execute() throws CRLFException {
        if (this.srcDir == null) {
            throw new CRLFException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new CRLFException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new CRLFException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new CRLFException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new CRLFException("destdir is not a directory!");
            }
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("options: eol=" + (this.eol == 0 ? "asis" : (this.eol == 1 ? "cr" : (this.eol == 2 ? "lf" : "crlf"))) + " tab=" + (this.tabs == 1 ? "add" : (this.tabs == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength + " wildcard=" + this.wildcard);
        }
        if (this.wildcard != null) {
            CRLFFileFilter filter = new CRLFFileFilter(this.wildcard, this.recurse);
            this.generateIncludedFiles(this.srcDir, filter);
        } else {
            this.generateIncludedFiles(this.srcDir, null);
        }
        Iterator fit = this.filesArray.iterator();
        while (fit.hasNext()) {
            this.processFile(((File)fit.next()).getPath());
        }
    }

    private void generateIncludedFiles(File srcDir, CRLFFileFilter filter) {
        if (srcDir.isDirectory()) {
            File[] files = srcDir.listFiles(filter);
            for (int x = 0; x < files.length; ++x) {
                this.generateIncludedFiles(files[x], filter);
            }
        } else {
            this.filesArray.add(srcDir);
        }
    }

    private File createTempFile(File parentDir) {
        String name = "fixcrlf" + new Random(System.currentTimeMillis()).nextLong();
        if (parentDir != null) {
            return new File(parentDir, name);
        }
        if (this.destDir == null) {
            if (this.srcDir != null) {
                return new File(this.srcDir, name);
            }
            return new File(System.getProperty("java.io.tmpdir"), name);
        }
        return new File(this.destDir, name);
    }

    private boolean filesEqual(File file1, File file2) throws CRLFException {
        char[] buf1 = new char[8192];
        char[] buf2 = new char[8192];
        if (file1.length() != file2.length()) {
            return false;
        }
        try {
            int buflen;
            BufferedReader reader1 = new BufferedReader(new FileReader(file1), 8192);
            BufferedReader reader2 = new BufferedReader(new FileReader(file2), 8192);
            while ((buflen = reader1.read(buf1, 0, 8192)) != -1) {
                reader2.read(buf2, 0, 8192);
                for (int i = 0; i < buflen; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    reader1.close();
                    reader2.close();
                    return false;
                }
            }
            reader1.close();
            reader2.close();
            return true;
        }
        catch (IOException e) {
            throw new CRLFException("IOException in filesEqual: " + file1 + " : " + file2);
        }
    }

    public void processFile(String file) throws CRLFException {
        File destFile;
        File srcFile = new File(file);
        File tmpFile = this.createTempFile(srcFile.getParentFile());
        OneLiner lines = new OneLiner(srcFile);
        this.process(lines, tmpFile, lines.getEncoding());
        File file2 = destFile = this.destDir == null ? srcFile : new File(this.destDir, srcFile.getName());
        if (destFile.exists()) {
            s_logger.fine("destFile exists");
            if (!this.filesEqual(destFile, tmpFile)) {
                s_logger.fine(destFile + " is being written");
                if (!destFile.delete()) {
                    throw new CRLFException("Unable to delete " + destFile);
                }
                if (!tmpFile.renameTo(destFile)) {
                    throw new CRLFException("Failed to transform " + srcFile + " to " + destFile + ". Couldn't rename temporary file: " + tmpFile);
                }
            } else {
                s_logger.fine(destFile + " is not written, as the contents are identical");
                if (!tmpFile.delete()) {
                    throw new CRLFException("Unable to delete " + tmpFile);
                }
            }
        } else {
            s_logger.fine("destFile does not exist");
            if (!tmpFile.renameTo(destFile)) {
                throw new CRLFException("Failed to transform " + srcFile + " to " + destFile + ". Couldn't rename temporary file: " + tmpFile);
            }
        }
        if (tmpFile != null) {
            tmpFile.delete();
        }
    }

    public void processStream(InputStream is, File outputFile) throws CRLFException {
        this.processStream(is, outputFile, null);
    }

    public void processStream(InputStream is, File outputFile, String encoding) throws CRLFException {
        this.process(new OneLiner(is, encoding), outputFile, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(OneLiner lines, File outputFile, String encoding) throws CRLFException {
        String outEncoding = encoding == null ? lines.getEncoding() : encoding;
        try {
            BufferedWriter outWriter;
            try {
                if (outEncoding != null) {
                    outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outEncoding));
                } else {
                    FileWriter writer = new FileWriter(outputFile);
                    outWriter = new BufferedWriter(writer);
                }
            }
            catch (IOException e) {
                throw new CRLFException(e);
            }
            while (lines.hasMoreElements()) {
                OneLiner.BufferLine line;
                try {
                    line = (OneLiner.BufferLine)lines.nextElement();
                }
                catch (NoSuchElementException e) {
                    throw new CRLFException(e);
                }
                String lineString = line.getLineString();
                int linelen = line.length();
                if (this.tabs == 0) {
                    try {
                        outWriter.write(lineString);
                    }
                    catch (IOException e) {
                        throw new CRLFException(e);
                    }
                }
                while (line.getNext() < linelen) {
                    switch (lines.getState()) {
                        case 0: {
                            this.notInConstant(line, line.length(), outWriter);
                            break;
                        }
                        case 5: {
                            int endComment = lineString.indexOf("*/", line.getNext());
                            if (endComment >= 0) {
                                endComment += 2;
                                lines.setState(1);
                            } else {
                                endComment = linelen;
                            }
                            this.notInConstant(line, endComment, outWriter);
                            break;
                        }
                        case 4: {
                            this.notInConstant(line, line.length(), outWriter);
                            lines.setState(1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            int begin = line.getNext();
                            char terminator = lines.getState() == 3 ? (char)'\"' : '\'';
                            this.endOfCharConst(line, terminator);
                            while (line.getNext() < line.getLookahead()) {
                                if (line.getNextCharInc() == '\t') {
                                    line.setColumn(line.getColumn() + this.tablength - line.getColumn() % this.tablength);
                                    continue;
                                }
                                line.incColumn();
                            }
                            try {
                                outWriter.write(line.substring(begin, line.getNext()));
                            }
                            catch (IOException e) {
                                throw new CRLFException(e);
                            }
                            lines.setState(1);
                            break;
                        }
                        case 1: {
                            this.nextStateChange(line);
                            this.notInConstant(line, line.getLookahead(), outWriter);
                        }
                    }
                }
                try {
                    outWriter.write(this.eolstr);
                }
                catch (IOException e) {
                    throw new CRLFException(e);
                }
            }
            try {
                if (this.ctrlz == 0) {
                    outWriter.write(lines.getEofStr());
                } else if (this.ctrlz == 1) {
                    outWriter.write(26);
                }
                outWriter.close();
            }
            catch (IOException e) {
                throw new CRLFException(e);
            }
            try {
                lines.close();
                lines = null;
            }
            catch (IOException e) {
                throw new CRLFException("Unable to close source stream");
            }
        }
        finally {
            try {
                if (lines != null) {
                    lines.close();
                }
            }
            catch (IOException io) {
                s_logger.severe("Error closing stream");
            }
        }
    }

    private void nextStateChange(OneLiner.BufferLine bufline) {
        int eol = bufline.length();
        int ptr = bufline.getNext();
        while (ptr < eol) {
            switch (bufline.getChar(ptr++)) {
                case '\'': {
                    bufline.setState(2);
                    bufline.setLookahead(--ptr);
                    return;
                }
                case '\"': {
                    bufline.setState(3);
                    bufline.setLookahead(--ptr);
                    return;
                }
                case '/': {
                    if (ptr >= eol) break;
                    if (bufline.getChar(ptr) == '*') {
                        bufline.setState(5);
                        bufline.setLookahead(--ptr);
                        return;
                    }
                    if (bufline.getChar(ptr) != '/') break;
                    bufline.setState(4);
                    bufline.setLookahead(--ptr);
                    return;
                }
            }
        }
        bufline.setLookahead(ptr);
    }

    private void endOfCharConst(OneLiner.BufferLine bufline, char terminator) throws CRLFException {
        int ptr = bufline.getNext();
        int eol = bufline.length();
        ++ptr;
        while (ptr < eol) {
            char c;
            if ((c = bufline.getChar(ptr++)) == '\\') {
                ++ptr;
                continue;
            }
            if (c != terminator) continue;
            bufline.setLookahead(ptr);
            return;
        }
        throw new CRLFException("endOfCharConst: unterminated char constant");
    }

    private void notInConstant(OneLiner.BufferLine bufline, int end, BufferedWriter outWriter) throws CRLFException {
        int nextTab;
        String line = bufline.substring(bufline.getNext(), end);
        int place = 0;
        int col = bufline.getColumn();
        this.linebuf.setLength(0);
        while ((nextTab = line.indexOf(9, place)) >= 0) {
            this.linebuf.append(line.substring(place, nextTab));
            int tabspaces = this.tablength - (col += nextTab - place) % this.tablength;
            this.linebuf.append(this.spaces.substring(0, tabspaces));
            col += tabspaces;
            place = nextTab + 1;
        }
        this.linebuf.append(line.substring(place, line.length()));
        String linestring = new String(this.linebuf.toString());
        if (this.tabs == -1) {
            try {
                outWriter.write(linestring);
            }
            catch (IOException e) {
                throw new CRLFException(e);
            }
        }
        this.linebuf2.setLength(0);
        place = 0;
        col = bufline.getColumn();
        int placediff = col - 0;
        int nextStop = col + (this.tablength - col % this.tablength);
        if (nextStop - col < 2) {
            this.linebuf2.append(linestring.substring(place, nextStop - placediff));
            place = nextStop - placediff;
            nextStop += this.tablength;
        }
        while (nextStop - placediff <= linestring.length()) {
            int tabCol = nextStop;
            while (--tabCol - placediff >= place && linestring.charAt(tabCol - placediff) == ' ') {
            }
            if (nextStop - tabCol > 2) {
                this.linebuf2.append(linestring.substring(place, ++tabCol - placediff));
                this.linebuf2.append('\t');
            } else {
                this.linebuf2.append(linestring.substring(place, nextStop - placediff));
            }
            place = nextStop - placediff;
            nextStop += this.tablength;
        }
        this.linebuf2.append(linestring.substring(place, linestring.length()));
        try {
            outWriter.write(this.linebuf2.toString());
        }
        catch (IOException e) {
            throw new CRLFException(e);
        }
        bufline.setColumn(bufline.getColumn() + linestring.length());
        bufline.setNext(end);
    }

    class OneLiner
    implements Enumeration {
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private StringBuffer line;
        private boolean reachedEof;
        private String encoding;

        public OneLiner(File srcFile) throws CRLFException {
            this.state = FixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.reader = null;
            this.reachedEof = false;
            this.encoding = null;
            try {
                try {
                    this.encoding = FileEncodingHelper.detect(srcFile, 1, false);
                }
                catch (IOException ioe) {
                    s_logger.log(Level.FINE, "A problem was encountered during encoding detection, the default will be used...", ioe);
                    this.encoding = null;
                }
                if (this.encoding != null) {
                    try {
                        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), this.encoding), 8192);
                    }
                    catch (UnsupportedEncodingException uee) {
                        s_logger.log(Level.FINE, "Unsupported encoding detected:" + this.encoding + ", the default will be used...", uee);
                    }
                }
                if (this.reader == null) {
                    this.reader = new BufferedReader(new FileReader(srcFile), 8192);
                }
                this.nextLine();
            }
            catch (IOException e) {
                throw new CRLFException(e);
            }
        }

        public OneLiner(InputStream is) throws CRLFException {
            this(is, null);
        }

        public OneLiner(InputStream is, String streamenc) throws CRLFException {
            this.state = FixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.reader = null;
            this.reachedEof = false;
            this.encoding = null;
            try {
                this.encoding = streamenc;
                this.reader = this.encoding != null ? new BufferedReader(new InputStreamReader(is, this.encoding), 8192) : new BufferedReader(new InputStreamReader(is), 8192);
                this.nextLine();
            }
            catch (IOException e) {
                throw new CRLFException(e);
            }
        }

        public String getEncoding() {
            return this.encoding;
        }

        protected void nextLine() throws CRLFException {
            int ch = -1;
            int eolcount = 0;
            this.eolStr = new StringBuffer();
            this.line = new StringBuffer();
            try {
                ch = this.reader.read();
                while (ch != -1 && ch != 13 && ch != 10) {
                    this.line.append((char)ch);
                    ch = this.reader.read();
                }
                if (ch == -1 && this.line.length() == 0) {
                    this.reachedEof = true;
                    return;
                }
                block1 : switch ((char)ch) {
                    case '\r': {
                        ++eolcount;
                        this.eolStr.append('\r');
                        this.reader.mark(2);
                        ch = this.reader.read();
                        switch (ch) {
                            case 13: {
                                ch = this.reader.read();
                                if ((char)ch == '\n') {
                                    eolcount += 2;
                                    this.eolStr.append("\r\n");
                                    break block1;
                                }
                                this.reader.reset();
                                break block1;
                            }
                            case 10: {
                                ++eolcount;
                                this.eolStr.append('\n');
                                break block1;
                            }
                            case -1: {
                                break block1;
                            }
                        }
                        this.reader.reset();
                        break;
                    }
                    case '\n': {
                        ++eolcount;
                        this.eolStr.append('\n');
                    }
                }
                if (eolcount == 0) {
                    int i = this.line.length();
                    while (--i >= 0 && this.line.charAt(i) == '\u001a') {
                    }
                    if (i < this.line.length() - 1) {
                        this.eofStr.append(this.line.toString().substring(i + 1));
                        if (i < 0) {
                            this.line.setLength(0);
                            this.reachedEof = true;
                        } else {
                            this.line.setLength(i + 1);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CRLFException(e);
            }
        }

        public String getEofStr() {
            return this.eofStr.toString();
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.reachedEof;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine tmpLine = new BufferLine(this.line.toString(), this.eolStr.toString());
            try {
                this.nextLine();
            }
            catch (CRLFException e) {
                throw new NoSuchElementException("OneLiner");
            }
            return tmpLine;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        class BufferLine {
            private int next = 0;
            private int column = 0;
            private int lookahead = -1;
            private String line;
            private String eolStr;

            public BufferLine(String line, String eolStr) {
                this.line = line;
                this.eolStr = eolStr;
            }

            public int getNext() {
                return this.next;
            }

            public void setNext(int next) {
                this.next = next;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public void setLookahead(int lookahead) {
                this.lookahead = lookahead;
            }

            public char getChar(int i) {
                return this.line.charAt(i);
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getColumn() {
                return this.column;
            }

            public void setColumn(int col) {
                this.column = col;
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public String getEol() {
                return this.eolStr;
            }

            public String substring(int begin) {
                return this.line.substring(begin);
            }

            public String substring(int begin, int end) {
                return this.line.substring(begin, end);
            }

            public void setState(int state) {
                OneLiner.this.setState(state);
            }

            public int getState() {
                return OneLiner.this.getState();
            }
        }
    }
}

