/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xmldiff.XmlDiff;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlDiffSchemas {
    private Document _jaxbEpisode;
    private boolean _isPresent;

    public XmlDiffSchemas(File source) throws XmlDiffException, IOException {
        if (source.exists()) {
            if (source.isDirectory()) {
                this._jaxbEpisode = this.loadEpisodeFromDir(source);
            } else if (source.getCanonicalPath().endsWith(".jar")) {
                this._jaxbEpisode = this.loadEpisodeFromJar(source);
            } else {
                throw new XmlDiffException("Invalid file:" + source.getCanonicalPath());
            }
        }
    }

    private File getTempDir(String destDir) throws IOException {
        File tempDirFile = null;
        tempDirFile = File.createTempFile("temp", "", new File(destDir));
        Delete.delete(tempDirFile);
        if (!tempDirFile.mkdir()) {
            throw new IOException("Failed to create temporary directory for Xml Diff: " + tempDirFile);
        }
        return tempDirFile;
    }

    private File findFile(File parentFile, String fileToFind) {
        if (parentFile.isDirectory()) {
            for (File child : parentFile.listFiles()) {
                File found = this.findFile(child, fileToFind);
                if (found == null) continue;
                return found;
            }
        } else if (parentFile.getName().equals(fileToFind)) {
            return parentFile;
        }
        return null;
    }

    private String findEntry(JarHelper jarHelper, String entryToFind) {
        for (String entry : jarHelper.getEntries()) {
            if (!entry.endsWith(entryToFind)) continue;
            return entry;
        }
        return null;
    }

    private Document loadEpisodeFromJar(File jarFile) throws IOException, XmlDiffException {
        Document jaxbEpisode;
        block9: {
            jaxbEpisode = null;
            JarHelper jarHelper = null;
            File tempDir = null;
            try {
                tempDir = this.getTempDir(jarFile.getParent());
                jarHelper = new JarHelper(jarFile);
                String entry = null;
                entry = this.findEntry(jarHelper, "sun-jaxb.episode");
                if (!StringUtil.isNullOrEmpty(entry)) {
                    File episodeFile = new File(tempDir, "sun-jaxb-one.episode");
                    jarHelper.extract(entry, episodeFile);
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    jaxbEpisode = dBuilder.parse(episodeFile);
                    break block9;
                }
                throw new XmlDiffException("Could not find sun-jaxb-one.episode file in Jar " + jarFile.getCanonicalPath());
            }
            catch (SAXException e) {
                throw new XmlDiffException(e);
            }
            catch (ParserConfigurationException e) {
                throw new XmlDiffException(e);
            }
            finally {
                if (jarHelper != null) {
                    jarHelper.close();
                }
                if (tempDir != null && tempDir.exists()) {
                    Delete.delete(tempDir);
                }
            }
        }
        return jaxbEpisode;
    }

    private Document loadEpisodeFromDir(File fileOne) throws XmlDiffException, IOException {
        try {
            File episodeFile = this.findFile(fileOne, "sun-jaxb.episode");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return dBuilder.parse(episodeFile);
        }
        catch (ParserConfigurationException e) {
            throw new XmlDiffException(e);
        }
        catch (SAXException e) {
            throw new XmlDiffException(e);
        }
    }

    public List<File> diffSchemas(String schemaName, XmlDiffAspect aspect1, XmlDiffAspect aspect2) throws XmlDiffException {
        return this.diffSchemas(schemaName, aspect1, aspect2, null);
    }

    public List<File> diffSchemas(String schemaName, XmlDiffAspect aspect1, XmlDiffAspect aspect2, XmlDiffTreeFilter filter) throws XmlDiffException {
        ArrayList<File> schemaFiles = new ArrayList<File>();
        String namespace = (String)aspect1.getAttributeValue("targetNamespace");
        NodeList bindingsList = this._jaxbEpisode.getElementsByTagName("bindings");
        for (int i = 0; i < bindingsList.getLength(); ++i) {
            Element element;
            Node binding = bindingsList.item(i);
            if (binding.getNodeType() == 1 && (element = (Element)binding).getAttribute("xmlns:tns").equals(namespace)) {
                this._isPresent = true;
                if (!XmlDiff.diffAspects(aspect1, aspect2, filter).hasChange()) {
                    NodeList schemaBindings = element.getChildNodes();
                    block1: for (int j = 0; j < schemaBindings.getLength(); ++j) {
                        Element schemaElement;
                        Node schemaNode = schemaBindings.item(j);
                        if (schemaNode.getNodeType() != 1 || !(schemaElement = (Element)schemaNode).getNodeName().equals("bindings")) continue;
                        NodeList classNodes = schemaElement.getChildNodes();
                        for (int k = 0; k < classNodes.getLength(); ++k) {
                            Element classElement;
                            String classString;
                            Node classNode = classNodes.item(k);
                            if (classNode.getNodeType() != 1 || StringUtil.isNullOrEmpty(classString = (classElement = (Element)classNode).getAttribute("ref"))) continue;
                            classString = classString.replaceAll("\\.", "/");
                            schemaFiles.add(new File(classString + ".class"));
                            continue block1;
                        }
                    }
                }
            }
            if (this._isPresent) break;
        }
        return schemaFiles;
    }

    public boolean isSchemaPresent() {
        return this._isPresent;
    }

    public boolean isSchemaPresent(XmlDiffAspect aspect) {
        String namespace = (String)aspect.getAttributeValue("targetNamespace");
        NodeList bindingsList = this._jaxbEpisode.getElementsByTagName("bindings");
        for (int i = 0; i < bindingsList.getLength(); ++i) {
            Element element;
            Node binding = bindingsList.item(i);
            if (binding.getNodeType() != 1 || !(element = (Element)binding).getAttribute("xmlns:tns").equals(namespace)) continue;
            return true;
        }
        return false;
    }
}

