/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.inputs.apis.Input;
import com.oracle.cie.nextgen.common.inputs.apis.Inputs;
import com.oracle.cie.nextgen.common.inputs.apis.Option;
import com.oracle.cie.nextgen.common.inputs.apis.Options;
import com.oracle.cie.nextgen.common.inputs.apis.Variable;
import com.oracle.cie.nextgen.common.inputs.apis.Variables;
import com.oracle.cie.nextgen.common.inputs.enums.OperationModeType;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.inputs.impl.OUIOptions;
import com.oracle.cie.nextgen.common.inputs.impl.OUIVariables;
import com.oracle.cie.nextgen.common.inputs.parser.CommandLineParser;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.xmlns.oui.options.ContextEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InputsImpl
implements Inputs {
    private static Inputs inputs;
    private CommandLineParser _cmdParser;
    private Options options = new OUIOptions();
    private Variables variables;
    private Set<String> _errMsgs;
    private boolean initialized = false;

    private InputsImpl() {
    }

    public static Inputs getInstance() {
        if (inputs == null) {
            inputs = new InputsImpl();
        }
        return inputs;
    }

    @Override
    public void reset() {
        inputs = null;
    }

    public Inputs clone() {
        return InputsImpl.getInstance();
    }

    @Override
    public void configure(String optionsXml, String variablesXml) {
        this.getOptions().configure(optionsXml);
        this.getVariables().configure(variablesXml);
    }

    @Override
    public void loadOptions() throws InputHandlerException {
        this.getOptions().processCommandLine(null, true);
        this.initialized = true;
    }

    @Override
    public void loadVariables() throws InputHandlerException {
        this.getVariables().processCommandLine(null, true);
        this.initialized = true;
    }

    @Override
    public boolean parseCommandLineArgs(String[] args) throws InputHandlerException {
        return this.parseCommandLineArgs(args, false);
    }

    @Override
    public boolean parseCommandLineArgs(String[] args, boolean _processOnlyOptions) throws InputHandlerException {
        boolean varSetup;
        this._cmdParser = new CommandLineParser(args, _processOnlyOptions);
        this.initialized = true;
        boolean ignoreInvalidArgs = this._cmdParser.isOptionPassed("ignoreInvalidArgs", true);
        boolean optionSetup = this.getOptions().processCommandLine(this._cmdParser.getOptions(), ignoreInvalidArgs);
        if (!this.isHelpRequested()) {
            if (this._cmdParser.isInvalidArgsPassed() && !ignoreInvalidArgs) {
                String errMsg = NLS.getMsg("invalid.arguments", Util.getString(this._cmdParser.getInvalidArgs()));
                this.getErrorMessages().add(errMsg);
            }
            if (!optionSetup) {
                this.getErrorMessages().addAll(this.getOptions().getErrorMessages());
            }
        }
        if (!_processOnlyOptions && !(varSetup = this.getVariables().processCommandLine(this._cmdParser.getVariables(), ignoreInvalidArgs, this.isHelpRequested()))) {
            this.getErrorMessages().addAll(this.getVariables().getErrorMessages());
        }
        if (this.isHelpRequested()) {
            this.getErrorMessages().clear();
            return true;
        }
        return Util.isEmpty(this.getErrorMessages());
    }

    @Override
    public Map<String, Option> getValidOptions() {
        return this.getOptions().getValidOptions();
    }

    @Override
    public Map<String, Variable> getValidVariables() {
        return this.getVariables().getValidVariables();
    }

    @Override
    public Map<String, Variable> getInstallerVariables() {
        return this.getVariables().getInstallerVariables();
    }

    @Override
    public Map<String, Variable> getProductVariables() {
        return this.getVariables().getProductVariables();
    }

    @Override
    public Map<String, Variable> getComponentVariables() {
        return this.getVariables().getComponentVariables();
    }

    @Override
    public boolean setVariable(String name, Object value) {
        if (!this.initialized()) {
            return false;
        }
        return this.getVariables().setVariable(name, value);
    }

    @Override
    public boolean setVariables(Map<String, Object> vars) {
        if (!this.initialized()) {
            return false;
        }
        return this.getVariables().setVariables(vars);
    }

    @Override
    public boolean updateVariable(String name, String value) {
        if (!this.initialized()) {
            return false;
        }
        return this.getVariables().updateVariable(name, value);
    }

    @Override
    public boolean updateVariables(Map<String, String> variables) {
        if (!this.initialized()) {
            return false;
        }
        return this.getVariables().updateVariables(variables);
    }

    @Override
    public boolean isHelpRequested() {
        if (!this.initialized()) {
            return false;
        }
        return this.getOptions().isHelpRequested();
    }

    @Override
    public Map<String, String> getOptionsHelpDetails() {
        if (!this.initialized()) {
            return new HashMap<String, String>(0);
        }
        return this.getOptions().getHelpDetails();
    }

    @Override
    public Map<String, String> getHelpDetails() {
        if (!this.initialized()) {
            return new HashMap<String, String>(0);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.getOptions().getHelpDetails());
        map.putAll(this.getVariables().getHelpDetails());
        return map;
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            this.options = new OUIOptions();
        }
        return this.options;
    }

    @Override
    public Variables getVariables() {
        if (this.variables == null) {
            this.variables = new OUIVariables();
        }
        return this.variables;
    }

    @Override
    public Input getInput(String key) {
        if (!this.initialized()) {
            return null;
        }
        if (this.getOptions().isOptionKey(key)) {
            return this.getOptions().getOption(key);
        }
        return this.getVariables().getVariable(key);
    }

    @Override
    public Input getOptionInput(String option) {
        return this.getOptions().getOption(option);
    }

    @Override
    public Input getVariableInput(String variable) {
        return this.getVariables().getVariable(variable);
    }

    @Override
    public Set<String> getErrorMessages() {
        if (this._errMsgs == null) {
            this._errMsgs = new LinkedHashSet<String>();
        }
        return this._errMsgs;
    }

    @Override
    public String getCommandLineUsageHelp() {
        return "install.sh [-option] [-option optValue] [variable=value] [variable={value1,value2,...,valueN}]";
    }

    @Override
    public boolean setOption(String name) {
        if (!this.initialized()) {
            return false;
        }
        return this.setOption(name, null);
    }

    @Override
    public boolean setOption(String name, String value) {
        if (!this.initialized()) {
            return false;
        }
        this.getErrorMessages().clear();
        if (this.getOptions().setOption(name, value)) {
            return true;
        }
        this.getErrorMessages().addAll(this.getOptions().getErrorMessages());
        return false;
    }

    @Override
    public boolean isPostInstallOperation() {
        if (!this.initialized()) {
            return false;
        }
        return this.getOptions().isPostInstallOperation();
    }

    @Override
    public ContextEnum getInstallContext() {
        if (!this.initialized()) {
            return null;
        }
        return this.getOptions().getInstallContext();
    }

    @Override
    public Map<String, String> getJVMProperties() {
        if (this._cmdParser != null) {
            return this._cmdParser.getJVMProperties();
        }
        return new HashMap<String, String>(0);
    }

    @Override
    public Set<String> getJVMOptions() {
        if (this._cmdParser != null) {
            return this._cmdParser.getJVMOptions();
        }
        return new HashSet<String>(0);
    }

    @Override
    public boolean isOptionSet(String option) {
        if (!this.initialized()) {
            return false;
        }
        Option o = this.getOptions().getOption(option);
        if (o != null) {
            return o.isValueSet();
        }
        return false;
    }

    @Override
    public OperationModeType getOperationModeType() {
        if (!this.initialized()) {
            return null;
        }
        return this.getOptions().getOperationModeType();
    }

    @Override
    public String getOptionPrefix() {
        return this.getOptions().getOptionPrefix();
    }

    @Override
    public boolean passedAsCmdLine(String inputName) {
        if (this._cmdParser != null) {
            return this._cmdParser.isInputPresent(inputName, true);
        }
        return false;
    }

    @Override
    public String getStringValue(String inputName) {
        if (!this.initialized()) {
            return null;
        }
        Input input = this.getInput(inputName);
        if (input != null) {
            return input.getStringValue();
        }
        return null;
    }

    @Override
    public Set<String> getCommandLineOptions() {
        if (this._cmdParser == null) {
            return new HashSet<String>(0);
        }
        return this._cmdParser.getOptions().keySet();
    }

    @Override
    public Set<String> getCommandLineVariables() {
        if (this._cmdParser == null) {
            return new HashSet<String>(0);
        }
        return this._cmdParser.getVariables().keySet();
    }

    private boolean initialized() {
        return this.initialized;
    }

    @Override
    public boolean validateMandatoryVariables() {
        if (this.getVariables().validateMandatoryVariables(this.getOperationModeType())) {
            return true;
        }
        this.getErrorMessages().addAll(this.getVariables().getErrorMessages());
        return false;
    }

    @Override
    public void unsetVariable(String name) {
        if (this.initialized()) {
            this.getVariables().unsetVariable(name);
        }
    }

    @Override
    public List<String> getInvalidArgs() {
        ArrayList<String> unknown = new ArrayList<String>();
        unknown.addAll(this._cmdParser.getInvalidArgs());
        unknown.addAll(this.options.getUnknownInputs());
        return unknown;
    }
}

