/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.parser;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.inputs.apis.Variable;
import com.oracle.cie.nextgen.common.inputs.dao.variables.GroupDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.IncludeVariablesGroupRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.MutuallyExclusiveVariablesDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.MutuallyExclusiveVariablesRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.ReferenceDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.StructureDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.VariableDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.VariablesDao;
import com.oracle.cie.nextgen.common.inputs.dao.variables.VariablesInfoDao;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.inputs.impl.VariableImpl;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.xmlns.oui.variables.VariablesType;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VariablesParser
extends DaoHelper<VariablesInfoDao> {
    private static final Logger _log = Logger.getLogger(VariablesParser.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/oui/variables";
    private static final String VARIABLES_INFO = "variables-info";
    private static final String DEFAULT_VARIABLES_FILE = "/resources/variables.xml";
    private String _variablesFile = "/resources/variables.xml";
    private static final String PRODUCT_VARIABLES_FILE = "/resources/product_variables.xml";
    public static final String VARIABLES_LOCATION_PROPERTY = "variables.xml.location";
    private static VariablesParser _instance;
    private Map<String, Map<String, Variable>> _variables;
    private Map<String, VariablesInfoDao> variablesDao;
    private Map<String, Set<String>> distinctGroups;
    private boolean isCaseSensitive = false;

    public static synchronized VariablesParser getInstance() throws InputHandlerException {
        if (_instance == null) {
            _instance = new VariablesParser();
        }
        return _instance;
    }

    private VariablesParser() throws InputHandlerException {
        super(VariablesInfoDao.class);
        try {
            this.parseVariablesDao();
        }
        catch (InputHandlerException e) {
            _log.log(Level.SEVERE, "VariablesParser" + e.getMessage());
            throw e;
        }
    }

    public void configure(String variablessXml) throws InputHandlerException {
        if (!StringUtil.isNullOrEmpty((String)variablessXml)) {
            this._variablesFile = variablessXml;
        }
        try {
            this.parseVariablesDao();
        }
        catch (InputHandlerException e) {
            _log.log(Level.SEVERE, "VariablesParser" + e.getMessage());
            throw e;
        }
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getRootElement() {
        return VARIABLES_INFO;
    }

    @Override
    public String getPath() {
        return "";
    }

    private void parseVariablesDao() throws InputHandlerException {
        this.variablesDao = new LinkedHashMap<String, VariablesInfoDao>();
        this.variablesDao.put(this._variablesFile, this.getVariablesInfoDao(VariablesParser.class.getResourceAsStream(this._variablesFile)));
        this.isCaseSensitive = this.getBaseVariablesDao().isCaseSensitive();
        this.addDistinctGroups(this.getBaseVariablesDao().getStructure());
        this.processProductVariables();
    }

    private void processProductVariables() throws InputHandlerException {
        String xmlVariables = System.getProperty(VARIABLES_LOCATION_PROPERTY);
        Object[] files = Util.getStringArray(xmlVariables);
        if (!Util.isEmpty(files)) {
            for (Object file : files) {
                if (!Util.isFileExists((String)file)) continue;
                this.processProductVariablesFile((String)file);
            }
        } else {
            InputStream is = VariablesParser.class.getResourceAsStream(PRODUCT_VARIABLES_FILE);
            if (is != null) {
                VariablesInfoDao variablesInfoDao = this.getVariablesInfoDao(is);
                this.variablesDao.put(PRODUCT_VARIABLES_FILE, variablesInfoDao);
                this.addDistinctGroups(variablesInfoDao.getStructure());
            }
        }
    }

    private void processProductVariablesFile(String file) throws InputHandlerException {
        VariablesInfoDao variablesInfoDao = this.getVariablesInfoDao(file);
        if (!Util.isEmpty(variablesInfoDao.getVariables())) {
            this.variablesDao.put(file, variablesInfoDao);
            this.addDistinctGroups(variablesInfoDao.getStructure());
        }
    }

    public Map<String, Map<String, Variable>> getVariables() throws InputHandlerException {
        this.loadVariables();
        return this._variables;
    }

    private void addDistinctGroups(StructureDao structure) {
        if (this.distinctGroups == null) {
            this.distinctGroups = new HashMap<String, Set<String>>();
        }
        if (structure == null) {
            return;
        }
        List<MutuallyExclusiveVariablesDao> mutuallyExclusiveVariables = structure.getMutuallyExclusiveVariables();
        if (!Util.isEmpty(mutuallyExclusiveVariables)) {
            for (MutuallyExclusiveVariablesDao mev : mutuallyExclusiveVariables) {
                this.distinctGroups.put(mev.getName(), VariablesParser.getVariableRefs(mev.getVariables()));
            }
        }
    }

    private static Set<String> getVariableRefs(List<? extends ReferenceDao> variables) {
        if (!Util.isEmpty(variables)) {
            HashSet<String> retVal = new HashSet<String>(variables.size());
            for (ReferenceDao referenceDao : variables) {
                retVal.add(referenceDao.getName());
            }
            return retVal;
        }
        return new HashSet<String>(0);
    }

    private void loadVariables() {
        this._variables = new LinkedHashMap<String, Map<String, Variable>>();
        for (String file : this.variablesDao.keySet()) {
            VariablesInfoDao varDao = this.variablesDao.get(file);
            Path resourceDir = null;
            if (!this._variablesFile.equals(file)) {
                resourceDir = NioHelper.getInstance().getPath(file, new String[0]).getParent();
            }
            this.addVariables(varDao.getVariables(), resourceDir);
        }
    }

    private void addVariables(List<VariablesDao> variables, Path resourceDir) {
        if (Util.isEmpty(variables)) {
            return;
        }
        for (VariablesDao variablesDao : variables) {
            String type = variablesDao.getType().name();
            String resource = variablesDao.getResource();
            if (!this._variables.containsKey(type)) {
                this._variables.put(type, new HashMap(variablesDao.getVariableDao().size()));
            }
            Map<String, Variable> vars = this._variables.get(type);
            ResourceBundle rb = this.loadResourceBundle(resource, resourceDir, null);
            if (Util.isEmpty(variablesDao.getVariableDao())) continue;
            for (VariableDao variableDao : variablesDao.getVariableDao()) {
                VariableImpl var = VariablesParser.createVariable(rb, variableDao);
                vars.put(variableDao.getName(), var);
            }
        }
    }

    private static VariableImpl createVariable(ResourceBundle rb, VariableDao variableDao) {
        VariableImpl var = new VariableImpl(variableDao.getName(), variableDao.getType());
        var.setDeprecated(variableDao.isDeprecated());
        var.setSecure(variableDao.isSecure());
        var.setSuppressedOnSilent(variableDao.suppressOnSilent());
        var.setCalculate(variableDao.calculate());
        var.setAdvise(variableDao.isAdvise());
        var.setBaseClass(variableDao.getBaseClass());
        var.setVarClass(variableDao.getVarClass());
        var.setComputeAtClone(variableDao.computeAtClone());
        var.setValidate(variableDao.validate());
        var.setGenerate(variableDao.generate());
        var.setPublish(variableDao.isPublish());
        if (!Util.isNullOrBlank(variableDao.getHelpId(), true) && variableDao.isPublish() && rb != null) {
            String helpText = rb.getString(variableDao.getHelpId());
            helpText = NLS.getMsg("variable.help.display.format", variableDao.getName(), helpText);
            if (variableDao.isDeprecated()) {
                helpText = NLS.getMsg("deprecated.msg", helpText);
            }
            var.setHelp(helpText);
        }
        var.setDefaultValue(variableDao.getValue());
        var.setDefaultResponseValue(variableDao.getDefaultResponseValue());
        return var;
    }

    private static GroupDao getGroupDao(List<? extends GroupDao> groupsDao, String operation) {
        if (Util.isEmpty(groupsDao) || Util.isNullOrBlank(operation, true)) {
            return null;
        }
        GroupDao modiferDao = null;
        for (GroupDao groupDao : groupsDao) {
            if (!Util.equals(groupDao.getName(), operation)) continue;
            modiferDao = groupDao;
            break;
        }
        return modiferDao;
    }

    private Set<String> getGroupVariables(StructureDao structure, GroupDao groupDao) {
        List<IncludeVariablesGroupRefDao> aggregateGoups;
        if (groupDao == null || structure == null) {
            return new HashSet<String>(0);
        }
        HashSet<String> groupVariables = new HashSet<String>();
        groupVariables.addAll(VariablesParser.getVariableRefs(groupDao.getVariables()));
        List<MutuallyExclusiveVariablesRefDao> mutuallyExclusiveVariables = groupDao.getMutuallyExclusiveGroups();
        if (!Util.isEmpty(mutuallyExclusiveVariables)) {
            for (MutuallyExclusiveVariablesRefDao mev : mutuallyExclusiveVariables) {
                groupVariables.addAll((Collection<String>)this.distinctGroups.get(mev.getName()));
            }
        }
        if (!Util.isEmpty(aggregateGoups = groupDao.getIncludeVariablesGroups())) {
            for (IncludeVariablesGroupRefDao ag : aggregateGoups) {
                GroupDao group = VariablesParser.getGroupDao(structure.getAggregateVariables(), ag.getName());
                groupVariables.addAll(this.getGroupVariables(structure, group));
            }
        }
        return groupVariables;
    }

    public Map<String, Set<String>> getUniqueGroups() {
        return this.distinctGroups;
    }

    public Set<String> getMandatoryVariables(String operation) {
        HashSet<String> mandatoryVariables = new HashSet<String>();
        for (String file : this.variablesDao.keySet()) {
            GroupDao mandatoryVariablesDao;
            StructureDao structure = this.variablesDao.get(file).getStructure();
            if (structure == null || (mandatoryVariablesDao = VariablesParser.getGroupDao(structure.getOperationMandatoryVariables(), operation)) == null) continue;
            mandatoryVariables.addAll(this.getGroupVariables(structure, mandatoryVariablesDao));
        }
        return mandatoryVariables;
    }

    private VariablesInfoDao getBaseVariablesDao() {
        return this.variablesDao.get(this._variablesFile);
    }

    public static void reset() {
        _instance = null;
    }

    private VariablesInfoDao getVariablesInfoDao(InputStream is) throws InputHandlerException {
        if (is == null) {
            InputHandlerException ex = new InputHandlerException("variables input stream specified was invalid.");
            _log.log(Level.SEVERE, "getVariablesInfoDao" + ex.getMessage());
            throw ex;
        }
        try {
            return (VariablesInfoDao)((Object)this.getRootWrapper(is));
        }
        catch (Exception e) {
            throw new InputHandlerException(e);
        }
    }

    private VariablesInfoDao getVariablesInfoDao(String fileName) throws InputHandlerException {
        if (!Util.isFileExists(fileName, false)) {
            InputHandlerException ex = new InputHandlerException("variables file specified was invalid: " + fileName);
            _log.log(Level.SEVERE, "getVariablesInfoDao" + ex.getMessage());
            throw ex;
        }
        try {
            return (VariablesInfoDao)((Object)this.getRootWrapper(NioHelper.getInstance().getPath(fileName, new String[0])));
        }
        catch (Exception e) {
            throw new InputHandlerException(e);
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public IDataHandler createInfo() {
        return this.create(NAMESPACE, VARIABLES_INFO);
    }

    public void writeProductVariablesFile(List<VariableDao> productVars, File dir, String distName, String distVersion, String resName) throws DataHandlerException {
        this.writeProductVariablesFile(productVars, NioHelper.getInstance().getPath(dir), distName, distVersion, resName);
    }

    public void writeProductVariablesFile(List<VariableDao> productVars, Path dir, String distName, String distVersion, String resName) throws DataHandlerException {
        HashMap<VariablesType, List<VariableDao>> varMap = new HashMap<VariablesType, List<VariableDao>>(1);
        varMap.put(VariablesType.PRODUCT, productVars);
        this.writeVariableFile(varMap, dir, distName, distVersion, resName);
    }

    private void writeVariableFile(Map<VariablesType, List<VariableDao>> varMap, Path dir, String distName, String distVersion, String resName) throws DataHandlerException {
        try {
            VariablesInfoDao variablesInfo = new VariablesInfoDao(distName, distVersion);
            ArrayList<VariablesDao> varDaos = new ArrayList<VariablesDao>();
            if (!Util.isEmpty(varMap)) {
                for (VariablesType type : varMap.keySet()) {
                    List<VariableDao> vars = varMap.get((Object)type);
                    if (Util.isEmpty(vars)) continue;
                    VariablesDao dao = new VariablesDao(type.value(), "resources/" + resName);
                    dao.setVariables(vars);
                    varDaos.add(dao);
                }
            }
            variablesInfo.setVariables(varDaos);
            this.save(variablesInfo, dir);
        }
        catch (InputHandlerException e) {
            throw new DataHandlerException((Throwable)e);
        }
    }

    public void writeVariableFileWithValue(Map<String, String> values, File file, String distName, String distVersion, String resName) throws DataHandlerException, InputHandlerException {
        this.writeVariableFileWithValue(values, NioHelper.getInstance().getPath(file), distName, distVersion, resName);
    }

    public void writeVariableFileWithValue(Map<String, String> values, Path file, String distName, String distVersion, String resName) throws DataHandlerException, InputHandlerException {
        this.writeVariableFile(this.getValueUpdatedDaos(values, file), file, distName, distVersion, resName);
    }

    private Map<VariablesType, List<VariableDao>> getValueUpdatedDaos(Map<String, String> values, Path file) throws InputHandlerException {
        Map<VariablesType, List<VariableDao>> existing = this.getVariableDaos(file);
        if (!Util.isEmpty(values)) {
            HashMap<VariablesType, List<VariableDao>> variables = new HashMap<VariablesType, List<VariableDao>>();
            Map<VariablesType, List<VariableDao>> daos = this.getVariableDaoMap();
            if (!Util.isEmpty(daos)) {
                for (VariablesType type : daos.keySet()) {
                    List<VariableDao> vars = daos.get((Object)type);
                    if (Util.isEmpty(vars)) continue;
                    for (VariableDao dao : vars) {
                        if (!values.containsKey(dao.getName())) continue;
                        dao.setValue(values.get(dao.getName()));
                        if (!variables.containsKey((Object)type)) {
                            if (existing.containsKey((Object)type)) {
                                variables.put(type, existing.get((Object)type));
                            } else {
                                variables.put(type, new ArrayList());
                            }
                        }
                        if (dao.computeAtClone()) continue;
                        if (((List)variables.get((Object)type)).contains((Object)dao)) {
                            _log.finest("Replacing existing variable value: " + dao.getName());
                            ((List)variables.get((Object)type)).remove((Object)dao);
                        }
                        ((List)variables.get((Object)type)).add(dao);
                    }
                }
            }
            return variables;
        }
        return existing;
    }

    private Map<VariablesType, List<VariableDao>> getVariableDaoMap() {
        Map<VariablesType, List<VariableDao>> variables = new HashMap<VariablesType, List<VariableDao>>();
        if (!Util.isEmpty(this.variablesDao)) {
            for (String file : this.variablesDao.keySet()) {
                VariablesInfoDao infoDao = this.variablesDao.get(file);
                variables = this.extractDaos(variables, infoDao);
            }
        }
        return variables;
    }

    private Map<VariablesType, List<VariableDao>> extractDaos(Map<VariablesType, List<VariableDao>> variables, VariablesInfoDao infoDao) {
        if (infoDao != null && !Util.isEmpty(infoDao.getVariables())) {
            for (VariablesDao type : infoDao.getVariables()) {
                if (type == null || Util.isEmpty(type.getVariableDao())) continue;
                if (!variables.containsKey((Object)type.getType())) {
                    variables.put(type.getType(), new ArrayList());
                }
                variables.get((Object)type.getType()).addAll(type.getVariableDao());
            }
        }
        return variables;
    }

    public Map<VariablesType, List<VariableDao>> getVariableDaos(File variableFile) throws InputHandlerException {
        return this.getVariableDaos(NioHelper.getInstance().getPath(variableFile));
    }

    public Map<VariablesType, List<VariableDao>> getVariableDaos(Path variableFile) throws InputHandlerException {
        Map<VariablesType, List<VariableDao>> variables = new HashMap<VariablesType, List<VariableDao>>();
        if (variableFile != null && Files.exists(variableFile, new LinkOption[0])) {
            VariablesInfoDao variablesInfoDao = this.getVariablesInfoDao(variableFile.toAbsolutePath().toString());
            variables = this.extractDaos(variables, variablesInfoDao);
        }
        return variables;
    }

    public String getVariableInfoName(File variableFile) throws InputHandlerException {
        return this.getVariableInfoName(NioHelper.getInstance().getPath(variableFile));
    }

    public String getVariableInfoName(Path variableFile) throws InputHandlerException {
        if (variableFile != null && Files.exists(variableFile, new LinkOption[0])) {
            VariablesInfoDao variablesInfoDao = this.getVariablesInfoDao(variableFile.toAbsolutePath().toString());
            return variablesInfoDao.getName();
        }
        return null;
    }

    public List<VariablesDao> getResourceDir(File variableFile) throws InputHandlerException {
        return this.getResourceDir(NioHelper.getInstance().getPath(variableFile));
    }

    public List<VariablesDao> getResourceDir(Path variableFile) throws InputHandlerException {
        if (variableFile != null && Files.exists(variableFile, new LinkOption[0])) {
            VariablesInfoDao variablesInfoDao = this.getVariablesInfoDao(variableFile.toAbsolutePath().toString());
            return variablesInfoDao.getVariables();
        }
        return null;
    }

    public static boolean isCurrentOptionsFile(String variablesFile) throws InputHandlerException {
        return VariablesParser.getInstance()._variablesFile.equals(variablesFile);
    }
}

