/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchBug;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatchModel;
import oracle.opatch.opatchsdk.OPatchPatchType;
import oracle.opatch.opatchsdk.OPatchPlatform;
import oracle.opatch.opatchsdk.OPatchWLSPrereqPatch;

public abstract class OPatchAbstractPatch {
    public abstract OPatchPatchType getPatchType();

    public abstract boolean isRollbackable();

    public abstract OPatchAction[] getActions() throws OPatchException;

    public abstract OPatchAction[] getOptionalActions() throws OPatchException;

    public abstract String getInstanceShutdownMessage();

    public abstract String[] getExecutablesAffected();

    public abstract Date getCreationTime() throws OPatchException;

    public abstract Date getAppliedDate() throws OPatchException;

    public String toString() {
        try {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("\n getPatchId               = " + this.getPatchId());
            sb.append("\n getUniquePatchIdentifier = " + this.getUniquePatchIdentifier());
            sb.append("\n getPatchDescription      = " + this.getPatchDescription());
            sb.append("\n getCreationTime          = " + this.getCreationTime());
            try {
                sb.append("\n getAppliedTime           = " + this.getAppliedDate());
            }
            catch (OPatchException e) {
                // empty catch block
            }
            if (this.getPatchLanguage() != null) {
                sb.append("\n getPatchLanguage         = " + this.getPatchLanguage().toString());
            }
            sb.append("\n getPatchLocation         = " + this.getPatchLocation());
            if (this.getPatchType() != null) {
                sb.append("\n getPatchType             = " + this.getPatchType().toString());
            } else {
                sb.append("\n Patch Type is INVALID.");
            }
            sb.append("\n getProductFamily         = " + this.getProductFamily());
            if (this.getPatchModel() != null) {
                sb.append("\n getPatchModel            = " + this.getPatchModel().toString());
            } else {
                sb.append("\n Patch Model is INVALID.");
            }
            sb.append("\n getActions()             = ");
            for (i = 0; i < this.getActions().length; ++i) {
                sb.append(this.getActions()[i] + "\n                            ");
            }
            sb.append("\n getBugs()                = ");
            for (i = 0; i < this.getBugs().length; ++i) {
                sb.append(this.getBugs()[i] + "\n                            ");
            }
            sb.append("\n getPrereqBugIDs()        = ");
            for (i = 0; i < this.getPrereqBugIDs().length; ++i) {
                sb.append(this.getPrereqBugIDs()[i] + "\n                            ");
            }
            sb.append("\n getComponentsAffected()  = ");
            for (i = 0; i < this.getComponentsAffected().length; ++i) {
                sb.append(this.getComponentsAffected()[i] + "\n                            ");
            }
            sb.append("\n getExecutablesAffected() = ");
            for (i = 0; i < this.getExecutablesAffected().length; ++i) {
                sb.append(this.getExecutablesAffected()[i] + "\n                            ");
            }
            sb.append("\n getOptionalComponents()  = ");
            for (i = 0; i < this.getOptionalComponents().length; ++i) {
                sb.append(this.getOptionalComponents()[i] + "\n                            ");
            }
            sb.append("\n getPlatforms()           = ");
            for (i = 0; i < this.getPlatforms().length; ++i) {
                sb.append(this.getPlatforms()[i] + "\n                            ");
            }
            sb.append("\n getRequiredComponents()  = ");
            for (i = 0; i < this.getRequiredComponents().length; ++i) {
                sb.append(this.getRequiredComponents()[i] + "\n                            ");
            }
            sb.append("\n getWlsPrereqOneOffs()    = ");
            for (i = 0; i < this.getWlsPrereqPatchIDs().length; ++i) {
                sb.append(this.getWlsPrereqPatchIDs()[i] + "\n                            ");
            }
            sb.append("\n getPrereqOneOffs()       = ");
            for (i = 0; i < this.getPrereqPatchIDs().length; ++i) {
                sb.append(this.getPrereqPatchIDs()[i] + "\n                            ");
            }
            sb.append("\n getOverLayOneOffs()      = ");
            for (i = 0; i < this.getOverLayPatchIDs().length; ++i) {
                sb.append(this.getOverLayPatchIDs()[i] + "\n                            ");
            }
            sb.append("\n isAutoPatch              = " + this.isAutoPatch());
            sb.append("\n isInstanceShutdownPatch  = " + this.isInstanceShutdownPatch());
            sb.append("\n getInstanceShutdownMsg   = " + this.getInstanceShutdownMessage());
            sb.append("\n isOnlinePatch            = " + this.isOnlinePatch());
            sb.append("\n isPatchSet               = " + this.isPatchSetUpdate());
            sb.append("\n isRollbackable           = " + this.isRollbackable());
            sb.append("\n isRollingPatch           = " + this.isRollingPatch());
            sb.append("\n isTranslatable           = " + this.isTranslatable());
            sb.append("\n");
            return sb.toString();
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return "";
        }
    }

    public abstract OPatchPatchModel getPatchModel();

    public abstract OPatchComponent[] getRequiredComponents();

    public abstract boolean isTranslatable();

    public abstract boolean isAutoPatch();

    public abstract String[] getPrereqBugIDs();

    public abstract String getPatchId();

    public abstract String getPatchLanguageId();

    public abstract OPatchAction[] getRequiredActions() throws OPatchException;

    public abstract String getPatchDescription();

    public abstract String getPatchLocation();

    public abstract boolean isPatchSetUpdate();

    public abstract String[] getOverLayPatchIDs();

    public abstract OPatchBug[] getBugs();

    public abstract boolean isOnlinePatch();

    public abstract String getUniquePatchIdentifier();

    public abstract String getProductFamily();

    public abstract boolean isRollingPatch();

    public abstract OPatchComponent[] getOptionalComponents();

    public abstract OPatchComponent[] getComponentsAffected();

    public abstract Properties getPatchInterviewList() throws OPatchException;

    public abstract String[] getMandatoryInterviewKeys() throws OPatchException;

    public abstract String[] getAllInterviewKeys() throws OPatchException;

    public abstract Locale getPatchLanguage();

    public abstract boolean isInstanceShutdownPatch();

    public abstract OPatchWLSPrereqPatch[] getWlsPrereqPatchIDs();

    public abstract String[] getPrereqPatchIDs();

    public abstract OPatchPlatform[] getPlatforms();
}

