/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import oracle.opatch.opatchsdk.OPatchStepOperation;

public class OPatchExecutionStep {
    private boolean isOperationSuccess = true;
    private boolean isRecoverySuccess = true;
    private OPatchStepOperation executionStep = null;
    private ArrayList<OPatchStepOperation> recoverySteps = null;

    protected void setOperationSuccess(boolean in) {
        this.isOperationSuccess = in;
    }

    protected void setRecoverySuccess(boolean in) {
        this.isRecoverySuccess = in;
    }

    protected void setExecutionStep(OPatchStepOperation executionStep) {
        this.executionStep = executionStep;
    }

    protected void addRecoveryStep(OPatchStepOperation recoveryStep) {
        if (this.recoverySteps == null) {
            this.recoverySteps = new ArrayList();
        }
        this.recoverySteps.add(recoveryStep);
    }

    public boolean isOperationSuccess() {
        if (this.executionStep == null) {
            return false;
        }
        return this.executionStep.isSuccess();
    }

    public boolean isRecoverySuccess() {
        if (this.recoverySteps == null || this.recoverySteps.size() == 0) {
            return false;
        }
        boolean isRecovery = true;
        OPatchStepOperation[] steps = this.getRecoverySteps();
        for (int i = 0; i < steps.length; ++i) {
            OPatchStepOperation step = steps[i];
            if (step.isSuccess()) continue;
            isRecovery = false;
            break;
        }
        return isRecovery;
    }

    public OPatchStepOperation getExecutionStep() {
        return this.executionStep;
    }

    public OPatchStepOperation[] getRecoverySteps() {
        if (this.recoverySteps == null) {
            return new OPatchStepOperation[0];
        }
        OPatchStepOperation[] steps = new OPatchStepOperation[this.recoverySteps.size()];
        this.recoverySteps.toArray(steps);
        return steps;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        if (this.executionStep == null) {
            buff.append("[No granular step available]");
            return buff.toString();
        }
        buff.append(this.executionStep.toString() + "\n");
        if (this.isOperationSuccess) {
            return buff.toString();
        }
        if (this.recoverySteps == null || this.recoverySteps.size() == 0) {
            buff.append("   [No recovery steps, Recovery Status : \"n/a\"]\n");
            return buff.toString();
        }
        buff.append("   [Consolidated Recovery Status: " + this.isRecoverySuccess + "]\n");
        buff.append("   [Recovery step(s):\n");
        for (int i = 0; i < this.recoverySteps.size(); ++i) {
            OPatchStepOperation step = this.recoverySteps.get(i);
            buff.append("   [Recovery Step " + i + ": " + "   " + step.toString() + "]\n");
            if (i != this.recoverySteps.size() - 1) continue;
            buff.append("]");
        }
        return buff.toString();
    }
}

