/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import model.common.AbstractBaseTarget;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchDeployException;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchFATarget;
import oracle.opatch.opatchsdk.OPatchStandAloneDeployAction;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUtils;

public class OPatchStandAloneSOADeployAction
extends OPatchStandAloneDeployAction {
    private String soaCompositeName = "";
    private String soaCompositeRevision = "";
    private WLDomain domainInfo;
    private String[] revHistory = new String[0];

    protected OPatchStandAloneSOADeployAction(String deployName, String relativeDeployPath) {
        super(deployName, relativeDeployPath);
    }

    @Override
    protected Map constructMap() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        Map superEnv = super.constructMap();
        env.putAll(superEnv);
        WLAdminServer adminServer = this.domainInfo.getWLAdminServer();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.COMMON_COMPONENTS_HOME", this.getCommonComponentsHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        env.put("CompRevisionsToUndoDeploy", this.revHistory);
        return env;
    }

    public void setSOACompositeName(String soaCompositeName) throws OPatchException {
        if (!this.soaCompositeName.equals("")) {
            throw new OPatchException("Please do not set the SOA composite name more than once (in the same object).");
        }
        this.soaCompositeName = soaCompositeName;
    }

    public void setSOACompositeRevision(String revision) throws OPatchException {
        if (!this.soaCompositeRevision.equals("")) {
            throw new OPatchException("Please do not set the SOA composite revision more than once (in the same object).");
        }
        this.soaCompositeRevision = revision;
    }

    public String getSOACompositeName() {
        return this.soaCompositeName;
    }

    public String getSOACompositeRevision() {
        return this.soaCompositeRevision;
    }

    public WLDomain getBoundDomain() {
        return this.domainInfo;
    }

    public void bindToClone(OPatchFAClonedConfigInstance faInstance, WLDomain domainInfo) throws OPatchException {
        if (faInstance == null) {
            throw new OPatchException("Please provide a non-null <OPatchFAClonedConfigInstance> object.");
        }
        if (!OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)domainInfo)) {
            throw new OPatchException("The system model object could not be binded to cloned config instances.");
        }
        this.setBoundToConfigInstance(true);
        this.domainInfo = domainInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy() throws OPatchDeployException {
        OPatchStepOperation prereqStep;
        String errorMsg;
        FMWClient client = null;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        this.setFailedClosingStep(null);
        String oracleHomePath = "";
        String logFile = "";
        boolean updatePrereqFailure = false;
        OPatchDeployException de = null;
        try {
            oracleHomePath = OPatchUtils.norm(this.getOracleHome());
            try {
                String compName = OPatchUtils.norm(this.getSOACompositeName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, OPatchFATarget.getStandAloneDeployTimeStamp(), "Deploy_Composite_" + compName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                String errorMsg3 = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                String stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg3, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg3);
            }
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg, errorMsg, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            client.deploy();
            OPatchUtils.updatePrereq(client, this);
            updatePrereqFailure = true;
            prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                throw new OPatchDeployException("OPatch failed in prerequisite checks prior to deploy.");
            }
        }
        catch (Throwable t) {
            try {
                if (!updatePrereqFailure) {
                    OPatchUtils.updatePrereq(client, this);
                    updatePrereqFailure = true;
                }
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchDeployException re = new OPatchDeployException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                de = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg4, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                OPatchStepOperation prereqStep2 = this.getFailedPrereqStep();
                if (prereqStep2 != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (de == null) return;
                    throw de;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                this.setExecLogFile(execLog);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), OPatchFATarget.getStandAloneDeployTimeStamp(), this);
                execLog = this.getExecLogFile();
                if (client != null) {
                    SOAComposite s = client.getSOAComposite();
                    String revBeforeDeploy = s.getDefaultRevisionBeforeDeploy();
                    String revAfterDeploy = s.getDefaultRevisionAfterDeploy();
                    String soaCompName = s.getName();
                    boolean failure = false;
                    if (de != null) {
                        failure = true;
                    }
                    OPatchUtils.updateConfig(this.domainInfo, soaCompName, revBeforeDeploy, revAfterDeploy, failure, client.getSOAHost(), client.getSOAPort());
                    this.setConfigLogFile(configLog);
                    OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getStandAloneDeployTimeStamp(), this);
                    configLog = this.getConfigLogFile();
                    client.close();
                }
                if (de == null) return;
                throw de;
            }
        }
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        prereqStep = this.getFailedPrereqStep();
        if (prereqStep != null) {
            if (client != null) {
                client.close();
            }
            if (de == null) return;
            throw de;
        }
        OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
        this.setExecLogFile(execLog);
        OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), OPatchFATarget.getStandAloneDeployTimeStamp(), this);
        execLog = this.getExecLogFile();
        if (client != null) {
            SOAComposite s = client.getSOAComposite();
            String revBeforeDeploy = s.getDefaultRevisionBeforeDeploy();
            String revAfterDeploy = s.getDefaultRevisionAfterDeploy();
            String soaCompName = s.getName();
            boolean failure = false;
            if (de != null) {
                failure = true;
            }
            OPatchUtils.updateConfig(this.domainInfo, soaCompName, revBeforeDeploy, revAfterDeploy, failure, client.getSOAHost(), client.getSOAPort());
            this.setConfigLogFile(configLog);
            OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getStandAloneDeployTimeStamp(), this);
            configLog = this.getConfigLogFile();
            client.close();
        }
        if (de == null) return;
        throw de;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        String errorMsg;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        FMWClient client = null;
        String oracleHomePath = this.getOracleHome();
        String logFile = "";
        this.setLogFile(logFile);
        OPatchException oe = null;
        try {
            String stepMsg;
            String errorMsg2;
            try {
                String compName = OPatchUtils.norm(this.getSOACompositeName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, OPatchFATarget.getStandAloneDeployTimeStamp(), "Prereq_Composite_" + compName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg3 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg3, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg2 = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg2, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg2);
            }
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg3 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg3, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                if (operation != OPatchFAOperation.PREREQ_DEPLOY) {
                    errorMsg2 = "OPatch does not support the operation \"" + operation.toString() + "\" for this artifact.";
                    stepMsg = "Check if operation \"" + operation.toString() + "\" is supported.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_OPERATION_SUPPORTED, stepMsg, errorMsg2, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    OPatchException re = new OPatchException(errorMsg2);
                    throw re;
                }
                client.prereq(true);
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException("OPatch fails in prereq on the artifact. " + t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        catch (Throwable t) {
            try {
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                oe = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                OPatchUtils.updatePrereq(client, this);
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg5 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg5, errorMsg4, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                if (client != null) {
                    client.close();
                }
                if (oe == null) return;
                throw oe;
            }
        }
        OPatchUtils.updatePrereq(client, this);
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg4 = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg4, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        if (client != null) {
            client.close();
        }
        if (oe == null) return;
        throw oe;
    }

    @Override
    public Object clone() {
        OPatchStandAloneSOADeployAction dAction = (OPatchStandAloneSOADeployAction)super.clone();
        try {
            dAction.setSOACompositeName(this.getSOACompositeName());
            dAction.setSOACompositeRevision(this.getSOACompositeRevision());
        }
        catch (OPatchException oPatchException) {
            // empty catch block
        }
        return dAction;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String fileName = this.getDeployFileName();
        String filePath = this.getCompleteDeployFilePath();
        String compositeName = this.getSOACompositeName();
        String compositeRevision = this.getSOACompositeRevision();
        buff.append("[SOA Composite Deploy: fileName = " + fileName + "");
        buff.append(", filePath = " + filePath + ", compositeName = " + compositeName + "");
        buff.append(", revision = " + compositeRevision + "]");
        return buff.toString();
    }
}

