/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class OCSPResponderConfig
implements Cloneable {
    private static final String a = "SHA1withRSA";
    private static final String b = "SHA1";
    private X509Certificate c;
    private boolean d;
    private boolean e;
    private boolean f;
    private int g = 5;
    private PrivateKey h;
    private String i;
    private List<X509Certificate> j;
    private String k;
    private String l;
    private String m = "SHA1";

    public OCSPResponderConfig() {
        this(null, null);
    }

    public OCSPResponderConfig(String string) {
        this(string, null);
    }

    public OCSPResponderConfig(String string, X509Certificate x509Certificate) {
        this.k = string;
        this.c = x509Certificate;
    }

    public void setDelegatedResponderCertRevocationEnabled(boolean bl2) {
        this.f = bl2;
    }

    public void setOCSPResponderProxy(String string) {
        this.l = string;
    }

    public void setResponderURL(String string) {
        this.k = string;
    }

    public void setTrustedResponderCert(X509Certificate x509Certificate) {
        this.c = x509Certificate;
    }

    public void setSignOCSPRequest(PrivateKey privateKey, List<X509Certificate> list) {
        this.setSignOCSPRequest(privateKey, null, list);
    }

    public void setSignOCSPRequest(PrivateKey privateKey, String string, List<X509Certificate> list) {
        if (privateKey == null || list == null) {
            throw new InvalidParameterException("Inputs should not be null");
        }
        if (list.size() < 1) {
            throw new InvalidParameterException("Must specify at least one certificate.");
        }
        this.h = privateKey;
        this.i = string == null ? a : string;
        this.j = new ArrayList<X509Certificate>(list);
        this.d = true;
    }

    public void setTimeTolerance(int n2) {
        this.g = n2;
    }

    public void setUseNonce(boolean bl2) {
        this.e = bl2;
    }

    public void setDigestAlgorithm(String string) {
        this.m = string;
    }

    public X509Certificate getTrustedResponderCert() {
        return this.c;
    }

    public String getOCSPResponderURL() {
        return this.k;
    }

    public String getOCSPProxy() {
        return this.l;
    }

    public List<X509Certificate> getExtraCerts() {
        return new ArrayList<X509Certificate>(this.j);
    }

    public PrivateKey getSigningKey() {
        return this.h;
    }

    public String getSigningAlgorithm() {
        return this.i;
    }

    public int getTimeTolerance() {
        return this.g;
    }

    public String getDigestAlgorithm() {
        return this.m;
    }

    public boolean isResponderRevocationCheckingEnabled() {
        return this.c == null && this.f;
    }

    public boolean isNonceInUse() {
        return this.e;
    }

    public boolean isSigningEnabled() {
        return this.d;
    }

    public Object clone() {
        OCSPResponderConfig oCSPResponderConfig;
        try {
            oCSPResponderConfig = (OCSPResponderConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Object.clone() unexpectedly threw CloneNotSupportedException.");
        }
        if (this.j != null) {
            oCSPResponderConfig.j = new ArrayList<X509Certificate>(this.j);
        }
        return oCSPResponderConfig;
    }
}

