/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crl;

import com.rsa.cryptoj.e.cg;
import com.rsa.cryptoj.e.ch;
import com.rsa.cryptoj.e.oz;
import com.rsa.cryptoj.e.pp;
import com.rsa.cryptoj.e.pt;
import com.rsa.cryptoj.e.pv;
import com.rsa.cryptoj.e.rl;
import com.rsa.jsafe.cert.IssuerInformation;
import com.rsa.jsafe.crl.CRLCreationException;
import com.rsa.jsafe.crl.CRLCreationParameterSpec;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.b;
import java.security.SecureRandom;
import java.security.cert.X509CRL;

public final class CRLCreationFactory {
    private final rl a;

    private CRLCreationFactory(oz oz2, ch ch2, SecureRandom secureRandom) {
        this.a = new rl(ch2, oz2, secureRandom);
    }

    public static CRLCreationFactory getInstance(String string) {
        return CRLCreationFactory.a(string, cg.a(), null);
    }

    public static CRLCreationFactory getInstance(String string, FIPS140Context fIPS140Context) {
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        return CRLCreationFactory.a(string, b.a(fIPS140Context), null);
    }

    public static CRLCreationFactory getInstance(String string, SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CRLCreationFactory.a(string, cg.a(), secureRandom);
    }

    public static CRLCreationFactory getInstance(String string, FIPS140Context fIPS140Context, SecureRandom secureRandom) {
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CRLCreationFactory.a(string, b.a(fIPS140Context), secureRandom);
    }

    private static CRLCreationFactory a(String string, ch ch2, SecureRandom secureRandom) {
        if (string == null) {
            throw new IllegalArgumentException("Validation type is null");
        }
        if (string.equalsIgnoreCase("X.509-SuiteB")) {
            return new CRLCreationFactory(new pv(), ch2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-Strict") || string.equalsIgnoreCase("X.509")) {
            return new CRLCreationFactory(new pt(), ch2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-NoValidation")) {
            return new CRLCreationFactory(new pp(), ch2, secureRandom);
        }
        throw new IllegalArgumentException("Unknown/unsupported validation type");
    }

    public X509CRL generateCRL(IssuerInformation issuerInformation, CRLCreationParameterSpec cRLCreationParameterSpec) throws CRLCreationException {
        return this.a.a(issuerInformation, cRLCreationParameterSpec);
    }
}

