/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crl;

import com.rsa.cryptoj.e.a;
import com.rsa.cryptoj.e.aa;
import com.rsa.cryptoj.e.b;
import com.rsa.cryptoj.e.d;
import com.rsa.cryptoj.e.dj;
import com.rsa.cryptoj.e.dn;
import com.rsa.cryptoj.e.dw;
import com.rsa.jsafe.cert.AccessDescription;
import com.rsa.jsafe.cert.AuthorityKeyIdentifier;
import com.rsa.jsafe.cert.DistributionPoint;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.ObjectID;
import com.rsa.jsafe.crl.IssuingDistributionPoint;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class X509CRLExtensionSpec
implements Cloneable {
    private Set<ObjectID> a = new HashSet<ObjectID>();
    private AuthorityKeyIdentifier b;
    private List<GeneralName> c;
    private BigInteger d;
    private BigInteger e;
    private List<DistributionPoint> f;
    private List<AccessDescription> g;
    private List<byte[]> h;
    private IssuingDistributionPoint i;
    private boolean j;

    public void setAuthorityKeyIdentifier(AuthorityKeyIdentifier authorityKeyIdentifier) {
        if (authorityKeyIdentifier == null) {
            throw new IllegalArgumentException("Authority key identifier is null");
        }
        this.b = authorityKeyIdentifier;
    }

    public void setIssuerAlternativeNames(List<GeneralName> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("names is null or contains null entries.");
        }
        this.c = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public void setCRLNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("CRL number is null");
        }
        this.d = bigInteger;
    }

    public void setDeltaCRL(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Base CRL number is null");
        }
        this.e = bigInteger;
        this.j = true;
    }

    public void setFreshestCRL(List<DistributionPoint> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("freshestCRL distribution point is null or contains null elements");
        }
        this.f = Collections.unmodifiableList(new ArrayList<DistributionPoint>(list));
    }

    public void setIssuingDistributionPoint(IssuingDistributionPoint issuingDistributionPoint) {
        if (issuingDistributionPoint == null) {
            throw new IllegalArgumentException("IssuingDistributionPoint is null");
        }
        this.i = (IssuingDistributionPoint)issuingDistributionPoint.clone();
    }

    public void setAuthorityInformationAccess(List<AccessDescription> list) {
        if (list == null || list.contains(null) || list.isEmpty()) {
            throw new IllegalArgumentException("Authority Access Information is null or empty or contains null elements");
        }
        this.g = Collections.unmodifiableList(new ArrayList<AccessDescription>(list));
    }

    public void setCriticalExtnOIDS(Set<ObjectID> set) {
        if (set == null || set.contains(null)) {
            throw new IllegalArgumentException("Critical extension set is null or contains null elements");
        }
        this.a = new HashSet<ObjectID>(set);
    }

    public void addCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.a.add(objectID);
    }

    public void addOtherExtension(byte[] byArray) throws InvalidEncodingException {
        if (byArray == null) {
            throw new IllegalArgumentException("Encoded extension is null");
        }
        try {
            com.rsa.cryptoj.e.a.a("Extension", byArray, 0);
        }
        catch (b b2) {
            throw new InvalidEncodingException("Invalid extension encoding.");
        }
        if (this.h == null) {
            this.h = new ArrayList<byte[]>();
        }
        this.h.add(dj.a(byArray));
    }

    public void removeCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.a.remove(objectID);
    }

    public List<GeneralName> getIssuerAlternativeNames() {
        return this.c;
    }

    public Set<ObjectID> getCriticalExtOIDS() {
        return new HashSet<ObjectID>(this.a);
    }

    public AuthorityKeyIdentifier getAuthKeyId() {
        return this.b;
    }

    public BigInteger getCRLNumber() {
        return this.d;
    }

    public BigInteger getBaseCRLNumber() {
        return this.e;
    }

    public boolean isDeltaCRL() {
        return this.j;
    }

    public List<DistributionPoint> getFreshestCRL() {
        return this.f;
    }

    public List<AccessDescription> getAuthorityAccessInformation() {
        return this.g;
    }

    public IssuingDistributionPoint getIssuingDistributionPoint() {
        return this.i == null ? null : (IssuingDistributionPoint)this.i.clone();
    }

    public List<byte[]> getOtherExtensions() {
        if (this.h == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        dw.a(arrayList, this.h);
        return arrayList;
    }

    public Object clone() {
        try {
            X509CRLExtensionSpec x509CRLExtensionSpec = (X509CRLExtensionSpec)super.clone();
            x509CRLExtensionSpec.a = new HashSet<ObjectID>(this.a);
            x509CRLExtensionSpec.h = dj.a(this.h);
            return x509CRLExtensionSpec;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone could not be created", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X509CRLExtensionSpec x509CRLExtensionSpec = (X509CRLExtensionSpec)object;
        return dw.b(this.a, x509CRLExtensionSpec.a) && dw.b(this.g, x509CRLExtensionSpec.g) && dw.b(this.f, x509CRLExtensionSpec.f) && dw.b(this.c, x509CRLExtensionSpec.c) && dw.b(this.h, x509CRLExtensionSpec.h) && dw.a(this.b, x509CRLExtensionSpec.b) && dw.a(this.e, x509CRLExtensionSpec.e) && dw.a(this.d, x509CRLExtensionSpec.d) && dw.a(this.i, x509CRLExtensionSpec.i);
    }

    public int hashCode() {
        int n2 = dn.a(7, this.a);
        n2 = dn.a(n2, this.g);
        n2 = dn.a(n2, this.f);
        n2 = dn.a(n2, this.c);
        n2 = dn.a(n2, this.h);
        n2 = dn.a(n2, this.b);
        n2 = dn.a(n2, this.e);
        n2 = dn.a(n2, this.d);
        n2 = dn.a(n2, this.i);
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRL Extension Spec [").append(dw.a);
        if (this.b != null) {
            stringBuffer.append("      ").append(this.b.toString());
        }
        if (this.g != null) {
            stringBuffer.append("      ").append("Authority Access Information [").append(dw.a);
            for (AccessDescription object : this.g) {
                stringBuffer.append("      ").append(object.toString()).append(dw.a);
            }
            stringBuffer.append("      ").append("]").append(dw.a);
        }
        if (this.e != null) {
            stringBuffer.append("      ").append("Base CRL Number [").append(this.e.toString()).append("]").append(dw.a);
        }
        if (this.d != null) {
            stringBuffer.append("      ").append("CRL Number [").append(this.d.toString()).append("]").append(dw.a);
        }
        if (this.f != null) {
            stringBuffer.append("      ").append("Freshest CRL Distribution Points [").append(dw.a);
            for (DistributionPoint distributionPoint : this.f) {
                stringBuffer.append("      ").append(distributionPoint.toString()).append(dw.a);
            }
            stringBuffer.append("      ").append("]").append(dw.a);
        }
        if (this.c != null) {
            stringBuffer.append("      ").append("Issuer Alt Names [").append(dw.a);
            for (GeneralName generalName : this.c) {
                stringBuffer.append("      ").append("   ").append(generalName.toString()).append(dw.a);
            }
            stringBuffer.append("      ").append("]").append(dw.a);
        }
        if (this.i != null) {
            stringBuffer.append("      ").append(this.i.toString());
        }
        if (this.h != null) {
            stringBuffer.append("      ").append("      ").append("Other Extensions: [").append(dw.a);
            for (byte[] byArray : this.h) {
                d d2 = com.rsa.cryptoj.e.a.a("Extension", byArray, 0);
                aa aa2 = (aa)d2.a(0);
                stringBuffer.append("      ").append("Extension OID.").append(aa2).append(", ").append("Value: ").append(d2.a(2)).append("]").append(dw.a);
            }
            stringBuffer.append("      ").append("]").append(dw.a);
        }
        stringBuffer.append("      ").append("Critical Extensions [").append(dw.a);
        for (ObjectID objectID : this.a) {
            stringBuffer.append("      ").append(objectID).append(",");
        }
        stringBuffer.append("      ").append("]").append(dw.a);
        stringBuffer.append("   ").append("]").append(dw.a);
        return stringBuffer.toString();
    }
}

