/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.oplan;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogInfo {
    final Logger logger = Logger.getLogger(OPlan.class.getName());
    File logDir;
    File machineReadableLogs;
    File hiddenFilesDir;
    private HashMap<Operation, String> oper2file = new HashMap();

    public LogInfo(File logdir) {
        this.oper2file.put(Operation.APPLY, "ApplyInstructions");
        this.oper2file.put(Operation.ROLLBACK, "RollbackInstructions");
        String datestr = OPlan.getInstance().getOPlanEnv().getSessionID();
        this.logDir = new File(logdir, datestr).getAbsoluteFile();
        this.logDir.mkdir();
        this.machineReadableLogs = new File(this.logDir, "machine-readable");
        this.machineReadableLogs.mkdir();
        this.hiddenFilesDir = new File(this.logDir, ".tmp");
        this.hiddenFilesDir.mkdir();
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getHiddenFilesDir() {
        return this.hiddenFilesDir;
    }

    public File getLogFile() {
        return new File(this.logDir, "log.txt");
    }

    public File getReadmeTxt() {
        String name = this.oper2file.get(OPlan.getInstance().getOPlanEnv().getOperation());
        return new File(this.logDir, name + ".txt");
    }

    public File getReadmeTxt(int index) {
        String name = this.oper2file.get(OPlan.getInstance().getOPlanEnv().getOperation());
        return new File(this.logDir, name + "_" + index + ".txt");
    }

    public File getReadmeHtml(int index) {
        String name = this.oper2file.get(OPlan.getInstance().getOPlanEnv().getOperation());
        return new File(this.logDir, name + "_" + index + ".html");
    }

    public File getReadmeHtml() {
        String name = this.oper2file.get(OPlan.getInstance().getOPlanEnv().getOperation());
        return new File(this.logDir, name + ".html");
    }

    private List<File> getFileListOfReadme(String name, String postfix) {
        File file;
        ArrayList<File> fileList = new ArrayList<File>();
        int index = 1;
        while ((file = new File(this.logDir, name + "_" + index + postfix)).isFile()) {
            fileList.add(file);
            ++index;
        }
        return fileList;
    }

    public List<File> getApplyReadmeHtml() {
        ArrayList<File> fileList = new ArrayList<File>();
        String name = this.oper2file.get(Operation.APPLY);
        String postfix = ".html";
        File file = new File(this.logDir, name + postfix);
        if (file.isFile()) {
            fileList.add(file);
            return fileList;
        }
        return this.getFileListOfReadme(name, postfix);
    }

    public List<File> getApplyReadmeTxt() {
        ArrayList<File> fileList = new ArrayList<File>();
        String name = this.oper2file.get(Operation.APPLY);
        String postfix = ".txt";
        File file = new File(this.logDir, name + postfix);
        if (file.isFile()) {
            fileList.add(file);
            return fileList;
        }
        return this.getFileListOfReadme(name, postfix);
    }

    public List<File> getRollbackReadmeHtml() {
        ArrayList<File> fileList = new ArrayList<File>();
        String name = this.oper2file.get(Operation.ROLLBACK);
        String postfix = ".html";
        File file = new File(this.logDir, name + postfix);
        if (file.isFile()) {
            fileList.add(file);
            return fileList;
        }
        return this.getFileListOfReadme(name, postfix);
    }

    public List<File> getRollbackReadmeTxt() {
        ArrayList<File> fileList = new ArrayList<File>();
        String name = this.oper2file.get(Operation.ROLLBACK);
        String postfix = ".txt";
        File file = new File(this.logDir, name + postfix);
        if (file.isFile()) {
            fileList.add(file);
            return fileList;
        }
        return this.getFileListOfReadme(name, postfix);
    }

    public File getPatchPlan() {
        return new File(this.logDir, "patch.plan");
    }

    public File getPrunedConfig() {
        return new File(this.logDir, "prunedconfig.graphml");
    }

    public File getConfigXml() {
        return new File(this.machineReadableLogs, "configData.xml");
    }

    public File getFullConfig() {
        return new File(this.machineReadableLogs, "config.graphml");
    }

    public File getConfigImageFile() {
        return new File(this.logDir, "configuration.png");
    }

    public File getAutomationXmlDir() {
        File automationDir = new File(this.machineReadableLogs, "automations");
        automationDir.mkdirs();
        return automationDir;
    }

    public File getLogsReadme() {
        return new File(this.logDir, "README");
    }

    public File getExecutionPlan() {
        return new File(this.machineReadableLogs, "execution-plan.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogSummary() throws IOException {
        this.logger.entering(OPlan.class.getName(), "printLogSummary");
        String str = this.getMessage();
        System.out.println(str);
        File readme = this.getLogsReadme();
        assert (!readme.isFile());
        readme.createNewFile();
        FileWriter fw = new FileWriter(readme);
        try {
            fw.write(str);
        }
        finally {
            fw.close();
        }
        this.logger.exiting(OPlan.class.getName(), "printLogSummary");
    }

    private String getMessage() {
        this.logger.entering(OPlan.class.getName(), "getMessage");
        StringBuilder sb = new StringBuilder();
        sb.append(OPlanBundle.getMessage(OPlan.class, "FILE_LOCATION_INTRODUCTION_MESSAGE", new Object[0]));
        List<File> fileList = this.getApplyReadmeHtml();
        this.getReadmeFile(sb, "APPLY_HTML", fileList);
        fileList = this.getApplyReadmeTxt();
        this.getReadmeFile(sb, "APPLY_TXT", fileList);
        fileList = this.getRollbackReadmeHtml();
        this.getReadmeFile(sb, "ROLLBACK_HTML", fileList);
        fileList = this.getRollbackReadmeTxt();
        this.getReadmeFile(sb, "ROLLBACK_TXT", fileList);
        sb.append("\n");
        this.logger.exiting(OPlan.class.getName(), "getMessage", sb.toString());
        return sb.toString();
    }

    private void getReadmeFile(StringBuilder sb, String message, List<File> fileList) {
        if (fileList != null && fileList.size() > 0) {
            for (int i = 0; i < fileList.size(); ++i) {
                File file = fileList.get(i);
                if (!file.isFile()) continue;
                sb.append(OPlanBundle.getMessage(OPlan.class, message, file.getAbsolutePath()));
            }
        }
    }
}

