/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import oracle.oplan.core.readme.TextMultiReadmeGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedTextReadmeGenerator
extends TextMultiReadmeGenerator {
    private static final Class c = IndexedTextReadmeGenerator.class;

    public IndexedTextReadmeGenerator(ReadmeFactory rf) {
        super(rf);
    }

    @Override
    protected void writePlansBlurb(FileWriter fw, List<ExecutionPlan> plans) throws IOException {
        if (plans.isEmpty()) {
            return;
        }
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plans.get(0));
        String msg = OPlanBundle.getReadmeMessage("AVAILABLE_" + operation + "_STRATEGY", "", "");
        fw.write(msg);
        fw.write("\n" + IndexedTextReadmeGenerator.underline(msg));
        fw.write("\n");
        if (ExeuctionPlanUtil.applyNrollbacks(ExeuctionPlanUtil.outofplaces(plans)).size() > 0) {
            this.writePlanBlurb(fw, ExeuctionPlanUtil.first(ExeuctionPlanUtil.applyNrollbacks(ExeuctionPlanUtil.outofplaces(plans))), true, true);
            if (ExeuctionPlanUtil.switchbacks(ExeuctionPlanUtil.outofplaces(plans)).size() > 0) {
                fw.write("\n");
                this.writePlanBlurb(fw, ExeuctionPlanUtil.first(ExeuctionPlanUtil.switchbacks(ExeuctionPlanUtil.outofplaces(plans))), false, true);
            }
        }
        if (ExeuctionPlanUtil.inplaces(plans).size() > 0) {
            if (ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.inplaces(plans)).size() > 0) {
                if (ExeuctionPlanUtil.autos(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.inplaces(plans))).size() > 0) {
                    this.writePlanBlurb(fw, ExeuctionPlanUtil.first(ExeuctionPlanUtil.autos(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.inplaces(plans)))), true, true);
                }
                if (ExeuctionPlanUtil.manuals(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.inplaces(plans))).size() > 0) {
                    this.writePlanBlurb(fw, ExeuctionPlanUtil.first(ExeuctionPlanUtil.manuals(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.inplaces(plans)))), true, true);
                }
                fw.write("\n\n");
            }
            if (ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.inplaces(plans)).size() > 0) {
                if (ExeuctionPlanUtil.dclis(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.inplaces(plans))).size() > 0) {
                    this.writePlanBlurb(fw, ExeuctionPlanUtil.first(ExeuctionPlanUtil.dclis(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.inplaces(plans)))), true, true);
                }
                if (ExeuctionPlanUtil.manuals(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.inplaces(plans))).size() > 0) {
                    this.writePlanBlurb(fw, ExeuctionPlanUtil.first(ExeuctionPlanUtil.manuals(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.inplaces(plans)))), true, true);
                }
                fw.write("\n\n");
            }
        }
        fw.write("\n\n");
    }
}

