/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchCheckSystemSpaceCommand
extends SimpleShellCommand {
    public OPatchCheckSystemSpaceCommand(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        String owner;
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        ExecutionMode exeMode = env.getExecutionMode();
        List<GenericPatch> patches = !exeMode.equals((Object)ExecutionMode.EM) ? env.getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        List<GenericPatch> sortedPatches = CommandUtils.sortPatchesById(patches);
        CommandUtils.storePatchIDsInContext(context, sortedPatches);
        ArrayList<String> cmds = new ArrayList<String>();
        String oplanCfgToolLogs = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "oplan";
        cmds.add("mkdir -p -m 775 " + oplanCfgToolLogs);
        String patchLoc = CommandUtils.getPatchLocationByOHOwner(OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage(), oh);
        String[] patchLocName = patchLoc.split("/");
        String patchName = "patch";
        if (patchLocName != null && patchLocName.length > 0 && patchLocName[patchLocName.length - 1] != null) {
            patchName = patchLocName[patchLocName.length - 1];
        }
        if ((owner = oh.getOwner()) == null || owner.equals("")) {
            owner = "user";
        }
        String phBaseFile = oplanCfgToolLogs + File.separator + owner + "_" + patchName + "_phBaseFile_patchList";
        if (env.isTargetOnWindows()) {
            phBaseFile = oh.getPath() + "\\.patch_storage\\" + owner + "_" + patchName + "_phBaseFile_patchList";
        }
        cmds.addAll(this.writePatchLocationsToFileCommand(sortedPatches, phBaseFile));
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        String opatchPath = CommandUtils.getOPatchPath(oh);
        if (patches != null && patches.size() != 0) {
            String mkdirCmd = "";
            String customLogDirCmd = "";
            Map<OPlanAccessOptParamKeys, String> optParam = OPlan.getInstance().getOPlanEnv().getOptionalParam();
            if (optParam.containsKey((Object)OPlanAccessOptParamKeys.opatchCustomLogDir)) {
                String customLogDirPath = CommandUtils.getCustomLogDir(optParam.get((Object)OPlanAccessOptParamKeys.opatchCustomLogDir), oh.getPath());
                mkdirCmd = "mkdir -p " + customLogDirPath + " ; ";
                customLogDirCmd = " -customLogDir " + customLogDirPath;
            }
            String cmd = mkdirCmd + opatchPath + " prereq CheckSystemSpace -phBaseFile " + phBaseFile + invPtrOption;
            if (ExecutionMode.EM == exeMode) {
                String GREP_COMMAND = CommandUtils.getGrepCommand(oh);
                cmd = cmd + " | " + GREP_COMMAND + " ZOP";
                if (!env.isTargetOnWindows()) {
                    cmd = "tmp=$(" + cmd + ");test ! \"$tmp\"";
                } else {
                    String user = oh.getOwner();
                    if (user == null || user.equals("")) {
                        user = "user";
                    }
                    String tmpFile = oh.getPath() + "\\.patch_storage\\OplanPre_" + user + ".tmp";
                    String emptyFile = oh.getPath() + "\\.patch_storage\\emptyfile_" + user;
                    String createEmptyFile = "type nul > " + emptyFile;
                    String fc = "fc " + tmpFile + " " + emptyFile + " > nul";
                    cmd = cmd + " > " + tmpFile + " & " + createEmptyFile + " & " + fc;
                }
            }
            cmds.add(cmd);
        }
        return cmds;
    }

    private List<String> writePatchLocationsToFileCommand(List<GenericPatch> sortedPatches, String phBaseFile) {
        ArrayList<String> cmds = new ArrayList<String>();
        boolean firstPatch = true;
        for (GenericPatch patch : sortedPatches) {
            String echoCmd = "";
            if (firstPatch) {
                echoCmd = "echo " + patch.getPatchLocation() + " > " + phBaseFile;
                firstPatch = false;
            } else {
                echoCmd = echoCmd + "echo " + patch.getPatchLocation() + " >> " + phBaseFile;
            }
            cmds.add(echoCmd);
        }
        return cmds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchCheckSystemSpaceCommand> {
        @Override
        public OPatchCheckSystemSpaceCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("CheckSystemSpace")) {
                return null;
            }
            OpatchAction oa = (OpatchAction)a;
            OPatchCheckSystemSpaceCommand com = new OPatchCheckSystemSpaceCommand(a);
            return com;
        }
    }
}

