/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.patch;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.oplan.core.oplan.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Patchmd {
    private final String OH_VAR_NAME = "ORACLE_HOME";
    public final String OH_VAR = "$ORACLE_HOME";
    Logger logger = Logger.getLogger(Patchmd.class.getName());
    private String xmlContent;
    private boolean init = false;
    private Document doc;
    private String sqlScriptLocation;
    private String applySQLPlusCommand;
    private String rollbackSQLPlusCommand;
    private String runLocation;
    private Pattern PATTERN = Pattern.compile("A\\$(\\w+)");

    public Patchmd(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    private void init() throws PatchmdParsingException {
        if (this.init) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(this.xmlContent));
            this.doc = builder.parse(is);
            NodeList scriptNodeList = this.doc.getElementsByTagName("*");
            if (scriptNodeList != null) {
                for (int i = 0; i < scriptNodeList.getLength(); ++i) {
                    NodeList parameterNodeList;
                    Element scriptElement;
                    Node scriptNode = scriptNodeList.item(i);
                    if (scriptNode.getNodeType() != 1 || !scriptNode.getNodeName().contains("Script") || !(scriptElement = (Element)scriptNode).hasAttribute("name") || !"sqlStep".equals(scriptElement.getAttribute("name")) || (parameterNodeList = scriptElement.getElementsByTagName("*")) == null) continue;
                    for (int j = 0; j < parameterNodeList.getLength(); ++j) {
                        Element parameterElement;
                        Node parameterNode = parameterNodeList.item(j);
                        if (parameterNode.getNodeType() != 1 || !parameterNode.getNodeName().contains("Parameter") || !(parameterElement = (Element)parameterNode).hasAttribute("name") || !parameterElement.hasAttribute("assignment")) continue;
                        if ("script_loc".equals(parameterElement.getAttribute("name"))) {
                            this.sqlScriptLocation = this.getResolvedString(parameterElement.getAttribute("assignment"));
                            continue;
                        }
                        if ("script".equals(parameterElement.getAttribute("name"))) {
                            this.applySQLPlusCommand = this.getResolvedString(parameterElement.getAttribute("assignment"));
                            continue;
                        }
                        if ("rollbackscript".equals(parameterElement.getAttribute("name"))) {
                            this.rollbackSQLPlusCommand = this.getResolvedString(parameterElement.getAttribute("assignment"));
                            continue;
                        }
                        if (!"run_loc".equals(parameterElement.getAttribute("name"))) continue;
                        this.runLocation = this.getResolvedString(parameterElement.getAttribute("assignment"));
                    }
                }
            }
            this.doc = null;
            this.xmlContent = null;
            this.init = true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception while parsing patchmd.xml.", e);
            throw new PatchmdParsingException(e);
        }
    }

    private String getResolvedString(String str) {
        this.logger.fine("Going to resolve: " + str);
        Matcher m = this.PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            this.logger.fine("Resolving sub-string: " + m.group(1));
            String property = this.getResolvedVariable(m.group(1));
            this.logger.fine("Resolved sub-string to : " + property);
            m.appendReplacement(sb, property);
        }
        m.appendTail(sb);
        this.logger.fine("Resolved to: " + sb);
        return sb.toString();
    }

    private String getResolvedVariable(String var) {
        String value = null;
        NodeList argumentNodeList = this.doc.getElementsByTagName("*");
        if (argumentNodeList != null) {
            for (int i = 0; i < argumentNodeList.getLength(); ++i) {
                Element argumentElement;
                Node argumentNode = argumentNodeList.item(i);
                if (argumentNode.getNodeType() != 1 || !argumentNode.getNodeName().contains("Argument") || !(argumentElement = (Element)argumentNode).hasAttribute("name") || !argumentElement.getAttribute("name").equals(var) || !argumentElement.hasAttribute("defaultValue")) continue;
                value = argumentElement.getAttribute("defaultValue");
            }
        }
        if ((value == null || value.length() == 0) && var.equalsIgnoreCase("ORACLE_HOME")) {
            return "\\$ORACLE_HOME";
        }
        return value == null ? var : value;
    }

    public String getSqlScriptLocation() throws PatchmdParsingException {
        this.init();
        return this.sqlScriptLocation;
    }

    public String getApplySQLPlusCommand() throws PatchmdParsingException {
        this.init();
        return this.sqlScriptLocation == null ? this.applySQLPlusCommand : this.sqlScriptLocation + "/" + this.applySQLPlusCommand;
    }

    public String getRollbackSQLPlusCommand() throws PatchmdParsingException {
        this.init();
        return this.sqlScriptLocation == null ? this.rollbackSQLPlusCommand : this.sqlScriptLocation + "/" + this.rollbackSQLPlusCommand;
    }

    public String getRunLocation() throws PatchmdParsingException {
        this.init();
        return this.runLocation;
    }

    static Patchmd getPatchxmXMLObject(String patchmdFile) throws IOException, PatchmdParsingException {
        return new Patchmd(IOUtils.getContent(new FileInputStream(patchmdFile)).toString());
    }

    public static class PatchmdParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PatchmdParsingException(Throwable t) {
            super(t);
        }
    }
}

