/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api.install;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import oracle.glcm.common.inventory.api.CentralInventory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.HomeOperations;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.HomeOperationsProviderNotFoundException;
import oracle.glcm.opatch.common.api.install.HomeOperationsServiceProvider;
import oracle.glcm.opatch.common.api.install.HomeOperationsShell;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.glcm.opatch.common.api.install.VersionInfo;

public abstract class HomeOperationsFactory {
    private static final String HOME_OPERATIONS_FACTORY_IMPL = System.getProperty("HOME_OPERATIONS_FACTORY_IMPL", "oracle.glcm.opatch.common.impl.install.HomeOperationsFactoryImpl");
    private static HomeOperationsFactory _instance;
    private List<HomeOperationsServiceProvider> _homeOperationsServiceProviders;

    public static HomeOperationsFactory getInstance() {
        return HomeOperationsFactory.getInstance(null);
    }

    public static HomeOperationsFactory getInstance(ClassLoader classLoader) {
        if (_instance == null) {
            if (classLoader == null) {
                classLoader = HomeOperationsFactory.class.getClassLoader();
            }
            try {
                _instance = (HomeOperationsFactory)classLoader.loadClass(HOME_OPERATIONS_FACTORY_IMPL).newInstance();
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to load home operations factory impl.", e);
            }
        }
        return _instance;
    }

    public HomeOperationsExt getHomeOperations(String homeDir) throws HomeOperationsException {
        return this.getHomeOperations(homeDir, null);
    }

    public HomeOperationsExt getHomeOperations(String homeDir, ClassLoader classLoader) throws HomeOperationsException {
        return this.getHomeOperations(homeDir, classLoader, false);
    }

    public HomeOperationsExt getHomeOperations(String homeDir, ClassLoader classLoader, boolean reload) throws HomeOperationsException {
        List<HomeOperationsServiceProvider> providers = this.getHomeOperationsServiceProviders(classLoader, reload);
        if (providers == null || providers.isEmpty()) {
            throw new HomeOperationsProviderNotFoundException("Failed to locate a home operations service provider implementation.");
        }
        for (HomeOperationsServiceProvider provider : providers) {
            if (!provider.isHomeSupported(homeDir)) continue;
            HomeOperations homeOperations = provider.getHomeOperationsInstance(homeDir);
            if (homeOperations == null) {
                throw new HomeOperationsException("The home operations instance obtained from the provider was null.");
            }
            if (homeOperations instanceof HomeOperationsExt) {
                return (HomeOperationsExt)homeOperations;
            }
            return new HomeOperationsShell(homeOperations);
        }
        throw new HomeOperationsProviderNotFoundException("A home operations service provider could not be found that supports the home: " + homeDir);
    }

    public CentralInventory getCentralInventory(String invPtr) throws HomeOperationsException {
        return this.getCentralInventory(invPtr, null, false);
    }

    public CentralInventory getCentralInventory(String invPtr, ClassLoader classLoader, boolean reload) throws HomeOperationsException {
        List<HomeOperationsServiceProvider> providers = this.getHomeOperationsServiceProviders(classLoader, reload);
        if (providers == null || providers.isEmpty()) {
            throw new HomeOperationsProviderNotFoundException("Failed to locate a home operations service provider implementation.");
        }
        return providers.get(0).getCentralInventoryInstance(invPtr);
    }

    public List<HomeOperationsServiceProvider> getHomeOperationsServiceProviders(ClassLoader classLoader, boolean reload) {
        if (this._homeOperationsServiceProviders == null || reload) {
            this._homeOperationsServiceProviders = new ArrayList<HomeOperationsServiceProvider>();
            if (classLoader == null) {
                classLoader = HomeOperationsFactory.class.getClassLoader();
            }
            ServiceLoader<HomeOperationsServiceProvider> loader = ServiceLoader.load(HomeOperationsServiceProvider.class, classLoader);
            for (HomeOperationsServiceProvider instance : loader) {
                this._homeOperationsServiceProviders.add(instance);
            }
        }
        return this._homeOperationsServiceProviders;
    }

    public ComponentInfo getComponentInfo(String name, String version) {
        return this.getComponentInfo(name, version, null);
    }

    public ComponentInfo getComponentInfo(String name, String version, String patchLevel) {
        return this.getComponentInfo(name, version, patchLevel, 0);
    }

    public abstract ComponentInfo getComponentInfo(String var1, String var2, String var3, int var4);

    public abstract VersionInfo getVersionInfo(String var1, boolean var2, boolean var3);

    @Deprecated
    public PatchInfo getPatchInfo(String patchId, String patchUpi, PatchSubType patchSubType, Map<ComponentInfo, ComponentCheckResult> patchComponents, Map<FileState, List<File>> affectedFiles, boolean rollback, List<String> bugList, String description, List<String> preReqs, List<Locale> languages, List<String> supersededPatches) {
        return this.getPatchInfo(patchId, patchUpi, patchSubType, patchComponents, affectedFiles, rollback, bugList, description, preReqs, languages, supersededPatches, null);
    }

    @Deprecated
    public PatchInfo getPatchInfo(String patchId, String patchUpi, PatchSubType patchSubType, Map<ComponentInfo, ComponentCheckResult> patchComponents, Map<FileState, List<File>> affectedFiles, boolean rollback, List<String> bugList, String description, List<String> preReqs, List<Locale> languages, List<String> supersededPatches, Calendar appliedDate) {
        return this.getPatchInfoBuilder().patchId(patchId).patchUpi(patchUpi).patchSubType(patchSubType).patchComponents(patchComponents).affectedFiles(affectedFiles).rollBack(rollback).bugList(bugList).description(description).preReqs(preReqs).languages(languages).supersededPatches(supersededPatches).appliedDate(appliedDate).build();
    }

    public PatchInfo getPatchInfoWithPaths(String patchId, String patchUpi, PatchSubType patchSubType, Map<ComponentInfo, ComponentCheckResult> patchComponents, Map<FileState, List<Path>> affectedPaths, boolean rollback, List<String> bugList, String description, List<String> preReqs, List<Locale> languages, List<String> supersededPatches) {
        return this.getPatchInfoWithPaths(patchId, patchUpi, patchSubType, patchComponents, affectedPaths, rollback, bugList, description, preReqs, languages, supersededPatches, null);
    }

    public PatchInfo getPatchInfoWithPaths(String patchId, String patchUpi, PatchSubType patchSubType, Map<ComponentInfo, ComponentCheckResult> patchComponents, Map<FileState, List<Path>> affectedPaths, boolean rollback, List<String> bugList, String description, List<String> preReqs, List<Locale> languages, List<String> supersededPatches, Calendar appliedDate) {
        return this.getPatchInfoBuilder().patchId(patchId).patchUpi(patchUpi).patchSubType(patchSubType).patchComponents(patchComponents).affectedPaths(affectedPaths).rollBack(rollback).bugList(bugList).description(description).preReqs(preReqs).languages(languages).supersededPatches(supersededPatches).appliedDate(appliedDate).build();
    }

    public abstract PatchInfo.Builder getPatchInfoBuilder();

    public InventoryComponentInfo getInventoryComponentInfo(String name, String version, String patchLevel, InventoryComponentInfo.Action action) {
        return this.getInventoryComponentInfo(name, version, patchLevel, action, 0);
    }

    public abstract InventoryComponentInfo getInventoryComponentInfo(String var1, String var2, String var3, InventoryComponentInfo.Action var4, int var5);
}

