/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.engineeredsystem;

import dbmodel.bundle_xml.Subpatch;
import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.patchmodel.PatchingTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import oracle.dbsysmodel.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.dbsysmodel.engineeredsystem.HashComputeFunction;
import oracle.dbsysmodel.patchsdk.PatchPackageException;

public class InventoryAndActionOnly
extends HashComputeFunction {
    @Override
    protected List<String> fileList(String patchLocation, SystemPatchBundleXML bundleXml) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (Subpatch subPatch : bundleXml.getSubpatches()) {
            if (subPatch.getPatchingTool() != PatchingTool.OPATCH) continue;
            String subPatchLoc = subPatch.getLocation();
            String subPatchAbsLoc = patchLocation + File.separator + subPatchLoc;
            if (EngineeredSystemPatchValidatorAndGenerator.IsSubPatchCompositePatch(subPatchAbsLoc)) {
                File compositePatchDir = new File(subPatchAbsLoc);
                if (!compositePatchDir.exists()) continue;
                for (File sp : compositePatchDir.listFiles()) {
                    if (!sp.isDirectory()) continue;
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).getAbsolutePath());
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).getAbsolutePath());
                }
                continue;
            }
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).getAbsolutePath());
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).getAbsolutePath());
        }
        return metaList;
    }

    @Override
    protected String getHashFunction() {
        return "sha1";
    }

    @Override
    protected String computeHash(List<String> metaList) throws PatchPackageException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction());
            Collections.sort(metaList);
            for (int j = 0; j < metaList.size(); ++j) {
                String tempContents = this.getContent(new FileInputStream(new File(metaList.get(j)))).toString();
                boolean newLine = tempContents.endsWith("\n");
                String metaContents = this.getContentWithFilter(new FileInputStream(new File(metaList.get(j))), "unique_patch_id", newLine).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b.length);
            for (int j = 0; j < b.length; ++j) {
                byte bit = b[j];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction() + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
        catch (Exception e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
    }

    @Override
    protected String computeHash(HashMap<String, byte[]> metaMap) throws PatchPackageException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction());
            ArrayList<String> keyList = new ArrayList<String>();
            Set<String> keySet = metaMap.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                keyList.add(iterator.next());
            }
            Collections.sort(keyList);
            for (String key : keyList) {
                String tempContents = this.getContent(new ByteArrayInputStream(metaMap.get(key))).toString();
                boolean newLine = tempContents.endsWith("\n");
                String metaContents = this.getContentWithFilter(new ByteArrayInputStream(metaMap.get(key)), "unique_patch_id", newLine).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b.length);
            for (int j = 0; j < b.length; ++j) {
                byte bit = b[j];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction() + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
        catch (Exception e) {
            PatchPackageException ppe = new PatchPackageException(e.getMessage());
            ppe.setStackTrace(e.getStackTrace());
            throw ppe;
        }
    }

    public StringBuffer getContentWithFilter(InputStream is, String filterWord, boolean newLine) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            if (!(line = sc.next()).contains(filterWord)) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine);
            if (newLine) {
                sw.write(10);
            }
        }
        sw.close();
        return sw.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }
}

