/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.common.nio;

import java.util.HashMap;
import java.util.Map;
import oracle.glcm.common.nio.FileSystemType;
import oracle.glcm.common.nio.NioService;
import oracle.glcm.common.nio.NioServiceImpl;

public class NioServiceFactory {
    private static Map<FileSystemType, NioService> _cache;
    private static NioService _defaultNioService;

    public static NioService configureDefault(FileSystemType fileSystemType) {
        _defaultNioService = NioServiceFactory.getNioService(fileSystemType);
        return _defaultNioService;
    }

    public static NioService resetDefault() {
        return NioServiceFactory.configureDefault(FileSystemType.File);
    }

    public static NioService getNioService() {
        if (_defaultNioService == null) {
            NioServiceFactory.resetDefault();
        }
        return _defaultNioService;
    }

    public static NioService getNioService(FileSystemType fileSystemType) {
        NioService nioService;
        NioService nioService2 = nioService = _cache != null ? _cache.get((Object)fileSystemType) : null;
        if (nioService == null) {
            nioService = new NioServiceImpl(fileSystemType);
            if (_cache == null) {
                _cache = new HashMap<FileSystemType, NioService>();
            }
            _cache.put(fileSystemType, nioService);
        }
        return nioService;
    }
}

