/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchActions;
import oracle.glcm.opatch.common.api.PatchAutomation;
import oracle.glcm.opatch.common.api.PatchChecksum;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.api.SystemPatchBundle;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.impl.AbstractPatch;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;
import oracle.glcm.opatch.common.impl.SingletonPatch;
import oracle.glcm.opatch.common.impl.dao.PatchCompositeDAO;

public class CompositePatch
extends AbstractPatch
implements Patch {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private PatchCompositeDAO compDao = null;
    private List<String> oneoff_subdirs = null;
    private List<String> orderedSubPatchIds = null;
    private String patchLocation = null;
    private List<Patch> listOneoffs = null;
    private Patch topPatch = null;
    private String patchId = null;
    private String patchUpi = null;
    private String patchDesc = null;
    private final PatchType type = PatchType.COMPOSITE_PATCH;

    public void cloneMetadata(String destinationPatchLoc) throws PatchMetadataWritingException {
        this.logger.info("Starting cloning patch metadata...");
        if (this.listOneoffs != null && this.listOneoffs.size() > 0) {
            for (Patch patch : this.listOneoffs) {
                String patchID = patch.getPatchId();
                patch.cloneMetadata(destinationPatchLoc + Constants.PATH + patchID);
            }
            this.cloneCompositeXml(destinationPatchLoc + Constants.PATH + this.patchId);
            this.logger.info("Done cloning patch metadata...");
        }
    }

    public List<PatchInventory.Component> getComponents() {
        ArrayList<PatchInventory.Component> list = new ArrayList<PatchInventory.Component>();
        if (this.listOneoffs == null) {
            return list;
        }
        HashSet hs = new HashSet();
        for (Patch oneoff : this.listOneoffs) {
            hs.addAll(oneoff.getComponents());
        }
        list.addAll(hs);
        this.logger.info("Number of components:" + list.size());
        return list;
    }

    public List<PatchDeployArtifact> getPatchDeployArtifacts() {
        ArrayList<PatchDeployArtifact> result = new ArrayList<PatchDeployArtifact>();
        if (this.listOneoffs == null) {
            return result;
        }
        for (Patch oneoff : this.listOneoffs) {
            result.addAll(oneoff.getPatchDeployArtifacts());
        }
        this.logger.info("Number of patch deploy artifact:" + result.size());
        return result;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public String getPatchUpi() {
        return this.patchUpi;
    }

    public PatchType getPatchType() {
        return this.type;
    }

    public PatchSubType getPatchSubType() {
        return null;
    }

    public List<Patch> getSubPatches() {
        if (this.listOneoffs == null) {
            return new ArrayList<Patch>();
        }
        return this.listOneoffs;
    }

    public String createHash() {
        PatchInventory.Fvalue fvalue = ((PatchInventory)this.topPatch.getPatchInventories().get(0)).getFvalue();
        String function = fvalue.getFunction();
        return this.calculateHash(function, this.patchLocation, this.getSubPatches());
    }

    public boolean verifyHash() {
        PatchInventory.Fvalue fvalue = ((PatchInventory)this.topPatch.getPatchInventories().get(0)).getFvalue();
        String function = fvalue.getFunction();
        String hash = this.calculateHash(function, this.patchLocation, this.getSubPatches());
        return hash.equals(fvalue.getValue());
    }

    @Override
    protected AbstractPatch createPatch(String patchLoc) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        return new CompositePatch(patchLoc);
    }

    private CompositePatch() {
    }

    private CompositePatch(String patchLoc) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        this.logger.info("Composite patch is creating from location" + this.patchLocation);
        this.patchLocation = patchLoc;
        this.getDirs();
        this.createSubpatches();
        this.logger.info("Composite patch has been created from location" + this.patchLocation);
    }

    private void getDirs() throws PatchMetadataLoadingException {
        File patchLoc = new File(this.patchLocation);
        String compositeFileName = null;
        String[] subdirs = patchLoc.list();
        int countCompositeXml = 0;
        for (int i = 0; i < subdirs.length; ++i) {
            String subpatchLoc = this.patchLocation + Constants.PATH + subdirs[i];
            String cFileName = subpatchLoc + Constants.PATH + Constants.COMPOSITE_XML;
            File file = new File(cFileName);
            if (file.exists() && !file.isDirectory()) {
                compositeFileName = cFileName;
                this.logger.info("Found composite.xml file at " + compositeFileName);
                this.patchId = subdirs[i];
                ++countCompositeXml;
            }
            if (countCompositeXml <= true) continue;
            throw new PatchMetadataLoadingException("Error: There are more than one composite.xml file in this composite patch");
        }
        this.getSubdirs(compositeFileName);
    }

    private void getSubdirs(String compositeFileName) throws PatchMetadataLoadingException {
        this.compDao = new PatchCompositeDAO(compositeFileName);
        this.orderedSubPatchIds = this.compDao.getSubpatchIDs();
        ArrayList<String> listSubDirs = new ArrayList<String>();
        for (String s : this.orderedSubPatchIds) {
            listSubDirs.add(this.patchLocation + Constants.PATH + s);
        }
        this.oneoff_subdirs = listSubDirs;
        this.logger.info("Directories of sub-patches:" + this.oneoff_subdirs);
    }

    private void createSubpatches() throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        ArrayList<Patch> list = new ArrayList<Patch>();
        Iterator<String> iter = this.oneoff_subdirs.iterator();
        while (iter.hasNext()) {
            SingletonPatch p = new SingletonPatch(iter.next());
            if (p.getPatchId().equals(this.patchId)) {
                this.topPatch = p;
                this.patchUpi = p.getPatchUpi();
                this.patchDesc = p.getPatchDescription();
            }
            list.add(p);
        }
        this.listOneoffs = list;
        this.logger.info("Done creating " + list.size() + " patches");
    }

    private void cloneCompositeXml(String patchLoc) throws PatchMetadataWritingException {
        this.compDao.saveToDir(patchLoc);
    }

    public String getPatchDescription() {
        return this.patchDesc;
    }

    public List<PatchInventory> getPatchInventories() {
        ArrayList<PatchInventory> result = new ArrayList<PatchInventory>();
        if (this.listOneoffs == null) {
            return result;
        }
        for (Patch oneoff : this.listOneoffs) {
            result.addAll(oneoff.getPatchInventories());
        }
        return result;
    }

    public List<PatchActions> getActions() {
        ArrayList<PatchActions> result = new ArrayList<PatchActions>();
        if (this.listOneoffs == null) {
            return result;
        }
        for (Patch oneoff : this.listOneoffs) {
            result.addAll(oneoff.getActions());
        }
        return result;
    }

    public List<PatchChecksum> getChecksums() {
        ArrayList<PatchChecksum> result = new ArrayList<PatchChecksum>();
        if (this.listOneoffs == null) {
            return result;
        }
        for (Patch oneoff : this.listOneoffs) {
            result.addAll(oneoff.getChecksums());
        }
        return result;
    }

    public List<MaintenanceAliasActionHolder> getMaintenanceAliasActionHolders() {
        ArrayList<MaintenanceAliasActionHolder> result = new ArrayList<MaintenanceAliasActionHolder>();
        if (this.listOneoffs == null) {
            return result;
        }
        for (Patch oneoff : this.listOneoffs) {
            result.addAll(oneoff.getMaintenanceAliasActionHolders());
        }
        return result;
    }

    public List<PatchAutomation> getAutomations() {
        ArrayList<PatchAutomation> result = new ArrayList<PatchAutomation>();
        if (this.listOneoffs == null) {
            return result;
        }
        for (Patch oneoff : this.listOneoffs) {
            result.addAll(oneoff.getAutomations());
        }
        return result;
    }

    public List<String> getOrderedSubPatchId() {
        return this.orderedSubPatchIds;
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public SystemPatchBundle getSystemPatchBundle() {
        this.logger.warning("Warning: composite patch does not have bundle");
        return null;
    }

    public List<String> getReplacesUPIs() {
        return this.compDao.getReplacesUPIs();
    }

    public String getSeries() {
        return this.compDao.getSeries();
    }

    public String getReplacesSeries() {
        return this.compDao.getReplacesSeries();
    }

    static {
        new PatchFactoryImpl().registerPatch(PatchType.COMPOSITE_PATCH, new CompositePatch());
    }
}

