/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.DomainConfigInventory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.impl.configinventory.action.ActionConfigInventory;
import oracle.glcm.opatch.common.impl.configinventory.patch.ActionType;
import oracle.glcm.opatch.common.impl.configinventory.patch.PatchType;
import oracle.glcm.opatch.common.impl.configinventory.patch.PhaseType;
import oracle.glcm.opatch.common.impl.configinventory.patch.PhaseTypeValue;
import oracle.glcm.opatch.common.impl.configinventory.patch.StatusValue;
import oracle.glcm.opatch.common.impl.dao.ActionConfigInventoryDAO;
import oracle.glcm.opatch.common.impl.dao.PatchConfigurationInvDAO;

public class DomainConfigInventoryImpl
implements DomainConfigInventory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private ActionConfigInventoryDAO aciDAO = null;
    private PatchConfigurationInvDAO pciDAO = null;
    private String domainDir = null;

    protected DomainConfigInventoryImpl(String domainDirectory) throws FileNotFoundException, DomainInventoryLoadingException, DomainInventoryUpdatingException {
        this.aciDAO = new ActionConfigInventoryDAO(domainDirectory);
        this.pciDAO = new PatchConfigurationInvDAO(domainDirectory);
        this.domainDir = domainDirectory;
    }

    public void createPatchEntries(List<Patch> patchList) throws DomainInventoryUpdatingException {
        this.pciDAO.createPatchEntries(patchList);
    }

    public DomainConfigInventory.PatchInventoryEntry removePatchEntry(String patchId) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        return new PatchInventoryEntryImpl(this.pciDAO.removePatchInventoryEntry(patchId));
    }

    public List<DomainConfigInventory.PatchInventoryEntry> removePatchEntry(List<String> patchList) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        ArrayList<DomainConfigInventory.PatchInventoryEntry> result = new ArrayList<DomainConfigInventory.PatchInventoryEntry>();
        if (patchList != null) {
            for (String id : patchList) {
                result.add(new PatchInventoryEntryImpl(this.pciDAO.removePatchInventoryEntry(id)));
            }
        }
        return result;
    }

    public DomainConfigInventory.Status getPatchStatus(String patchId, DomainConfigInventory.PhaseType phase) throws DomainInventoryLoadingException {
        PhaseTypeValue ptv = PhaseTypeValue.fromValue((String)phase.value());
        StatusValue sv = this.pciDAO.getPatchStatus(patchId, ptv);
        return DomainConfigInventory.Status.fromValue((String)sv.value());
    }

    public Map<String, DomainConfigInventory.Status> getPatchStatus(List<String> listPatchId, DomainConfigInventory.PhaseType phase) throws DomainInventoryLoadingException {
        HashMap<String, DomainConfigInventory.Status> result = new HashMap<String, DomainConfigInventory.Status>();
        for (String s : listPatchId) {
            result.put(s, this.getPatchStatus(s, phase));
        }
        return result;
    }

    public DomainConfigInventory.PatchInventoryEntry getPatchInventoryEntry(String patchId) throws DomainInventoryLoadingException {
        if (this.pciDAO.getPatchInventoryEntry(patchId) != null) {
            return new PatchInventoryEntryImpl(this.pciDAO.getPatchInventoryEntry(patchId));
        }
        return null;
    }

    public List<DomainConfigInventory.PatchInventoryEntry> getPatchInventoryEntries() throws DomainInventoryLoadingException {
        ArrayList<DomainConfigInventory.PatchInventoryEntry> result = new ArrayList<DomainConfigInventory.PatchInventoryEntry>();
        List<PatchType> ptList = this.pciDAO.getPatchInventoryEntries();
        for (PatchType pt : ptList) {
            result.add(new PatchInventoryEntryImpl(pt));
        }
        return result;
    }

    public List<Patch> getDelta(List<Patch> patchList, DomainConfigInventory.PhaseType phase) throws DomainInventoryLoadingException {
        return this.pciDAO.getDelta(patchList, PhaseTypeValue.fromValue((String)phase.value()));
    }

    public void updateActionStatus(String actionID, String patchID, DomainConfigInventory.PhaseType phase, DomainConfigInventory.Status status) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        this.pciDAO.updateActionStatus(patchID, actionID, PhaseTypeValue.fromValue((String)phase.value()), StatusValue.fromValue((String)status.value()));
    }

    public void addEntry(String name, Date date, String actor) throws DomainInventoryUpdatingException {
        this.aciDAO.addEntry(name, date, actor);
    }

    public DomainConfigInventory.ActionInventoryEntry removeEntry(String name) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        ActionConfigInventory.ActionInventoryEntry entry = this.aciDAO.removeEntry(name);
        if (entry != null) {
            return new ActionInventoryEntryImpl(entry);
        }
        return null;
    }

    public DomainConfigInventory.ActionInventoryEntry getEntry(String name) throws DomainInventoryLoadingException {
        ActionConfigInventory.ActionInventoryEntry entry = this.aciDAO.getEntry(name);
        if (entry != null) {
            return new ActionInventoryEntryImpl(entry);
        }
        return null;
    }

    public boolean entryExists(String name) throws DomainInventoryLoadingException {
        return this.aciDAO.entryExists(name);
    }

    public List<DomainConfigInventory.ActionInventoryEntry> getEntries() throws DomainInventoryLoadingException {
        return this.getListActionInventoryEntry(this.aciDAO.getEntries());
    }

    private List<DomainConfigInventory.ActionInventoryEntry> getListActionInventoryEntry(List<ActionConfigInventory.ActionInventoryEntry> list) {
        ArrayList<DomainConfigInventory.ActionInventoryEntry> result = new ArrayList<DomainConfigInventory.ActionInventoryEntry>();
        for (ActionConfigInventory.ActionInventoryEntry e : list) {
            result.add(new ActionInventoryEntryImpl(e));
        }
        return result;
    }

    class PatchInventoryEntryImpl
    implements DomainConfigInventory.PatchInventoryEntry {
        private String patchId = null;
        private String patchUpi = null;
        private List<DomainConfigInventory.PatchInventoryEntry.Phase> listPhase = new ArrayList<DomainConfigInventory.PatchInventoryEntry.Phase>();

        public PatchInventoryEntryImpl(PatchType pt) {
            if (pt != null) {
                this.patchId = pt.getId();
                this.patchUpi = pt.getUpi();
                List phaseList = pt.getPhase();
                if (phaseList != null) {
                    for (PhaseType phaseT : phaseList) {
                        this.listPhase.add(new PhaseImpl(phaseT));
                    }
                }
            }
        }

        public String getPatchId() {
            return this.patchId;
        }

        public String getPatchUpi() {
            return this.patchUpi;
        }

        public List<DomainConfigInventory.PatchInventoryEntry.Phase> getPhases() {
            return this.listPhase;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\nPatch Id:" + this.getPatchId() + " Upi:" + this.getPatchUpi());
            for (DomainConfigInventory.PatchInventoryEntry.Phase p : this.listPhase) {
                sb.append(p.toString());
            }
            return sb.toString();
        }

        class ActionEntryImpl
        implements DomainConfigInventory.PatchInventoryEntry.Phase.ActionEntry {
            private String actionId = null;
            private String date = null;
            private DomainConfigInventory.Status status = null;

            public ActionEntryImpl(ActionType at) {
                if (at != null) {
                    this.actionId = at.getId();
                    this.date = at.getDate();
                    this.status = DomainConfigInventory.Status.fromValue((String)at.getActionStatus().value());
                }
            }

            public String getActionId() {
                return this.actionId;
            }

            public DomainConfigInventory.Status getActionStatus() {
                return this.status;
            }

            public String getDate() {
                return this.date;
            }

            public String toString() {
                return "\n\t\tAction Entry: id:" + this.getActionId() + " date:" + this.getDate() + " status:" + this.getActionStatus().value();
            }
        }

        class PhaseImpl
        implements DomainConfigInventory.PatchInventoryEntry.Phase {
            private DomainConfigInventory.Status status = null;
            private DomainConfigInventory.PhaseType phase = null;
            private List<DomainConfigInventory.PatchInventoryEntry.Phase.ActionEntry> actionList = new ArrayList<DomainConfigInventory.PatchInventoryEntry.Phase.ActionEntry>();

            public PhaseImpl(PhaseType pt) {
                if (pt != null) {
                    this.status = DomainConfigInventory.Status.fromValue((String)pt.getPatchStatus().value());
                    this.phase = DomainConfigInventory.PhaseType.fromValue((String)pt.getType().value());
                    List listAt = pt.getAction();
                    if (listAt != null) {
                        for (ActionType at : listAt) {
                            this.actionList.add(new ActionEntryImpl(at));
                        }
                    }
                }
            }

            public DomainConfigInventory.PhaseType getPhaseType() {
                return this.phase;
            }

            public DomainConfigInventory.Status getPatchStatus() {
                return this.status;
            }

            public List<DomainConfigInventory.PatchInventoryEntry.Phase.ActionEntry> getActionEntries() {
                return this.actionList;
            }

            public void setPatchStatus(DomainConfigInventory.Status status) {
                this.status = status;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(" \n\tContent of a phase: phaseType:" + this.getPhaseType().value() + " phaseStatus:" + this.getPatchStatus().value());
                for (DomainConfigInventory.PatchInventoryEntry.Phase.ActionEntry ae : this.getActionEntries()) {
                    sb.append(ae.toString());
                }
                return sb.toString();
            }
        }
    }

    class ActionInventoryEntryImpl
    implements DomainConfigInventory.ActionInventoryEntry {
        private String name = null;
        private String date = null;
        private String actor = null;

        public ActionInventoryEntryImpl(ActionConfigInventory.ActionInventoryEntry ace) {
            if (ace != null) {
                this.name = ace.getName();
                this.date = ace.getDate();
                this.actor = ace.getActor();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDate() {
            return this.date;
        }

        public String getActor() {
            return this.actor;
        }

        public String toString() {
            return "\n\tAction Entry content: name:" + this.getName() + ", date:" + this.getDate() + ", actor:" + this.getActor();
        }
    }
}

