/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.ContentType;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.dao.PatchInventoryDAO;
import oracle.glcm.opatch.common.utils.LocalUtils;

public class PatchInventoryImpl
implements PatchInventory {
    private PatchInventoryDAO pidao = null;

    public PatchInventoryImpl() {
    }

    public PatchInventoryImpl(String inventoryLoc) throws PatchMetadataLoadingException {
        this.pidao = new PatchInventoryDAO(inventoryLoc);
    }

    public String getPatchId() {
        return this.pidao.getPatchId();
    }

    public String getPatchUpid() {
        return this.pidao.getPatchUpid();
    }

    public List<PatchInventory.Component> getComponents() {
        return this.pidao.getComponents();
    }

    public List<List<PatchInventory.Component>> getAtLeastOneComponents() {
        return this.pidao.getAtLeastOneComponents();
    }

    protected void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning patch inventory.xml", (Throwable)e);
            }
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning patch inventory.xml");
        }
        String inventoryFile = destinationPatchLoc + Constants.PATH + Constants.INVENTORY_XML;
        this.pidao.save(inventoryFile);
    }

    public String getPatchDescription() {
        return this.pidao.getPatchDescription();
    }

    public String getOpackVersion() {
        return this.pidao.getOpackVersion();
    }

    public String getBundleDescription() {
        return this.pidao.getBundleDescription();
    }

    public String getMinOpatchVersion() {
        return this.pidao.getMinOpatchVersion();
    }

    public Boolean getCannotAutoRollback() {
        return this.pidao.getCannotAutoRollback();
    }

    public Boolean getNotRollbackable() {
        return this.pidao.getNotRollbackable();
    }

    public Boolean getOJVM() {
        return this.pidao.getOJVM();
    }

    public Boolean getRHP() {
        return this.pidao.getRHP();
    }

    public Calendar getDateOfPatch() {
        return this.pidao.getDateOfPatch();
    }

    public String getUniqueTag() {
        return this.pidao.getUniqueTag();
    }

    public List<PatchInventory.Bug> getBugs() {
        return this.pidao.getBugs();
    }

    public List<PatchInventory.OsPlatform> getOsPlatforms() {
        return this.pidao.getOsPlatforms();
    }

    public List<PatchInventory.Executable> getExecutables() {
        return this.pidao.getExecutables();
    }

    public Boolean getInstanceShutdown() {
        return this.pidao.getInstanceShutdown();
    }

    public String getInstanceShutdownMessage() {
        return this.pidao.getInstanceShutdownMessage();
    }

    public Boolean getOnlineRacInstallable() {
        return this.pidao.getOnlineRacInstallable();
    }

    public Boolean getRunAsRoot() {
        return this.pidao.getRunAsRoot();
    }

    public Boolean getSqlMigrate() {
        return this.pidao.getSqlMigrate();
    }

    public List<PatchInventory.Prereq> getWlsPrereqOneoffs() {
        return this.pidao.getWlsPrereqOneoffs();
    }

    public List<PatchInventory.Prereq> getPrereqOneoffs() {
        return this.pidao.getPrereqOneoffs();
    }

    public List<PatchInventory.Prereq> getCoreqOneoffs() {
        return this.pidao.getCoreqOneoffs();
    }

    public List<PatchInventory.Prereq> getOverlayOneoffs() {
        return this.pidao.getOverlayOneoffs();
    }

    public String getPatchType() {
        return this.pidao.getPatchType();
    }

    public PatchSubType getPatchSubType() {
        return this.pidao.getPatchSubType();
    }

    public String getPatchLanguage() {
        return this.pidao.getPatchLanguage();
    }

    public PatchInventory.ProductFamily getProductFamily() {
        return this.pidao.getProductFamily();
    }

    public String getPatchModel() {
        return this.pidao.getPatchModel();
    }

    public Boolean getAuto() {
        return this.pidao.getAuto();
    }

    public Boolean getExitIfPrescriptError() {
        return this.pidao.getExitIfPrescriptError();
    }

    public Boolean getTranslatable() {
        return this.pidao.getTranslatable();
    }

    public List<PatchInventory.Application> getApplicationShutdownList() {
        return this.pidao.getApplicationShutdownList();
    }

    public String getApplicableProduct() {
        return this.pidao.getApplicableProduct();
    }

    public List<PatchInventory.Product> getProducts() {
        return this.pidao.getProducts();
    }

    public List<PatchInventory.Automation> getAutomations() {
        return this.pidao.getAutomations();
    }

    public List<PatchInventory.SystemComponent> getSystemComponentList() {
        return this.pidao.getSystemComponentList();
    }

    public List<PatchInventory.ApplicationDir> getAppDirs() {
        return this.pidao.getAppDirs();
    }

    public PatchInventory.PatchCharacteristics getPatchChara() {
        return this.pidao.getPatchChara();
    }

    public Boolean getStrsubsPropertyFile() {
        return this.pidao.getStrsubsPropertyFile();
    }

    public String getConstituentPatchId() {
        return this.pidao.getConstituentPatchId();
    }

    public Boolean getFMWRolling() {
        return this.pidao.getFMWRolling();
    }

    public Boolean getFMWFeatureBearing() {
        return this.pidao.getFMWFeatureBearing();
    }

    public Boolean getSqlPatch() {
        return this.pidao.getSqlPatch();
    }

    public String getSqlPatchDatabaseStartupMode() {
        return this.pidao.getSqlPatchDatabaseStartupMode();
    }

    public PatchInventory.Fvalue getFvalue() {
        return this.pidao.getFvalue();
    }

    public Boolean getDeleteOldDirectory() {
        return this.pidao.getDeleteOldDirectory();
    }

    public class PatchCharacteristicsImpl
    implements PatchInventory.PatchCharacteristics {
        private ContentType contentType = null;

        public void setContentType(ContentType contentType) {
            this.contentType = contentType;
        }

        public ContentType getContentType() {
            return this.contentType;
        }
    }

    public class ApplicationDirImpl
    implements PatchInventory.ApplicationDir {
        private String path = null;

        public ApplicationDirImpl(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class FvalueImpl
    implements PatchInventory.Fvalue {
        String hashFunction = null;
        String minOpatchVersion = null;
        String value = null;

        public FvalueImpl(String minOpatchVersion, String hashFunction, String value) {
            this.hashFunction = hashFunction;
            this.minOpatchVersion = minOpatchVersion;
            this.value = value;
        }

        public String getFunction() {
            return this.hashFunction;
        }

        public String getMinOpatchVersion() {
            return this.minOpatchVersion;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class SystemComponentImpl
    implements PatchInventory.SystemComponent {
        private String name = null;
        private String version = null;
        private Boolean shutdown = null;

        public SystemComponentImpl(String name, String version, Boolean shutdown) {
            this.name = name;
            this.version = version;
            this.shutdown = shutdown;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getShutDown() {
            return this.shutdown;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public class AutomationImpl
    implements PatchInventory.Automation {
        private String filename = null;

        public AutomationImpl(String filename) {
            this.filename = filename;
        }

        public String getFileName() {
            return this.filename;
        }
    }

    public class ApplicationImpl
    implements PatchInventory.Application {
        private String name = null;
        private String version = null;

        public ApplicationImpl(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getName() {
            return this.name;
        }
    }

    public class ProductImpl
    implements PatchInventory.Product {
        private String name = null;
        private List<String> versions = null;

        public ProductImpl(String name, List<String> versions) {
            this.name = name;
            this.versions = versions;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getVersions() {
            return this.versions;
        }
    }

    public class PrereqImpl
    implements PatchInventory.Prereq {
        private String id = null;
        private String opt = null;

        public PrereqImpl(String id, String opt) {
            this.id = id;
            this.opt = opt;
        }

        public String getOneoffId() {
            return this.id;
        }

        public String getOption() {
            return this.opt;
        }
    }

    public class ExecutableImpl
    implements PatchInventory.Executable {
        private String path = null;

        public ExecutableImpl(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class BugImpl
    implements PatchInventory.Bug {
        private String number = null;
        private String desc = null;

        public BugImpl(String number, String desc) {
            this.number = number;
            this.desc = desc;
        }

        public String getNumber() {
            return this.number;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    public class OsPlatformImpl
    implements PatchInventory.OsPlatform {
        private String name = null;
        private String id = null;

        public OsPlatformImpl(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }

    public class ProductFamilyImpl
    implements PatchInventory.ProductFamily {
        private List<String> subProducts = null;
        private String value = "";

        public ProductFamilyImpl(String value, List<String> subProducts) {
            this.value = value;
            this.subProducts = subProducts;
        }

        public List<String> getSubProducts() {
            if (null == this.subProducts) {
                return new ArrayList<String>();
            }
            return this.subProducts;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class ComponentImpl
    implements PatchInventory.Component {
        private String name = null;
        private String version = null;
        private String patchLevel = null;
        private String optString = null;

        public ComponentImpl(String name, String version, String patchLevel, String optString) {
            this.name = name;
            this.version = version;
            this.patchLevel = patchLevel;
            this.optString = optString;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPatchLevel() {
            return this.patchLevel;
        }

        public Boolean isRequired() {
            return this.optString.equalsIgnoreCase("R");
        }

        public String getOptString() {
            return this.optString;
        }

        public int hashCode() {
            String str = this.name + this.version;
            return str.hashCode();
        }

        public boolean equals(Object o) {
            boolean b = this.hashCode() == o.hashCode();
            return b;
        }

        public String toString() {
            return this.getName() + " " + this.getVersion() + (!LocalUtils.isNullOrEmpty(this.getPatchLevel(), true) ? " (patch-level " + this.getPatchLevel() + ")" : "");
        }
    }
}

