/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchActions;
import oracle.glcm.opatch.common.api.PatchAutomation;
import oracle.glcm.opatch.common.api.PatchChecksum;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.api.SystemPatchBundle;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.impl.AbstractPatch;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchActionsImpl;
import oracle.glcm.opatch.common.impl.PatchAutomationImpl;
import oracle.glcm.opatch.common.impl.PatchChecksumImpl;
import oracle.glcm.opatch.common.impl.PatchDeployArtifactImpl;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;
import oracle.glcm.opatch.common.impl.PatchInventoryImpl;
import oracle.glcm.opatch.common.impl.PatchMaintenanceAliasImpl;
import oracle.glcm.opatch.common.impl.alias.action.MaintenanceAliasActionService;

public class SingletonPatch
extends AbstractPatch
implements Patch {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final PatchType type = PatchType.SINGLETON_PATCH;
    private String patchLocation = null;
    private String inventoryFile = null;
    private String actionFile = null;
    private String checksumFile = null;
    private String maintenanceAliasFile = null;
    private String automationFile = null;
    private String patchDeployFile = null;
    private PatchDeployArtifactImpl pdi = null;
    private PatchInventoryImpl pii = null;
    private PatchActionsImpl pai = null;
    private PatchChecksumImpl pcsi = null;
    private MaintenanceAliasActionHolder maah = null;
    private PatchAutomationImpl paui = null;
    private PatchMaintenanceAliasImpl pmai = null;
    private String patchID = null;

    public void cloneMetadata(String destinationPatchLoc) throws PatchMetadataWritingException {
        this.pii.saveToDir(destinationPatchLoc);
        this.pai.saveToDir(destinationPatchLoc);
        if (this.pcsi != null) {
            this.pcsi.saveToDir(destinationPatchLoc);
        }
        if (this.paui != null) {
            this.paui.saveToDir(destinationPatchLoc);
        }
        if (this.pdi != null) {
            this.pdi.saveToDir(destinationPatchLoc);
        }
        if (this.pmai != null) {
            this.pmai.saveToDir(destinationPatchLoc);
        }
    }

    public List<PatchInventory.Component> getComponents() {
        ArrayList<PatchInventory.Component> result = new ArrayList<PatchInventory.Component>();
        List<PatchActions.Component> aComps = this.pai.getComponents();
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (PatchActions.Component c : aComps) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ComponentImpl iComp = patchInventoryImpl.new PatchInventoryImpl.ComponentImpl(c.getName(), c.getVersion(), c.getPatchLevel(), c.getOptString());
            result.add(iComp);
        }
        return result;
    }

    public List<PatchDeployArtifact> getPatchDeployArtifacts() {
        ArrayList<PatchDeployArtifact> result = new ArrayList<PatchDeployArtifact>();
        if (this.pdi != null) {
            result.add(this.pdi);
        }
        return result;
    }

    public String getPatchId() {
        return this.patchID;
    }

    public String getPatchUpi() {
        return this.pii.getPatchUpid();
    }

    public List<PatchInventory> getPatchInventories() {
        ArrayList<PatchInventory> result = new ArrayList<PatchInventory>();
        if (this.pii != null) {
            result.add(this.pii);
        }
        return result;
    }

    public PatchType getPatchType() {
        return this.type;
    }

    public PatchSubType getPatchSubType() {
        return this.pii.getPatchSubType();
    }

    public List<Patch> getSubPatches() {
        return new ArrayList<Patch>(Arrays.asList(this));
    }

    public String createHash() {
        PatchInventory.Fvalue fvalue = this.pii.getFvalue();
        String function = fvalue.getFunction();
        return this.calculateHash(function, this.patchLocation, this.getSubPatches());
    }

    public boolean verifyHash() {
        PatchInventory.Fvalue fvalue = this.pii.getFvalue();
        String function = fvalue.getFunction();
        String hash = this.calculateHash(function, this.patchLocation, this.getSubPatches());
        return hash.equals(fvalue.getValue());
    }

    @Override
    protected AbstractPatch createPatch(String patchLocation) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        return new SingletonPatch(patchLocation);
    }

    private SingletonPatch() {
    }

    protected SingletonPatch(String patchLoc) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        this.patchLocation = patchLoc;
        this.inventoryFile = this.patchLocation + Constants.PATH + Constants.INVENTORY_XML;
        Path invFile = NioServiceFactory.getNioService().getPath(this.inventoryFile, new String[0]);
        if (!Files.exists(invFile, new LinkOption[0]) || Files.isDirectory(invFile, new LinkOption[0])) {
            throw new PatchNotFoundException("PatchInventory.xml file does not exist in patchlocation:" + this.patchLocation);
        }
        this.logger.info("PatchInventoryImpl is creating from " + this.inventoryFile);
        this.pii = new PatchInventoryImpl(this.inventoryFile);
        this.logger.info("PatchInventoryImpl has been created from " + this.inventoryFile);
        this.patchID = this.pii.getPatchId();
        if (this.patchID == null) {
            throw new InvalidPatchMetadataException("Patch ID or Reference_ID does not exist in patch inventory.xml");
        }
        this.logger.info("Patch id:" + this.patchID);
        this.actionFile = this.patchLocation + Constants.PATH + Constants.ACTIONS_XML;
        Path actFile = NioServiceFactory.getNioService().getPath(this.actionFile, new String[0]);
        if (!Files.exists(actFile, new LinkOption[0]) || Files.isDirectory(actFile, new LinkOption[0])) {
            throw new InvalidPatchMetadataException("PatchActions.xml file does not exist in patchlocation:" + this.patchLocation);
        }
        this.logger.info("PatchActionsImpl is creating from " + this.actionFile);
        this.pai = new PatchActionsImpl(this.actionFile);
        this.logger.info("PatchActionsImpl has been created from " + this.actionFile);
        this.checksumFile = this.patchLocation + Constants.PATH + Constants.CHECKSUM_XML;
        Path csFile = NioServiceFactory.getNioService().getPath(this.checksumFile, new String[0]);
        if (!Files.exists(csFile, new LinkOption[0]) || Files.isDirectory(csFile, new LinkOption[0])) {
            this.logger.info(this.checksumFile + " does not exist");
            this.checksumFile = null;
        } else {
            this.logger.info("PatchChecksumImpl is creating from " + this.checksumFile);
            this.pcsi = new PatchChecksumImpl(this.checksumFile);
            this.logger.info("PatchChecksumImpl has been created from " + this.checksumFile);
        }
        this.automationFile = this.patchLocation + Constants.PATH + Constants.AUTOMATION_XML;
        Path autoFile = NioServiceFactory.getNioService().getPath(this.automationFile, new String[0]);
        if (!Files.exists(autoFile, new LinkOption[0]) || Files.isDirectory(autoFile, new LinkOption[0])) {
            this.logger.info(this.automationFile + " does not exist");
            this.automationFile = null;
        } else {
            this.logger.info("PatchAutomationImpl is creating from " + this.automationFile);
            this.paui = new PatchAutomationImpl(this.automationFile);
            this.logger.info("PatchAutomationImpl has been created from " + this.automationFile);
        }
        this.patchDeployFile = this.patchLocation + Constants.PATH + Constants.PATCH_DEPLOY_XML;
        Path pdfile = NioServiceFactory.getNioService().getPath(this.patchDeployFile, new String[0]);
        if (Files.exists(pdfile, new LinkOption[0]) && !Files.isDirectory(pdfile, new LinkOption[0])) {
            this.logger.info("PatchDeployArtifactImpl is creating from " + this.patchDeployFile);
            this.pdi = new PatchDeployArtifactImpl(this.patchDeployFile);
            this.logger.info("PatchDeployArtifactImpl has been created from " + this.patchDeployFile);
        } else {
            this.logger.info("Patch Deploy artifact does not exist");
            this.patchDeployFile = null;
        }
        this.maintenanceAliasFile = this.patchLocation + Constants.PATH + Constants.MAINTENANCEALIAS_XML;
        Path maFile = NioServiceFactory.getNioService().getPath(this.maintenanceAliasFile, new String[0]);
        if (!Files.exists(maFile, new LinkOption[0]) || Files.isDirectory(maFile, new LinkOption[0])) {
            this.logger.info(this.maintenanceAliasFile + " does not exist");
            this.maintenanceAliasFile = null;
        } else {
            try {
                this.logger.info("MaintenanceAlias is creating from " + this.maintenanceAliasFile);
                this.maah = MaintenanceAliasActionService.getInstance().loadMaintenanceAliasAction(maFile);
                this.pmai = new PatchMaintenanceAliasImpl(this.maintenanceAliasFile);
                this.logger.info("MaintenanceAlias has been created from " + this.maintenanceAliasFile);
            }
            catch (MaintenanceAliasException e) {
                e.printStackTrace();
            }
        }
    }

    public String getActionFile() {
        return this.actionFile;
    }

    public String getInventoryFile() {
        return this.inventoryFile;
    }

    public String getChecksumFile() {
        return this.checksumFile;
    }

    public String getMaintenanceAliasFile() {
        return this.maintenanceAliasFile;
    }

    public String getAutomationFile() {
        return this.automationFile;
    }

    public String getPatchDeployFile() {
        return this.patchDeployFile;
    }

    public String getPatchDescription() {
        return this.pii.getPatchDescription();
    }

    public List<PatchActions> getActions() {
        ArrayList<PatchActions> result = new ArrayList<PatchActions>();
        if (this.pai != null) {
            result.add(this.pai);
        }
        return result;
    }

    public List<PatchChecksum> getChecksums() {
        ArrayList<PatchChecksum> result = new ArrayList<PatchChecksum>();
        if (this.pcsi != null) {
            result.add(this.pcsi);
        }
        return result;
    }

    public List<MaintenanceAliasActionHolder> getMaintenanceAliasActionHolders() {
        ArrayList<MaintenanceAliasActionHolder> result = new ArrayList<MaintenanceAliasActionHolder>();
        if (this.maah != null) {
            result.add(this.maah);
        }
        return result;
    }

    public List<PatchAutomation> getAutomations() {
        ArrayList<PatchAutomation> result = new ArrayList<PatchAutomation>();
        if (this.paui != null) {
            result.add(this.paui);
        }
        return result;
    }

    public List<String> getOrderedSubPatchId() {
        this.logger.info("Not applicable method for this object");
        return null;
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public SystemPatchBundle getSystemPatchBundle() {
        this.logger.warning("Warning: singleton patch does not have bundle");
        return null;
    }

    static {
        new PatchFactoryImpl().registerPatch(PatchType.SINGLETON_PATCH, new SingletonPatch());
    }
}

