/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.glcm.opatch.common.api.SystemSubpatchInfo;
import oracle.glcm.opatch.common.impl.bundle.Subpatch;
import oracle.glcm.opatch.common.impl.bundle.TargetType;

public class SystemSubpatchInfoImpl
implements SystemSubpatchInfo {
    private Subpatch subpatch = null;

    public SystemSubpatchInfoImpl(Subpatch sp) {
        this.subpatch = sp;
    }

    public String getPatchId() {
        return this.subpatch.getPatchId();
    }

    public String getPatchUpi() {
        return this.subpatch.getUniquePatchId();
    }

    public List<String> getTargetTypes() {
        ArrayList<String> result = new ArrayList<String>();
        List ttList = this.subpatch.getTargetTypes().getTargetType();
        for (TargetType tt : ttList) {
            result.add(tt.getType().name());
        }
        return result;
    }

    public String getPatchLocation() {
        return this.subpatch.getLocation();
    }

    public String getPatchType() {
        return this.subpatch.getPatchType().value();
    }

    public String getPatchingTool() {
        return this.subpatch.getPatchingTool().value();
    }

    public String getPlatform() {
        return this.subpatch.getPlatform();
    }

    public int hashCode() {
        String str = this.subpatch.getPatchId();
        return str.hashCode();
    }

    public boolean equals(Object o) {
        boolean b = this.hashCode() == o.hashCode();
        return b;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(Patch id:" + this.getPatchId());
        sb.append(",TargetTypes:" + this.getTargetTypes());
        sb.append(",Platform:" + this.getPlatform());
        sb.append(",PatchType:" + this.getPatchType());
        sb.append(",PatchingTool:" + this.getPatchingTool());
        sb.append(")");
        return sb.toString();
    }
}

