/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias.patch;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.alias.ArtifactReference;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasBuilderFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasService;
import oracle.glcm.opatch.common.api.alias.action.ActionType;
import oracle.glcm.opatch.common.api.alias.action.ArtifactReferenceAction;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasAction;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.api.alias.action.MappingAction;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchHandler;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchRec;
import oracle.glcm.opatch.common.api.alias.patch.PatchRec;
import oracle.glcm.opatch.common.helpers.MaintenanceAliasActionInfoHelper;
import oracle.glcm.opatch.common.helpers.MaintenanceAliasInfoHelper;
import oracle.glcm.opatch.common.impl.alias.MaintenanceAliasInventoryImpl;
import oracle.glcm.opatch.common.impl.alias.action.MaintenanceAliasActionImpl;
import oracle.glcm.opatch.common.impl.alias.action.MaintenanceAliasActionService;
import oracle.glcm.opatch.common.impl.alias.patch.MaintenanceAliasPatchService;

public class MaintenanceAliasPatchHandlerImpl
implements MaintenanceAliasPatchHandler {
    private static final Logger _logger = Logger.getLogger(MaintenanceAliasPatchHandlerImpl.class.getName());
    private String _oracleHome;
    private MaintenanceAliasPatchRec _maPatch = null;
    private MaintenanceAliasService _service = null;
    public static final String ADD_ACTION = "ADD";
    public static final String UPDATE_ACTION = "UPDATE";
    public static final String DELETE_ACTION = "DELETE";

    public MaintenanceAliasPatchHandlerImpl(String oracleHome) throws MaintenanceAliasException {
        this._oracleHome = oracleHome;
        try {
            Path mapatch_file = NioServiceFactory.getNioService().getPath(MaintenanceAliasActionInfoHelper.getInstance().getMaintenanceAliasPatchPath(this._oracleHome), new String[0]);
            this._maPatch = mapatch_file == null || !Files.exists(mapatch_file, new LinkOption[0]) || !Files.isRegularFile(mapatch_file, new LinkOption[0]) || !Files.isReadable(mapatch_file) ? null : MaintenanceAliasPatchService.getInstance().loadMaintenanceAliasPatch(mapatch_file);
            this._service = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasService(this._oracleHome);
        }
        catch (MaintenanceAliasException e) {
            _logger.log(Level.FINE, e.getMessage());
            throw new MaintenanceAliasException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<MaintenanceAlias> getAllMaintenanceAliasToDisplay() throws MaintenanceAliasException {
        if (this._maPatch != null) {
            this.patchingMaintenanceAlias();
        }
        MaintenanceAliasInventoryImpl maInv = new MaintenanceAliasInventoryImpl(this._service);
        return maInv.getAllMaintenanceAliases();
    }

    private void patchingMaintenanceAlias() throws MaintenanceAliasException {
        Set patches = this._maPatch.getPatchRecs();
        List<PatchRec> patcheslist = this.sortPatchList(patches);
        for (PatchRec patch : patcheslist) {
            String patchLoc = patch.getPatchLocation();
            String patchFileLoc = MaintenanceAliasActionInfoHelper.getInstance().getMaintenanceAliasInfoPathFromPatch(patchLoc);
            HashSet<String> patched = new HashSet<String>();
            try {
                MaintenanceAliasActionService maService = MaintenanceAliasActionService.getInstance();
                MaintenanceAliasActionHolder maHolder = maService.loadMaintenanceAliasAction(patchFileLoc);
                Set maliases = maHolder.getMaintenanceAliasActions();
                Set mappings = maHolder.getMappingActions();
                Map<String, MappingAction> maps = maService.getMappingActionMap(maHolder);
                for (MaintenanceAliasAction malias : maliases) {
                    if (malias.getAction().toString().equals(ADD_ACTION)) {
                        MappingAction ma = maps.get(malias.getMaintenanceAlias().getMaintenanceAliasKey());
                        malias = this.addMappingsToMA(malias, ma);
                    }
                    this.patchMaintenanceAliasInfo(malias);
                    if (!malias.getAction().toString().equals(DELETE_ACTION) && !malias.getAction().toString().equals(ADD_ACTION)) continue;
                    patched.add(malias.getMaintenanceAlias().getMaintenanceAliasKey());
                }
                for (MappingAction mapping : mappings) {
                    String key = mapping.getMaintenanceAliasKey();
                    if (patched.contains(key)) continue;
                    this.patchArtifactReference(mapping);
                }
            }
            catch (MaintenanceAliasException e) {
                StringBuffer sb = new StringBuffer(e.getMessage());
                sb.append("\r\n");
                sb.append("Failed in patch: " + patch.getId());
                throw new MaintenanceAliasException(sb.toString(), (Throwable)e);
            }
        }
    }

    private MaintenanceAliasAction addMappingsToMA(MaintenanceAliasAction malias, MappingAction map) {
        ArrayList<ArtifactReference> mappings = new ArrayList<ArtifactReference>();
        MaintenanceAliasBuilderFactory builder = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasBuilderFactory();
        MaintenanceAlias tmpma = malias.getMaintenanceAlias();
        for (ArtifactReferenceAction comp : map.getComponentActions()) {
            mappings.add(builder.getComponentArtifactReferenceBuilder(comp.getArtifactReference().getName(), comp.getArtifactReference().getVersion()).build());
        }
        for (ArtifactReferenceAction dist : map.getDistributionActions()) {
            mappings.add(builder.getDistributionArtifactReferenceBuilder(dist.getArtifactReference().getName(), dist.getArtifactReference().getVersion()).build());
        }
        for (ArtifactReferenceAction fsa : map.getFeatureSetActions()) {
            mappings.add(builder.getFeatureSetArtifactReferenceBuilder(fsa.getArtifactReference().getName(), fsa.getArtifactReference().getVersion()).build());
        }
        MaintenanceAlias ma = builder.getMaintenanceAliasBuilder(tmpma.getProductFamily(), tmpma.getMaintenanceAliasKey(), tmpma.getProduct(), tmpma.getBundleType(), tmpma.getVersion(), tmpma.getTimestamp(), tmpma.getPatchType(), mappings).setPatchLevel(tmpma.getPatchLevel()).build();
        MaintenanceAliasAction maa = new MaintenanceAliasActionImpl.Builder(ma, malias.getAction()).build();
        return maa;
    }

    private List<PatchRec> sortPatchList(Set<PatchRec> patches) {
        ArrayList<PatchRec> patchesList = new ArrayList<PatchRec>();
        for (PatchRec patch : patches) {
            patchesList.add(patch);
        }
        Collections.sort(patchesList, new Comparator<PatchRec>(){

            @Override
            public int compare(PatchRec arg0, PatchRec arg1) {
                if (arg0.getApplicationTime().compareTo(arg1.getApplicationTime()) == 0) {
                    return arg0.getCreationTime().compareTo(arg1.getCreationTime());
                }
                return arg0.getApplicationTime().compareTo(arg1.getApplicationTime());
            }
        });
        return patchesList;
    }

    private void patchMaintenanceAliasInfo(MaintenanceAliasAction malias) throws MaintenanceAliasException {
        ActionType action = malias.getAction();
        MaintenanceAlias ma = malias.getMaintenanceAlias();
        boolean ispatched = false;
        switch (action) {
            case ADD: {
                ispatched = this._service.addMaintenanceAlias(ma);
                break;
            }
            case UPDATE: {
                ispatched = this._service.updateMaintenanceAlias(ma);
                break;
            }
            case DELETE: {
                ispatched = this._service.deleteMaintenanceAlias(ma);
                break;
            }
            default: {
                ispatched = true;
            }
        }
        if (!ispatched) {
            throw new MaintenanceAliasException("Failed to " + action + " Maintenance Alias: " + ma.getMaintenanceAliasKey());
        }
    }

    private void patchArtifactReference(MappingAction malias) throws MaintenanceAliasException {
        String maliaskey = malias.getMaintenanceAliasKey();
        HashSet mappings = new HashSet();
        boolean ispatched = false;
        mappings.addAll(malias.getComponentActions());
        mappings.addAll(malias.getFeatureSetActions());
        mappings.addAll(malias.getDistributionActions());
        for (ArtifactReferenceAction mapping : mappings) {
            ActionType action = mapping.getAction();
            ArtifactReference map = mapping.getArtifactReference();
            switch (action) {
                case ADD: {
                    ispatched = this._service.addMaintenanceAliasMapping(maliaskey, map);
                    break;
                }
                case UPDATE: {
                    ispatched = this._service.updateMaintenanceAliasMapping(maliaskey, map);
                    break;
                }
                case DELETE: {
                    ispatched = this._service.deleteMaintenanceAliasMapping(maliaskey, map);
                    break;
                }
                default: {
                    ispatched = false;
                }
            }
            if (ispatched) continue;
            throw new MaintenanceAliasException("Failed to " + mapping.getAction() + " Maintenance Alias mapping: " + mapping.getArtifactReference().getName() + " " + mapping.getArtifactReference().getVersion());
        }
    }
}

