/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.jaxb;

import com.oracle.cie.common.util.reporting.CommonReceiver;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.jaxb.messages.CompletionWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.InitiationWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.MessageWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.ProgressWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.ReportWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.Wrapper;
import com.oracle.cie.common.util.reporting.messages.TypedMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class JaxbReceiver
extends CommonReceiver {
    private XMLStreamReader _reader;

    public JaxbReceiver(InputStream in) throws ReportingException {
        super(in);
    }

    public JaxbReceiver(InputStream in, String messageIndicator) throws ReportingException {
        super(in, messageIndicator);
    }

    @Override
    public TypedMessage readNextMessage() throws ReportingException {
        try {
            if (!this.isClosed() && this._reader.hasNext()) {
                this._reader.nextTag();
                String elementName = this._reader.getLocalName();
                Class clazz = null;
                if ("report".equals(elementName)) {
                    clazz = ReportWrapper.class;
                } else if ("initiation".equals(elementName)) {
                    clazz = InitiationWrapper.class;
                } else if ("message".equals(elementName)) {
                    clazz = MessageWrapper.class;
                } else if ("progress".equals(elementName)) {
                    clazz = ProgressWrapper.class;
                } else if ("completion".equals(elementName)) {
                    clazz = CompletionWrapper.class;
                }
                if (clazz != null) {
                    Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
                    return ((Wrapper)unmarshaller.unmarshal(this._reader, clazz).getValue()).getWrapped();
                }
            }
        }
        catch (Exception e) {
            throw new ReportingException("Failed to read next message.", e);
        }
        return null;
    }

    @Override
    protected void configure() throws ReportingException {
        try {
            Enumeration<InputStream> streams = Collections.enumeration(Arrays.asList(new ByteArrayInputStream("<report>".getBytes()), this.getIn(), new ByteArrayInputStream("</report>".getBytes())));
            SequenceInputStream sequenceStream = new SequenceInputStream(streams);
            this._reader = XMLInputFactory.newInstance().createXMLStreamReader(sequenceStream);
            this._reader.next();
        }
        catch (Exception e) {
            throw new ReportingException("Failed to create xml stream reader.", e);
        }
    }
}

