/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver.remote;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.RemoteOperations;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class HomeListCollector
implements RemoteOperations {
    private static final int SUCCESS = 0;

    @Override
    public int executeAction(List<String> argsList) {
        if (argsList != null) {
            String giHomePath = ClusterInformationLoader.getInstance().getGridHome();
            System.setProperty("ORACLE_HOME", giHomePath);
            OUIDriver.setupEnvironment(giHomePath, giHomePath + File.separator + "oraInst.loc");
            ArrayList<String[]> homeList = OUIDriver.getHomesList();
            if (null != homeList) {
                StringBuffer buff = new StringBuffer();
                buff.append("HOST").append("=").append(OsysUtility.getHostname()).append(System.lineSeparator());
                buff.append("HOME_LIST").append("=");
                for (String[] homeArr : homeList) {
                    if (StringUtil.isNullOrEmpty((String)homeArr[0])) continue;
                    buff.append(FileUtils.getFile((String)homeArr[0])).append(",");
                }
                Reporting.report((String)buff.toString());
            }
        }
        return 0;
    }
}

