/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEncrypt;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rules;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.fmwpatchverbs.DeployActionEl;
import oracle.opatch.fmwpatchverbs.LifecycleActionEl;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchext.SecurePrompter;
import oracle.opatch.opatchfafmw.FmwHelper;
import oracle.opatch.opatchfafmw.OPatchFmwDS;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchBIPDeployAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchJEELifecycleAction;
import oracle.opatch.opatchsdk.OPatchMultipleBIPDeploy;
import oracle.opatch.opatchsdk.OPatchSOACompositeLifecycleAction;
import oracle.opatch.opatchsdk.OPatchSOAConfigPlan;
import oracle.opatch.opatchsdk.OPatchSOADeployAction;
import oracle.opatch.opatchsdk.OPatchSOARbDeployAction;
import oracle.opatch.opatchsdk.OPatchStandAloneDeployAction;
import oracle.opatch.opatchsdk.OPatchStandAloneSOADeployAction;
import oracle.opatch.patchverbs.AutomationElement;
import oracle.opatch.patchverbs.InterviewEl;
import oracle.opatch.patchverbs.ParserObject;
import oracle.opatch.security.WeblogicSecurity;
import oracle.opatch.wrappers.WrapperFactory;

public class FMWClientFactory {
    static Thread mainThread = Thread.currentThread();
    public static final String ADMIN_SERVER_URL = "AdminServerURL";
    public static final String ADMIN_USER = "AdminUser";
    public static final String ADMIN_SP = "ASP";
    public static final String NODE_MANAGER_USER = "NodeManagerUser";
    public static final String NODE_MP = "NMP";
    public static final String LDAP_BIND_DN = "LDAPBindDN";
    public static final String LDAP_P2 = "LDAPP2";
    public static final String LDAP_HOST_NAME = "LDAPhostName";
    public static final String LDAP_PORT_NUMBER = "LDAPPortNumber";
    public static final String LDAP_SSL_MODE = "LDAPSSLMode";
    public static String[] interData = new String[0];
    public static Properties interProp = null;

    public static ArrayList getCopyPaths(PatchObject po, String oh) {
        PatchAction[] pa = po.getAllActions();
        ArrayList<String> copyPath = new ArrayList<String>();
        for (int i2 = 0; i2 < pa.length; ++i2) {
            if (!(pa[i2] instanceof CopyAction)) continue;
            CopyAction ca = (CopyAction)pa[i2];
            String path = ca.getParentFilePath(oh);
            copyPath.add(path);
        }
        return copyPath;
    }

    public static String sanitizePath(String oh, String path, String fileName) throws Exception {
        StringBuffer newPath = new StringBuffer();
        newPath.append(oh);
        newPath.append(File.separator);
        newPath.append(PatchObjectUtil.filterString(path));
        newPath.append(File.separator);
        newPath.append(fileName);
        String finalPath = PatchObjectUtil.getPlatformDependentPath(newPath.toString());
        return finalPath;
    }

    public static boolean isPresent(String path, ArrayList copyPath) {
        try {
            String cPath1 = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]).toAbsolutePath().normalize().toString();
            for (int i2 = 0; i2 < copyPath.size(); ++i2) {
                String cPath2 = WrapperFactory.getNioServiceWrapper().getPath((String)copyPath.get(i2), new String[0]).toAbsolutePath().normalize().toString();
                if (!cPath1.equals(cPath2)) continue;
                return true;
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return false;
        }
        return false;
    }

    public static String getTempLocation(String oracleHomePath, String cookedPatchID) {
        String customLogDir = OPatchEnv.getCustomLogDir();
        String tempLoc = "";
        tempLoc = customLogDir != null && !customLogDir.equals("") ? customLogDir + File.separator + cookedPatchID : OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        return tempLoc;
    }

    /*
     * Unable to fully structure code
     */
    public static FMWClient getClient(String oh, String loc) {
        cp = new HashMap<String, String>(3);
        nm = false;
        logger = new OPatchLogger();
        FMWClientFactory.info(logger, "[FMW] Preparing Context ...");
        client = new FMWClient(logger);
        lifeCycle = false;
        soaOnly = false;
        parser = null;
        cp.put(FMWClient.LOG_FILE_LOCATION, OLogger.getLogFileLocation());
        if (loc != null) {
            po = null;
            try {
                po = PatchObject.getInstance(loc);
            }
            catch (Exception e) {
                throw new RuntimeException(OLogger.getString("OUI-67100", new Object[]{"OPatch", loc}), e);
            }
            OPatchSessionHelper.checkMinOPatchVersions(new PatchObject[]{po});
            if (!FMWClientFactory.isAutomatable(po)) {
                throw new UnsupportedOperationException(OLogger.getString("OUI-67702"));
            }
            parser = FMWClientFactory.getAutomationParserObject(po);
            if (parser != null) {
                try {
                    elements = parser.getAutomationElementsByName("LifecycleAction");
                    if (elements == null || elements.length <= 0) ** GOTO lbl55
                    list = new HashSet<String>(3);
                    for (i = 0; i < elements.length; ++i) {
                        lca = (LifecycleActionEl)elements[i];
                        dependencies = lca.getDependencyList();
                        if (dependencies == null || dependencies.size() <= 0) continue;
                        for (String dependency : dependencies) {
                            if (dependency == null || "".equals(dependency)) continue;
                            list.add(dependency);
                        }
                    }
                    if (list.size() <= 0) ** GOTO lbl55
                    client.setTargets(FMWClient.CONTAINER, list);
                    nm = true;
                    lifeCycle = true;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in getting metadata from automation.xml", e);
                }
            } else {
                apps = po.getDeployList();
                if (apps != null && apps.length > 0) {
                    data = new String[apps.length];
                    for (i = 0; i < apps.length; ++i) {
                        data[i] = apps[i].getApplicationName();
                    }
                    client.setTargets(FMWClient.CONTAINER, new HashSet<String>(Arrays.asList(data)));
                    nm = true;
                    lifeCycle = true;
                } else {
                    throw new RuntimeException("OPatch was not able to retrieve 'auto' information from patch contents.\nThe patch may be 'auto' certified but no automation data could be retrieved.");
                }
            }
lbl55:
            // 4 sources

            if (nm && (guid = FMWClientFactory.getHomeGUID(logger, oh)) != null) {
                cp.put(FMWClient.COMMON_HOME_GUID, guid);
            }
            customLogDir = OPatchEnv.getCustomLogDir();
            tempLoc = "";
            tempLoc = customLogDir != null && customLogDir.equals("") == false ? customLogDir + File.separator + po.getCookedPatchID() : OPatchEnv.getPatchStorageDirectoryPath(oh, po.getCookedPatchID());
            cp.put(FMWClient.TEMP_LOCATION, tempLoc);
            cp.put(FMWClient.ORACLE_HOME, oh);
            cp.put(FMWClient.PATCH_LOCATION, po.getPatchLocation());
            cp.put(FMWClient.PATCH_ID, po.getPatchID());
        } else {
            type = OPatchEnv.getFMWCmdTargetType();
            nm = true;
            if ("soaComposite".equalsIgnoreCase(type)) {
                soaOnly = true;
                comp_name = OPatchEnv.getFMWCompositeName();
                comp_rev = OPatchEnv.getFMWCompositeRevision();
                client.addSOAComposite(comp_name, comp_rev);
            } else {
                lifeCycle = true;
                if ("fmwApplication".equalsIgnoreCase(type)) {
                    type = FMWClient.APPLICATION;
                    nm = false;
                } else {
                    type = "fmwContainer".equalsIgnoreCase(type) != false ? FMWClient.CONTAINER : ("fmwServer".equalsIgnoreCase(type) != false ? FMWClient.SERVER : ("fmwCluster".equalsIgnoreCase(type) != false ? FMWClient.CLUSTER : null));
                }
                if (type == null) {
                    throw new RuntimeException("Invalid Target type. Please provide valid Entity type.");
                }
                targetList = OPatchEnv.getFMWTargetList();
                if (targetList == null || targetList.size() == 0) {
                    throw new RuntimeException("Empty Target Names list.");
                }
                client.setTargets(type, targetList);
            }
        }
        data = FMWClientFactory.interviewUser(soaOnly, lifeCycle, false);
        prop = null;
        if (parser != null) {
            prop = FMWClientFactory.interviewAutomation(parser);
        }
        if (lifeCycle || soaOnly) {
            client.setDomain(data);
        }
        client.setConfigProperties(cp);
        client.setInterviewProperties(prop);
        client.done();
        return client;
    }

    public static FMWClient[] getAllClients(String oh, String loc, boolean apply, boolean dryRun) {
        return FMWClientFactory.getAllClients(oh, loc, true, apply, dryRun);
    }

    public static FMWClient[] getAllClients(String oh, String loc, boolean isInterview, boolean apply, boolean dryRun) {
        ArrayList<FMWClient> clientList = new ArrayList<FMWClient>();
        boolean bipSupport = false;
        Properties prop = null;
        String relPathAdd = "";
        String logFileLocation = OLogger.getLogFileLocation();
        if (loc != null) {
            String guid;
            String[] data_ds;
            PatchObject po = null;
            boolean phOption = OPatchEnv.getPatchloc() != null && !OPatchEnv.getPatchloc().equals("");
            boolean deployUtil = OPatchEnv.getUtilOption().equalsIgnoreCase("deploy");
            try {
                po = PatchObject.getInstance(loc);
                relPathAdd = apply && dryRun ? loc + File.separator + "files" : oh;
                if (deployUtil && phOption) {
                    relPathAdd = loc + File.separator + "files";
                }
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                throw new RuntimeException(OLogger.getString("OUI-67100", new Object[]{"OPatch", loc}), e2);
            }
            OPatchSessionHelper.checkMinOPatchVersions(new PatchObject[]{po});
            if (!FMWClientFactory.isAutomatable(po)) {
                if (deployUtil) {
                    return null;
                }
                throw new UnsupportedOperationException(OLogger.getString("OUI-67702"));
            }
            ArrayList copyPath = FMWClientFactory.getCopyPaths(po, oh);
            ParserObject parser = FMWClientFactory.getAutomationParserObject(po);
            if (parser != null) {
                try {
                    boolean lifeCycle = false;
                    boolean ldiffDeploy = false;
                    boolean isSOADeploy = false;
                    boolean isBIPDeploy = false;
                    AutomationElement[] lc_elements = parser.getAutomationElementsByName("LifecycleAction");
                    if (lc_elements != null && lc_elements.length > 0) {
                        lifeCycle = true;
                    }
                    AutomationElement[] elements = parser.getListOfElements();
                    for (int i2 = 0; i2 < elements.length; ++i2) {
                        HashMap<String, String> cp = new HashMap<String, String>(3);
                        boolean nm = false;
                        OPatchLogger logger = new OPatchLogger();
                        FMWClientFactory.info(logger, "[FMW] Preparing Context ...");
                        if (elements[i2] instanceof InterviewEl) continue;
                        FMWClient client = new FMWClient(logger);
                        client.setPreAction(elements[i2].isPreAction());
                        String actionType = "Restart";
                        if (elements[i2] instanceof LifecycleActionEl) {
                            HashSet<String> list = new HashSet<String>(3);
                            LifecycleActionEl lca = (LifecycleActionEl)elements[i2];
                            ArrayList dependencies = lca.getDependencyList();
                            if (dependencies != null && dependencies.size() > 0) {
                                for (String dependency : dependencies) {
                                    if (dependency == null || "".equals(dependency)) continue;
                                    list.add(dependency);
                                }
                            }
                            if (list.size() > 0) {
                                client.setTargets(FMWClient.CONTAINER, list);
                                client.setActionType(lca.getLifeCycleActionType());
                                nm = true;
                            }
                        } else if (elements[i2] instanceof DeployActionEl) {
                            String fileName;
                            String path;
                            String msg;
                            DeployActionEl da = (DeployActionEl)elements[i2];
                            if (da.isSOACompDeploy() || da.isSOARbDeploy()) {
                                if (!apply) {
                                    throw new RuntimeException(OLogger.getString("OUI-68024"));
                                }
                                String name = da.getSOADeployCompositeName();
                                String path2 = da.getDeployPath();
                                String fileName2 = da.getDeployFileName();
                                if (!FMWClientFactory.isPresent(path2 = FMWClientFactory.sanitizePath(relPathAdd, path2, fileName2), copyPath) && relPathAdd.equals(oh)) {
                                    msg = OLogger.getString("OUI-67718", new Object[]{"soaComposite", path2});
                                    OLogger.println(msg);
                                    continue;
                                }
                                isSOADeploy = true;
                                String revision = da.getSOADeployRevision();
                                boolean designChanges = da.getSOADeployDesignChanges();
                                boolean resourceBundle = da.isSOARbDeploy();
                                boolean isBaseCompDeployment = da.isBaseCompositeDeployment();
                                client.addSOAComposite(name, path2, revision, designChanges, resourceBundle, isBaseCompDeployment);
                                if (OPatchEnv.isBaseConfigPlanForDeploy()) {
                                    client.setNoneConfigPlan(false);
                                }
                            }
                            if (da.isLDIFDeploy()) {
                                if (!apply) continue;
                                path = da.getDeployPath();
                                fileName = da.getDeployFileName();
                                if (!FMWClientFactory.isPresent(path = FMWClientFactory.sanitizePath(relPathAdd, path, fileName), copyPath) && relPathAdd.equals(oh)) {
                                    String msg2 = OLogger.getString("OUI-67718", new Object[]{"LDIF data", path});
                                    OLogger.println(msg2);
                                    continue;
                                }
                                ldiffDeploy = true;
                                client.addLDIF(fileName, path);
                            }
                            if (da.isBIPDeploy()) {
                                if (!bipSupport) {
                                    String msg3 = OLogger.getString("OUI-67728");
                                    OLogger.println(msg3);
                                    continue;
                                }
                                path = da.getDeployPath();
                                fileName = da.getDeployFileName();
                                String relativePath = FMWClientFactory.sanitizePath("", path, fileName);
                                if (!FMWClientFactory.isPresent(path = FMWClientFactory.sanitizePath(relPathAdd, path, fileName), copyPath) && relPathAdd.equals(oh)) {
                                    msg = OLogger.getString("OUI-67718", new Object[]{"BIP", path});
                                    OLogger.println(msg);
                                    continue;
                                }
                                client.addBIP(fileName, path, relativePath, oh);
                                isBIPDeploy = true;
                            }
                        }
                        if (isSOADeploy || elements[i2] instanceof LifecycleActionEl) {
                            String guid2;
                            if (nm && (guid2 = FMWClientFactory.getHomeGUID(logger, oh)) != null) {
                                cp.put(FMWClient.COMMON_HOME_GUID, guid2);
                            }
                            String customLogDir = OPatchEnv.getCustomLogDir();
                            String tempLoc = "";
                            tempLoc = customLogDir != null && !customLogDir.equals("") ? customLogDir + File.separator + po.getCookedPatchID() : OPatchEnv.getPatchStorageDirectoryPath(oh, po.getCookedPatchID());
                            cp.put(FMWClient.TEMP_LOCATION, tempLoc);
                            cp.put(FMWClient.LOG_FILE_LOCATION, logFileLocation);
                        }
                        cp.put(FMWClient.ORACLE_HOME, oh);
                        cp.put(FMWClient.PATCH_LOCATION, po.getPatchLocation());
                        cp.put(FMWClient.PATCH_ID, po.getPatchID());
                        client.setConfigProperties(cp);
                        clientList.add(client);
                    }
                    String[] data = new String[]{};
                    if (isInterview) {
                        data = FMWClientFactory.interviewUser(isSOADeploy, lifeCycle, ldiffDeploy);
                        if (bipSupport) {
                            prop = FMWClientFactory.interviewAutomation(parser);
                        }
                        interProp = prop;
                        interData = data;
                    } else {
                        data = interData;
                        prop = interProp;
                    }
                    for (int i3 = 0; i3 < clientList.size(); ++i3) {
                        FMWClient client = (FMWClient)clientList.get(i3);
                        if (ldiffDeploy) {
                            client.setLDAPCredentials(data);
                        }
                        if (isSOADeploy || lifeCycle) {
                            client.setDomain(data);
                        }
                        client.setInterviewProperties(prop);
                        client.done();
                    }
                }
                catch (Exception e3) {
                    RuntimeException rte = new RuntimeException(e3.getMessage());
                    rte.setStackTrace(e3.getStackTrace());
                    throw rte;
                }
            }
            OPatchLogger logger = new OPatchLogger();
            FMWClientFactory.info(logger, "[FMW] Preparing Context ...");
            HashMap<String, String> cp = new HashMap<String, String>(3);
            boolean nm = false;
            FMWClient client = new FMWClient(logger);
            OPatchFmwDS.DeployDS[] apps = po.getDeployList();
            if (apps != null && apps.length > 0) {
                data_ds = new String[apps.length];
                for (int i4 = 0; i4 < apps.length; ++i4) {
                    data_ds[i4] = apps[i4].getApplicationName();
                }
            } else {
                throw new RuntimeException("OPatch was not able to retrieve 'auto' information from patch contents.\nThe patch may be 'auto' certified but no automation data could be retrieved.");
            }
            client.setTargets(FMWClient.CONTAINER, new HashSet<String>(Arrays.asList(data_ds)));
            nm = true;
            if (nm && (guid = FMWClientFactory.getHomeGUID(logger, oh)) != null) {
                cp.put(FMWClient.COMMON_HOME_GUID, guid);
            }
            String customLogDir = OPatchEnv.getCustomLogDir();
            String tempLoc = "";
            tempLoc = customLogDir != null && !customLogDir.equals("") ? customLogDir + File.separator + po.getCookedPatchID() : OPatchEnv.getPatchStorageDirectoryPath(oh, po.getCookedPatchID());
            cp.put(FMWClient.TEMP_LOCATION, tempLoc);
            cp.put(FMWClient.LOG_FILE_LOCATION, logFileLocation);
            String[] data = FMWClientFactory.interviewUser(true, nm, false);
            client.setDomain(data);
            client.setConfigProperties(cp);
            client.done();
            clientList.add(client);
        } else {
            OPatchLogger logger = new OPatchLogger();
            FMWClientFactory.info(logger, "[FMW] Preparing Context ...");
            HashMap<String, String> cp = new HashMap<String, String>(3);
            cp.put(FMWClient.LOG_FILE_LOCATION, logFileLocation);
            boolean nm = true;
            FMWClient client = new FMWClient(logger);
            String type = OPatchEnv.getFMWCmdTargetType();
            if ("fmwApplication".equalsIgnoreCase(type)) {
                type = FMWClient.APPLICATION;
                nm = false;
            } else {
                type = "fmwContainer".equalsIgnoreCase(type) ? FMWClient.CONTAINER : ("fmwServer".equalsIgnoreCase(type) ? FMWClient.SERVER : ("fmwCluster".equalsIgnoreCase(type) ? FMWClient.CLUSTER : null));
            }
            if (type == null) {
                throw new RuntimeException("Invalid Target type. Please provide valid Entity type.");
            }
            HashSet targetList = OPatchEnv.getFMWTargetList();
            if (targetList == null || targetList.size() == 0) {
                throw new RuntimeException("Empty Target Names list.");
            }
            client.setTargets(type, targetList);
            String[] data = FMWClientFactory.interviewUser(true, nm, false);
            client.setDomain(data);
            client.setConfigProperties(cp);
            client.done();
            clientList.add(client);
        }
        FMWClient[] allClients = clientList.toArray(new FMWClient[clientList.size()]);
        OPatchEnv.setFMWClients(allClients);
        return allClients;
    }

    public static ParserObject getAutomationParserObject(PatchObject po) {
        ArrayList<ParserObject> parsers = po.getParserObject();
        for (ParserObject p2 : parsers) {
            if (!p2.getFileName().equals("automation.xml")) continue;
            return p2;
        }
        return null;
    }

    private static void info(String s) {
        OLogger.printlnOnLog(s);
    }

    private static void info(FMWClient.LoggerWrapper logger, String s) {
        logger.printInLogFile(s);
    }

    private static boolean isAutomatable(PatchObject po) {
        return Rules.isAutomatable(po);
    }

    private static String norm(String s) {
        return s == null ? "" : s.trim();
    }

    private static boolean check(String property, String file) {
        if ("".equals(file)) {
            if (OPatchEnv.isSilent()) {
                FMWClientFactory.info("[FMW-WARNING] [" + property + "] File not provided.");
            }
            return false;
        }
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]);
        if (!Files.isRegularFile(f2, new LinkOption[0])) {
            if (OPatchEnv.isSilent()) {
                FMWClientFactory.info("[FMW-WARNING] [" + property + "] File [" + file + "] doesn't exist.");
            }
            return false;
        }
        if (!Files.isReadable(f2)) {
            if (OPatchEnv.isSilent()) {
                FMWClientFactory.info("[FMW-WARNING] [" + property + "] File [" + file + "] doesn't have read permission.");
            }
            return false;
        }
        return true;
    }

    private static Properties interviewAutomation(ParserObject po) throws RuntimeException {
        Properties p2 = null;
        try {
            AutomationElement[] ae = po.getAutomationElementsByName("Interview");
            if (ae == null) {
                return p2;
            }
            if (ae.length == 0) {
                return p2;
            }
            p2 = new Properties();
            Properties opatchProp = OPatchEnv.getOPatchProperties();
            ArrayList<String> neededList = new ArrayList<String>();
            for (int i2 = 0; i2 < ae.length; ++i2) {
                InterviewEl ie = (InterviewEl)ae[i2];
                String question = ie.getQuestionValue();
                String key = ie.getKeyValue();
                boolean mask = ie.getMaskValue();
                boolean isRequired = ie.getRequiredValue();
                String defaultValue = ie.getDefaultValue();
                defaultValue = defaultValue.trim();
                String finalResult = "";
                char[] data = new char[]{};
                String dataStr = "";
                boolean gotFromProp = false;
                try {
                    block16: {
                        block13: {
                            block14: {
                                block15: {
                                    dataStr = opatchProp.getProperty(key);
                                    if (dataStr == null) {
                                        dataStr = "";
                                    } else {
                                        gotFromProp = true;
                                    }
                                    do {
                                        if (!OPatchEnv.isSilent() && dataStr.equals("")) {
                                            data = SecurePrompter.readResponse(question, null, !mask);
                                            dataStr = new String(data);
                                            dataStr = dataStr.trim();
                                        }
                                        if (dataStr != null && !dataStr.equals("")) break block13;
                                        if (!isRequired) break block14;
                                        if (!defaultValue.equals("")) break block15;
                                    } while (!OPatchEnv.isSilent());
                                    neededList.add(key);
                                    break block16;
                                }
                                dataStr = defaultValue;
                                break block16;
                            }
                            dataStr = defaultValue;
                            break block16;
                        }
                        if ((OPatchEnv.isSilent() || gotFromProp) && mask && !dataStr.equals("")) {
                            dataStr = OPatchEncrypt.performOperation(OPatchEncrypt.DECRYPT, dataStr, OPatchEnv.getOracleHome());
                        }
                    }
                    finalResult = dataStr;
                    p2.setProperty(key, finalResult);
                    continue;
                }
                catch (Exception e2) {
                    RuntimeException rte = new RuntimeException(e2.getMessage());
                    rte.setStackTrace(e2.getStackTrace());
                    throw rte;
                }
            }
            if (neededList.size() != 0) {
                throw new RuntimeException(OLogger.getString("OUI-67725", new Object[]{neededList.toString()}));
            }
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            throw new RuntimeException(e3.getMessage());
        }
        return p2;
    }

    private static String[] interviewUser(boolean soaDeploy, boolean lifeCycle, boolean ldifDeploy) {
        char[] data;
        String url;
        int MAX_SIZE = 10;
        boolean shouldReadAdminURL = false;
        String[] var = new String[]{ADMIN_SERVER_URL, "AdminConfigFile", "AdminKeyFile", "NodeManagerConfigFile", "NodeManagerKeyFile", "LDAPHost", "LDAPPort", "LDAPUserName", "LDAPPassword", LDAP_SSL_MODE};
        String[] desc = new String[]{"Please enter the WebLogic Admin Server URL", "Please enter the WebLogic Admin Server username", "Please enter the WebLogic Admin Server password", "Please enter the NodeManager username", "Please enter the NodeManager password", "Please enter the LDAP Server Host Name", "Please enter the LDAP Port Number", "Please enter the LDAP Realm (Bind DN)", "Please enter the LDAP Realm Password", "Is LDAP port SSL port?(y|n)"};
        boolean[] visible = new boolean[]{true, true, false, true, false, true, true, true, false, true};
        boolean[] encrypt = new boolean[]{false, true, true, true, true, false, false, false, true, false};
        int size = 0;
        if (soaDeploy && ldifDeploy) {
            size = 10;
        } else if (lifeCycle && ldifDeploy) {
            size = 10;
        } else if (soaDeploy) {
            size = 3;
        } else if (lifeCycle) {
            size = 5;
        } else if (ldifDeploy) {
            size = 10;
        }
        BitSet bits = new BitSet(size);
        String[] result = new String[MAX_SIZE];
        Properties p2 = OPatchEnv.getOPatchProperties();
        if (p2 != null) {
            String[] credentials;
            String key;
            String config;
            if ((soaDeploy || lifeCycle) && !"".equals(url = FMWClientFactory.norm(p2.getProperty(var[0])))) {
                result[0] = url;
                bits.set(0);
            }
            if (soaDeploy || lifeCycle) {
                config = FMWClientFactory.norm(p2.getProperty(var[1]));
                key = FMWClientFactory.norm(p2.getProperty(var[2]));
                if (config.equals("") && key.equals("")) {
                    config = FMWClientFactory.norm(p2.getProperty("userConfigFile"));
                    key = FMWClientFactory.norm(p2.getProperty("userKeyFile"));
                }
                if (FMWClientFactory.check(var[1], config) & FMWClientFactory.check(var[2], key)) {
                    try {
                        credentials = WeblogicSecurity.getCredentials(config, key);
                        result[1] = credentials[0];
                        result[2] = credentials[1];
                        bits.set(1);
                        bits.set(2);
                    }
                    catch (Exception e2) {
                        OLogger.printStackTrace(e2);
                    }
                }
            }
            if (lifeCycle) {
                config = FMWClientFactory.norm(p2.getProperty(var[3]));
                key = FMWClientFactory.norm(p2.getProperty(var[4]));
                if (FMWClientFactory.check(var[3], config) & FMWClientFactory.check(var[4], key)) {
                    try {
                        credentials = WeblogicSecurity.getCredentials(config, key);
                        result[3] = credentials[0];
                        result[4] = credentials[1];
                        bits.set(3);
                        bits.set(4);
                    }
                    catch (Exception e3) {
                        OLogger.printStackTrace(e3);
                    }
                }
            }
            if (ldifDeploy) {
                String userName = FMWClientFactory.norm(p2.getProperty(var[7]));
                String encryptedPassword = FMWClientFactory.norm(p2.getProperty(var[8]));
                String sslMode = FMWClientFactory.norm(p2.getProperty(var[9]));
                String host = FMWClientFactory.norm(p2.getProperty(var[5]));
                String port = FMWClientFactory.norm(p2.getProperty(var[6]));
                if (!"".equals(host)) {
                    result[5] = host;
                    bits.set(5);
                }
                if (!"".equals(port)) {
                    result[6] = port;
                    bits.set(6);
                }
                if (!"".equals(userName)) {
                    result[7] = userName;
                    bits.set(7);
                }
                if (!"".equals(sslMode)) {
                    result[9] = sslMode;
                    bits.set(9);
                }
                if (encryptedPassword == null) {
                    encryptedPassword = "";
                }
                if (!"".equals(encryptedPassword)) {
                    String password;
                    result[8] = password = OPatchEncrypt.performOperation(OPatchEncrypt.DECRYPT, encryptedPassword, OPatchEnv.getOracleHome());
                    bits.set(8);
                }
            }
        }
        if (OPatchEnv.isSilent()) {
            if (!bits.get(0) && (soaDeploy || lifeCycle) && (url = FMWClientFactory.getAdminURL()) != null) {
                result[0] = url;
                bits.set(0);
            }
            StringBuffer sb = null;
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 >= 0 && i2 < 3 && soaDeploy && !bits.get(i2)) {
                    StringBuffer stringBuffer = sb = sb == null ? new StringBuffer(var[i2]) : sb.append(", ").append(var[i2]);
                }
                if (i2 >= 3 && i2 < 5 && lifeCycle && !bits.get(i2)) {
                    StringBuffer stringBuffer = sb = sb == null ? new StringBuffer(var[i2]) : sb.append(", ").append(var[i2]);
                }
                if (i2 < 5 || i2 >= 10 || !ldifDeploy || bits.get(i2)) continue;
                sb = sb == null ? new StringBuffer(var[i2]) : sb.append(", ").append(var[i2]);
            }
            if (sb != null) {
                throw new RuntimeException(OLogger.getString("OUI-67715", new Object[]{sb.toString()}));
            }
            return result;
        }
        if (soaDeploy || lifeCycle) {
            for (int i3 = 0; i3 < 3; ++i3) {
                if (bits.get(i3)) continue;
                data = null;
                do {
                    try {
                        data = SecurePrompter.readResponse(desc[i3], i3 == 0 ? FMWClientFactory.getAdminURL() : null, visible[i3]);
                    }
                    catch (Exception e4) {
                        OLogger.printStackTrace(e4);
                    }
                } while (data == null || data.length == 0);
                result[i3] = String.valueOf(data);
                Arrays.fill(data, '0');
            }
        }
        if (lifeCycle) {
            for (int i4 = 3; i4 < 5; ++i4) {
                if (bits.get(i4)) continue;
                data = null;
                do {
                    try {
                        data = SecurePrompter.readResponse(desc[i4], null, visible[i4]);
                    }
                    catch (Exception e5) {
                        OLogger.printStackTrace(e5);
                    }
                } while (data == null || data.length == 0);
                result[i4] = String.valueOf(data);
                Arrays.fill(data, '0');
            }
        }
        if (ldifDeploy) {
            for (int i5 = 5; i5 < 10; ++i5) {
                if (bits.get(i5)) continue;
                data = null;
                boolean input = true;
                do {
                    try {
                        data = SecurePrompter.readResponse(desc[i5], null, visible[i5]);
                        if (i5 != 9) continue;
                        String strData = String.valueOf(data).trim();
                        if (!strData.equals("y") && !strData.equals("n")) {
                            input = false;
                            continue;
                        }
                        data = strData.equals("y") ? "true".toCharArray() : "false".toCharArray();
                        input = true;
                    }
                    catch (Exception e6) {
                        OLogger.printStackTrace(e6);
                    }
                } while (data == null || data.length == 0 || !input);
                result[i5] = String.valueOf(data);
                Arrays.fill(data, '0');
            }
        }
        return result;
    }

    private static String getAdminURL() {
        try {
            String url;
            String domain = FMWClientFactory.norm(OPatchEnv.getFMWDomainName());
            if ("".equals(domain)) {
                OLogger.printlnOnLog("Trying to get the default domain...");
                String oh = OPatchEnv.getOracleHome();
                HashSet set = FmwHelper.getDomainOracleHomeMap(null, null, oh, null);
                if (set == null || set.size() == 0) {
                    String msg = OLogger.getString("OUI-67831", new Object[]{oh});
                    OLogger.printlnOnLog(msg);
                    return null;
                }
                if (set.size() > 1) {
                    OLogger.printlnOnLog("Following domains are configured from this Oracle Home:\n");
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        String[] parts;
                        String domainInfo = FMWClientFactory.norm((String)it.next());
                        if ("".equals(domainInfo) || (parts = domainInfo.split(";")).length != 2) continue;
                        OLogger.printlnOnLog(" Domain Name = \"" + parts[0] + "\" Path = \"" + parts[1] + "\"");
                    }
                    String msg = OLogger.getString("OUI-67832", new Object[]{oh});
                    OLogger.printlnOnLog(msg);
                    return null;
                }
                String domainInfo = FMWClientFactory.norm((String)set.iterator().next());
                if ("".equals(domainInfo) || domainInfo.length() < 3 || "".equals(domain = FMWClientFactory.norm(domainInfo.split(";")[0]))) {
                    String msg = OLogger.getString("OUI-67831", new Object[]{oh});
                    OLogger.printlnOnLog(msg);
                    return null;
                }
            }
            if ("".equals(url = FMWClientFactory.norm(FmwHelper.getAdminURL(domain)))) {
                return null;
            }
            return url;
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return null;
        }
    }

    private static String getHomeGUID(FMWClient.LoggerWrapper logger, String oh) {
        try {
            String home = FMWClientFactory.norm(System.getProperty("OPatch.COMMON_COMPONENTS_HOME"));
            if ("".equals(home)) {
                throw new Exception("Common Components Home is not specified.");
            }
            IIPMReadServices readServices = PrereqSession.getReadServices(oh);
            if (!readServices.isInventoryLoaded()) {
                throw new Exception("Oracle Home [" + oh + "] is not registered with Central Inventory.");
            }
            String guid = readServices.getGUID(home);
            FMWClientFactory.info(logger, "[FMW] Home GUID for [" + home + "] [" + guid + "]");
            return guid;
        }
        catch (Throwable t) {
            FMWClientFactory.info(logger, new StringBuffer("[FMW] [HomeGUID] ").append(t).toString());
            return null;
        }
    }

    private static String[] getData(Map map) {
        String[] data = new String[10];
        data[0] = (String)map.get(ADMIN_SERVER_URL);
        data[1] = (String)map.get(ADMIN_USER);
        char[] pw = (char[])map.get(ADMIN_SP);
        if (pw != null) {
            data[2] = new String(pw);
        }
        data[3] = (String)map.get(NODE_MANAGER_USER);
        char[] nmpw = (char[])map.get(NODE_MP);
        if (nmpw != null) {
            data[4] = new String(nmpw);
        }
        if (pw != null) {
            Arrays.fill(pw, '0');
        }
        if (nmpw != null) {
            Arrays.fill(nmpw, '0');
        }
        data[5] = (String)map.get(LDAP_HOST_NAME);
        data[6] = (String)map.get(LDAP_PORT_NUMBER);
        data[7] = (String)map.get(LDAP_BIND_DN);
        char[] ldappw = (char[])map.get(LDAP_P2);
        if (ldappw != null) {
            data[8] = new String(ldappw);
            Arrays.fill(ldappw, '0');
        }
        data[9] = (String)map.get(LDAP_SSL_MODE);
        return data;
    }

    /*
     * Unable to fully structure code
     */
    public static FMWClient[] getClients(String oh, String loc, Map iMap, Properties prop) {
        cp = new HashMap<String, String>(3);
        logger = new SDKLogger();
        FMWClientFactory.info(logger, "[FMW] Preparing Context ...");
        clientList = new ArrayList<FMWClient>();
        data = FMWClientFactory.getData(iMap);
        soaCompsPresent = false;
        isSOADeploy = false;
        isLifeCycle = false;
        isLDIFDeploy = false;
        isBIPDeploy = false;
        cp.put(FMWClient.LOG_FILE_LOCATION, OLogger.getLogFileLocation());
        mode = (String)iMap.get("OPatch.OPER_MODE");
        if (loc == null) ** GOTO lbl109
        po = null;
        try {
            po = PatchObject.getInstance(loc);
        }
        catch (Exception e) {
            throw new RuntimeException(OLogger.getString("OUI-67100", new Object[]{"OPatch", loc}), e);
        }
        copyPath = FMWClientFactory.getCopyPaths(po, oh);
        parser = FMWClientFactory.getAutomationParserObject(po);
        try {
            mandatoryKeys = parser.getRequiredInterviewKeys();
            neededKeys = new ArrayList<String>();
            if (prop != null) {
                for (k = 0; k < mandatoryKeys.length; ++k) {
                    value = prop.getProperty(mandatoryKeys[k]);
                    if (value != null && !value.equals("")) continue;
                    neededKeys.add(mandatoryKeys[k]);
                }
            } else {
                for (k = 0; k < mandatoryKeys.length; ++k) {
                    neededKeys.add(mandatoryKeys[k]);
                }
            }
            if (neededKeys.size() != 0) {
                throw new RuntimeException(OLogger.getString("OUI-67726", new Object[]{neededKeys.toString()}));
            }
        }
        catch (Exception e) {
            rte = new RuntimeException(e.getMessage());
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        if (parser != null) {
            try {
                elements = parser.getAutomationElementsByName("DeployActions");
                if (elements == null || elements.length <= 0) ** GOTO lbl160
                for (i = 0; i < elements.length; ++i) {
                    client = new FMWClient(logger);
                    da = (DeployActionEl)elements[i];
                    if (da.isSOACompDeploy() || da.isSOARbDeploy()) {
                        name = da.getSOADeployCompositeName();
                        path = da.getDeployPath();
                        fileName = da.getDeployFileName();
                        if (!FMWClientFactory.isPresent(path = FMWClientFactory.sanitizePath(oh, path, fileName), copyPath)) {
                            msg = OLogger.getString("OUI-67718", new Object[]{"soaComposite", path});
                            OLogger.println(msg);
                            continue;
                        }
                        isSOADeploy = true;
                        soaCompsPresent = true;
                        revision = da.getSOADeployRevision();
                        designChanges = da.getSOADeployDesignChanges();
                        resourceBundle = da.isSOARbDeploy();
                        client.addSOAComposite(name, path, revision, designChanges, resourceBundle);
                    }
                    if (da.isLDIFDeploy()) {
                        if (mode.equals("rollback")) continue;
                        path = da.getDeployPath();
                        fileName = da.getDeployFileName();
                        if (!FMWClientFactory.isPresent(path = FMWClientFactory.sanitizePath(oh, path, fileName), copyPath)) {
                            msg = OLogger.getString("OUI-67718", new Object[]{"LDIF data", path});
                            OLogger.println(msg);
                            continue;
                        }
                        isLDIFDeploy = true;
                        client.addLDIF(fileName, path);
                    }
                    if (da.isBIPDeploy()) {
                        path = da.getDeployPath();
                        fileName = da.getDeployFileName();
                        relativePath = FMWClientFactory.sanitizePath("", path, fileName);
                        if (!FMWClientFactory.isPresent(path = FMWClientFactory.sanitizePath(oh, path, fileName), copyPath)) {
                            msg = OLogger.getString("OUI-67718", new Object[]{"BIP", path});
                            OLogger.println(msg);
                            continue;
                        }
                        client.addBIP(fileName, path, relativePath, oh);
                        isBIPDeploy = true;
                    }
                    tempLoc = FMWClientFactory.getTempLocation(oh, po.getCookedPatchID());
                    cp.put(FMWClient.TEMP_LOCATION, tempLoc);
                    cp.put(FMWClient.ORACLE_HOME, oh);
                    cp.put(FMWClient.PATCH_ID, po.getPatchID());
                    cp.put(FMWClient.PATCH_LOCATION, (String)iMap.get("OPATCH.PATCH_ARCHIVE_ROOT"));
                    if (isSOADeploy) {
                        client.setDomain(data);
                    }
                    if (isLDIFDeploy) {
                        client.setLDAPCredentials(data);
                    }
                    client.setInterviewProperties(prop);
                    client.setConfigProperties(cp);
                    client.done();
                    clientList.add(client);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in getting metadata from automation.xml", e);
            }
        } else {
            throw new RuntimeException("OPatch was not able to parse the 'automation' file of the patch to get metadata");
lbl109:
            // 1 sources

            type = (String)iMap.get("OPATCH.ENTITY_TYPE");
            nm = false;
            client = new FMWClient(logger);
            if (type != null) {
                if ("soaComposite".equalsIgnoreCase(type)) {
                    nm = true;
                    comp_name = (String)iMap.get("COMPOSITE_NAME");
                    comp_rev = (String)iMap.get("COMPOSITE_REVISION");
                    client.addSOAComposite(comp_name, comp_rev);
                } else {
                    if ("fmwApplication".equalsIgnoreCase(type)) {
                        type = FMWClient.APPLICATION;
                    } else if ("fmwContainer".equalsIgnoreCase(type)) {
                        type = FMWClient.CONTAINER;
                        nm = true;
                    } else if ("fmwServer".equalsIgnoreCase(type)) {
                        type = FMWClient.SERVER;
                        nm = true;
                    } else if ("fmwCluster".equalsIgnoreCase(type)) {
                        type = FMWClient.CLUSTER;
                        nm = true;
                    } else {
                        type = null;
                    }
                    if (type == null) {
                        throw new RuntimeException("Invalid Entity type. Please provide valid Entity type.");
                    }
                    targetList = null;
                    list = (String[])iMap.get("OPATCH.ENTITY_NAMES");
                    if (list != null && list.length > 0) {
                        targetList = new HashSet<String>(Arrays.asList(list));
                    }
                    if (targetList == null) {
                        throw new RuntimeException("Empty Entity Names list.");
                    }
                    client.setTargets(type, targetList);
                    cp.put(FMWClient.STOP_ANY_SERVER, "true");
                }
            }
            home = (String)iMap.get("OPatch.COMMON_COMPONENTS_HOME");
            if (nm && home != null) {
                System.setProperty("OPatch.COMMON_COMPONENTS_HOME", home);
                guid = FMWClientFactory.getHomeGUID(logger, oh);
                if (guid != null) {
                    cp.put(FMWClient.COMMON_HOME_GUID, guid);
                }
            }
            client.setDomain(data);
            client.setInterviewProperties(prop);
            client.setConfigProperties(cp);
            client.done();
            clientList.add(client);
        }
lbl160:
        // 3 sources

        allClients = clientList.toArray(new FMWClient[clientList.size()]);
        return allClients;
    }

    public static FMWClient getDomainClient(Map iMap) throws Exception {
        HashMap<String, String> cp = new HashMap<String, String>(3);
        String oh = (String)iMap.get("OPatch.ORACLE_HOME");
        cp.put(FMWClient.ORACLE_HOME, oh);
        String[] data = FMWClientFactory.getData(iMap);
        FMWClient client = new FMWClient(null);
        client.setDomain(data);
        client.setConfigProperties(cp);
        return client;
    }

    public static FMWClient getClient(OPatchFAAutomationAction faaa, Map iMap, Properties prop) throws Exception {
        FMWClient client;
        HashMap<String, String> cp;
        block14: {
            String fileName;
            String relPathAdd;
            String[] data;
            block17: {
                String oh;
                SDKLogger logger;
                block16: {
                    String path;
                    block15: {
                        block13: {
                            OPatchSOADeployAction soa;
                            OPatchDeployAction deploy;
                            cp = new HashMap<String, String>(3);
                            logger = new SDKLogger();
                            FMWClientFactory.info(logger, "[FMW] Preparing Context ...");
                            client = new FMWClient(logger);
                            boolean soaCompsPresent = false;
                            boolean isSOADeploy = false;
                            boolean isLifeCycle = false;
                            boolean isBIPDeploy = false;
                            oh = (String)iMap.get("OPatch.ORACLE_HOME");
                            cp.put(FMWClient.TEMP_LOCATION, (String)iMap.get("TEMP_LOCATION"));
                            cp.put(FMWClient.ORACLE_HOME, oh);
                            cp.put(FMWClient.PATCH_ID, (String)iMap.get("PATCH_ID"));
                            cp.put(FMWClient.PATCH_LOCATION, (String)iMap.get("OPATCH.PATCH_ARCHIVE_ROOT"));
                            cp.put(FMWClient.LOG_FILE_LOCATION, OLogger.getLogFileLocation());
                            data = FMWClientFactory.getData(iMap);
                            relPathAdd = (String)iMap.get("OPatch.RELATIVE_DEPLOY_PATH");
                            path = "";
                            fileName = "";
                            if (faaa instanceof OPatchDeployAction) {
                                deploy = (OPatchDeployAction)faaa;
                                path = deploy.getDeployFilePath();
                                fileName = deploy.getDeployFileName();
                                path = FMWClientFactory.sanitizePath(relPathAdd, path, fileName);
                            }
                            if (faaa instanceof OPatchStandAloneDeployAction) {
                                deploy = (OPatchStandAloneDeployAction)faaa;
                                path = deploy.getRelativeDeployFilePath();
                                fileName = deploy.getDeployFileName();
                                path = FMWClientFactory.sanitizePath(relPathAdd, path, fileName);
                            }
                            if (!(faaa instanceof OPatchSOADeployAction) && !(faaa instanceof OPatchStandAloneSOADeployAction)) break block13;
                            String name = "";
                            String revision = "";
                            boolean isBaseCompDeploy = false;
                            if (faaa instanceof OPatchSOADeployAction) {
                                soa = (OPatchSOADeployAction)faaa;
                                name = soa.getSOACompositeName();
                                revision = soa.getSOACompositeRevision();
                                isBaseCompDeploy = soa.isBaseCompositeDeployment();
                                if (soa.getConfigPlan() == OPatchSOAConfigPlan.BASE_COMPOSITE_CONFIG_PLAN) {
                                    client.setNoneConfigPlan(false);
                                } else {
                                    client.setNoneConfigPlan(true);
                                }
                            } else if (faaa instanceof OPatchStandAloneSOADeployAction) {
                                soa = (OPatchStandAloneSOADeployAction)faaa;
                                name = soa.getSOACompositeName();
                                revision = soa.getSOACompositeRevision();
                            }
                            boolean designChanges = false;
                            client.addSOAComposite(name, path, revision, designChanges, false, isBaseCompDeploy);
                            client.setDomain(data);
                            client.setRevisionToUndoDeployComposite((String[])iMap.get("CompRevisionsToUndoDeploy"));
                            break block14;
                        }
                        if (!(faaa instanceof OPatchSOARbDeployAction)) break block15;
                        OPatchSOARbDeployAction soaRb = (OPatchSOARbDeployAction)faaa;
                        boolean designChanges = false;
                        client.addSOAComposite("", path, "", false, true);
                        client.setDomain(data);
                        break block14;
                    }
                    if (!(faaa instanceof OPatchBIPDeployAction)) break block16;
                    OPatchBIPDeployAction bipAction = (OPatchBIPDeployAction)faaa;
                    String path_original = bipAction.getDeployFilePath();
                    String biHome = bipAction.getBIHome();
                    String relativePath = FMWClientFactory.sanitizePath("", path_original, fileName);
                    while (relativePath.startsWith(File.separator)) {
                        relativePath = relativePath.substring(1);
                    }
                    client.addBIP(fileName, path, relativePath, biHome);
                    break block14;
                }
                if (!(faaa instanceof OPatchJEELifecycleAction)) break block17;
                OPatchJEELifecycleAction jee = (OPatchJEELifecycleAction)faaa;
                String type = FMWClient.SERVER;
                String name = jee.getTargetName();
                HashSet<String> targetList = new HashSet<String>();
                targetList.add(name);
                client.setTargets(type, targetList);
                client.setDomain(data);
                cp.put(FMWClient.STOP_ANY_SERVER, "true");
                String home = (String)iMap.get("OPatch.COMMON_COMPONENTS_HOME");
                if (home == null) break block14;
                System.setProperty("OPatch.COMMON_COMPONENTS_HOME", home);
                String guid = FMWClientFactory.getHomeGUID(logger, oh);
                if (guid == null) break block14;
                cp.put(FMWClient.COMMON_HOME_GUID, guid);
                break block14;
            }
            if (faaa instanceof OPatchSOACompositeLifecycleAction) {
                OPatchSOACompositeLifecycleAction soaLifeCycle = (OPatchSOACompositeLifecycleAction)faaa;
                String comp_name = soaLifeCycle.getCompositeName();
                String comp_rev = soaLifeCycle.getRevision();
                client.addSOAComposite(comp_name, comp_rev);
                client.setDomain(data);
            } else if (faaa instanceof OPatchMultipleBIPDeploy) {
                OPatchMultipleBIPDeploy multipleBIP = (OPatchMultipleBIPDeploy)faaa;
                OPatchBIPDeployAction[] biActions = multipleBIP.getBIPDeployActions();
                for (int i2 = 0; i2 < biActions.length; ++i2) {
                    OPatchBIPDeployAction bipAction = biActions[i2];
                    String biPath = biActions[i2].getDeployFilePath();
                    String biFileName = biActions[i2].getDeployFileName();
                    biPath = FMWClientFactory.sanitizePath(relPathAdd, biPath, fileName);
                    String path_original = bipAction.getDeployFilePath();
                    String relativePath = FMWClientFactory.sanitizePath("", path_original, biFileName);
                    while (relativePath.startsWith(File.separator)) {
                        relativePath = relativePath.substring(1);
                    }
                    client.addBIP(biFileName, biPath, relativePath, multipleBIP.getBIHome());
                }
            }
        }
        client.setInterviewProperties(prop);
        client.setConfigProperties(cp);
        client.done();
        return client;
    }

    private static class SDKLogger
    extends FMWClient.LoggerWrapper {
        private SDKLogger() {
        }

        @Override
        public boolean debug() {
            return OPatchEnv.getFileLogLevel() == OLogger.FINEST;
        }

        @Override
        public void printOnConsole(String s) {
            OLogger.println(s);
        }

        @Override
        public void printInLogFile(String s) {
            OLogger.printlnOnLog(s);
        }

        @Override
        public void printInMainLogFile(String s) {
            OLogger.writeLog(mainThread, Level.INFO.intValue(), s);
        }

        @Override
        public void printWarnMessage(String s) {
            OLogger.warn("OUI-67124", new Object[]{s});
        }

        @Override
        public void close() {
            try {
                OPatchACL.invokeOLogger(this, "closeLogFile", null);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
        }
    }

    private static class OPatchLogger
    extends FMWClient.LoggerWrapper {
        private OPatchLogger() {
        }

        @Override
        public Locale locale() {
            String locale = FMWClientFactory.norm(System.getProperty("OPatch.LOCALE"));
            if ("".equals(locale)) {
                return null;
            }
            String[] parts = locale.split("_");
            try {
                switch (parts.length) {
                    case 1: {
                        return new Locale(parts[0]);
                    }
                    case 2: {
                        return new Locale(parts[0], parts[1]);
                    }
                }
                return new Locale(parts[0], parts[1], parts[2]);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                return null;
            }
        }

        @Override
        public boolean debug() {
            return Boolean.parseBoolean(System.getProperty("OPatch.DEBUG"));
        }

        @Override
        public void printOnConsole(String s) {
            OLogger.printlnOnConsole(s);
        }

        @Override
        public void printInLogFile(String s) {
            OLogger.printlnOnLog(s);
        }

        @Override
        public void printWarnMessage(String s) {
            OLogger.warn("OUI-67124", new Object[]{s});
        }
    }
}

