/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.ArrayList;
import oracle.opatch.JarActionEntity;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.opatchlogger.OLogger;

public class JarActionEntityTree {
    private static TreeNode root = new TreeNode(-1, "", "", null, null);
    private static JarActionEntityTree tree = new JarActionEntityTree();

    private JarActionEntityTree() {
    }

    public static JarActionEntityTree getInstance() {
        return tree;
    }

    public static TreeNode getRoot() {
        return root;
    }

    private static void addJarActionNodes(int level, String[] jarList, String[] jarPathList, JarActionEntity ja, TreeNode root) {
        StringBuffer buff = new StringBuffer("JarActionTree::addJarActionNodes() called");
        OLogger.debug(buff.toString());
        if (level >= jarList.length) {
            return;
        }
        buff = new StringBuffer("Adding Jar Action Node Info : [Level]" + root.getLevel() + " [Jar Path]" + root.getJarPath() + " [Name]" + root.getJarName() + " [isLeaf]" + root.isLeaf());
        OLogger.debug(buff.toString());
        TreeNode curNode = new TreeNode(level, jarList[level], jarPathList[level], null, root);
        if (root.isLeaf()) {
            ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
            curNode.setEntryName(MultiJarUtil.combineEntry(jarPathList[level], jarList[level]));
            if (level == jarList.length - 1) {
                curNode.setJarActionEntity(ja);
            }
            childs.add(curNode);
            root.setChilds(childs);
        } else {
            ArrayList childs = root.getChilds();
            boolean nodeExist = false;
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                if (!curNode.equals(childs.get(i2))) continue;
                nodeExist = true;
                curNode = (TreeNode)childs.get(i2);
                break;
            }
            if (!nodeExist) {
                curNode.setEntryName(MultiJarUtil.combineEntry(jarPathList[level], jarList[level]));
                if (level == jarList.length - 1) {
                    curNode.setJarActionEntity(ja);
                }
                childs.add(curNode);
                root.setChilds(childs);
            }
        }
        JarActionEntityTree.addJarActionNodes(level + 1, jarList, jarPathList, ja, curNode);
    }

    protected static void addJarActionNodes(String oracleHomePath, JarActionEntity ja, TreeNode root) {
        ja.getParentFilePath(oracleHomePath);
        String[] jarPathList = ja.getJarPathList();
        if (jarPathList.length > 0) {
            jarPathList[0] = jarPathList[0].substring(oracleHomePath.length());
        }
        StringBuffer buff = new StringBuffer("Added Jar Action Info : ");
        buff.append("[Node Number:] " + jarPathList.length);
        for (int i2 = 0; i2 < jarPathList.length; ++i2) {
            buff.append("[JarName] " + ja.getJarList()[i2]);
            buff.append("[JarPath] " + jarPathList[i2]);
        }
        OLogger.debug(buff.toString());
        JarActionEntityTree.addJarActionNodes(0, ja.getJarList(), jarPathList, ja, root);
    }

    protected static void taverse(TreeNode root) {
        if (root == null || root.isLeaf()) {
            return;
        }
        ArrayList childs = root.getChilds();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            TreeNode child = (TreeNode)childs.get(i2);
            System.out.println("------------------------------------");
            System.out.println(child.getJarName() + " " + child.getJarPath() + " " + child.getLevel());
            System.out.println("------------------------------------");
            JarActionEntityTree.taverse(child);
        }
    }

    protected static boolean isDeleteJarActionNode(TreeNode curNode) {
        return curNode.getJarAction().getActionName().equals("DeleteJarAction");
    }

    protected static boolean isJarActionNode(TreeNode curNode) {
        return curNode.getJarAction().getActionName().equals("JarAction");
    }

    public static class TreeNode {
        private int level;
        private String jarName;
        private String jarPath;
        private ArrayList childs;
        private TreeNode parent;
        private String entryName;
        private JarActionEntity jarActionEntity;
        private boolean entryExist = false;

        public TreeNode(int level, String jarName, String jarPath, ArrayList childs, TreeNode parent) {
            this.level = level;
            this.jarName = jarName;
            this.jarPath = jarPath;
            this.childs = childs;
            this.parent = parent;
        }

        public TreeNode(int level, String jarName, String jarPath, ArrayList childs) {
            this.level = level;
            this.jarName = jarName;
            this.jarPath = jarPath;
            this.childs = childs;
            this.parent = null;
        }

        public String getJarName() {
            return this.jarName;
        }

        protected void setJarName(String jarName) {
            this.jarName = jarName;
        }

        public String getJarPath() {
            return this.jarPath;
        }

        protected void setJarPath(String jarPath) {
            this.jarPath = jarPath;
        }

        public ArrayList getChilds() {
            return this.childs;
        }

        protected void setChilds(ArrayList childs) {
            this.childs = childs;
        }

        public int getLevel() {
            return this.level;
        }

        protected void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.childs == null || this.childs.size() == 0;
        }

        public String getEntryName() {
            return this.entryName;
        }

        protected void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public boolean isEntryExist() {
            return this.entryExist;
        }

        protected void setEntryExist(boolean entryExist) {
            this.entryExist = entryExist;
        }

        protected JarActionEntity getJarAction() {
            return this.jarActionEntity;
        }

        protected void setJarActionEntity(JarActionEntity jarActionEntity) {
            this.jarActionEntity = jarActionEntity;
        }

        public boolean equals(Object o2) {
            StringBuffer buff = new StringBuffer("TreeNode::equals() called");
            OLogger.debug(buff.toString());
            if (o2 instanceof TreeNode) {
                TreeNode cprNode = (TreeNode)o2;
                String jarname = cprNode.getJarName();
                String jarPath = cprNode.getJarPath();
                int level = cprNode.getLevel();
                buff = new StringBuffer("[This info ] level: " + this.getLevel() + " JarName: " + this.getJarName() + " JarPath: " + this.getJarPath());
                buff.append("[Compare Info ] level: " + level + " JarName: " + jarname + " JarPath: " + jarPath);
                OLogger.debug(buff.toString());
                if (level == this.getLevel() && jarname.equalsIgnoreCase(this.getJarName()) && jarPath.equalsIgnoreCase(this.getJarPath())) {
                    return true;
                }
            }
            return false;
        }
    }
}

