/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchRestartException;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.NioDeleteOnExitHook;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchOOPHelper {
    private static final String FILE_OPATCH_SCRIPT = "opatch";
    private static final String ENV_TEMP_ORACLE_HOME = "OOP_TEMP_OH";
    private static final String ENV_TEMP_JAVA_HOME = "OOP_TEMP_JAVA";
    private static final String ENV_RESTART_CMD = "OOP_RESTART_CMD";
    private static String[] args = null;

    public static String[] getArgs() {
        return args;
    }

    public static void setArgs(String[] args) {
        OPatchOOPHelper.args = args;
    }

    public static String getOPatchHomePath() throws IOException {
        String loc = OPatchEnv.getOPatchHome();
        if (loc == null || loc.isEmpty() || !Files.exists(WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]), new LinkOption[0])) {
            throw new OPatchException("Can not find opatch home.");
        }
        return loc;
    }

    public static String getJavaHomePath() {
        String loc = OPatchEnv.getJdkLoc();
        if (!(loc != null && !loc.isEmpty() && Files.exists(WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]), new LinkOption[0]) || (loc = OPatchEnv.getJreLoc()) != null && !loc.isEmpty() && Files.exists(WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]), new LinkOption[0]))) {
            loc = System.getProperty("java.home");
        }
        return loc;
    }

    public static String getExecutablePath() {
        StringBuffer path = new StringBuffer();
        path.append(System.getenv("PATH"));
        String pathProperty = System.getProperty("OPatch.PATH");
        if (pathProperty != null && !pathProperty.isEmpty()) {
            path.append(File.pathSeparator);
            path.append(pathProperty);
        }
        return path.toString();
    }

    public static String getOUIPath() {
        String loc = OPatchEnv.getOUILocation();
        if (loc == null || loc.isEmpty() || !Files.exists(WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]), new LinkOption[0])) {
            throw new OPatchException("Can not find oui.");
        }
        return loc;
    }

    public static Set<String> getDependencies(ClassLoader classLoader, Path limitDir, Set<String> pathSet) throws IOException {
        ClassLoader parentClassLoader;
        if (classLoader == null || limitDir != null && (!Files.exists(limitDir, new LinkOption[0]) || !Files.isDirectory(limitDir, new LinkOption[0])) || pathSet == null) {
            throw new OPatchException("Parameters given are invalid.");
        }
        if (!URLClassLoader.class.isAssignableFrom(classLoader.getClass())) {
            return pathSet;
        }
        String limitPath = limitDir == null ? null : limitDir.toAbsolutePath().normalize().toString();
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                if (!url.getProtocol().equals("file")) continue;
                String urlPath = url.getPath();
                if (OPatchEnv.isWindows()) {
                    urlPath = (urlPath = urlPath.replace("\\", "/")).startsWith("/") ? urlPath.substring(1) : urlPath;
                }
                Path filePath = WrapperFactory.getNioServiceWrapper().getPath(urlPath, new String[0]);
                String fileLoc = filePath.toAbsolutePath().normalize().toString();
                if (!Files.exists(filePath, new LinkOption[0]) || pathSet.contains(fileLoc)) continue;
                pathSet.add(fileLoc);
                if (fileLoc.toLowerCase().endsWith(".jar")) {
                    JarFile jarFile = new JarFile(fileLoc);
                    OPatchOOPHelper.getDependencies(jarFile, limitDir, pathSet);
                    jarFile.close();
                }
                if (limitPath == null || fileLoc.startsWith(limitPath)) continue;
                pathSet.remove(fileLoc);
            }
        }
        if ((parentClassLoader = classLoader.getParent()) != null) {
            OPatchOOPHelper.getDependencies(parentClassLoader, limitDir, pathSet);
        }
        return pathSet;
    }

    public static Set<String> getDependencies(JarFile jarFile, Path limitDir, Set<String> pathSet) throws IOException {
        String classpath;
        Attributes attributes;
        if (jarFile == null || limitDir != null && (!Files.exists(limitDir, new LinkOption[0]) || !Files.isDirectory(limitDir, new LinkOption[0])) || pathSet == null) {
            throw new OPatchException("Parameters given are invalid.");
        }
        String limitPath = limitDir == null ? null : limitDir.toAbsolutePath().normalize().toString();
        String parentPath = WrapperFactory.getNioServiceWrapper().getPath(jarFile.getName(), new String[0]).getParent().toAbsolutePath().normalize().toString();
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (classpath = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
            String[] relativeFilePaths;
            for (String relativeFilePath : relativeFilePaths = classpath.split("\\s+")) {
                Path file = WrapperFactory.getNioServiceWrapper().getPath(parentPath, relativeFilePath);
                if (!Files.exists(file, new LinkOption[0]) || pathSet.contains(file.toAbsolutePath().normalize().toString())) continue;
                String filePath = file.toAbsolutePath().normalize().toString();
                pathSet.add(filePath);
                if (filePath.toLowerCase().endsWith(".jar")) {
                    JarFile newJarFile;
                    try {
                        newJarFile = new JarFile(filePath);
                    }
                    catch (Exception ex) {
                        OLogger.printlnOnLog(OLogger.WARNING, "invalid jar file : " + filePath);
                        OLogger.printlnOnLog(OLogger.WARNING, ex.getMessage());
                        continue;
                    }
                    OPatchOOPHelper.getDependencies(newJarFile, limitDir, pathSet);
                    newJarFile.close();
                }
                if (limitPath == null || filePath.startsWith(limitPath)) continue;
                pathSet.remove(filePath);
            }
        }
        return pathSet;
    }

    public static Set<String> getClassFiles(String classpath, Path limitDir) throws IOException {
        String[] classFilePaths;
        if (classpath == null || classpath.isEmpty() || limitDir != null && (!Files.exists(limitDir, new LinkOption[0]) || !Files.isDirectory(limitDir, new LinkOption[0]))) {
            throw new OPatchException("Parameters given are invalid.");
        }
        HashSet<String> pathSet = new HashSet<String>();
        String limitPath = limitDir == null ? null : limitDir.toAbsolutePath().normalize().toString();
        for (String classFilePath : classFilePaths = classpath.split(File.pathSeparator)) {
            Path classFile = WrapperFactory.getNioServiceWrapper().getPath(classFilePath, new String[0]);
            if (classFilePath == null || classFilePath.isEmpty() || !Files.exists(classFile, new LinkOption[0])) continue;
            String classFileAbsolutePath = classFile.toAbsolutePath().normalize().toString();
            if (limitPath != null && !classFileAbsolutePath.startsWith(limitPath)) continue;
            pathSet.add(classFileAbsolutePath);
        }
        return pathSet;
    }

    public static Path copyOPatchHome() throws IOException {
        return OPatchOOPHelper.copyOPatchHome(null);
    }

    public static Path copyOPatchHome(Path dstHome) throws IOException {
        return OPatchOOPHelper.copyOPatchHome(null, dstHome);
    }

    public static Path copyOPatchHome(Path srcHome, Path dstHome) throws IOException {
        if (srcHome == null || !Files.exists(srcHome, new LinkOption[0])) {
            srcHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchOOPHelper.getOPatchHomePath(), new String[0]);
        }
        if (dstHome == null) {
            try {
                dstHome = OPatchOOPHelper.createTempFolder("opatch-home", null);
            }
            catch (IOException e2) {
                throw new OPatchException("Can not find destination opatch home.");
            }
        } else if (!Files.exists(dstHome, new LinkOption[0])) {
            Files.createDirectories(dstHome, new FileAttribute[0]);
        } else if (!Files.isDirectory(dstHome, new LinkOption[0])) {
            throw new OPatchException("Parameters given are invalid.");
        }
        boolean copyFailed = SystemCall.copyRecurse(srcHome, dstHome, false, false);
        if (copyFailed) {
            throw new OPatchException("Errors occurred while copying files. Check log file for more details");
        }
        OLogger.printlnOnLog("OOP: copy opatch home from " + srcHome + " to " + dstHome + " succeed");
        return dstHome;
    }

    public static Path copyDependencies(Class<?> clazz) throws IOException {
        return OPatchOOPHelper.copyDependencies(clazz, null);
    }

    public static Path copyDependencies(Class<?> clazz, Path dstDir) throws IOException {
        return OPatchOOPHelper.copyDependencies(clazz, null, dstDir);
    }

    public static Path copyDependencies(Class<?> clazz, Path limitDir, Path dstDir) throws IOException {
        if (!(limitDir == null || Files.exists(limitDir, new LinkOption[0]) && Files.isDirectory(limitDir, new LinkOption[0]))) {
            throw new OPatchException("Parameters given are invalid.");
        }
        if (dstDir == null) {
            try {
                dstDir = OPatchOOPHelper.createTempFolder("opatch-dependencies", null);
            }
            catch (IOException e2) {
                throw new OPatchException("Can not find destination folder.");
            }
        } else if (!Files.exists(dstDir, new LinkOption[0])) {
            Files.createDirectories(dstDir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dstDir, new LinkOption[0])) {
            throw new OPatchException("Parameters given are invalid.");
        }
        HashSet<String> pathSet = new HashSet<String>();
        OPatchOOPHelper.getDependencies(clazz.getClassLoader(), limitDir, pathSet);
        OPatchOOPHelper.copyClassFiles(pathSet, limitDir, dstDir);
        return dstDir;
    }

    public static Path copyClassFiles(String classpath) throws IOException {
        return OPatchOOPHelper.copyClassFiles(classpath, null);
    }

    public static Path copyClassFiles(String classpath, Path dstDir) throws IOException {
        return OPatchOOPHelper.copyClassFiles(classpath, null, dstDir);
    }

    public static Path copyClassFiles(String classpath, Path limitDir, Path dstDir) throws IOException {
        if (classpath == null) {
            throw new OPatchException("Parameters given are invalid.");
        }
        if (classpath.isEmpty()) {
            return dstDir;
        }
        if (!(limitDir == null || Files.exists(limitDir, new LinkOption[0]) && Files.isDirectory(limitDir, new LinkOption[0]))) {
            throw new OPatchException("Parameters given are invalid.");
        }
        if (dstDir == null) {
            try {
                dstDir = OPatchOOPHelper.createTempFolder("opatch-dependencies", null);
            }
            catch (IOException e2) {
                throw new OPatchException("Can not find destination folder.");
            }
        } else if (!Files.exists(dstDir, new LinkOption[0])) {
            Files.createDirectories(dstDir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dstDir, new LinkOption[0])) {
            throw new OPatchException("Parameters given are invalid.");
        }
        Set<String> pathSet = OPatchOOPHelper.getClassFiles(classpath, limitDir);
        OPatchOOPHelper.copyClassFiles(pathSet, limitDir, dstDir);
        return dstDir;
    }

    private static Path copyClassFiles(Set<String> pathSet, Path limitDir, Path dstDir) throws IOException {
        if (pathSet == null) {
            throw new OPatchException("Parameters given are invalid.");
        }
        if (pathSet.isEmpty()) {
            return dstDir;
        }
        String replacePath = dstDir.toAbsolutePath().normalize().toString();
        String limitPath = limitDir == null ? null : limitDir.toAbsolutePath().normalize().toString();
        String limitPathRegex = limitPath == null ? null : limitPath.replace("\\", "\\\\").replace(".", "\\.").replace("*", "\\*").replace("$", "\\$").replace("+", "\\+").replace("?", "\\?").replace("|", "\\|").replace("(", "\\(").replace(")", "\\)");
        replacePath = replacePath == null ? null : replacePath.replace("\\", "\\\\").replace(".", "\\.").replace("*", "\\*").replace("$", "\\$").replace("+", "\\+").replace("?", "\\?").replace("|", "\\|").replace("(", "\\(").replace(")", "\\)");
        for (String srcPath : pathSet) {
            if (limitPath != null && !srcPath.startsWith(limitPath)) continue;
            String dstPath = limitPathRegex == null ? replacePath + File.separator + srcPath.replaceFirst(":", "") : srcPath.replaceFirst(limitPathRegex, replacePath);
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dstPath, new String[0]);
            if (Files.exists(dstFile, new LinkOption[0])) continue;
            if (SystemCall.copyRecurse(WrapperFactory.getNioServiceWrapper().getPath(srcPath, new String[0]), dstFile, false, false)) {
                throw new OPatchException("Errors occurred while copying files. Check log file for more details");
            }
            OLogger.printlnOnLog(OLogger.INFO, "OOP: copy class file from " + srcPath + " to" + dstPath + " succeed");
        }
        return dstDir;
    }

    public static Path copyJavaHome() throws IOException {
        return OPatchOOPHelper.copyJavaHome(null);
    }

    public static Path copyJavaHome(Path dstHome) throws IOException {
        return OPatchOOPHelper.copyJavaHome(null, dstHome);
    }

    public static Path copyJavaHome(Path srcHome, Path dstHome) throws IOException {
        if (srcHome == null || !Files.exists(srcHome, new LinkOption[0])) {
            srcHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchOOPHelper.getJavaHomePath(), new String[0]);
        }
        if (dstHome == null) {
            try {
                dstHome = OPatchOOPHelper.createTempFolder("java-home", null);
            }
            catch (IOException e2) {
                throw new OPatchException("Can not find destination Java home.");
            }
        } else if (!Files.exists(dstHome, new LinkOption[0])) {
            Files.createDirectories(dstHome, new FileAttribute[0]);
        } else if (!Files.isDirectory(dstHome, new LinkOption[0])) {
            throw new OPatchException("Parameters given are invalid.");
        }
        boolean copyFailed = SystemCall.copyRecurse(srcHome, dstHome, false, false);
        if (copyFailed) {
            throw new OPatchException("Errors occurred while copying files. Check log file for more details");
        }
        OLogger.printlnOnLog("OOP: copy java home from " + srcHome + " to " + dstHome + " succeed");
        return dstHome;
    }

    public static Path copyOUI() {
        return OPatchOOPHelper.copyOUI(null);
    }

    public static Path copyOUI(Path dst) {
        return OPatchOOPHelper.copyOUI(null, dst);
    }

    public static Path copyOUI(Path src, Path dst) {
        if (src == null || !Files.exists(src, new LinkOption[0])) {
            src = WrapperFactory.getNioServiceWrapper().getPath(OPatchOOPHelper.getOUIPath(), new String[0]);
        }
        if (dst == null) {
            try {
                dst = OPatchOOPHelper.createTempFolder("oui", null);
            }
            catch (IOException e2) {
                throw new OPatchException("Can not find destination oui.");
            }
        } else if (!Files.exists(dst, new LinkOption[0])) {
            try {
                Files.createDirectories(dst, new FileAttribute[0]);
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
        } else if (!Files.isDirectory(dst, new LinkOption[0])) {
            throw new OPatchException("Parameters given are invalid.");
        }
        boolean copyFailed = SystemCall.copyRecurse(src, dst, false, false);
        if (copyFailed) {
            throw new OPatchException("Errors occurred while copying files. Check log file for more details");
        }
        OLogger.printlnOnLog("OOP: copy oui directory from " + src + " to " + dst + " succeed");
        return dst;
    }

    public static Path createTempFolder(String foldername) throws IOException {
        return OPatchOOPHelper.createTempFolder(foldername, null);
    }

    private static Path createTempFolder(String foldername, Path parentDir) throws IOException {
        Path oracleHome = null;
        try {
            oracleHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome(), new String[0]);
            String oracleHomePath = oracleHome.toAbsolutePath().normalize().toString();
        }
        catch (Exception e2) {
            Object oracleHomePath = null;
        }
        if (foldername == null || foldername.isEmpty()) {
            foldername = "opatch-temp";
        } else {
            foldername.replace("/", "_").replace("\\", "_").replace(":", "");
        }
        if (parentDir == null || !Files.exists(parentDir, new LinkOption[0]) || !Files.isDirectory(parentDir, new LinkOption[0])) {
            parentDir = oracleHome.resolve(".patch_storage");
        }
        if (!Files.isWritable(parentDir) && !Files.isExecutable(parentDir)) {
            throw new IOException("Cannot create temp folder within " + parentDir.toAbsolutePath().toString() + " which is not writable/executable.");
        }
        StringBuffer folderName = new StringBuffer();
        OLogger.printlnOnLog(OLogger.INFO, "OOP: temporary stage directory :" + parentDir);
        folderName.append(foldername).append("-").append(System.currentTimeMillis()).append(new Random().nextInt(400));
        Path tempFolder = WrapperFactory.getNioServiceWrapper().getPath(parentDir.toString(), folderName.toString());
        if (!Files.exists(tempFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(tempFolder, new FileAttribute[0]);
                OLogger.printlnOnLog(OLogger.INFO, "OOP: temporary folder " + tempFolder + " created successfully");
            }
            catch (Exception e3) {
                throw new IOException("Cannot create temp folder at " + tempFolder.toAbsolutePath().toString());
            }
        } else if (!Files.isDirectory(tempFolder, new LinkOption[0])) {
            throw new IOException("Cannot create temp folder at " + tempFolder.toAbsolutePath().toString() + " because existing location is not a directory.");
        }
        NioDeleteOnExitHook.add(tempFolder);
        return tempFolder;
    }

    public static void loadExternalLibs(String classpath) {
        String oracleHomePath;
        String tempOracleHomePath = System.getenv(ENV_TEMP_ORACLE_HOME);
        Path oracleHome = null;
        try {
            oracleHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome(), new String[0]);
            oracleHomePath = oracleHome.toAbsolutePath().normalize().toString();
        }
        catch (Exception e2) {
            oracleHomePath = null;
        }
        if (tempOracleHomePath == null || tempOracleHomePath.isEmpty() || !Files.exists(WrapperFactory.getNioServiceWrapper().getPath(tempOracleHomePath, new String[0]), new LinkOption[0]) || oracleHomePath == null || oracleHomePath.isEmpty()) {
            return;
        }
        try {
            OPatchOOPHelper.copyClassFiles(classpath, oracleHome, WrapperFactory.getNioServiceWrapper().getPath(tempOracleHomePath, new String[0]));
        }
        catch (IOException e3) {
            throw new OPatchException("Errors occurred while copying class files during OOP.");
        }
    }

    public static String updateClassPath() {
        String oracleHomePath;
        String tempOracleHomePath = System.getenv(ENV_TEMP_ORACLE_HOME);
        try {
            Path oracleHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome(), new String[0]);
            oracleHomePath = oracleHome.toAbsolutePath().normalize().toString();
        }
        catch (Exception e2) {
            oracleHomePath = null;
        }
        if (tempOracleHomePath == null || tempOracleHomePath.isEmpty() || !Files.exists(WrapperFactory.getNioServiceWrapper().getPath(tempOracleHomePath, new String[0]), new LinkOption[0]) || oracleHomePath == null || oracleHomePath.isEmpty()) {
            return System.getProperty("java.class.path");
        }
        String oracleHomePathRegex = oracleHomePath.replace("\\", "\\\\").replace(".", "\\.").replace("*", "\\*").replace("$", "\\$").replace("+", "\\+").replace("?", "\\?").replace("|", "\\|").replace("(", "\\(").replace(")", "\\)");
        return OPatchOOPHelper.updateClassPath(oracleHomePathRegex, tempOracleHomePath);
    }

    public static String updateClassPath(String regex, String replacement) {
        String[] classFilePaths;
        String classpath = System.getProperty("java.class.path");
        StringBuffer newClassPath = new StringBuffer();
        for (String classFilePath : classFilePaths = classpath.split(File.pathSeparator)) {
            String classFileAbsolutePath = WrapperFactory.getNioServiceWrapper().getPath(classFilePath, new String[0]).toAbsolutePath().normalize().toString();
            newClassPath.append(classFileAbsolutePath.replaceFirst(regex, replacement));
            newClassPath.append(File.pathSeparator);
        }
        String newclasspath = newClassPath.toString();
        System.setProperty("java.class.path", newclasspath);
        return newclasspath;
    }

    public static void invokeOPatch(Path tempOracleHome, Path tempOpatchHome, Path tempJavaHome, Collection<String> args) throws IOException {
        Path opatchScriptFile;
        if (tempOpatchHome == null || !Files.exists(tempOpatchHome, new LinkOption[0]) || tempJavaHome == null || !Files.exists(tempJavaHome, new LinkOption[0])) {
            throw new OPatchException("Parameters given are invalid.");
        }
        String opatchHomePath = tempOpatchHome.toAbsolutePath().normalize().toString();
        if (OPatchEnv.isWindows()) {
            opatchScriptFile = WrapperFactory.getNioServiceWrapper().getPath(opatchHomePath, "opatch.cmd");
            if (!Files.exists(opatchScriptFile, new LinkOption[0]) && !Files.exists(opatchScriptFile = WrapperFactory.getNioServiceWrapper().getPath(opatchHomePath, "opatch.bat"), new LinkOption[0])) {
                throw new OPatchException("Can not find opatch executable script.");
            }
        } else {
            opatchScriptFile = WrapperFactory.getNioServiceWrapper().getPath(opatchHomePath, FILE_OPATCH_SCRIPT);
            if (!Files.exists(opatchScriptFile, new LinkOption[0]) && !Files.exists(opatchScriptFile = WrapperFactory.getNioServiceWrapper().getPath(opatchHomePath, "opatch.sh"), new LinkOption[0])) {
                throw new OPatchException("Can not find opatch executable script.");
            }
        }
        StringBuffer command = new StringBuffer();
        command.append(opatchScriptFile.toAbsolutePath().normalize().toString());
        String commandName = null;
        if (args != null && !args.isEmpty()) {
            Iterator<String> iterator = args.iterator();
            commandName = iterator.next();
            command.append(" ").append(commandName);
            while (iterator.hasNext()) {
                String arg = iterator.next();
                if (arg.equals("-oop")) continue;
                if (arg.equals("-oh")) {
                    iterator.next();
                    continue;
                }
                command.append(" ").append(arg);
                if (!arg.equals("-jre")) continue;
                command.append(" ").append(tempJavaHome.toAbsolutePath().normalize().toString());
                iterator.next();
            }
        }
        command.append(" -oh ").append(OPatchEnv.getOracleHome());
        if (commandName != null && (commandName.equals("apply") || commandName.equals("rollback") || commandName.equals("napply") || commandName.equals("nrollback"))) {
            OLogger.printlnOnLog("OOP : Should ask for user confirmation to proceed ");
        }
        command.append(" -").append("restart");
        String logSessionId = System.getProperty("CommonLog.LOG_SESSION_ID");
        if (logSessionId != null && !logSessionId.isEmpty()) {
            command.append(" -log_session_id ").append(logSessionId);
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer envs = new StringBuffer();
        if (OPatchEnv.isWindows()) {
            envs.append("@echo off").append(lineSeparator);
            envs.append("set ").append("ORACLE_HOME").append("=").append(OPatchEnv.getOracleHome()).append(lineSeparator);
            envs.append("set ").append("PATH").append("=").append(OPatchOOPHelper.getExecutablePath()).append(lineSeparator);
            envs.append("set ").append("JAVA_HOME").append("=").append(tempJavaHome.toAbsolutePath().normalize().toString()).append(lineSeparator);
            envs.append("set ").append(ENV_TEMP_ORACLE_HOME).append("=").append(tempOracleHome.toAbsolutePath().normalize().toString()).append(lineSeparator);
            envs.append("set \"").append(ENV_RESTART_CMD).append("=").append(command.toString()).append("\"");
            OLogger.printlnOnLog("OOP: envionment variables configured");
            OLogger.printlnOnLog(envs.toString());
        } else {
            envs.append("#!/bin/sh").append(lineSeparator).append(lineSeparator);
            envs.append("ORACLE_HOME").append("=").append(OPatchEnv.getOracleHome()).append(lineSeparator);
            envs.append("PATH").append("=").append(OPatchOOPHelper.getExecutablePath()).append(lineSeparator);
            envs.append("JAVA_HOME").append("=").append(tempJavaHome.toAbsolutePath().normalize().toString()).append(lineSeparator);
            envs.append(ENV_TEMP_ORACLE_HOME).append("=").append(tempOracleHome.toAbsolutePath().normalize().toString()).append(lineSeparator);
            envs.append(ENV_TEMP_JAVA_HOME).append("=").append(tempJavaHome.toAbsolutePath().normalize().toString()).append(lineSeparator);
            envs.append(ENV_RESTART_CMD).append("=\"").append(command.toString()).append("\"").append(lineSeparator).append(lineSeparator);
            envs.append("export ").append("ORACLE_HOME").append(lineSeparator);
            envs.append("export ").append("PATH").append(lineSeparator);
            envs.append("export ").append("JAVA_HOME").append(lineSeparator);
            envs.append("export ").append(ENV_TEMP_ORACLE_HOME).append(lineSeparator);
            envs.append("export ").append(ENV_TEMP_JAVA_HOME).append(lineSeparator);
            envs.append("export ").append(ENV_RESTART_CMD).append(lineSeparator);
            OLogger.printlnOnLog("OOP: envionment variables configured");
            OLogger.printlnOnLog(envs.toString());
        }
        OPatchOOPHelper.writeIntoTempFile(envs.toString());
    }

    private static String writeIntoTempFile(String content) {
        String filePath = null;
        Path file = null;
        try {
            filePath = OPatchEnv.getLogFileLocation(OPatchEnv.getOracleHome()) + File.separator + "oop_temp" + (OPatchEnv.isWindows() ? ".bat" : ".out");
            file = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]);
            Files.createFile(file, new FileAttribute[0]);
            OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (Exception e2) {
            if (file != null && Files.exists(file, new LinkOption[0])) {
                try {
                    Files.deleteIfExists(file);
                }
                catch (IOException e1) {
                    OLogger.debug(e1.getMessage());
                }
            }
            OLogger.printlnOnConsole("Errors occurred while operating oop temp file.");
        }
        return filePath;
    }

    public static OPatchRestartException getOPatchRestartExceptionFromCauseChain(Throwable t) {
        OPatchRestartException e2 = null;
        while (t != null && (t = t.getCause()) != null) {
            if (!(t instanceof OPatchRestartException)) continue;
            e2 = (OPatchRestartException)t;
            break;
        }
        return e2;
    }

    public static void deleteOOPStaleEntries(String oracleHomePath) {
        File[] dirNames;
        OLogger.printlnOnLog("Delete the stale entries from home");
        String tempAppend = "/";
        if (OPatchEnv.isWindows()) {
            tempAppend = "\\";
        }
        File path = new File(oracleHomePath + tempAppend + ".patch_storage");
        for (File f2 : dirNames = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dirpath, String requiredName) {
                return requiredName.toLowerCase().startsWith("opatch-temp") || requiredName.toLowerCase().startsWith("java-home") || requiredName.toLowerCase().startsWith("oracle-home");
            }
        })) {
            OLogger.printlnOnLog("Delete stale entry:" + f2.getName());
            SystemCall.deleteRecurse(WrapperFactory.getNioServiceWrapper().getPath(f2.getAbsolutePath(), new String[0]), true);
        }
    }

    public static void launchOOP() throws IOException {
        Path srcJavaHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchOOPHelper.getJavaHomePath(), new String[0]);
        Path srcOPatchHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchOOPHelper.getOPatchHomePath(), new String[0]);
        Path srcOracleHome = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome(), new String[0]);
        Path srcOUI = WrapperFactory.getNioServiceWrapper().getPath(OPatchOOPHelper.getOUIPath(), new String[0]);
        String srcJavaHomePath = srcJavaHome.toAbsolutePath().normalize().toString();
        String srcOPatchHomePath = srcOPatchHome.toAbsolutePath().normalize().toString();
        String srcOracleHomePath = srcOracleHome.toAbsolutePath().normalize().toString();
        String srcOUIPath = srcOUI.toAbsolutePath().normalize().toString();
        try {
            OPatchOOPHelper.deleteOOPStaleEntries(srcOracleHomePath);
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("Deletion of OOP related stale entries is failed" + e2.getMessage());
        }
        Path dstOracleHome = OPatchOOPHelper.createTempFolder("oracle-home");
        Path dstOPatchHome = null;
        dstOPatchHome = srcOPatchHomePath.startsWith(srcOracleHomePath) ? OPatchOOPHelper.copyOPatchHome(dstOracleHome.resolve("OPatch")) : srcOPatchHome;
        if (srcOUIPath.startsWith(srcOracleHomePath)) {
            OPatchOOPHelper.copyOUI(dstOracleHome.resolve("oui"));
        }
        Path dstJavaHome = null;
        dstJavaHome = srcJavaHomePath.startsWith(srcOPatchHomePath) ? WrapperFactory.getNioServiceWrapper().getPath(srcJavaHomePath.replace(srcOPatchHomePath, dstOPatchHome.toAbsolutePath().normalize().toString()), new String[0]) : (srcJavaHomePath.startsWith(srcOracleHomePath) ? OPatchOOPHelper.copyJavaHome(srcJavaHome, WrapperFactory.getNioServiceWrapper().getPath(srcJavaHomePath.replace(srcOracleHomePath, dstOracleHome.toAbsolutePath().normalize().toString()), new String[0])) : OPatchOOPHelper.copyJavaHome(srcJavaHome, null));
        OPatchOOPHelper.copyDependencies(OPatch.class, srcOracleHome, dstOracleHome);
        throw new OPatchRestartException(dstOracleHome, dstOPatchHome, dstJavaHome);
    }
}

