/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchZipInputStream;
import oracle.opatch.OUIReplacer;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipUtilities {
    private static String fileSeparator = File.separator;
    static final int BUFFER = 2048;
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
    public static final int DEFAULT = 0;
    public static final int ZIP = 1;
    public static final int JAR_WAR_MAR = 2;
    public static final int TAR_GZ_TGZ = 3;

    public static String unzip(String zipFile, String toLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ZipUtilities::unzip");
        OLogger.debug(buff);
        BufferedOutputStream dest = null;
        boolean topLevel = true;
        String topLevelDir = "";
        try {
            ZipEntry entry;
            InputStream fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(zipFile, new String[0]), new OpenOption[0]);
            OPatchZipInputStream zis = new OPatchZipInputStream((InputStream)new BufferedInputStream(fis), zipFile);
            HashMap externalAttrInfo = zis.getPermissionInfo();
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                OLogger.debug(new StringBuffer("Extracting : " + entry));
                String extractPath = toLocation + fileSeparator + entry.getName();
                int permissionInfo = Integer.parseInt(externalAttrInfo.get(entry.getName()).toString());
                if (topLevel) {
                    topLevel = false;
                    topLevelDir = entry.getName();
                }
                long time = entry.getTime();
                if (entry.isDirectory()) {
                    Path e2 = WrapperFactory.getNioServiceWrapper().getPath(extractPath, new String[0]);
                    if (!Files.exists(e2, new LinkOption[0])) {
                        Files.createDirectories(e2, new FileAttribute[0]);
                    }
                    if (OPatchEnv.isWindows() || permissionInfo == 0) continue;
                    OUIReplacer.changePermission(extractPath, permissionInfo);
                    continue;
                }
                Path entryFile = WrapperFactory.getNioServiceWrapper().getPath(extractPath, new String[0]);
                if (Files.exists(entryFile, new LinkOption[0])) {
                    Files.delete(entryFile);
                } else if (!Files.exists(entryFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
                }
                byte[] data = new byte[2048];
                OutputStream fos = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(extractPath, new String[0]), new OpenOption[0]);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                if (OPatchEnv.isWindows()) continue;
                if (permissionInfo != 0) {
                    OUIReplacer.changePermission(extractPath, permissionInfo);
                }
                if (Long.valueOf(time) == null || time == 0L) continue;
                Path setTimeStampFile = WrapperFactory.getNioServiceWrapper().getPath(extractPath, new String[0]);
                Files.setLastModifiedTime(setTimeStampFile, FileTime.fromMillis(time));
            }
            zis.close();
        }
        catch (Exception e3) {
            buff = new StringBuffer("Failed to unzip the given file : ");
            buff.append(zipFile);
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException("Unzip failied", e3);
            throw re;
        }
        return topLevelDir;
    }

    public static void depressFiles(String fileLoc, String parentLoc) {
        try {
            switch (ZipUtilities.getType(fileLoc)) {
                case 1: {
                    ZipUtilities.unzip(fileLoc, parentLoc);
                    break;
                }
                case 2: {
                    ZipUtilities.unJar(fileLoc, parentLoc);
                    break;
                }
                case 3: {
                    ZipUtilities.unGz(fileLoc, parentLoc);
                    break;
                }
                default: {
                    ZipUtilities.unzip(fileLoc, parentLoc);
                    break;
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unJar(String fileLoc, String parentLoc) {
        StringBuffer buff = new StringBuffer("ZipUtilities::depressFiles");
        OLogger.debug(buff);
        InputStream is = null;
        OutputStream fos = null;
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            JarFile jar = new JarFile(fileLoc);
            Enumeration<JarEntry> enums = jar.entries();
            while (enums.hasMoreElements()) {
                JarEntry file = enums.nextElement();
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(parentLoc, file.getName());
                if (file.isDirectory()) {
                    Files.createDirectories(f2, new FileAttribute[0]);
                    continue;
                }
                if (!Files.exists(f2.getParent(), new LinkOption[0])) {
                    Files.createDirectories(f2.getParent(), new FileAttribute[0]);
                }
                int count = 0;
                byte[] data = new byte[2048];
                is = jar.getInputStream(file);
                bis = new BufferedInputStream(is);
                fos = Files.newOutputStream(f2, new OpenOption[0]);
                bos = new BufferedOutputStream(fos, 2048);
                while ((count = bis.read(data, 0, 2048)) != -1) {
                    ((BufferedOutputStream)bos).write(data, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                bis.close();
                bos.close();
                fos.close();
                is.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public static void unGzip(String src, String loc, String tarPath) throws Exception {
        if (!Files.exists(WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]), new LinkOption[0])) {
            Files.createDirectories(WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]), new FileAttribute[0]);
        }
        InputStream fin = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]), new OpenOption[0]);
        BufferedInputStream in = new BufferedInputStream(fin);
        OutputStream out = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(tarPath, new String[0]), new OpenOption[0]);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
        byte[] buffer = new byte[1024];
        int n2 = 0;
        while (-1 != (n2 = gzIn.read(buffer))) {
            out.write(buffer, 0, n2);
        }
        out.close();
        gzIn.close();
    }

    public static void unTar(String srcPath, String destPath) throws Exception {
        InputStream inputStream = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(srcPath, new String[0]), new OpenOption[0]);
        TarArchiveInputStream in = new TarArchiveInputStream(inputStream);
        TarArchiveEntry entry = in.getNextTarEntry();
        while (entry != null) {
            Path curfile = WrapperFactory.getNioServiceWrapper().getPath(destPath, entry.getName());
            int mode = entry.getMode();
            Set<PosixFilePermission> permission = ZipUtilities.toPerms(mode);
            if (entry.isDirectory()) {
                if (!Files.exists(curfile, new LinkOption[0])) {
                    Files.createDirectories(curfile, new FileAttribute[0]);
                    continue;
                }
            } else {
                Path parent = curfile.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                OutputStream out = Files.newOutputStream(curfile, new OpenOption[0]);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.close();
            }
            if (!OPatchEnv.isWindows()) {
                Files.setPosixFilePermissions(curfile, permission);
            }
            Files.setLastModifiedTime(curfile, FileTime.fromMillis(entry.getModTime().getTime()));
            entry = in.getNextTarEntry();
        }
        in.close();
    }

    public static void unGz(String fileLoc, String parentLoc) throws Exception {
        String extractLoc = OPatchEnv.getPatchUnzipLocation();
        String timestamp = sdf.format(new Date());
        String tarName = extractLoc + fileSeparator + timestamp + ".tar";
        ZipUtilities.unGzip(fileLoc, extractLoc, tarName);
        ZipUtilities.unTar(tarName, parentLoc);
        if (Files.exists(WrapperFactory.getNioServiceWrapper().getPath(tarName, new String[0]), new LinkOption[0])) {
            Files.delete(WrapperFactory.getNioServiceWrapper().getPath(tarName, new String[0]));
        }
    }

    public static void compressZip(String jarName, String rootDir) throws IOException, ArchiveException {
        ArchiveOutputStream jos = new ArchiveStreamFactory().createArchiveOutputStream("zip", Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(jarName, new String[0]), new OpenOption[0]));
        ArrayList<Path> fileList = ZipUtilities.getFiles(rootDir);
        String parentDir = WrapperFactory.getNioServiceWrapper().getPath(rootDir, new String[0]).getParent().toString();
        for (Path f2 : fileList) {
            if (!Files.exists(f2, new LinkOption[0])) continue;
            ZipArchiveEntry je = new ZipArchiveEntry(ZipUtilities.getEntryName(f2, parentDir));
            if (!OPatchEnv.isWindows()) {
                int mode = OUIReplacer.getPermission(f2.toString());
                je.setUnixMode(mode);
            }
            long time = Files.getLastModifiedTime(f2, new LinkOption[0]).toMillis();
            je.setTime(time);
            jos.putArchiveEntry((ArchiveEntry)je);
            if (je.isDirectory()) {
                jos.closeArchiveEntry();
                continue;
            }
            BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(f2, new OpenOption[0]));
            IOUtils.copy((InputStream)bis, (OutputStream)jos, (int)2048);
            jos.closeArchiveEntry();
            bis.close();
        }
        jos.finish();
    }

    private static String getEntryName(Path f2, String rootPath) {
        String fPath = f2.toAbsolutePath().toString();
        String entryName = fPath.indexOf(rootPath) != -1 ? fPath.substring(rootPath.length() + 1) : f2.getFileName().toString();
        if (Files.isDirectory(f2, new LinkOption[0])) {
            entryName = entryName + fileSeparator;
        }
        return entryName;
    }

    private static ArrayList<Path> getFiles(String directory) {
        Path dir = WrapperFactory.getNioServiceWrapper().getPath(directory, new String[0]);
        ArrayList<Path> fileNameList = new ArrayList<Path>();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir);){
            if (files != null) {
                for (Path file : files) {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        fileNameList.addAll(ZipUtilities.getFiles(file.toString()));
                        continue;
                    }
                    fileNameList.add(file);
                }
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        fileNameList.add(dir);
        return fileNameList;
    }

    public static int convertPermissionsSetToInt(Set<PosixFilePermission> permissions) {
        int result = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            result |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            result |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result |= 1;
        }
        return result;
    }

    public static Set<PosixFilePermission> toPerms(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static int getType(String fileLoc) {
        if (fileLoc.endsWith(".zip")) {
            return 1;
        }
        if (fileLoc.endsWith(".jar") || fileLoc.endsWith(".war") || fileLoc.endsWith("mar")) {
            return 2;
        }
        if (fileLoc.endsWith(".tar.gz") || fileLoc.endsWith(".gz") || fileLoc.endsWith("tgz")) {
            return 3;
        }
        return 0;
    }
}

