/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;

public final class NPatchRelations {
    private ArrayList<NPatchRelation> empty = new ArrayList();
    private ArrayList<NPatchRelation> supersets = null;
    private ArrayList<NPatchRelation> subsets = null;
    private ArrayList<NPatchRelation> betters = null;
    private ArrayList<NPatchRelation> worses = null;
    private ArrayList<NPatchRelation> duplicates = null;
    private ArrayList<NPatchRelation> higherPSUs = null;
    private ArrayList<NPatchRelation> lowerPSUs = null;
    private ArrayList<NPatchRelation> conflicts = null;
    private ArrayList<NPatchRelation> subsetPSU = null;
    private ArrayList<NPatchRelation> supersetPSU = null;
    private ArrayList<NPatchRelation> invalidPSU = null;

    public NPatchRelations() {
    }

    public NPatchRelations(NPatchRelations relations) {
        if (relations.getSupersets().size() > 0) {
            for (NPatchRelation relation : relations.getSupersets()) {
                this.addSuperset(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getSubsets().size() > 0) {
            for (NPatchRelation relation : relations.getSubsets()) {
                this.addSubset(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getBetters().size() > 0) {
            for (NPatchRelation relation : relations.getBetters()) {
                this.addBetter(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getWorses().size() > 0) {
            for (NPatchRelation relation : relations.getWorses()) {
                this.addWorse(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getDuplicates().size() > 0) {
            for (NPatchRelation relation : relations.getDuplicates()) {
                this.addDuplicate(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getHigherPSUs().size() > 0) {
            for (NPatchRelation relation : relations.getHigherPSUs()) {
                this.addHigherPSU(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getLowerPSUs().size() > 0) {
            for (NPatchRelation relation : relations.getLowerPSUs()) {
                this.addLowerPSU(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getConflicts().size() > 0) {
            for (NPatchRelation relation : relations.getConflicts()) {
                this.addConflict(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getSubsetPSU().size() > 0) {
            for (NPatchRelation relation : relations.getSubsetPSU()) {
                this.addSubsetPSU(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getSupersetPSU().size() > 0) {
            for (NPatchRelation relation : relations.getSupersetPSU()) {
                this.addSupersetPSU(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
        if (relations.getInvalidPSU().size() > 0) {
            for (NPatchRelation relation : relations.getInvalidPSU()) {
                this.addInvalidPSU(new NPatchRelation(relation.from(), relation.to(), relation.getDef()));
            }
        }
    }

    protected void addSuperset(NPatchRelation rel) {
        if (this.supersets == null) {
            this.supersets = new ArrayList();
        }
        this.supersets.add(rel);
    }

    protected void addSubset(NPatchRelation rel) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        this.subsets.add(rel);
    }

    protected void addHigherPSU(NPatchRelation rel) {
        if (this.higherPSUs == null) {
            this.higherPSUs = new ArrayList();
        }
        this.higherPSUs.add(rel);
    }

    protected void addLowerPSU(NPatchRelation rel) {
        if (this.lowerPSUs == null) {
            this.lowerPSUs = new ArrayList();
        }
        this.lowerPSUs.add(rel);
    }

    protected void addWorse(NPatchRelation rel) {
        if (this.worses == null) {
            this.worses = new ArrayList();
        }
        this.worses.add(rel);
    }

    protected void addBetter(NPatchRelation rel) {
        if (this.betters == null) {
            this.betters = new ArrayList();
        }
        this.betters.add(rel);
    }

    protected void addDuplicate(NPatchRelation rel) {
        if (this.duplicates == null) {
            this.duplicates = new ArrayList();
        }
        this.duplicates.add(rel);
    }

    protected void addConflict(NPatchRelation rel) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList();
        }
        this.conflicts.add(rel);
    }

    protected void addSubsetPSU(NPatchRelation rel) {
        if (this.subsetPSU == null) {
            this.subsetPSU = new ArrayList();
        }
        this.subsetPSU.add(rel);
    }

    protected void addSupersetPSU(NPatchRelation rel) {
        if (this.supersetPSU == null) {
            this.supersetPSU = new ArrayList();
        }
        this.supersetPSU.add(rel);
    }

    protected void addInvalidPSU(NPatchRelation rel) {
        if (this.invalidPSU == null) {
            this.invalidPSU = new ArrayList();
        }
        this.invalidPSU.add(rel);
    }

    public boolean isBetterOf(IPatch conflictPatch) {
        if (this.betters != null) {
            for (NPatchRelation better : this.betters) {
                if (!better.to().equals(conflictPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWorseOf(IPatch conflictPatch) {
        if (this.worses != null) {
            for (NPatchRelation worse : this.worses) {
                if (!worse.to().equals(conflictPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConflictOf(IPatch conflictPatch) {
        if (this.conflicts != null) {
            for (NPatchRelation conflict : this.conflicts) {
                if (!conflict.to().equals(conflictPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSupersetOf(IPatch conflictPatch) {
        if (this.supersets != null) {
            for (NPatchRelation superset : this.supersets) {
                if (!superset.to().equals(conflictPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubsetOf(IPatch conflictPatch) {
        if (this.subsets != null) {
            for (NPatchRelation subset : this.subsets) {
                if (!subset.to().equals(conflictPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDuplicateOf(IPatch conflictPatch) {
        if (this.duplicates != null) {
            for (NPatchRelation duplicate : this.duplicates) {
                if (!duplicate.to().equals(conflictPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGenericRelation(IPatch conflictPatch) {
        return this.isSubsetOf(conflictPatch) || this.isSupersetOf(conflictPatch) || this.isBetterOf(conflictPatch) || this.isWorseOf(conflictPatch) || this.isDuplicateOf(conflictPatch);
    }

    public Collection<NPatchRelation> getSupersets() {
        return this.supersets == null ? this.empty : this.supersets;
    }

    public Collection<NPatchRelation> getSubsets() {
        return this.subsets == null ? this.empty : this.subsets;
    }

    public Collection<NPatchRelation> getDuplicates() {
        return this.duplicates == null ? this.empty : this.duplicates;
    }

    public Collection<NPatchRelation> getConflicts() {
        return this.conflicts == null ? this.empty : this.conflicts;
    }

    public Collection<NPatchRelation> getWorses() {
        return this.worses == null ? this.empty : this.worses;
    }

    public Collection<NPatchRelation> getBetters() {
        return this.betters == null ? this.empty : this.betters;
    }

    public Collection<NPatchRelation> getHigherPSUs() {
        return this.higherPSUs == null ? this.empty : this.higherPSUs;
    }

    public Collection<NPatchRelation> getLowerPSUs() {
        return this.lowerPSUs == null ? this.empty : this.lowerPSUs;
    }

    public Collection<NPatchRelation> getSubsetPSU() {
        return this.subsetPSU == null ? this.empty : this.subsetPSU;
    }

    public Collection<NPatchRelation> getSupersetPSU() {
        return this.supersetPSU == null ? this.empty : this.supersetPSU;
    }

    public Collection<NPatchRelation> getInvalidPSU() {
        return this.invalidPSU == null ? this.empty : this.invalidPSU;
    }

    public boolean isEmpty() {
        return this.getConflicts().isEmpty() && this.getDuplicates().isEmpty() && this.getSubsets().isEmpty() && this.getSupersets().isEmpty() && this.getBetters().isEmpty() && this.getWorses().isEmpty() && this.getHigherPSUs().isEmpty() && this.getLowerPSUs().isEmpty() && this.getSubsetPSU().isEmpty() && this.getSupersetPSU().isEmpty() && this.getInvalidPSU().isEmpty();
    }

    public Collection<NPatchRelation> getWholeSupersets() {
        if (this.supersets == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> wholeSupersets = new ArrayList<NPatchRelation>();
        for (NPatchRelation superset : this.supersets) {
            IPatch from = superset.from();
            IPatch to = superset.to();
            if (from.isComposite() || to.isComposite()) {
                if (!superset.isWholeRelation()) continue;
                wholeSupersets.add(superset);
                continue;
            }
            wholeSupersets.add(superset);
        }
        return wholeSupersets;
    }

    public Collection<NPatchRelation> getWholeSubsets() {
        if (this.subsets == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> wholeSubsets = new ArrayList<NPatchRelation>();
        for (NPatchRelation subset : this.subsets) {
            IPatch from = subset.from();
            IPatch to = subset.to();
            if (from.isComposite() || to.isComposite()) {
                if (!subset.isWholeRelation()) continue;
                wholeSubsets.add(subset);
                continue;
            }
            wholeSubsets.add(subset);
        }
        return wholeSubsets;
    }

    public Collection<NPatchRelation> getWholeConflicts() {
        if (this.conflicts == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> wholeConflicts = new ArrayList<NPatchRelation>();
        for (NPatchRelation conflict : this.conflicts) {
            IPatch from = conflict.from();
            IPatch to = conflict.to();
            if (from.isComposite() || to.isComposite()) {
                if (from.isComposite() && to.isComposite()) {
                    wholeConflicts.add(conflict);
                }
                if (!conflict.isWholeRelation()) continue;
                wholeConflicts.add(conflict);
                continue;
            }
            wholeConflicts.add(conflict);
        }
        return wholeConflicts;
    }

    public Collection<NPatchRelation> getWholeCompositeConflicts() {
        if (this.conflicts == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> wholeConflicts = new ArrayList<NPatchRelation>();
        for (NPatchRelation conflict : this.conflicts) {
            if (!conflict.isWholeRelation()) continue;
            wholeConflicts.add(conflict);
        }
        return wholeConflicts;
    }

    public Collection<NPatchRelation> getSingleConflicts() {
        if (this.conflicts == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> singleConflicts = new ArrayList<NPatchRelation>();
        for (NPatchRelation conflict : this.conflicts) {
            if (conflict.isWholeRelation()) continue;
            singleConflicts.add(conflict);
        }
        return singleConflicts;
    }

    public Collection<NPatchRelation> getWholeCompositeSubsets() {
        if (this.subsets == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> wholesubsets = new ArrayList<NPatchRelation>();
        for (NPatchRelation subset : this.subsets) {
            if (!subset.isWholeRelation()) continue;
            wholesubsets.add(subset);
        }
        return wholesubsets;
    }

    public Collection<NPatchRelation> getSingleSubsets() {
        if (this.subsets == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> singleSubsets = new ArrayList<NPatchRelation>();
        for (NPatchRelation subset : this.subsets) {
            if (subset.isWholeRelation()) continue;
            singleSubsets.add(subset);
        }
        return singleSubsets;
    }

    public Collection<NPatchRelation> getWholeCompositeSupersets() {
        if (this.supersets == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> wholeSupersets = new ArrayList<NPatchRelation>();
        for (NPatchRelation superset : this.supersets) {
            if (!superset.isWholeRelation()) continue;
            wholeSupersets.add(superset);
        }
        return wholeSupersets;
    }

    public Collection<NPatchRelation> getSingleSupersets() {
        if (this.supersets == null) {
            return this.empty;
        }
        ArrayList<NPatchRelation> singleSupersets = new ArrayList<NPatchRelation>();
        for (NPatchRelation superset : this.supersets) {
            if (superset.isWholeRelation()) continue;
            singleSupersets.add(superset);
        }
        return singleSupersets;
    }

    public void clearConflict(IPatch p2) {
        if (this.conflicts != null) {
            for (NPatchRelation conflict : this.conflicts) {
                if (!conflict.to().equals(p2)) continue;
                this.conflicts.remove(conflict);
                break;
            }
        }
    }
}

