/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.OneOffEntry;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.wrappers.WrapperFactory;

public class BuildComposite {
    private NApplyData data;
    private OneOffEntry[] patchesToApply;

    public BuildComposite(NApplyData data) {
        this.data = data;
    }

    public void build(NApplyData data) {
        this.checkComposite(data);
        this.buildCompositeArray(data);
    }

    public void checkComposite(NApplyData data) {
        this.patchesToApply = data.getPatchesToApply();
        ArrayList startIndexComposite = new ArrayList();
        ArrayList endIndexComposite = new ArrayList();
        ArrayList compositeIndices = CompositePatchObject.determineCompositeIndices(this.patchesToApply);
        if (compositeIndices.size() < 1) {
            data.setIsComposite(false);
        }
        for (int i2 = 0; i2 < compositeIndices.size(); ++i2) {
            if (i2 % 2 == 0) {
                startIndexComposite.add(compositeIndices.get(i2));
            } else {
                endIndexComposite.add(compositeIndices.get(i2));
            }
            if (startIndexComposite.size() == 1 && endIndexComposite.size() == 1) {
                data.setIsComposite(true);
                data.setCompositeStartIndex((Integer)startIndexComposite.get(0));
                data.setCompositeEndIndex((Integer)endIndexComposite.get(0));
                data.setActivePatch(this.patchesToApply[data.getCompositeEndIndex()].getID());
                continue;
            }
            if (startIndexComposite.size() <= 1 && endIndexComposite.size() <= 1) continue;
            String errorMsg = "We do not allow more than 1 composite applied at a time.";
            throw new RuntimeException(errorMsg);
        }
    }

    public void buildCompositeArray(NApplyData data) {
        String[] compositeSequence = null;
        OneOffEntry[] compositeSubArray = null;
        int compositeSize = 0;
        OneOffEntry[] correctSubArray = null;
        if (data.isComposite()) {
            int compositeStartIndex = data.getCompositeStartIndex();
            int compositeEndIndex = data.getCompositeEndIndex();
            data.setCompositeSize(compositeEndIndex - compositeStartIndex + 1);
            compositeSize = data.getCompositeSize();
            compositeSubArray = new OneOffEntry[compositeSize];
            for (int i2 = compositeStartIndex; i2 <= compositeEndIndex; ++i2) {
                compositeSubArray[i2 - compositeStartIndex] = this.patchesToApply[i2];
            }
            for (OneOffEntry o2 : compositeSubArray) {
                Path compFilePath = WrapperFactory.getNioServiceWrapper().getPath(o2.getCompositeFileLocation(), new String[0]);
                if (!Files.exists(compFilePath, new LinkOption[0])) continue;
                compositeSequence = new String[compositeSize];
                compositeSequence = CompositePatchObject.getConstituentList(compFilePath.toString());
            }
            if (compositeSequence == null || compositeSequence.length == 0) {
                CompositePatchObject.checkUIDs(compositeSubArray);
                data.setCompositeSubArray(compositeSubArray);
            } else if (compositeSubArray.length == compositeSequence.length) {
                int num = 0;
                correctSubArray = new OneOffEntry[compositeSubArray.length];
                HashMap<String, OneOffEntry> subArrayMap = new HashMap<String, OneOffEntry>();
                for (int i3 = 0; i3 < compositeSubArray.length; ++i3) {
                    if (compositeSubArray[i3].getPatchID() == compositeSequence[i3]) {
                        ++num;
                    }
                    subArrayMap.put(compositeSubArray[i3].getPatchID(), compositeSubArray[i3]);
                }
                if (num == compositeSubArray.length) {
                    CompositePatchObject.checkUIDs(compositeSubArray);
                    data.setCompositeSubArray(compositeSubArray);
                } else {
                    for (int j2 = 0; j2 < compositeSequence.length; ++j2) {
                        correctSubArray[j2] = (OneOffEntry)subArrayMap.get(compositeSequence[j2]);
                    }
                    CompositePatchObject.checkUIDs(correctSubArray);
                    data.setCompositeSubArray(correctSubArray);
                    data.setActivePatch(correctSubArray[correctSubArray.length - 1].getPatchID());
                }
            }
        } else {
            data.setCompositeSubArray(null);
        }
    }
}

