/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.Rules;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckConflictAdapter;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PrereqSet;

public final class ConflictReporter {
    private static Comparator<OneOffEntry> sortComparator = new Comparator<OneOffEntry>(){

        @Override
        public int compare(OneOffEntry p1, OneOffEntry p2) {
            int p2Len;
            int p1Len = p1.getID().length();
            if (p1Len < (p2Len = p2.getID().length())) {
                return -1;
            }
            if (p1Len > p2Len) {
                return 1;
            }
            return p1.getID().compareTo(p2.getID());
        }
    };

    public static void processFailMessage(NApplyData data) {
        ConflictMatrixOutput output = data.getInterOutput();
        OneOffEntry[] patchesCanGo = output.getListOfPatchesThatCanGoNow();
        CheckConflictAdapter adapter = data.getCheckConflictAdapter();
        if (adapter.isConflictStatusCode()) {
            if (OPatchSessionHelper.hasHotPatch(new PrereqSet(data.getInterOutput().getListOfPatchesToBeMerged()))) {
                OLogger.warn("OUI-67281", new Object[]{OPatchSessionHelper.getHotPatchIDs(new PrereqSet(data.getInterOutput().getListOfPatchesToBeMerged()))});
                OPatchStateManagerFactory.getInstance().setErrorCode(66);
                PrereqFailedException re = new PrereqFailedException("Some Online Patch(es) has conflicts.");
                throw re;
            }
            if (OPatchEnv.isIgnoreConflict()) {
                OPatchStateManagerFactory.getInstance().setErrorCode(66);
                if (patchesCanGo.length == 0) {
                    throw new RuntimeException("After skipping conflicting patches, there is no patch to apply.");
                }
            }
            String msg = "Inter-conflict checking failed in apply incoming patches";
            OPatchStateManagerFactory.getInstance().setErrorCode(218);
            throw new RuntimeException(msg);
        }
        OLogger.println("");
        throw new RuntimeException(adapter.getPrereqErrorMessage());
    }

    private static void processNotNeedUI(NApplyData data, CheckConflictAdapter adapter) {
        ConflictMatrixOutput output = data.getInterOutput();
        OneOffEntry[] notNeeds = output.getListOfPatchesNotNeeded();
        ArrayList<OneOffEntry> skipConflicts = adapter.getSkipConflicts();
        ArrayList<OneOffEntry> skipConflictsToComposite = adapter.getSkipConflictToComposite();
        ArrayList<OneOffEntry> duplicates = adapter.getDuplicates();
        ArrayList<OneOffEntry> subsetOfBigPoh = adapter.getSubsetOfBigPoh();
        ArrayList<OneOffEntry> composites = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> others = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> subsetPSUTrain = adapter.getSubsetPSUTrain();
        OneOffEntry[] conflicts = output.getListOfPatchesToBeMerged();
        if (notNeeds.length > 0) {
            StringBuffer message = new StringBuffer(4096);
            for (OneOffEntry notNeed : notNeeds) {
                if (skipConflicts.contains(notNeed) || duplicates.contains(notNeed) || subsetOfBigPoh.contains(notNeed) || skipConflictsToComposite.contains(notNeed)) continue;
                if (notNeed.getIsComposite()) {
                    composites.add(notNeed);
                    continue;
                }
                others.add(notNeed);
            }
            if (skipConflicts.size() > 0 && conflicts.length > 0) {
                Collections.sort(skipConflicts, sortComparator);
                for (OneOffEntry oneOff : conflicts) {
                    message.append("   ");
                    message.append(oneOff.getID());
                }
                OLogger.warn("OUI-67301", new Object[]{message.toString()});
                message.setLength(0);
                message.append("OPatch found that the following patch(es) are not required.\n");
                message.append("Conflict detected and skipped:\n");
                message.append(" [ ");
                for (OneOffEntry skip : skipConflicts) {
                    message.append(skip.getID()).append(" ");
                }
                message.append("]\n");
                OLogger.println(message.toString());
            }
            if (skipConflictsToComposite.size() > 0) {
                Collections.sort(skipConflictsToComposite, sortComparator);
                for (OneOffEntry oneOff : conflicts) {
                    message.append("   ");
                    message.append(oneOff.getID());
                }
                OLogger.warn("OUI-67301", new Object[]{message.toString()});
                message.setLength(0);
                message.append("OPatch found that the following patch(es) are skipped because conflict with existing composite patch in oracle home.\n");
                message.append("Conflict detected and skipped:\n");
                message.append(" [ ");
                for (OneOffEntry skip : skipConflictsToComposite) {
                    message.append(skip.getID()).append(" ");
                }
                message.append("]\n");
                OLogger.println(message.toString());
            }
            if (others.size() > 0) {
                Collections.sort(others, sortComparator);
                message.setLength(0);
                message.append("OPatch found that the following patch(es) are not required.\n");
                message.append("They are either subset of the patches in Oracle Home (or) subset of the patches in the given list:\n");
                message.append(" [ ");
                for (OneOffEntry oneOff : others) {
                    message.append(oneOff.getID()).append(" ");
                }
                message.append("]\n");
                OLogger.println(message.toString());
            }
            if (subsetOfBigPoh.size() > 0) {
                Collections.sort(subsetOfBigPoh, sortComparator);
                message.setLength(0);
                message.append("OPatch found that the following patch(es) are not required.\n");
                message.append("Conflict detected and the total bug fixes of the them are subset of patches in Oracle Home:\n");
                message.append(" [ ");
                for (OneOffEntry oneOff : subsetOfBigPoh) {
                    message.append(oneOff.getID()).append(" ");
                }
                message.append("]\n");
                OLogger.println(message.toString());
            }
            if (composites.size() > 0 && subsetPSUTrain.size() == 0) {
                message.setLength(0);
                message.append("OPatch found that the following patches are not required.\n");
                message.append("All of the constituents of the composite patch [ ");
                for (OneOffEntry comp : composites) {
                    message.append(comp.getID()).append(" ");
                }
                message.append("] are already installed in the Oracle Home.\n");
                OLogger.println(message.toString());
            }
            if (subsetPSUTrain.size() > 0) {
                message.setLength(0);
                message.append("\nOPatch found that the following patches [ ");
                for (OneOffEntry comp : subsetPSUTrain) {
                    message.append(comp.getID()).append(" ");
                }
                message.append("] cannot be installed because there is already an Overriding Cumulative Patch Bundle installed in Oracle Home.\n");
                throw new RuntimeException(message.toString());
            }
        }
    }

    private static void processAutoRollbackUI(NApplyData data, CheckConflictAdapter adapter) {
        ConflictMatrixOutput output = data.getInterOutput();
        OneOffEntry[] patchesToBeRollback = output.getListOfPatchesThatNeedToBeRollback();
        ArrayList<OneOffEntry> subsetOfBigPi = adapter.getSubsetOfBigPi();
        if (patchesToBeRollback.length == 0) {
            return;
        }
        StringBuffer autoROllbackbuff = new StringBuffer(4096);
        if (subsetOfBigPi.size() > 0) {
            Collections.sort(subsetOfBigPi, sortComparator);
            autoROllbackbuff.append("OPatch found that the following patches will be rolled back.\n");
            autoROllbackbuff.append("Conflict detected and the total bug fixes of incoming patches are superset of patches in Oracle Home:\n");
            autoROllbackbuff.append(" [ ");
            for (OneOffEntry oneoff : subsetOfBigPi) {
                autoROllbackbuff.append(oneoff.getID()).append(" ");
            }
            autoROllbackbuff.append("]\n");
            OLogger.println(autoROllbackbuff.toString());
        }
        autoROllbackbuff.setLength(0);
        for (int i2 = 0; i2 < patchesToBeRollback.length; ++i2) {
            autoROllbackbuff.append("   ");
            autoROllbackbuff.append(patchesToBeRollback[i2].getID());
        }
        if (!Rules.shouldSwitchONAutoRollback(OPatchEnv.getOracleHome())) {
            OneOffEntry[] patchesCanGo = output.getListOfPatchesThatCanGoNow();
            PrereqSet patchesCanGoSet = new PrereqSet(patchesCanGo);
            PrereqSet patchesRollSet = new PrereqSet(patchesToBeRollback);
            patchesCanGoSet.retain(patchesRollSet);
            PrereqSet tmpSet = patchesRollSet.delete(patchesCanGoSet);
            StringBuffer subsetBuff = new StringBuffer();
            if (tmpSet.size() > 0) {
                for (int i3 = 0; i3 < tmpSet.size(); ++i3) {
                    subsetBuff.append("   ");
                    String id = tmpSet.getElement(i3).getID();
                    subsetBuff.append(id);
                }
                StringBuffer dBuff = new StringBuffer(" has auto-rollback due to superset-subset but we are not doing it.");
                dBuff.append("\nfor non-identical patches.");
                OLogger.debug(dBuff);
                OLogger.warn("OUI-67328", new Object[]{subsetBuff.toString()});
            }
        }
        OLogger.warn("OUI-67303", new Object[]{autoROllbackbuff.toString()});
    }

    public static void processSucceedUI(NApplyData data, boolean checkAgain) {
        ConflictMatrixOutput output = data.getInterOutput();
        OneOffEntry[] patchesNotNeed = output.getListOfPatchesNotNeeded();
        OneOffEntry[] patchesToBeRollback = output.getListOfPatchesThatNeedToBeRollback();
        OneOffEntry[] patchesCanGo = output.getListOfPatchesThatCanGoNow();
        if (!(patchesToBeRollback.length <= 0 && patchesNotNeed.length <= 0 || checkAgain)) {
            String msg = output.getConflictDetailsString();
            OLogger.println(msg);
            OLogger.println("");
        }
        ConflictReporter.processNotNeedUI(data, data.getCheckConflictAdapter());
        ConflictReporter.processAutoRollbackUI(data, data.getCheckConflictAdapter());
        if (patchesCanGo.length == 0 && OPatchEnv.isIgnoreConflict()) {
            OPatchStateManagerFactory.getInstance().setErrorCode(66);
            if (patchesCanGo.length == 0) {
                throw new RuntimeException("After skipping conflicting patches, there is no patch to apply.");
            }
        }
    }

    public static void processDuplicateUI(NApplyData data) {
        CheckConflictAdapter adapter = data.getCheckConflictAdapter();
        ConflictMatrixOutput output = data.getInterOutput();
        OneOffEntry[] patchesCanGo = output.getListOfPatchesThatCanGoNow();
        ArrayList<OneOffEntry> duplicates = adapter.getDuplicates();
        HashSet<OneOffEntry> filterDuplicates = new HashSet<OneOffEntry>(duplicates);
        for (OneOffEntry cango : patchesCanGo) {
            if (!filterDuplicates.contains(cango)) continue;
            filterDuplicates.remove(cango);
        }
        if (filterDuplicates.size() > 0) {
            OLogger.println("\nThe following patches are duplicate and are skipped:");
            OneOffEntry[] finalDuplicates = filterDuplicates.toArray(new OneOffEntry[filterDuplicates.size()]);
            PrereqSet pset = new PrereqSet(finalDuplicates);
            OLogger.println(pset.toString());
        }
    }

    public static void processFailUI(NApplyData data) {
        ConflictMatrixOutput output = data.getInterOutput();
        OneOffEntry[] patchesToBeMerged = output.getListOfPatchesToBeMerged();
        String msg = output.getConflictDetailsString();
        OLogger.println(msg);
        OLogger.println("");
        if (patchesToBeMerged.length > 0) {
            StringBuffer mergeBuff = new StringBuffer(4096);
            for (int i2 = 0; i2 < patchesToBeMerged.length; ++i2) {
                mergeBuff.append("   ");
                String id = patchesToBeMerged[i2].getID();
                if (data.getModelCode() == 2) {
                    if (patchesToBeMerged[i2].getPatchType().equals("snowball")) {
                        OLogger.println("Patch \"" + id + "\" is a \"" + "Fusion Applications" + "\" patch.");
                    } else if (patchesToBeMerged[i2].getPatchType().equals("singleton")) {
                        OLogger.println("Patch \"" + id + "\" is a \"" + "singleton" + "\" patch.");
                    }
                }
                mergeBuff.append(id);
            }
            OLogger.warn("OUI-67301", new Object[]{mergeBuff.toString()});
        }
    }
}

