/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchingFlow;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.wrappers.WrapperFactory;

public class RepoFileSystemEnv {
    public static void setupCasRepoFileSystem(String oracleHomePath) throws Exception {
        if (OPatchEnv.isCasRepoEnabled()) {
            OPatchEnv.setLegacyNioEnable(PrereqAPI.isLegacyNIOCapable(oracleHomePath));
        }
        OPatchEnv.setPatchingFlow();
        FileSystem fileSystem = WrapperFactory.getNioServiceWrapper().getFileSystem(Paths.get(oracleHomePath, new String[0]));
        boolean isCasDirectlyPatching = PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow());
        if (isCasDirectlyPatching && !OPatchEnv.isReport() && fileSystem == null) {
            RepoFileSystemEnv.createCasRepo(oracleHomePath);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("FILE_SYSTEM_STAGE_PARENT_PATH", oracleHomePath + File.separator + ".cas");
            env.put("FILE_SYSTEM_COMMIT_ABORT_WRAPPER", OPatchEnv.COMMIT_ABORT_WRAPPER);
            env.put("FILE_SYSTEM_PATCH_MEMENTO_WRAPPER", OPatchEnv.PATCH_MEMENTO_WRAPPER);
            env.put("FILE_SYSTEM_PATCHING_ENABLED", true);
            WrapperFactory.getNioServiceWrapper().configureRepoFileSystem();
            try {
                WrapperFactory.getNioServiceWrapper().newFileSystem(Paths.get(oracleHomePath, new String[0]), env);
            }
            catch (IOException e2) {
                OLogger.warn("Failed to create file system: " + e2.getMessage());
                throw new Exception(e2.getMessage());
            }
        }
    }

    private static void createCasRepo(String oracleHomePath) throws Exception {
        block6: {
            CASFileServices casFileServices = new CASFileServices();
            try {
                casFileServices.initialize(oracleHomePath, true);
                if (casFileServices.isCasReposPresent()) break block6;
                if (!OPatchEnv.isReport()) {
                    casFileServices.attach();
                    break block6;
                }
                StringBuffer errorMsg = new StringBuffer("Cas repo does not exist. '-report' mode is not support in cas directly patching flow.");
                errorMsg.append("Pls use 'obrepo attach' to create cas repo.");
                Exception e2 = new Exception(errorMsg.toString());
                throw e2;
            }
            catch (RuntimeException re) {
                OLogger.warn("Failed to create cas repo: " + re.getMessage());
                throw new Exception(re.getMessage());
            }
            finally {
                casFileServices.cleanup();
            }
        }
    }

    private static void closeCasRepoFileSystem(String oracleHomePath) {
        try {
            OLogger.justlog(OLogger.INFO, "Closing file system for " + oracleHomePath);
            FileSystem fileSystem = WrapperFactory.getNioServiceWrapper().getFileSystem(Paths.get(oracleHomePath, new String[0]));
            if (fileSystem != null) {
                OPatchEnv.COMMIT_ABORT_WRAPPER.setManualClose(true);
                fileSystem.close();
            }
        }
        catch (Exception e2) {
            OLogger.warn("Failed to close file system for " + oracleHomePath);
        }
    }

    public static void restoreMementoToOH(String oracleHomePath) {
        RepoFileSystemEnv.closeCasRepoFileSystem(oracleHomePath);
        CASFileServices cas = new CASFileServices();
        try {
            cas.initialize(oracleHomePath, true);
            cas.synch(new HashMap<Path, String>());
            OLogger.justlog(OLogger.INFO, "Restored the latest patch memento to OH\n");
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            cas.cleanup();
        }
    }
}

