/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.util.ArrayList;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.opatchlogger.OLogger;

public class dbpkgAction
extends PatchAction
implements ConflictDetectable {
    String pkgName;
    String sqlFileName;
    String pkgType;
    String sqlFilePath;

    public dbpkgAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception, RuntimeException {
        super(pc, lineNumber);
        String pkgName = null;
        String sqlFileName = null;
        String pkgType = null;
        String sqlFilePath = null;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for dbpkgAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals("name")) {
                pkgName = val;
            }
            if (arg.equals("file")) {
                sqlFileName = val;
            }
            if (arg.equals("type")) {
                pkgType = val;
            }
            if (!arg.equals("file_path")) continue;
            sqlFilePath = val;
        }
        if (pkgName == null || sqlFileName == null || pkgType == null || sqlFilePath == null) {
            String errMsg = "The dbpkg action is null";
            if (pkgName == null) {
                errMsg = errMsg + "The dbpkg package name is null";
            }
            if (sqlFileName == null) {
                errMsg = errMsg + "The dbpkg sql file name is null";
            }
            if (pkgType == null) {
                errMsg = errMsg + "The dbpkg package type is null";
            }
            if (sqlFilePath == null) {
                errMsg = errMsg + "The dbpkg file path is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.pkgName = pkgName;
        this.sqlFileName = sqlFileName;
        this.pkgType = pkgType;
        this.sqlFilePath = PatchObjectUtil.getPlatformDependentPath(sqlFilePath);
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        return "";
    }

    @Override
    public String getActionName() {
        return "dbpkgAction";
    }

    @Override
    public String getActionDesc() {
        return "Patch a database package.";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return true;
    }

    public String getPackageName() {
        return this.pkgName;
    }

    public String getSqlFileName() {
        return this.sqlFileName;
    }

    public String getPkgType() {
        return this.pkgType;
    }

    public String getSqlFilePath() {
        return this.sqlFilePath;
    }

    @Override
    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("dbpkgAction::conflictDetectable()  ");
        boolean tmpB = false;
        if (!(this.pkgName == null || this.pkgName.equals("") || this.sqlFileName == null || this.sqlFileName.equals("") || this.pkgType == null || this.pkgType.equals("") || this.sqlFilePath == null || this.sqlFilePath.equals(""))) {
            tmpB = true;
        }
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    @Override
    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) {
        String[] pkgThatWillBeTouched = this.filesTouched(oracleHomePath);
        String conflictingPkg = "";
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            PatchAction[] patchActions = oneoffs[i2].getPatchActions();
            for (int j2 = 0; j2 < patchActions.length; ++j2) {
                dbpkgAction pkgAction;
                String[] pkgAlreadyTouched;
                boolean isConflict;
                if (patchActions[j2] == null || !(patchActions[j2] instanceof dbpkgAction) || !(isConflict = pkgThatWillBeTouched[0].equals((pkgAlreadyTouched = (pkgAction = (dbpkgAction)patchActions[j2]).filesTouched(oracleHomePath))[0]))) continue;
                conflictingPkg = pkgThatWillBeTouched[0];
            }
        }
        return conflictingPkg;
    }

    @Override
    public String[] filesTouched(String oracleHomePath) {
        StringBuffer finalString = new StringBuffer();
        finalString.append(this.getPackageName());
        finalString.append(":");
        finalString.append(this.getPkgType());
        return new String[]{finalString.toString()};
    }

    public String getRelativeSqlFilePath() {
        StringBuffer finalPath = new StringBuffer();
        finalPath.append(this.sqlFilePath);
        finalPath.append(File.separator);
        finalPath.append(this.sqlFileName);
        return finalPath.toString();
    }

    public String getCompleteSqlFilePath(String patchLocation) {
        StringBuffer completePath = new StringBuffer();
        completePath.append(patchLocation);
        completePath.append(File.separator);
        completePath.append("files");
        completePath.append(File.separator);
        completePath.append(this.getRelativeSqlFilePath());
        return completePath.toString();
    }
}

