/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.EnumSet;
import java.util.List;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.ApplicationLifeCycle;
import oracle.opatch.opatchfafmw.CheckAdminServer;
import oracle.opatch.opatchfafmw.CheckApplicationLifeCycle;
import oracle.opatch.opatchfafmw.CheckBIPDeploy;
import oracle.opatch.opatchfafmw.CheckBIPUndeploy;
import oracle.opatch.opatchfafmw.CheckBaseSOACompositeDeploy;
import oracle.opatch.opatchfafmw.CheckCompositeLifecycle;
import oracle.opatch.opatchfafmw.CheckConfiguration;
import oracle.opatch.opatchfafmw.CheckSOACompositeDeploy;
import oracle.opatch.opatchfafmw.CheckSOACompositeUndeploy;
import oracle.opatch.opatchfafmw.CheckSOAServer;
import oracle.opatch.opatchfafmw.CheckServerLifeCycle;
import oracle.opatch.opatchfafmw.CompositeLifeCycle;
import oracle.opatch.opatchfafmw.CompositeStatus;
import oracle.opatch.opatchfafmw.DeployBIP;
import oracle.opatch.opatchfafmw.DeployBaseSOAComposite;
import oracle.opatch.opatchfafmw.DeployLDIF;
import oracle.opatch.opatchfafmw.DeploySOAResourceBundle;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.FMWException;
import oracle.opatch.opatchfafmw.JMXConnection;
import oracle.opatch.opatchfafmw.ListDeployedComposites;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.ServerConfigAttributes;
import oracle.opatch.opatchfafmw.ServerLifeCycle;
import oracle.opatch.opatchfafmw.SingleAPISOACompositeDeploy;
import oracle.opatch.opatchfafmw.UndeployBIP;
import oracle.opatch.opatchfafmw.UndeploySOAComposite;
import oracle.opatch.opatchfafmw.rb.RB;

public final class FMWProductDriver {
    private final FMWContext c;
    private final EnumSet<FMWContext.OperationCode> set = EnumSet.noneOf(FMWContext.OperationCode.class);

    FMWProductDriver(FMWContext c2) {
        this.c = c2;
    }

    public void run(FMWContext.OperationCode o2) {
        if (o2 == null) {
            return;
        }
        if (!this.c.getAllowedOperations().contains((Object)o2)) {
            Logger.warn(RB.Entry.OPERATION_NOT_ALLOWED, this.c.getAllowedOperations().toString());
            return;
        }
        if (this.set.contains((Object)o2)) {
            return;
        }
        if (o2.prereq() != null) {
            this.run(o2.prereq());
        }
        Operation op = null;
        switch (o2) {
            case STOP: 
            case STOP_NSERVER: {
                switch (this.c.getTargets().getType()) {
                    case SERVER: {
                        op = new ServerLifeCycle(false);
                        break;
                    }
                    case APPLICATION: {
                        op = new ApplicationLifeCycle(false);
                    }
                }
                break;
            }
            case START: 
            case START_NSERVER: {
                switch (this.c.getTargets().getType()) {
                    case SERVER: {
                        op = new ServerLifeCycle(true);
                        break;
                    }
                    case APPLICATION: {
                        op = new ApplicationLifeCycle(true);
                    }
                }
                break;
            }
            case SERVER_CONFIG_ATTRIBUTE: {
                op = new ServerConfigAttributes();
                break;
            }
            case COMPOSITE_STATUS: {
                op = new CompositeStatus();
                break;
            }
            case PREREQ_LIFE_CYCLE: {
                switch (this.c.getTargets().getType()) {
                    case SERVER: {
                        op = new CheckServerLifeCycle();
                        break;
                    }
                    case APPLICATION: {
                        op = new CheckApplicationLifeCycle();
                    }
                }
                break;
            }
            case PREREQ_ADMIN_SERVER_AVAILABLE: {
                op = new CheckAdminServer();
                break;
            }
            case PREREQ_CONFIGURATION: {
                op = new CheckConfiguration();
                break;
            }
            case PREREQ_SOA_SERVER_AVAILABLE: {
                op = new CheckSOAServer();
                break;
            }
            case PREREQ_SOA_COMPOSITE_DEPLOY: {
                op = new CheckSOACompositeDeploy();
                break;
            }
            case PREREQ_SOA_COMPOSITE_UNDEPLOY: {
                op = new CheckSOACompositeUndeploy();
                break;
            }
            case PREREQ_BIP_DEPLOY: {
                op = new CheckBIPDeploy();
                break;
            }
            case PREREQ_BIP_UNDEPLOY: {
                op = new CheckBIPUndeploy();
                break;
            }
            case PREREQ_COMPOSITE_LIFECYCLE: {
                op = new CheckCompositeLifecycle();
                break;
            }
            case DEPLOY_SOA_COMPOSITE: {
                Logger.logi("Deploying with SOA single deploy API");
                op = new SingleAPISOACompositeDeploy();
                break;
            }
            case UNDEPLOY_SOA_COMPOSITE: {
                op = new UndeploySOAComposite();
                break;
            }
            case DEPLOY_SOA_RESOURCE_BUNDLE: {
                op = new DeploySOAResourceBundle();
                break;
            }
            case DEPLOY_LDIF: {
                op = new DeployLDIF();
                break;
            }
            case STOP_COMPOSITE: {
                op = new CompositeLifeCycle(false);
                break;
            }
            case START_COMPOSITE: {
                op = new CompositeLifeCycle(true);
                break;
            }
            case DEPLOY_BIP: {
                op = new DeployBIP();
                break;
            }
            case UNDEPLOY_BIP: {
                op = new UndeployBIP();
                break;
            }
            case LIST_DEPLOYED_COMPOSITES: {
                op = new ListDeployedComposites();
                break;
            }
            case DEPLOY_BASE_SOA_COMPOSITE: {
                op = new DeployBaseSOAComposite();
                break;
            }
            case PREREQ_BASE_SOA_COMPOSITE_DEPLOY: {
                op = new CheckBaseSOACompositeDeploy();
            }
        }
        if (op == null) {
            Logger.error(RB.Entry.OPERATION_NOT_SUPPORTED, o2.name());
        }
        Logger.log(RB.Entry.RUNNING_OPERATION, o2.name());
        try {
            boolean failed;
            List<OPatchStepAdapter> steps;
            op.run(this.c);
            if (OPatchEnv.isReport() && (steps = this.c.getContextBuilder().getExecutionSteps()) != null && steps.size() > 0) {
                Logger.log(OPatchStepAdapter.getStepString(steps));
                this.c.getContextBuilder().getExecutionSteps().clear();
            }
            boolean bl = failed = this.c.getContextBuilder().getFailedPrereqStep() != null;
            if (failed) {
                throw new RuntimeException(this.c.getContextBuilder().getFailedPrereqStep().getErrorMessage());
            }
            Logger.log(RB.Entry.OPERATION_COMPLETED, o2.name());
        }
        catch (FMWException e2) {
            Logger.log(RB.Entry.OPERATION_FAILED, o2.name());
            throw e2;
        }
        catch (Throwable t) {
            Logger.log(RB.Entry.OPERATION_FAILED, o2.name());
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        this.set.add(o2);
    }

    public void close() {
        JMXConnection.close();
    }

    public void resetAndIgnorePreStepsForLifeCycleOperation() {
        this.set.clear();
        this.set.add(FMWContext.OperationCode.PREREQ_ADMIN_SERVER_AVAILABLE);
        this.set.add(FMWContext.OperationCode.PREREQ_CONFIGURATION);
        this.set.add(FMWContext.OperationCode.PREREQ_LIFE_CYCLE);
    }
}

