/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FmwHelper {
    public static String getDomainHome(String domainName) {
        try {
            HashMap hm = FmwHelper.getDomainsList(null);
            String output = (String)hm.get(domainName);
            FmwHelper.debug("Domain Dir for (" + domainName + ") [" + output + "]");
            return output;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog(e2.getMessage());
            OLogger.printStackTrace(e2);
            return null;
        }
    }

    public static String getAdminURL(String domainName) {
        String domainDir = FmwHelper.getDomainHome(domainName);
        try {
            Path dd = WrapperFactory.getNioServiceWrapper().getPath(domainDir, new String[0]);
            if (!Files.isDirectory(dd, new LinkOption[0])) {
                FmwHelper.debug("Invalid Domain Directory for (" + domainName + ") [" + domainDir + "]");
                return null;
            }
            String append = new StringBuffer("config").append(File.separator).append("config.xml").toString();
            Path dc = WrapperFactory.getNioServiceWrapper().getPath(dd.toString(), append);
            FmwHelper.debug("Finding Admin URL For Domain [" + domainName + "]");
            FmwHelper.debug("Parsing domain-config file [" + dc.toAbsolutePath().toString() + "]");
            String output = FmwHelper.parseDomainConfigXML(dc);
            FmwHelper.debug("Admin URL [" + output + "]");
            return output;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog(e2.getMessage());
            OLogger.printStackTrace(e2);
            return null;
        }
    }

    public static String getApplicationsDir(String domainName) {
        String domainDir = FmwHelper.getDomainHome(domainName);
        try {
            Path dd = WrapperFactory.getNioServiceWrapper().getPath(domainDir, new String[0]);
            if (!Files.isDirectory(dd, new LinkOption[0])) {
                FmwHelper.debug("Invalid Domain Directory for (" + domainName + ") [" + domainDir + "]");
                return null;
            }
            String append = new StringBuffer("init-info").append(File.separator).append("domain-info.xml").toString();
            Path di = WrapperFactory.getNioServiceWrapper().getPath(dd.toString(), append);
            FmwHelper.debug("Finding APPS Directory For Domain [" + domainName + "]");
            FmwHelper.debug("Parsing domain-info file [" + di.toAbsolutePath().toString() + "]");
            String output = FmwHelper.parseDomainInfoXML2(Files.newInputStream(di, new OpenOption[0]));
            FmwHelper.debug("Application Dir [" + output + "]");
            return output;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog(e2.getMessage());
            OLogger.printStackTrace(e2);
            return null;
        }
    }

    private static String parseDomainConfigXML(Path file) throws Exception {
        String DEFAULT_PROTOCOL = "t3";
        String DEFAULT_SSL_PROTOCOL = "t3s";
        String DEFAULT_ADDRESS = "localhost";
        String DEFAULT_PORT = "7001";
        String DEFAULT_SSL_PORT = "7101";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(Files.newInputStream(file, new OpenOption[0]));
            doc.getDocumentElement().normalize();
            StringBuffer sb = new StringBuffer("");
            NodeList nl = doc.getElementsByTagName("admin-server-name");
            if (nl != null && nl.getLength() > 0 && (nl = ((Element)nl.item(0)).getChildNodes()) != null && nl.getLength() > 0) {
                String adminServer = nl.item(0).getNodeValue();
                if (adminServer == null || adminServer.trim().length() == 0) {
                    FmwHelper.debug("AdminServer Tag not found.");
                    return null;
                }
                FmwHelper.debug("AdminServer found [" + adminServer + "]");
                nl = doc.getElementsByTagName("server");
                if (nl != null) {
                    adminServer = adminServer.trim();
                    for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                        String name = FmwHelper.getNodeValue(nl.item(i2), "name");
                        if (name == null || !adminServer.equals(name.trim())) continue;
                        String listenAddress = FmwHelper.getNodeValue(nl.item(i2), "listen-address");
                        String listenPortEnabled = FmwHelper.getNodeValue(nl.item(i2), "listen-port-enabled");
                        if (listenPortEnabled != null && listenPortEnabled.trim().equals("false")) {
                            String sslListenPort = FmwHelper.getChildNodeValue(nl.item(i2), "ssl", "listen-port");
                            String sslListenPortEnabled = FmwHelper.getChildNodeValue(nl.item(i2), "ssl", "enabled");
                            sb.append(DEFAULT_SSL_PROTOCOL).append("://");
                            sb.append(listenAddress == null || listenAddress.trim().length() == 0 ? DEFAULT_ADDRESS : listenAddress.trim()).append(":");
                            sb.append(sslListenPort == null || sslListenPortEnabled == null || sslListenPort.trim().length() == 0 || sslListenPortEnabled.equals("false") ? DEFAULT_SSL_PORT : sslListenPort.trim());
                            continue;
                        }
                        String listenPort = FmwHelper.getNodeValue(nl.item(i2), "listen-port");
                        sb.append(DEFAULT_PROTOCOL).append("://");
                        sb.append(listenAddress == null || listenAddress.trim().length() == 0 ? DEFAULT_ADDRESS : listenAddress.trim()).append(":");
                        sb.append(listenPort == null || listenPort.trim().length() == 0 ? DEFAULT_PORT : listenPort.trim());
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception e2) {
            throw new Exception("Error in parsing xml.", e2);
        }
    }

    private static String getNodeValue(Node node, String tag) {
        if (node != null && node.getNodeType() == 1) {
            Element e2 = (Element)node;
            for (Node child = e2.getFirstChild(); child != null; child = child.getNextSibling()) {
                NodeList nl;
                if (child.getNodeType() != 1 || !tag.equals(child.getNodeName()) || (nl = (e2 = (Element)child).getChildNodes()) == null || nl.getLength() <= 0) continue;
                return nl.item(0).getNodeValue();
            }
        }
        return null;
    }

    private static String getChildNodeValue(Node node, String childNodeName, String tag) {
        if (node != null && node.getNodeType() == 1) {
            Element e2 = (Element)node;
            for (Node child = e2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !childNodeName.equals(child.getNodeName())) continue;
                return FmwHelper.getNodeValue(child, tag);
            }
        }
        return null;
    }

    private static ArrayList parseDomainInfoXML(InputStream is) throws Exception {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            final ArrayList list = new ArrayList();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String oh;
                    if ("install-comp-ref".equals(qName) && (oh = attributes.getValue("product_home")) != null && oh.trim().length() > 0) {
                        list.add(oh);
                    }
                }
            };
            saxParser.parse(is, handler);
            is.close();
            return list;
        }
        catch (SAXException se) {
            throw new Exception("Error in parsing xml.", se);
        }
        catch (Exception e2) {
            throw new Exception("Error in parsing xml.", e2);
        }
    }

    private static String parseDomainInfoXML2(InputStream is) throws Exception {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            final StringBuffer sb = new StringBuffer();
            DefaultHandler handler = new DefaultHandler(){
                boolean found = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String ad;
                    if (!this.found && "domain-info".equals(qName) && (ad = attributes.getValue("appdir")) != null && ad.trim().length() > 0) {
                        sb.append(ad);
                        this.found = true;
                    }
                }
            };
            saxParser.parse(is, handler);
            is.close();
            return sb.toString();
        }
        catch (SAXException se) {
            throw new Exception("Error in parsing xml.", se);
        }
        catch (Exception e2) {
            throw new Exception("Error in parsing xml.", e2);
        }
    }

    private static ArrayList parseRegistryXML(InputStream is) throws Exception {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            final ArrayList list = new ArrayList();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String installDir;
                    String name;
                    if ("component".equals(qName) && "WebLogic Server".equals(name = attributes.getValue("name")) && (installDir = attributes.getValue("InstallDir")) != null && installDir.trim().length() != 0) {
                        list.add(installDir);
                    }
                }
            };
            saxParser.parse(is, handler);
            is.close();
            return list;
        }
        catch (SAXException se) {
            throw new Exception("Error in parsing xml.", se);
        }
        catch (Exception e2) {
            throw new Exception("Error in parsing xml.", e2);
        }
    }

    private static HashMap getDomainsList(String mwHome) {
        Path reg;
        ArrayList list;
        block17: {
            list = null;
            reg = null;
            if (mwHome == null || mwHome.trim().length() == 0) {
                mwHome = OPatchFmwEnv.getMwHome();
            }
            FmwHelper.debug("Middleware Home [" + mwHome + "]");
            try {
                if (OPatchEnv.isNextGen()) {
                    try {
                        FmwHelper.loadLsDomainsNextGenOUILibs();
                        return FmwHelper.getDomainsListNextGen(mwHome);
                    }
                    catch (Exception e2) {
                        OLogger.printStackTrace(e2);
                        OLogger.println(e2.getMessage());
                        return null;
                    }
                }
                if (mwHome == null || mwHome.trim().length() == 0) {
                    throw new Exception("Middleware Home not found.");
                }
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(mwHome, new String[0]);
                if (Files.isDirectory(f2, new LinkOption[0])) {
                    FmwHelper.debug("Checking for Registry File in Middleware Home [" + f2.toAbsolutePath().toString() + "]");
                    reg = WrapperFactory.getNioServiceWrapper().getPath(f2.toString(), "registry.xml");
                    if (reg == null || !Files.exists(reg, new LinkOption[0])) {
                        throw new Exception("Couldn't find Registry File 'registry.xml' in Middleware Home \"" + f2.toAbsolutePath().toString() + "\". Invalid Middleware Home.");
                    }
                    break block17;
                }
                throw new Exception("Invalid Middleware Home. Directory \"" + f2.toAbsolutePath().toString() + "\" doesn't exist.");
            }
            catch (Exception e3) {
                OLogger.printStackTrace(e3);
                OLogger.println(e3.getMessage());
                return null;
            }
        }
        try {
            FmwHelper.debug("Parsing Registry File [" + reg.toAbsolutePath() + "]");
            list = FmwHelper.parseRegistryXML(Files.newInputStream(reg, new OpenOption[0]));
            FmwHelper.debug("List of WLS Homes " + list.toString());
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
            OLogger.println(e4.getMessage());
            return null;
        }
        Properties props = new Properties();
        HashMap<String, String> output = new HashMap<String, String>(3);
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String wlsHome = (String)list.get(i2);
                try {
                    String append = new StringBuffer("common").append(File.separator).append("nodemanager").append(File.separator).append("nodemanager.domains").toString();
                    Path nmd = WrapperFactory.getNioServiceWrapper().getPath(wlsHome + File.separator + append, new String[0]);
                    FmwHelper.debug("Finding domains from file [" + nmd.toAbsolutePath() + "]");
                    InputStream fis = Files.newInputStream(nmd, new OpenOption[0]);
                    props.load(fis);
                    Enumeration<?> e5 = props.propertyNames();
                    while (e5.hasMoreElements()) {
                        String domainName = (String)e5.nextElement();
                        String domainDir = props.getProperty(domainName);
                        FmwHelper.debug("Found [" + domainName + "], [" + domainDir + "]");
                        output.put(domainName, domainDir);
                    }
                    props.clear();
                    continue;
                }
                catch (Exception e6) {
                    OLogger.printStackTrace(e6);
                    OLogger.println(e6.getMessage());
                }
            }
        } else {
            OLogger.println("WLS_HOME not found for this MW_HOME.");
        }
        return output;
    }

    public static HashSet getDomainOracleHomeMap(String domain, String domainPath, String oracleHome, String middlewareHome) {
        FmwHelper.debug("DOMAIN      -- [" + domain + "]");
        FmwHelper.debug("DOMAIN PATH -- [" + domainPath + "]");
        FmwHelper.debug("ORACLE_HOME -- [" + oracleHome + "]");
        FmwHelper.debug("MW_HOME     -- [" + middlewareHome + "]");
        HashSet<String> output = new HashSet<String>(3);
        HashSet<String> hs = new HashSet<String>(3);
        boolean invalid_domain_name = true;
        try {
            HashMap<String, String> hm;
            if (domainPath != null && domainPath.trim().length() != 0) {
                domain = "base_domain";
                hm = new HashMap<String, String>(1);
                hm.put(domain, domainPath.trim());
            } else {
                hm = FmwHelper.getDomainsList(null);
            }
            if (hm != null && hm.size() > 0) {
                block4: for (Map.Entry pairs : hm.entrySet()) {
                    String domainName = (String)pairs.getKey();
                    if (domain != null && domainName.equals(domain)) {
                        invalid_domain_name = false;
                    }
                    String domainDir = (String)pairs.getValue();
                    FmwHelper.debug("Found [" + domainName + "], [" + domainDir + "]");
                    if (hs.add(domainDir) && (domain == null || domain.equals(domainName))) {
                        Path dd = WrapperFactory.getNioServiceWrapper().getPath(domainDir, new String[0]);
                        if (!Files.isDirectory(dd, new LinkOption[0])) {
                            FmwHelper.debug("Invalid Domain Directory [" + domainDir + "]");
                            continue;
                        }
                        String append = new StringBuffer("init-info").append(File.separator).append("domain-info.xml").toString();
                        Path di = WrapperFactory.getNioServiceWrapper().getPath(dd.toString(), append);
                        try {
                            FmwHelper.debug("Finding Oracle Homes For Domain [" + domainName + "]");
                            FmwHelper.debug("Parsing domain-info file [" + di.toAbsolutePath() + "]");
                            ArrayList ohList = FmwHelper.parseDomainInfoXML(Files.newInputStream(di, new OpenOption[0]));
                            if (ohList == null) continue;
                            for (int k2 = 0; k2 < ohList.size(); ++k2) {
                                String oh = (String)ohList.get(k2);
                                FmwHelper.debug("Found Oracle Home [" + oh + "]");
                                if (domain != null) {
                                    if (!output.add(oh)) continue;
                                    FmwHelper.debug("[lshomes -domain] adding to output [" + oh + "]");
                                    continue;
                                }
                                if (!output.add(domainName + ";" + domainDir)) continue;
                                FmwHelper.debug("[lsdomains -oh] adding to output [" + domainName + "]");
                                continue block4;
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            OLogger.printStackTrace(ex);
                            OLogger.println(ex.getMessage());
                            continue;
                        }
                    }
                    FmwHelper.debug("Duplicate domain directory found or [lshomes -domain] command input doesn't match with this domain. Skipping.");
                }
                if (domainPath == null && domain != null && invalid_domain_name) {
                    OLogger.println("Invalid domain name specified. To get the list of valid domain names use 'opatch lsdomains' command and select the correct domain name.");
                }
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            OLogger.println(e2.getMessage());
        }
        return output;
    }

    private static void debug(String msg) {
        StringBuffer sb = new StringBuffer(msg);
        OLogger.debug(sb);
    }

    private static void loadLsDomainsNextGenOUILibs() {
        try {
            Properties prop = System.getProperties();
            boolean isWindows = OPatchEnv.isWindows();
            if (prop != null) {
                String classpath = prop.getProperty("java.class.path");
                String commonHome = prop.getProperty("OPatch.COMMON_COMPONENTS_HOME");
                if (commonHome != null && !commonHome.equals("")) {
                    StringBuilder buff = new StringBuilder("");
                    Path modules = WrapperFactory.getNioServiceWrapper().getPath(commonHome + File.separator + "modules", new String[0]);
                    DirectoryStream<Path> tempJlibs = Files.newDirectoryStream(modules);
                    ArrayList<Path> jlibs = new ArrayList<Path>();
                    for (Path file : tempJlibs) {
                        if (!file.getFileName().toString().endsWith(".jar")) continue;
                        jlibs.add(file);
                    }
                    for (Path jlib : jlibs) {
                        buff.append(isWindows ? ";" : ":");
                        buff.append(jlib.toAbsolutePath().normalize().toString());
                        OPatchSessionHelper.loadExternalLibFile(jlib.toAbsolutePath().normalize().toString());
                    }
                    classpath = classpath + buff.toString();
                    prop.setProperty("java.class.path", classpath);
                }
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
    }

    private static HashMap getDomainsListNextGen(String mwhome) {
        String class1 = "com.oracle.cie.external.domain.info.MWDomainInfoFactory";
        String class2 = "com.oracle.cie.external.domain.info.MWDomainInfo";
        String class3 = "com.oracle.cie.external.domain.info.DomainInformation";
        HashMap<Object, Object> domainsMap = null;
        try {
            OLogger.disableConsoleOutput();
            Class<?> clazz1 = Class.forName(class1);
            Method m2 = clazz1.getMethod("getMiddlewareDomainInfo", String.class);
            Object obj = m2.invoke(null, mwhome);
            Class<?> clazz2 = Class.forName(class2);
            Class<?>[] params = null;
            Object[] objs = null;
            m2 = clazz2.getMethod("getDomainList", params);
            obj = m2.invoke(obj, objs);
            List lists = (List)obj;
            Class<?> clazz3 = Class.forName(class3);
            Method m1 = clazz3.getMethod("getDomainName", params);
            Method m22 = clazz3.getMethod("getDomainPath", params);
            domainsMap = new HashMap<Object, Object>();
            for (Object o2 : lists) {
                domainsMap.put(m1.invoke(o2, objs), m22.invoke(o2, objs));
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            throw new RuntimeException(e2);
        }
        finally {
            OLogger.enableConsoleOutput();
        }
        return domainsMap;
    }

    private static void parseDomainRegistryXML(InputStream is, final HashMap ret) throws Exception {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ArrayList list = new ArrayList();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("domain".equals(qName)) {
                        String location = attributes.getValue("location");
                        String name = WrapperFactory.getNioServiceWrapper().getPath(location, new String[0]).getFileName().toString();
                        ret.put(name, location);
                    }
                }
            };
            saxParser.parse(is, handler);
            is.close();
        }
        catch (SAXException se) {
            throw new Exception("Error in parsing xml.", se);
        }
        catch (Exception e2) {
            throw new Exception("Error in parsing xml.", e2);
        }
    }
}

