/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.List;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.opatchfafmw.OPatchFAStepErrorCode;
import oracle.opatch.opatchsdk.OPatchFAStep;

public class OPatchStepAdapter {
    private OPatchFAStep step;
    private String stepDescription = "";
    private String errorMsg = "";
    private boolean isSuccess = true;
    private RuntimeException exceptionObj = null;

    protected OPatchStepAdapter(OPatchFAStep faStep) {
        this.step = faStep;
    }

    private OPatchStepAdapter() {
    }

    public OPatchFAStep getStep() {
        return this.step;
    }

    public void setStepDescription(String desc) {
        this.stepDescription = desc;
    }

    public String getStepDescription() {
        return this.stepDescription;
    }

    public void setErrorMessage(String msg) {
        this.errorMsg = msg;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public void setSuccess(boolean suc) {
        this.isSuccess = suc;
        if (!suc) {
            int errorCode = OPatchFAStepErrorCode.getCmdlineErrorCode(this.step);
            OPatchStateManagerFactory.getInstance().setErrorCode(errorCode);
        }
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setExceptionObject(RuntimeException obj) {
        this.exceptionObj = obj;
    }

    public RuntimeException getExceptionObject() {
        return this.exceptionObj;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[ Step: ");
        buff.append(this.step.name());
        buff.append(", Description: ");
        buff.append(this.getStepDescription());
        buff.append(", Operation Status: ");
        buff.append(this.isSuccess());
        if (!this.isSuccess()) {
            buff.append(", Error Message: ");
            buff.append(this.getErrorMessage());
            if (this.getExceptionObject() != null) {
                buff.append(", Exception Info: ");
                buff.append(this.getExceptionObject().getStackTrace());
            }
        }
        buff.append("]");
        return buff.toString();
    }

    public static String getStepString(List<OPatchStepAdapter> steps) {
        StringBuffer buff = new StringBuffer("Report Steps:");
        if (steps == null || steps.size() == 0) {
            buff.append("\n [No execution steps available]");
            return buff.toString();
        }
        buff.append("\n");
        for (int i2 = 0; i2 < steps.size(); ++i2) {
            OPatchStepAdapter step = steps.get(i2);
            buff.append("   [Execution Step " + i2 + ":\n" + "   " + step.toString());
            if (i2 == steps.size()) continue;
            buff.append("   ]\n");
        }
        return buff.toString();
    }

    public String getOPatchStepErrorCode() {
        return OPatchFAStepErrorCode.getErrorCode(this.step);
    }
}

