/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import oracle.fabric.deploy.jaxb2.UpdateType;
import oracle.fabric.management.deployedcomposites.CompositeManager;
import oracle.fabric.management.deployedcomposites.mbean.Status;
import oracle.integration.platform.blocks.deploy.merge.MergeManager;
import oracle.integration.platform.blocks.deploy.merge.MergeManagerUtil;
import oracle.integration.platform.blocks.deploy.patch.CompositePatchManager;
import oracle.integration.platform.blocks.deploy.patch.PatchStatus;
import oracle.integration.platform.blocks.deploy.servlet.CompositeDeployerClient;
import oracle.integration.platform.blocks.deploy.servlet.CompositeStoreClient;
import oracle.opatch.opatchfafmw.JMXConnection;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchSOAStep;
import oracle.opatch.opatchfafmw.SOATimeoutException;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.soa.deployplan.DeployManager;
import oracle.soa.management.facade.Composite;
import oracle.soa.management.facade.Locator;
import oracle.soa.management.facade.LocatorFactory;
import oracle.soa.management.facade.Mode;
import oracle.soa.management.facade.State;
import oracle.soa.management.util.CompositeFilter;

public final class SOACompositeManager {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private URL url;
    private static final String DEFAULT = "default";

    public String getSOAHost() {
        return this.host;
    }

    public int getSOAPort() {
        return this.port;
    }

    SOACompositeManager(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        String s = "http://" + host + ":" + port;
        try {
            this.url = new URL(s);
            OPatchSOAStep.init(host, port, username, s);
        }
        catch (Exception e2) {
            Logger.error(RB.Entry.MALFORMED_URL, s);
        }
    }

    boolean isSOAPlatformReady() throws Exception {
        CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
        ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
        if (on == null) {
            Logger.logi("Unable to get valid Composite LifecycleMbean. It may be caused by soa-infra being down.");
            return false;
        }
        Status statusObj = CompositeManager.getSOAPlatformStatus((ObjectName)on);
        if (statusObj != null) {
            return statusObj.isReady();
        }
        Logger.logi("Unable to retrieve Status from SOA CompositeManager");
        return false;
    }

    boolean isDeployed(String compositeDN) throws Exception {
        String t3url = "t3://" + this.host + ":" + this.port + "/soa-infra";
        CompositeFilter filter = new CompositeFilter();
        filter.setCompositeDN(compositeDN);
        Hashtable<String, String> props = new Hashtable<String, String>(3);
        props.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        props.put("java.naming.provider.url", t3url);
        Locator locator = LocatorFactory.createLocator(props);
        List list = locator.getComposites(filter);
        return list.size() > 0;
    }

    boolean isBaseCompositeDeployed(String compName) throws Exception {
        String t3url = "t3://" + this.host + ":" + this.port + "/soa-infra";
        CompositeFilter filter = new CompositeFilter();
        filter.setCompositeName(compName);
        Hashtable<String, String> props = new Hashtable<String, String>(3);
        props.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        props.put("java.naming.provider.url", t3url);
        Locator locator = LocatorFactory.createLocator(props);
        List list = locator.getComposites(filter);
        return list.size() > 0;
    }

    boolean isRetired(String compositeDN) throws Exception {
        String t3url = "t3://" + this.host + ":" + this.port + "/soa-infra";
        CompositeFilter filter = new CompositeFilter();
        filter.setCompositeDN(compositeDN);
        Hashtable<String, String> props = new Hashtable<String, String>(3);
        props.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        props.put("java.naming.provider.url", t3url);
        Locator locator = LocatorFactory.createLocator(props);
        List list = locator.getComposites(filter);
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Composite comp = (Composite)it.next();
            String mode = comp.getMode();
            if (!Mode.retired.toString().equals(mode)) continue;
            return true;
        }
        return false;
    }

    boolean isActive(String compositeDN) throws Exception {
        String t3url = "t3://" + this.host + ":" + this.port + "/soa-infra";
        CompositeFilter filter = new CompositeFilter();
        filter.setCompositeDN(compositeDN);
        Hashtable<String, String> props = new Hashtable<String, String>(3);
        props.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        props.put("java.naming.provider.url", t3url);
        Locator locator = LocatorFactory.createLocator(props);
        List list = locator.getComposites(filter);
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Composite comp = (Composite)it.next();
            String mode = comp.getMode();
            if (Mode.active.toString().equals(mode)) {
                return true;
            }
            if (!Mode.retired.toString().equals(mode)) continue;
            return false;
        }
        return false;
    }

    boolean isStarted(String compositeDN) throws Exception {
        String t3url = "t3://" + this.host + ":" + this.port + "/soa-infra";
        CompositeFilter filter = new CompositeFilter();
        filter.setCompositeDN(compositeDN);
        Hashtable<String, String> props = new Hashtable<String, String>(3);
        props.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        props.put("java.naming.provider.url", t3url);
        Locator locator = LocatorFactory.createLocator(props);
        List list = locator.getComposites(filter);
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Composite comp = (Composite)it.next();
            String state = comp.getState();
            if (State.on.toString().equals(state)) {
                return true;
            }
            if (!State.off.toString().equals(state)) continue;
            return false;
        }
        return false;
    }

    private boolean execute(String command, UpdateType updateType, String compositeDN, String file) throws Exception {
        CompositeStoreClient client = new CompositeStoreClient(this.url);
        client.setBasicAuth(this.username, this.password);
        client.setCommand(command);
        if (updateType != null) {
            client.setUpdateType(updateType);
        } else {
            updateType = UpdateType.ALL;
        }
        client.setCompositeDN(compositeDN);
        client.setJarFile(file);
        if (Logger.debug) {
            StringBuilder sb = new StringBuilder("Executing Command\n");
            sb.append("Command    [").append(command).append("]\n");
            sb.append("UpdateType [").append(updateType.name()).append("]\n");
            sb.append("CompositeDN[").append(compositeDN).append("]\n");
            sb.append("File       [").append(file).append("]\n");
            sb.append("URL        [").append(this.url.toString()).append("]\n");
            Logger.debug(sb.toString());
        }
        int code = client.sendRequest();
        if (Logger.debug) {
            Logger.debug("Response Code [" + code + "]");
        }
        if (code != 200) {
            if (client.getErrorMsg() != null) {
                Logger.logw(client.getErrorMsg());
            }
            return false;
        }
        return true;
    }

    void exportComposite(UpdateType updateType, String compositeDN, String file) throws Exception {
        if (!this.execute("export_composite", updateType, compositeDN, file)) {
            Logger.logw("[SOA COMPOSITE] [exportComposite] [COULD NOT EXPORT COMPOSITE] UpdateType [" + updateType + "] SOA Composite [" + compositeDN + "]");
            RuntimeException re = new RuntimeException("Could not Export Composite");
            throw re;
        }
        Logger.logi("[SOA COMPOSITE] [exportComposite] [SUCCESS] UpdateType [" + updateType + "] SOA Composite [" + compositeDN + "]");
    }

    void exportUpdates(UpdateType updateType, String compositeDN, String file) throws Exception {
        if (this.execute("export_updates", updateType, compositeDN, file)) {
            Logger.logi("[SOA COMPOSITE] [exportUpdates] [SUCCESS] UpdateType [" + updateType + "] SOA Composite [" + compositeDN + "]");
        } else {
            Logger.logw("[SOA COMPOSITE] [exportUpdates] [COULD NOT EXPORT UPDATES] UpdateType [" + updateType + "] SOA Composite [" + compositeDN + "]");
        }
    }

    void importUpdates(UpdateType updateType, String compositeDN, String file) throws Exception {
        if (!this.execute("import_updates", updateType, compositeDN, file)) {
            Logger.logw("[SOA COMPOSITE] [importUpdates] [COULD NOT IMPORT UPDATES] SOA Composite [" + compositeDN + "]");
            RuntimeException re = new RuntimeException("Could not Import Updates");
            throw re;
        }
        Logger.logi("[SOA COMPOSITE] [importUpdates] [SUCCESS] SOA Composite [" + compositeDN + "]");
    }

    void extractPlan(String sar, String configPlan) throws Exception {
        DeployManager dm = new DeployManager();
        dm.setVerbose(true);
        if (Logger.debug) {
            StringBuilder sb = new StringBuilder("Executing Command\n");
            sb.append("Command    [").append("Extract Plan").append("]\n");
            sb.append("SAR        [").append(sar).append("]\n");
            sb.append("ConfigPlan [").append(configPlan).append("]\n");
            Logger.debug(sb.toString());
        }
        dm.extractPlan(sar, configPlan);
    }

    void attachPlan(String sar, String configPlan, boolean overwrite) throws Exception {
        DeployManager dm = new DeployManager();
        dm.setVerbose(true);
        if (Logger.debug) {
            StringBuilder sb = new StringBuilder("Executing Command\n");
            sb.append("Command    [").append("Attach Plan").append("]\n");
            sb.append("SAR        [").append(sar).append("]\n");
            sb.append("ConfigPlan [").append(configPlan).append("]\n");
            Logger.debug(sb.toString());
        }
        dm.attachPlan(sar, configPlan, overwrite);
    }

    String getDefaultRevision(String name) throws Exception {
        String compositeDN = "default/" + name;
        CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
        ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
        if (on == null) {
            throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
        }
        return CompositeManager.getDefaultCompositeRevision((ObjectName)on, (String)compositeDN);
    }

    String listDeployedComposites() throws Exception {
        try {
            CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
            ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
            if (on == null) {
                throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
            }
            return CompositeManager.listDeployedComposites((ObjectName)on);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            throw e2;
        }
    }

    String listDeployedComposites(String name) throws ParseException, Exception {
        String str = this.listDeployedComposites();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, "\n");
        String calculatedName = " " + name + "[";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(calculatedName);
            if (index == -1) continue;
            sb.append(token);
            sb.append("\n");
        }
        return sb.toString();
    }

    void stopComposite(String name, String revision) throws Throwable {
        String compositeDN = "default/" + name + '!' + revision;
        CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
        ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
        if (on == null) {
            throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
        }
        CompositeManager.stopComposite((ObjectName)on, (String)compositeDN);
    }

    void startComposite(String name, String revision) throws Throwable {
        String compositeDN = "default/" + name + '!' + revision;
        CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
        ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
        if (on == null) {
            throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
        }
        CompositeManager.startComposite((ObjectName)on, (String)compositeDN);
    }

    void retireComposite(String compositeDN) throws Exception {
        CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
        ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
        if (on == null) {
            throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
        }
        CompositeManager.retireComposite((ObjectName)on, (String)compositeDN);
    }

    void activateComposite(String compositeDN) {
        try {
            CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
            ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
            if (on == null) {
                throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
            }
            CompositeManager.activateComposite((ObjectName)on, (String)compositeDN);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            return;
        }
    }

    void assignDefaultComposite(String compositeDN) throws Exception {
        CompositeManager.initConnection((String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
        ObjectName on = CompositeManager.getCompositeLifeCycleMBean();
        if (on == null) {
            throw new Exception("OPatch cannot find Composite lifecycle mbean. Please check if the soa-infra is ready to accept and service requests. The host is \"" + this.host + "\" and port is \"" + this.port + "\".");
        }
        CompositeManager.assignDefaultComposite((ObjectName)on, (String)compositeDN);
    }

    boolean isJdevCustomizationRequired(String composite, String path) {
        File compositeJar = new File(composite);
        File pathJar = new File(path);
        return MergeManagerUtil.isJdevCustomizationRequired((File)compositeJar, (File)pathJar);
    }

    void mergeUpdates(String result, String composite, String path, String customization, String log) {
        File resultJar = new File(result);
        File compositeJar = new File(composite);
        File pathJar = new File(path);
        File customizationJar = new File(customization);
        File logFile = new File(log);
        MergeManager mm = new MergeManager(compositeJar, pathJar, customizationJar, resultJar);
        mm.setLogging(logFile, 1, true);
        mm.merge();
        mm.clean();
    }

    void enableEDNEvents() throws Exception {
        this.setEDNAttribute(0);
    }

    void disableEDNEvents() throws Exception {
        this.setEDNAttribute(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEDNAttribute(int paused) throws Exception {
        JMXConnector connector = null;
        try {
            connector = JMXConnection.getConnector("t3", this.host, this.port, this.username, this.password, "weblogic.management.mbeanservers.runtime");
            MBeanServerConnection mbs = JMXConnection.getConnection(connector);
            ObjectName EDNMBeanName = new ObjectName("*:type=EDNConfig,*");
            Set<ObjectInstance> beans = mbs.queryMBeans(EDNMBeanName, null);
            if (beans.size() == 0) {
                Logger.loge("Cannot find EDNConfig mbean on this server");
            } else if (beans.size() > 1) {
                Logger.loge("Found multiple EDNConfig mbeans");
            } else {
                EDNMBeanName = beans.iterator().next().getObjectName();
            }
            mbs.setAttribute(EDNMBeanName, new Attribute("Paused", paused));
        }
        catch (Throwable throwable) {
            JMXConnection.closeConnector(connector);
            throw throwable;
        }
        JMXConnection.closeConnector(connector);
    }

    PatchStatus prereqSingleDeploy(String patchSarFile, boolean noneConfigPlan) {
        CompositePatchManager patchManager = new CompositePatchManager(this.url.toString(), patchSarFile, DEFAULT);
        patchManager.setBasicAuth(this.username, this.password);
        if (noneConfigPlan) {
            patchManager.setConfigPlan("none");
        }
        Logger.logi("prereqSingleDeploy: validatePatch " + this.url.toString() + " " + patchSarFile);
        PatchStatus status = patchManager.validatePatch();
        Logger.logi("prereqSingleDeploy status summary " + status.getStepInfoSummary());
        if (status.getState() == PatchStatus.PATCH_STATE.validateSuccess) {
            Logger.logi("prereqSingleDeploy status  successful");
        } else if (status.getState() == PatchStatus.PATCH_STATE.validateFaiedWithFindingBase) {
            Logger.logi("Patch validation failed: cannot find base composite. Please verify the base composite exists in the target SOA platform");
        } else if (status.getState() == PatchStatus.PATCH_STATE.validateFaiedWithJDevCustomization) {
            Logger.logi("Patch validation failed: composite patch requires JDEV customization. Please customize the patch using JDEV.");
        } else {
            Logger.logi("Patch validation failed" + status.toString());
        }
        return status;
    }

    PatchStatus singleDeploy(String patchSarFile, boolean noneConfigPlan, String logFile) {
        CompositePatchManager patchManager = new CompositePatchManager(this.url.toString(), patchSarFile, DEFAULT);
        patchManager.setBasicAuth(this.username, this.password);
        if (noneConfigPlan) {
            patchManager.setConfigPlan("none");
        }
        Logger.logi("singleDeploy: patchComposite " + this.url.toString() + " " + patchSarFile);
        Logger.logi("singleDeploy: logfile " + logFile);
        patchManager.setMergeLog(logFile);
        PatchStatus status = patchManager.patchComposite();
        Logger.logi("singleDeploy status summary " + status.getStepInfoSummary());
        if (status.getState() == PatchStatus.PATCH_STATE.patchSuccess) {
            Logger.logi("singleDeploy status  successful");
        } else if (status.getState() == PatchStatus.PATCH_STATE.prepareFailure) {
            Logger.logi("singleDeploy status prepare failture");
        } else if (status.getState() == PatchStatus.PATCH_STATE.patchFailedRecoverSuccess) {
            Logger.logi("singleDeploy status  patch failed to recover");
        } else if (status.getState() == PatchStatus.PATCH_STATE.recoverFailed) {
            PatchStatus.RecoverStatus recoverStatus = status.getRecoverStatus();
            if (recoverStatus == null) {
                Logger.logi("singleDeploy recover status failed");
            } else {
                if (recoverStatus.isUndeployFailed()) {
                    Logger.logi("singleDeploy recover status undeployed failed");
                }
                if (recoverStatus.isBaseDefaultFailed()) {
                    Logger.logi("singleDeploy recover status base default failed");
                }
            }
        }
        return status;
    }

    boolean deployComposite(String file, String plan) throws Exception {
        CompositeDeployerClient client = new CompositeDeployerClient(this.url);
        client.setBasicAuth(this.username, this.password);
        client.setOverwrite(false);
        client.setForceDefault(false);
        client.setCommand("deploy");
        client.setPartition(DEFAULT);
        if (plan != null) {
            client.setDeployPlan(plan);
        }
        if (file.endsWith(".ear")) {
            client.setEar(file);
        } else {
            client.setSar(file);
        }
        if (Logger.debug) {
            StringBuilder sb = new StringBuilder("Deploying SOA Composite\n");
            sb.append("Composite[").append(file).append("]\n");
            sb.append("Plan     [").append(plan).append("]\n");
            Logger.debug(sb.toString());
        }
        int code = -1;
        code = client.sendRequest();
        if (Logger.debug) {
            Logger.debug("Response Code [" + code + "]");
        }
        if (code == -1) {
            throw new SOATimeoutException(code, client.getErrorMsg());
        }
        if (code != 200) {
            Logger.loge("Error in deploying composite. Code [" + code + "]\n" + client.getErrorMsg());
            throw new Exception(client.getErrorMsg());
        }
        return true;
    }

    boolean undeployComposite(String compositeDN) throws Exception {
        CompositeDeployerClient client = new CompositeDeployerClient(this.url);
        client.setBasicAuth(this.username, this.password);
        client.setCommand("undeploy");
        client.setCompositeDN(compositeDN);
        if (Logger.debug) {
            StringBuilder sb = new StringBuilder("Undeploying SOA Composite");
            sb.append("CompositeDN[").append(compositeDN).append("]\n");
            Logger.debug(sb.toString());
        }
        int code = -1;
        code = client.sendRequest();
        if (Logger.debug) {
            Logger.debug("Response Code [" + code + "]");
        }
        if (code != 200) {
            Logger.loge("Error in undeploying composite. Code [" + code + "]\n" + client.getErrorMsg());
            throw new Exception(client.getErrorMsg());
        }
        return true;
    }
}

