/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.opatch.opatchlogger.ConsoleFormatter;

public class MyRootConsoleHandler
extends ConsoleHandler {
    private static ThreadLocal stream = new ThreadLocal(){

        protected MyRootConsoleHandler initialValue() {
            return new MyRootConsoleHandler();
        }
    };
    PrintStream myConsoleOutStream = null;
    PrintStream myConsoleErrStream = null;

    public MyRootConsoleHandler() {
        if (this.myConsoleOutStream == null) {
            this.myConsoleOutStream = System.out;
        }
        if (this.myConsoleErrStream == null) {
            this.myConsoleErrStream = System.err;
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.getFormatter() == null) {
            this.setFormatter(new ConsoleFormatter());
        }
        MyRootConsoleHandler consoleHandler = (MyRootConsoleHandler)stream.get();
        try {
            if (!this.isLoggable(record)) {
                return;
            }
            String message = this.getFormatter().format(record);
            if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                consoleHandler.myConsoleErrStream.write(message.getBytes());
            } else {
                consoleHandler.myConsoleOutStream.write(message.getBytes());
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }
}

