/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.opatch.CopyAction;
import oracle.opatch.FVData;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.UpdateComponent;
import oracle.opatch.WLSPatch;
import oracle.opatch.ZOPErrorMessage;
import oracle.opatch.ioc.IOC;
import oracle.opatch.ioc.IOCHelper;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.NoOpPatchException;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResource;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.wrappers.WrapperFactory;

public class IOCPrereqAPI {
    private static IOCPrereqAPI instance;

    private IOCPrereqAPI() {
    }

    public static IOCPrereqAPI getInstance() {
        if (instance == null) {
            instance = new IOCPrereqAPI();
        }
        return instance;
    }

    public PrereqResult checkFusionAppsCompatibleIOC(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkFusionAppsCompatibleIOC()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        int patchingModel = IOC.INSTANCE.getPatchingModel();
        if (patchingModel == 2) {
            if (!(IPMUtil.canGetLangsForInvEntry() && IPMUtil.canGetDescForInvEntry() && IPMUtil.canGetUniqueIDForInvEntry() && IPMUtil.canSetSubsetPatchesForInvEntry())) {
                String msg = OLogger.getString("OUI-67645");
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(msg);
                if (OPatchEnv.isContinueOnPrereqFailure()) {
                    for (String patchId : PrereqAPI.getPatchesToApplyList()) {
                        OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_FUSION_APPS_COMPATIBLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
            } else {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public PrereqResult checkPatchApplicableOnCurrentPlatformIOC(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchApplicableOnCurrentPlatformIOC()");
        OLogger.debug(buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int pIter = 0; pIter < patchObjects.length; ++pIter) {
            int i2;
            buff = new StringBuffer("Reading the platforms for patch");
            buff.append(patchObjects[pIter].getPatchID());
            OLogger.debug(buff);
            Platform[] platforms = patchObjects[pIter].getPlatforms();
            boolean success = false;
            int aru_id = 0;
            if (platforms.length == 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                buff = new StringBuffer("List of platforms the patch (");
                buff.append(patchObjects[pIter].getPatchID());
                buff.append(" ) applicable is Empty");
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
                return resObj;
            }
            for (int i3 = 0; i3 < platforms.length; ++i3) {
                if (!platforms[i3].getID().equals(PrereqResource.GENERIC_PLATFORM_ID[0]) && !platforms[i3].getID().equals(PrereqResource.GENERIC_PLATFORM_ID[1])) continue;
                success = true;
                buff = new StringBuffer("\nGenereic Platform ID " + platforms[i3].getID());
                buff.append("is specified for patch : ");
                buff.append(patchObjects[pIter].getPatchID());
                OLogger.verbose(OPatchSession.PREREQ, buff);
                buff = new StringBuffer("Prereq checkPatchApplicableOnCurrentPlatform Passed on patch :");
                buff.append(patchObjects[pIter].getPatchID());
                OLogger.printlnOnLog(buff.toString());
                break;
            }
            if (success) continue;
            try {
                aru_id = IOC.INSTANCE.getPlatformId();
            }
            catch (Throwable t) {
                aru_id = 0;
            }
            if (aru_id <= 0) {
                if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    failedPatches.add(patchObjects[pIter].getPatchID());
                }
                buff = new StringBuffer("ARU_ID got for patch ( ");
                buff.append(patchObjects[pIter].getPatchID());
                buff.append(" ) is negative");
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
                continue;
            }
            boolean noFurtherCheck = true;
            StringBuffer sbAru = new StringBuffer();
            String sAru = "";
            while (noFurtherCheck) {
                sbAru = new StringBuffer();
                sbAru.append(aru_id);
                sAru = sbAru.toString();
                for (i2 = 0; i2 < platforms.length; ++i2) {
                    if (!platforms[i2].getID().equals(sAru)) continue;
                    success = true;
                    buff = new StringBuffer("\nPatch ");
                    buff.append(patchObjects[pIter]);
                    buff.append(" : Platform ID matched is ");
                    buff.append(sAru);
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    buff = new StringBuffer("Prereq checkPatchApplicableOnCurrentPlatform Passed for patch : ");
                    buff.append(patchObjects[pIter].getPatchID());
                    OLogger.printlnOnLog(buff.toString());
                }
                noFurtherCheck = false;
            }
            if (success || aru_id <= 0 || resObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) continue;
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            failedPatches.add(patchObjects[pIter].getPatchID());
            buff = new StringBuffer("Patch ( ");
            buff.append(patchObjects[pIter].getPatchID());
            buff.append(" ) is not applicable on current platform.\n");
            buff.append("Platform ID needed is : ");
            buff.append(sAru);
            buff.append("\nPlatform IDs supported by patch are: ");
            for (i2 = 0; i2 < platforms.length; ++i2) {
                buff.append(platforms[i2].getID() + " ");
            }
            OLogger.debug(buff);
            resObj.addDetail(buff.toString());
        }
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public PrereqResult checkPatchingModelIOC(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchingModelIOC()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjects == null) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("Input list of PatchObjects are 'null'.");
            resObj.addDetail(buff.toString());
            return resObj;
        }
        int homePatchModel = IOC.INSTANCE.getPatchingModel();
        StringBuffer failedPatches = new StringBuffer("");
        ArrayList<String> failedPatchesList = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            String modelType = patchObjects[i2].getPatchInventory().getPatchModel();
            int modelCode = PatchingModel.getModelCodeRep(modelType);
            if (modelCode == homePatchModel && (homePatchModel != 2 || !"singleton".equals(patchObjects[i2].getPatchType()))) continue;
            failedPatches.append(" ");
            failedPatches.append(patchObjects[i2].getPatchID());
            failedPatchesList.add(patchObjects[i2].getPatchID());
        }
        if (!failedPatches.toString().equals("")) {
            String msg = OLogger.getString("OUI-67640", new Object[]{oracleHomePath, PatchingModel.getModelType(homePatchModel), failedPatches.toString()});
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(msg);
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : failedPatchesList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCHING_MODEL, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (PatchObject po : patchObjects) {
                OUSession.addPrereqResultForPatchesToReport(po.getPatchID(), OPatchPatchPrereq.CHECK_PATCHING_MODEL, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public PrereqResult checkPatchsetUpdateComponentsIOC(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchsetUpdateComponentsIOC()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjects == null) {
            buff = new StringBuffer("PatchObject Array is null");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        PrereqResult isCompat = new PrereqResult();
        isCompat = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, patchObjects);
        if (isCompat.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || isCompat.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (PatchObject pObject : patchObjects) {
                    OUSession.addPrereqResultForPatchesToReport(pObject.getPatchID(), OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS, isCompat, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return isCompat;
        }
        InstalledComponent[] installedComponents = IOC.INSTANCE.getAllInstalledComponents();
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            if (!patchObjects[i2].getPatchInventory().isMiniPatchSet()) continue;
            ArrayList updateComp = patchObjects[i2].getPatchInventory().getUpdateCompsList();
            UpdateComponent[] uc = new UpdateComponent[updateComp.size()];
            for (int j2 = 0; j2 < updateComp.size(); ++j2) {
                UpdateComponent upObj;
                uc[j2] = upObj = (UpdateComponent)updateComp.get(j2);
            }
            boolean isAnyUpdateComp = false;
            boolean checkZeroComp = false;
            for (int j3 = 0; j3 < updateComp.size(); ++j3) {
                UpdateComponent upObj = (UpdateComponent)updateComp.get(j3);
                if (!upObj.isIncluded()) continue;
                isAnyUpdateComp = true;
            }
            if (isAnyUpdateComp || !checkZeroComp) continue;
            buff = new StringBuffer("Patch Set Update \"" + patchObjects[i2].getPatchID() + "\": There are zero components to be " + "upgraded in the Oracle Home.\nPatchset Update requires component version upgrade.\n");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            failedPatches.add(patchObjects[i2].getPatchID());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the components to be upgraded can be done successfully.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkPatchsetUpdateComponents Passed"));
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public PrereqResult checkInstalledOneOffs(String oracleHomePath, String[] patchIDs, Vector installedPatchIDs, Vector notInstalledPatchIDs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkInstalledOneOffs()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchIDs == null || patchIDs.length == 0) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Argument patchIDs is empty");
            OLogger.printlnOnLog(buff.toString());
            resObj.addDetail(buff.toString());
            return resObj;
        }
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            int noTokens;
            boolean maybeLang = false;
            StringTokenizer tk2 = new StringTokenizer(patchIDs[i2], "_");
            if (tk2 != null && (noTokens = tk2.countTokens()) >= 2) {
                maybeLang = true;
            }
            if (maybeLang) {
                String[] inputs = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchIDs[i2], true);
                patchIDs[i2] = inputs[1];
            }
            maybeLang = false;
        }
        Set<String> activePatchesInOH = IOC.INSTANCE.getActivePatchIds();
        for (int pIter = 0; pIter < patchIDs.length; ++pIter) {
            boolean thisPatchIsPresent = false;
            if (activePatchesInOH.contains(patchIDs[pIter])) {
                thisPatchIsPresent = true;
                installedPatchIDs.add(patchIDs[pIter]);
                break;
            }
            if (thisPatchIsPresent) continue;
            buff = new StringBuffer("Skipping patch " + patchIDs[pIter]);
            buff.append(" as it is not present in the Oracle Home.\n");
            OLogger.printlnOnLog(buff.toString());
            notInstalledPatchIDs.add(patchIDs[pIter]);
        }
        if (notInstalledPatchIDs.size() > 0) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("\nPatches not installed are:\n");
            buff.append(notInstalledPatchIDs.toString());
            OLogger.printlnOnLog(buff.toString());
            if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                ZOPErrorMessage.printErrorMessage(30);
            }
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (int i3 = 0; i3 < installedPatchIDs.size(); ++i3) {
                    String patchId = (String)installedPatchIDs.elementAt(i3);
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_INSTALLED_ONE_OFFS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
        } else {
            buff = new StringBuffer("\nAll the specified patches are present in the Oracle Home.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public PrereqResult checkPatchApplyDependents(String oracleHomePath, OneOffEntry[] oneOffs) {
        Set<String> installedOneOffIds;
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchApplyDependents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        String[] prereqOneOffs = null;
        String[] requiredBugList = new String[]{};
        WLSPatch[] wlsPrereqOneOffs = null;
        String[] bugList = new String[]{};
        ArrayList simulateRBPatchIDs = OPatchEnv.getToBeRolledBackPatchIDs();
        try {
            installedOneOffIds = IOC.INSTANCE.getActivePatchIds();
            if (simulateRBPatchIDs != null && simulateRBPatchIDs.size() != 0) {
                Iterator it = simulateRBPatchIDs.iterator();
                while (it.hasNext()) {
                    String id = it.next().toString();
                    if (!installedOneOffIds.contains(id)) continue;
                    installedOneOffIds.remove(id);
                }
            }
        }
        catch (Throwable t) {
            buff = new StringBuffer("Throwable occured: " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(re);
            return resObj;
        }
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int oIter = 0; oIter < oneOffs.length; ++oIter) {
            boolean found;
            int i2;
            prereqOneOffs = oneOffs[oIter].getPrereqPatchIDs();
            wlsPrereqOneOffs = oneOffs[oIter].getWlsPrereqPatchIDs();
            requiredBugList = oneOffs[oIter].getPrereqBugIDs();
            StringBuffer missingOneOffs = new StringBuffer();
            StringBuffer missingWlsOneOffs = new StringBuffer();
            StringBuffer missingBugs = new StringBuffer();
            boolean prereqNotPresent = false;
            boolean wlsPrereqNotPresent = false;
            boolean bugsNotPresent = false;
            boolean addedOne = false;
            for (i2 = 0; i2 < wlsPrereqOneOffs.length; ++i2) {
                WLSPatch requiredWlsOneOff = wlsPrereqOneOffs[i2];
                found = false;
                Object[] wlsList = OPatchEnv.getWlsPrereqOneOffsList();
                for (int wIndex = 0; wIndex < wlsList.length; ++wIndex) {
                    WLSPatch installedWlsOneOff = (WLSPatch)wlsList[wIndex];
                    if (!requiredWlsOneOff.equals(installedWlsOneOff)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (!requiredWlsOneOff.isRequired()) {
                    OLogger.println("Patch " + oneOffs[oIter].getID() + ": " + "Optional prerequisite WLS patch(es) \"" + requiredWlsOneOff.getPatchID() + "\" is " + "not present in the WLS Home.");
                } else {
                    wlsPrereqNotPresent = true;
                    if (addedOne) {
                        missingWlsOneOffs.append(",");
                    }
                    missingWlsOneOffs.append(requiredWlsOneOff.getPatchID());
                    addedOne = true;
                }
                requiredWlsOneOff.setMissing(true);
            }
            if (wlsPrereqNotPresent) {
                buff = new StringBuffer("\nThe Patch " + oneOffs[oIter].getID() + " requires that WLS patch(es)");
                buff.append(" \"" + missingWlsOneOffs + "\" ");
                buff.append("be installed.");
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(oneOffs[oIter].getPatchID());
            }
            for (i2 = 0; i2 < prereqOneOffs.length; ++i2) {
                boolean found2 = false;
                if (installedOneOffIds.contains(prereqOneOffs[i2])) {
                    found2 = true;
                    break;
                }
                if (!found2) {
                    for (int k2 = 0; k2 < oneOffs.length; ++k2) {
                        if (!prereqOneOffs[i2].equals(oneOffs[k2].getID())) continue;
                        found2 = true;
                        break;
                    }
                }
                if (found2) continue;
                prereqNotPresent = true;
                missingOneOffs.append(prereqOneOffs[i2]);
                missingOneOffs.append(" ");
            }
            if (prereqNotPresent) {
                buff = new StringBuffer("Interim patch " + oneOffs[oIter].getID());
                buff.append(" requires prerequisite patch(es) [ ");
                buff.append(missingOneOffs);
                buff.append("] which are not present in the Oracle Home.\n");
                buff.append("Apply prerequisite patch(es) [ ");
                buff.append(missingOneOffs);
                buff.append("] before applying interim patch " + oneOffs[oIter].getID() + " .");
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(oneOffs[oIter].getPatchID());
            }
            Set<String> allBugs = IOC.INSTANCE.getAllBugIds();
            for (int i3 = 0; i3 < requiredBugList.length; ++i3) {
                found = allBugs.contains(requiredBugList[i3]);
                if (!found) {
                    block9: for (int l2 = 0; l2 < oneOffs.length; ++l2) {
                        if (l2 == oIter) continue;
                        String[] bugsCur = oneOffs[l2].getBugIDsFixed();
                        for (int k3 = 0; k3 < bugsCur.length; ++k3) {
                            if (!requiredBugList[i3].equals(bugsCur[k3])) continue;
                            found = true;
                            continue block9;
                        }
                    }
                }
                if (found) continue;
                bugsNotPresent = true;
                missingBugs.append(requiredBugList[i3]);
                missingBugs.append(" ");
            }
            if (!bugsNotPresent) continue;
            buff = new StringBuffer("Required prerequisite bug fix(es) [ ");
            buff.append(missingBugs);
            buff.append("] for patch '");
            buff.append(oneOffs[oIter].getID());
            buff.append("' are not present in the Oracle Home.");
            OLogger.debug(buff);
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            failedPatches.add(oneOffs[oIter].getPatchID());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public PrereqResult checkCentralInventoryForOH(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("\nOracle Home is registered with the given Central Inventory.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        PrereqResult resObj = new PrereqResult();
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    public PrereqResult checkCentralInventoryForRWSession(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("\nSession was created and got the information about the given Oracle Home.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        PrereqResult resObj = new PrereqResult();
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    public static PrereqResult checkNoOpPatchesIOC(String oracleHomePath, PatchObject[] patchObjects, Vector store) {
        PrereqResult sbFileVersions;
        StringBuffer buff = new StringBuffer("IOCPrereqAPI::checkNoOpPatchesIOC()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        boolean noOpPatchFound = false;
        Vector<PatchObject> snowBallNoOpList = new Vector<PatchObject>();
        PatchObject[] checkSnowBallNoOpList = new PatchObject[]{};
        if (patchObjects == null) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("Input array of PatchObjects is null.");
            return resObj;
        }
        int modelCode = IOC.INSTANCE.getPatchingModel();
        StringBuffer listOfNoOpPatches = new StringBuffer("The following no-op. patches have no components compatible with that of the Oracle Home to patch.\n");
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            String patchID = patchObjects[i2].getPatchID();
            boolean isNoOp = IOCPrereqAPI.isNoOpPatch(oracleHomePath, patchObjects[i2]);
            if (isNoOp) {
                noOpPatchFound = true;
                listOfNoOpPatches.append(" ");
                listOfNoOpPatches.append(patchID);
                store.add(patchID);
                continue;
            }
            snowBallNoOpList.add(patchObjects[i2]);
        }
        if (snowBallNoOpList != null && snowBallNoOpList.size() != 0) {
            checkSnowBallNoOpList = new PatchObject[snowBallNoOpList.size()];
            snowBallNoOpList.toArray(checkSnowBallNoOpList);
        }
        if (modelCode != 2) {
            if (noOpPatchFound) {
                resObj.addDetail(listOfNoOpPatches.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                return resObj;
            }
            OLogger.printlnOnLogAndVerbose("None of the selected patches are no-op. patches..");
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        StringBuffer listOfNoOpSnowball = new StringBuffer();
        if (noOpPatchFound) {
            listOfNoOpSnowball.append(listOfNoOpPatches.toString());
            listOfNoOpSnowball.append("\n");
        }
        if ((sbFileVersions = IOCPrereqAPI.checkFileVersions(oracleHomePath, checkSnowBallNoOpList, store)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
            noOpPatchFound = true;
            Vector result = sbFileVersions.getResultDetails();
            for (int k2 = 0; k2 < result.size(); ++k2) {
                listOfNoOpSnowball.append((String)result.get(k2));
            }
        }
        if (noOpPatchFound) {
            resObj.addDetail(listOfNoOpSnowball.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return resObj;
        }
        OLogger.printlnOnLogAndVerbose("None of the selected patch(es) are no-op. patch(es)");
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    public static PrereqResult checkFileVersions(String oracleHomePath, PatchObject[] patchObjects, Vector store) {
        StringBuffer buff = new StringBuffer("IOCPrereqAPI::checkFileVersions()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        ProcessFileVersions processor = new ProcessFileVersions();
        int modelCode = IOC.INSTANCE.getPatchingModel();
        if (modelCode != 2) {
            buff = new StringBuffer("The Oracle Home \"" + oracleHomePath + "\" does not " + "support \"" + PatchingModel.getModelType(2) + "\"");
            buff.append("\nThis prereq is not applicable for this home.");
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            if (OPatchEnv.isFATwoPhase()) {
                processor.computeComps(patchObjects);
            }
            return resObj;
        }
        PrereqResult patchModelResObj = IOCPrereqAPI.getInstance().checkPatchingModelIOC(oracleHomePath, patchObjects);
        if (patchModelResObj.getResult() == PrereqResult.ExecuteStatus.FAILED || patchModelResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            return patchModelResObj;
        }
        if (patchObjects == null) {
            resObj.addDetail("Could not create OPatch based Patch Objects based on the input.");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return resObj;
        }
        Map<Object, Object> m2 = new HashMap();
        boolean fv_exist = false;
        if (OPatchEnv.isFATwoPhase()) {
            fv_exist = ProcessFileVersions.existFvOh(oracleHomePath);
        }
        if (fv_exist) {
            OLogger.printlnOnLogAndVerbose("\nCheckFileVersions: Parse cached fv_oh to get HashTable of all installed Snowball Copy Actions Filenames with their versions...");
            try {
                NApplyDataSerializer serializer = new NApplyDataSerializer();
                m2 = serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_oh.txt");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                OLogger.printlnOnLogAndVerbose("Unable to parse cached OH files.");
                fv_exist = false;
            }
        }
        if (!fv_exist) {
            OLogger.printlnOnLogAndVerbose("\nCheckFileVersions: Cached fv_oh does not exist or is invalid, re-generate it.");
            m2 = new HashMap<String, String>(IOC.INSTANCE.getFileVersionMap());
        }
        Arrays.sort(patchObjects, new Comparator<PatchObject>(){

            @Override
            public int compare(PatchObject o1, PatchObject o2) {
                return o1.getPatchLocation().compareTo(o2.getPatchLocation());
            }
        });
        HashMap<String, String> m_bk = new HashMap<String, String>(m2);
        OneOffEntry[] pi = new OneOffEntry[patchObjects.length];
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            pi[i2] = patchObjects[i2].toOneOffEntry(oracleHomePath);
        }
        FVData fvData = OPatchSessionHelper.getCopyFileVerForPi(pi);
        Map<String, String> mpi = fvData.getCopyMap();
        Map<String, List<String>> mpi_delete = fvData.getDeleteMap();
        HashMap<String, String> m_all_cp = new HashMap<String, String>(IOC.INSTANCE.getFileVersionMap());
        HashMap<String, String> activeDelete = new HashMap<String, String>();
        boolean errorFlag = false;
        StringBuffer errorBuff = new StringBuffer();
        OLogger.printlnOnLogAndVerbose("\nThis Prereq will check only for copy actions (file version) of present components (mentioned by patches) in Oracle Home.");
        OLogger.printlnOnLogAndVerbose("For component & file related checks, Please use 'opatch prereq checkApplicable'.\n");
        for (int i3 = 0; i3 < patchObjects.length; ++i3) {
            String patchType = patchObjects[i3].getPatchType();
            if (!patchType.equals("snowball")) continue;
            long aiCount = 0L;
            long noOpCount = 0L;
            OLogger.printlnOnLogAndVerbose("Verifying if Patch \"" + patchObjects[i3].getPatchID() + "\" has some file versions greater than the one " + "installed in Oracle Home and among patch(es)...");
            for (PatchComponent pc : patchObjects[i3].getIncludedPatchComponents()) {
                for (OrderedPatchAction ai : pc.getSnowballOrderedActions()) {
                    String activeKey;
                    String ohVer;
                    String value;
                    String file;
                    OrderedPatchAction act;
                    ++aiCount;
                    if (ai instanceof CopyAction) {
                        int intraVal;
                        act = (CopyAction)ai;
                        file = ((CopyAction)act).getFilename();
                        value = ((CopyAction)act).getFileVersion();
                        ohVer = (String)m2.get(file);
                        String intraVer = mpi.get(file);
                        List<String> intraDelete = mpi_delete.get(file);
                        String historyVer = (String)m_all_cp.get(file);
                        OLogger.log(OLogger.FINE, "File for the copy action is : " + ((CopyAction)act).getParentFilePath(oracleHomePath));
                        OLogger.log(OLogger.FINE, "Source Version of the copy action is : " + value);
                        OLogger.log(OLogger.FINE, "Destination Version of the copy action is : " + (ohVer == null ? "No version available" : ohVer));
                        boolean deleteFlag = null == intraVer;
                        int retVal = OPatchSessionHelper.isGreaterDecimal(value, ohVer);
                        int n2 = intraVal = null == intraVer ? -1 : OPatchSessionHelper.isGreaterDecimal(value, intraVer);
                        if (retVal == 1 && intraVal > -1 && null != intraDelete) {
                            if (intraDelete.contains("lemax.version")) {
                                deleteFlag = true;
                            } else {
                                for (String ver : intraDelete) {
                                    if (ver.startsWith("le")) {
                                        String deleteVer = ver.substring(2);
                                        int val = OPatchSessionHelper.isGreaterDecimal(deleteVer, value);
                                        if (val != 1) continue;
                                        if (!OPatchSessionHelper.isBeingIntraDeleted(patchObjects, i3, file, value)) break;
                                        deleteFlag = true;
                                        break;
                                    }
                                    int val = OPatchSessionHelper.isGreaterDecimal(ver, value);
                                    if (val != 0) continue;
                                    if (!OPatchSessionHelper.isBeingIntraDeleted(patchObjects, i3, file, value)) break;
                                    deleteFlag = true;
                                    break;
                                }
                            }
                        }
                        if (retVal != 1 || intraVal == -1 || deleteFlag) {
                            ++noOpCount;
                            if (retVal != 1) {
                                OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" has " + "version \"" + value + "\" lesser or " + "equal to version \"" + ohVer + "\" of the same file in Oracle Home.");
                            } else if (intraVal == -1) {
                                OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" has " + "version \"" + value + "\" lesser or " + "equal to version \"" + intraVer + "\" of the same file touched by patch in Oracle Home.");
                            } else if (deleteFlag) {
                                OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" is marked for delete.");
                            }
                        } else {
                            m2.put(file, value);
                            OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" from " + "patch \"" + patchObjects[i3].getPatchID() + "\" has " + "version \"" + value + "\" set in map as it is now the higher version.");
                        }
                        int hisVal = OPatchSessionHelper.isGreaterDecimal(value, historyVer);
                        if (deleteFlag || hisVal != 1) continue;
                        m_all_cp.put(file, value);
                        continue;
                    }
                    if (!(ai instanceof DeleteAction)) continue;
                    act = (DeleteAction)ai;
                    file = ((DeleteAction)act).getFileName();
                    value = ((DeleteAction)act).getFileVersion();
                    ohVer = (String)m2.get(file);
                    String historyVer = (String)m_all_cp.get(file);
                    Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(((DeleteAction)act).getParentFilePath(oracleHomePath), new String[0]);
                    List<String> intraDelete = mpi_delete.get(file);
                    if (ohVer != null) {
                        if (((DeleteAction)act).isHasFileVersion()) {
                            if (value.startsWith("le")) {
                                String deleteVer = value.substring(2);
                                int retVal = OPatchSessionHelper.isGreaterDecimal(deleteVer, ohVer);
                                if (retVal == 1) {
                                    buff = new StringBuffer("Delete Action " + ((DeleteAction)act).getParentFilePath(oracleHomePath) + " version is higher than --> " + ohVer + ".");
                                    buff.append("\nWe will remove the version " + ohVer + " in the oh.");
                                    OLogger.debug(buff);
                                    m2.remove(file);
                                    continue;
                                }
                                ++noOpCount;
                                OLogger.printlnOnLogAndVerbose("Delete action \"" + ((DeleteAction)act).getParentFilePath(oracleHomePath) + "\" has " + "version \"" + value + "\" lesser than version \"" + ohVer + "\" of the same file touched by patch in Oracle Home.");
                                continue;
                            }
                            if (null != intraDelete && !intraDelete.contains(value)) {
                                ++noOpCount;
                                continue;
                            }
                            int retVal = OPatchSessionHelper.isGreaterDecimal(value, ohVer);
                            if (retVal == 0) {
                                buff = new StringBuffer("Delete Action " + ((DeleteAction)act).getParentFilePath(oracleHomePath) + " version is higher than --> " + ohVer + ".");
                                buff.append("\nWe will remove the version " + ohVer + " in the oh.");
                                OLogger.debug(buff);
                                m2.remove(file);
                                continue;
                            }
                            ++noOpCount;
                            continue;
                        }
                        m2.remove(file);
                        OLogger.printlnOnLogAndVerbose("Delete action \"" + ((DeleteAction)act).getParentFilePath(oracleHomePath) + "\" has " + "version \"" + value + "\" match with version \"" + ohVer + "\" of the same file touched by patch in Oracle Home.");
                        continue;
                    }
                    if (Files.isRegularFile(dstFile, new LinkOption[0]) && null != historyVer) {
                        ++noOpCount;
                        continue;
                    }
                    if (!((DeleteAction)act).isHasFileVersion()) {
                        value = "lemax.version";
                    }
                    boolean actDel = false;
                    List<String> key = mpi_delete.get(file);
                    if (null != key && key.contains(value)) {
                        actDel = true;
                    }
                    if (null != (activeKey = (String)activeDelete.get(file)) && activeKey.equals(value) || !Files.exists(dstFile, new LinkOption[0]) && !((DeleteAction)act).getIsReq()) {
                        actDel = false;
                    }
                    if (!actDel || ((DeleteAction)act).isHasFileVersion() && !value.startsWith("le")) {
                        ++noOpCount;
                        continue;
                    }
                    activeDelete.put(file, value);
                }
            }
            if (aiCount != noOpCount || aiCount == 0L) continue;
            OLogger.printlnOnLogAndVerbose("Patch \"" + patchObjects[i3].getPatchID() + "\" is a no-op. patch. based on file versions.");
            errorFlag = true;
            errorBuff.append(patchObjects[i3].getPatchID() + " ");
            store.add(patchObjects[i3].getPatchID());
        }
        if (errorFlag) {
            buff = new StringBuffer("The following no-op. \"Fusion Applications\" patch(es) have all copy version(s) less or equal to version(s) installed in\nOracle Home (or) among selected patch(es).");
            buff.append("\n " + errorBuff.toString());
            buff.append("\nPlease refer log file for more details.");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        if (OPatchEnv.isFATwoPhase()) {
            OLogger.printlnOnLog("\nCheckFileVersions: OPatch is called with two-phase patching for snowball. Serialize file/version information into disk.");
            processor.computeFV(patchObjects, oracleHomePath, m_bk, fv_exist);
            processor.computeNoOp(store);
            processor.computeComps(patchObjects);
        }
        return resObj;
    }

    public static PrereqResult checkIfRequiredDeleteActionExist(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("IOCPrereqAPI::checkIfRequiredDeleteActionExist()");
        OLogger.debug(buff);
        StringBuffer patchInfo = new StringBuffer("");
        boolean inputFault = false;
        PrereqResult resObj = new PrereqResult();
        buff = new StringBuffer("");
        Map<Object, Object> copyFileVerMap = new HashMap();
        if (OPatchEnv.isFATwoPhase()) {
            boolean fvExist = ProcessFileVersions.existFvOh(oracleHomePath);
            if (fvExist) {
                OLogger.printlnOnLogAndVerbose("\ncheckIfRequiredDeleteActionExist: Parse cached fv_oh to get HashTable of all installed Snowball Copy Actions Filenames with their versions...");
                try {
                    NApplyDataSerializer serializer = new NApplyDataSerializer();
                    copyFileVerMap = serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_oh.txt");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    OLogger.printlnOnLogAndVerbose("Unable to parse cached OH files.");
                    fvExist = false;
                }
            }
            if (!fvExist) {
                OLogger.printlnOnLogAndVerbose("\ncheckIfRequiredDeleteActionExist: Cached fv_oh does not exist or is invalid, re-generate it.");
                copyFileVerMap = IOC.INSTANCE.getFileVersionMap();
            }
        } else {
            copyFileVerMap = IOC.INSTANCE.getFileVersionMap();
        }
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            ListIterator dActions = patchObjects[i2].getAllIncludedDeleteActions();
            patchInfo = new StringBuffer(" Patch " + patchObjects[i2].getPatchID() + " : \n");
            while (dActions.hasNext()) {
                String fileVersion;
                DeleteAction da = (DeleteAction)dActions.next();
                if (!da.isSnowBallDeleteAction()) continue;
                String filename = da.getFileName();
                Path deleteFileInOH = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath + File.separator + filename, new String[0]);
                String string = fileVersion = da.isHasFileVersion() ? da.getFileVersion() : "lemax.version";
                if (!da.getIsReq()) continue;
                if (!Files.exists(deleteFileInOH, new LinkOption[0])) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("  \tRequired Delete Action ");
                    buff.append(filename);
                    buff.append(" with version ");
                    buff.append(da.getFileVersion());
                    buff.append(" failed, the target file doesn't exist in oracle home");
                    inputFault = true;
                    continue;
                }
                if (fileVersion.startsWith("le")) {
                    if ("lemax.version".equals(fileVersion)) continue;
                    String updateVersion = fileVersion.substring(2);
                    String presentVersion = (String)copyFileVerMap.get(filename);
                    int retVal = OPatchSessionHelper.isGreaterDecimal(presentVersion, updateVersion);
                    if (retVal == -1) continue;
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("  \tRequired Delete Action ");
                    buff.append(filename);
                    buff.append(" with version ");
                    buff.append(da.getFileVersion());
                    buff.append(" failed, it has no subset action in oracle home.");
                    inputFault = true;
                    continue;
                }
                String presentVersion = (String)copyFileVerMap.get(filename);
                int retVal = OPatchSessionHelper.isGreaterDecimal(presentVersion, fileVersion);
                if (retVal == 0) continue;
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff.append("  \tRequired Delete Action ");
                buff.append(filename);
                buff.append(" with version ");
                buff.append(da.getFileVersion());
                buff.append(" failed, the target file doesn't exist in oracle home.");
                inputFault = true;
            }
            if (inputFault) {
                buff.append("\n");
                patchInfo.append(buff);
                inputFault = false;
                resObj.addDetail(patchInfo.toString());
                failedPatches.add(patchObjects[i2].getPatchID());
            }
            patchInfo = new StringBuffer();
            buff = new StringBuffer();
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_IF_REQUIRED_DELETE_ACTION_EXIST, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static boolean isNoOpPatch(String oracleHomePath, PatchObject patchObject) {
        try {
            Map<PatchComponent, PatchComponentCheckResult> analyzed = IOCHelper.INSTANCE.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
                if (!entry.getKey().isRequired() && !entry.getValue().getResult().isProcessComponent()) continue;
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static PrereqResult checkComponents(String oracleHomePath, PatchObject patchObject, Vector includedPC) throws NoOpPatchException {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkComponents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        boolean failedReqComponent = false;
        boolean ngVersionMismatchFailure = false;
        try {
            Map<PatchComponent, PatchComponentCheckResult> analyzed = IOCHelper.INSTANCE.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            PatchComponentCheckResult pcCheck = null;
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                pcCheck = analyzed.get(pc);
                OLogger.debug(pcCheck.getDetails());
                if (pcCheck.getResult().isProcessComponent()) {
                    includedPC.add(pc);
                    continue;
                }
                if (pcCheck.getResult().isProcessingNotRequired()) {
                    pc.setExcluded();
                    continue;
                }
                if (pc.isRequired()) {
                    failedReqComponent = true;
                } else {
                    pc.setExcluded();
                }
                if (!OPatchEnv.isNextGenUpgradePatchingSupported() || !pcCheck.getResult().isVersionMismatch()) continue;
                ngVersionMismatchFailure = true;
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occured: " + t.getMessage()));
            resObj.addDetail(t.getMessage());
            return resObj;
        }
        if (ngVersionMismatchFailure) {
            includedPC.removeAllElements();
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("Version Mismatch of Component occured. This Patch cannot be applied");
            return resObj;
        }
        if (failedReqComponent) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("One or many required components cannot be processed.");
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        resObj.addDetail("CheckComponent prereq succeeded");
        return resObj;
    }
}

