/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacSrvm;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OUSessionHelper;
import oracle.opatch.opatchutil.UtilEnv;
import oracle.opatch.wrappers.WrapperFactory;

public class RemoveOnNodes {
    protected static void removeListedFilesTest(String oracleHomePath) throws RuntimeException {
        try {
            String listedFileHolder = "";
            OLogger.println("This option will remove a given file on a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            String fileToRemove = "";
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            if (!UtilEnv.isFR()) {
                throw new RuntimeException("-fr argument is required to remove file on remote nodes.");
            }
            fileToRemove = UtilEnv.getFilesToRemove();
            OUSessionHelper.FilePrompt filePrompt = OUSessionHelper.createTempFileHolder(fileToRemove, false, false, OPatchEnv.getTmpDir(), "opatch_rac.tmp");
            listedFileHolder = filePrompt.getFileHolder();
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            String baseDir = filePrompt.getBaseDir();
            OLogger.println("The file \"" + fileToRemove + "\" will be removed on remote node(s).");
            racSrvm.removeListedFilesOnNodes(baseDir, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected static void removeListedFiles(String oracleHomePath) throws RuntimeException {
        try {
            String listedFileHolder = "";
            OLogger.println("This option will remove listed files on a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            String frFile = RacFileCreator.getFRFinalName();
            if (UtilEnv.isFR()) {
                listedFileHolder = UtilEnv.getFilesToRemove();
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(listedFileHolder, new String[0]);
                if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
                    throw new IOException("The file \"" + listedFileHolder + "\" does not exists or is not readable.\n");
                }
                if (Files.isDirectory(f2, new LinkOption[0])) {
                    throw new IOException("The parameter to -fr option \"" + listedFileHolder + "\" is a directory.\n");
                }
            } else {
                throw new RuntimeException("-fr argument is required to remove files on remote nodes in silent mode");
            }
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            OLogger.println("The files listed in \"" + listedFileHolder + "\" will be removed on remote node(s).");
            racSrvm.removeListedFilesOnNodes(oracleHomePath, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected static void removeListedDirsTest(String oracleHomePath) throws RuntimeException {
        try {
            String listedFileHolder = "";
            OLogger.println("This option will remove a given dir on a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            String dirToRemove = "";
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            if (!UtilEnv.isDR()) {
                throw new RuntimeException("-dr argument is required to remove directory on remote nodes.");
            }
            dirToRemove = UtilEnv.getDirectoriesToRemove();
            OUSessionHelper.FilePrompt filePrompt = OUSessionHelper.createTempFileHolder(dirToRemove, false, true, OPatchEnv.getTmpDir(), "opatch_rac.tmp");
            listedFileHolder = filePrompt.getFileHolder();
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            String baseDir = filePrompt.getBaseDir();
            OLogger.println("The directory \"" + dirToRemove + "\" will be removed on remote node(s).");
            racSrvm.removeListedDirsOnNodes(baseDir, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected static void removeListedDirs(String oracleHomePath) throws RuntimeException {
        try {
            String listedFileHolder = "";
            OLogger.println("This option will remove listed dirs on a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            String drFile = RacFileCreator.getDRFinalName();
            if (UtilEnv.isDR()) {
                listedFileHolder = UtilEnv.getDirectoriesToRemove();
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(listedFileHolder, new String[0]);
                if (listedFileHolder.isEmpty() || !Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
                    throw new IOException("The file \"" + listedFileHolder + "\" does not exists or is not readable.\n");
                }
                if (Files.isDirectory(f2, new LinkOption[0])) {
                    throw new IOException("The parameter to -dr option \"" + listedFileHolder + "\" is a directory.\n");
                }
            } else {
                throw new RuntimeException("-dr argument is required to remove directories on remote nodes in silent mode");
            }
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            OLogger.println("The directories listed in \"" + listedFileHolder + "\" will be removed on remote node(s).");
            racSrvm.removeListedDirsOnNodes(oracleHomePath, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }
}

