/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.twophase.INonBinaryPatchAction;
import oracle.opatch.twophase.PatchActions;
import oracle.opatch.twophase.PhaseTwoMakeAction;

public class MakePatchActions
extends PatchActions
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    protected void build(Map<OPatchPatchKey, PatchObject[]> patchMap) {
        PatchObject[] res = this.getAllPatches(patchMap);
        MakeAction[] makes = OPatchSessionHelper.getIncludedMakeActions(OPatchEnv.getOracleHome(), res);
        OPatchPatchKey key = null;
        Iterator<OPatchPatchKey> iterator = patchMap.keySet().iterator();
        if (iterator.hasNext()) {
            OPatchPatchKey pK;
            key = pK = iterator.next();
        }
        if (makes != null && makes.length != 0) {
            this.put(key, this.build(makes));
        }
    }

    public void runAll() {
        ArrayList<MakeAction> makes = new ArrayList<MakeAction>();
        MakeAction[] action = null;
        for (OPatchPatchKey key : this.keySet()) {
            INonBinaryPatchAction[] patchActs;
            for (INonBinaryPatchAction binAct : patchActs = (INonBinaryPatchAction[])this.get(key)) {
                makes.add(((PhaseTwoMakeAction)binAct).get());
            }
        }
        action = new MakeAction[makes.size()];
        makes.toArray(action);
        OPatchSession.runMake(OPatchEnv.getSessionName(), OPatchEnv.getOracleHome(), action);
    }

    @Override
    public INonBinaryPatchAction getAction(PatchObject p2) {
        throw new UnsupportedOperationException("Invalid operation Make Action Map.");
    }

    @Override
    public String getFileName(String prefix, String postfix) {
        return prefix + ".make." + postfix;
    }

    private INonBinaryPatchAction[] build(MakeAction[] makes) {
        ArrayList<PhaseTwoMakeAction> list = new ArrayList<PhaseTwoMakeAction>();
        for (MakeAction make : makes) {
            list.add(new PhaseTwoMakeAction(make));
        }
        INonBinaryPatchAction[] res = new INonBinaryPatchAction[list.size()];
        list.toArray(res);
        return res;
    }

    private PatchObject[] getAllPatches(Map<OPatchPatchKey, PatchObject[]> patchMap) {
        ArrayList<PatchObject> list = new ArrayList<PatchObject>();
        for (PatchObject[] patches : patchMap.values()) {
            for (PatchObject p2 : patches) {
                list.add(p2);
            }
        }
        PatchObject[] res = new PatchObject[list.size()];
        list.toArray(res);
        return res;
    }
}

