/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionRunner;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalPatchActionRunner
implements PatchActionRunner {
    private static final Logger _logger = Logger.getLogger(LocalPatchActionRunner.class.getName());
    private PatchAction _patchAction;
    private PatchTarget _patchTarget;
    private boolean _isRequiredCheck;
    private PatchActionResult _patchActionResult;

    public LocalPatchActionRunner(PatchAction patchAction, PatchTarget patchTarget, boolean isRequiredCheck) {
        this._patchAction = patchAction;
        this._patchTarget = patchTarget;
        this._isRequiredCheck = isRequiredCheck;
    }

    @Override
    public Map<PatchTarget, PatchActionResult> getPatchActionResults() {
        HashMap<PatchTarget, PatchActionResult> results = new HashMap<PatchTarget, PatchActionResult>();
        results.put(this._patchTarget, this._patchActionResult);
        return results;
    }

    @Override
    public void run() {
        try {
            _logger.info("Local patch action runner executing" + (this._isRequiredCheck ? " is required check for" : "") + " patch action " + this._patchAction + " on patch target " + this._patchTarget);
            if (!this._isRequiredCheck) {
                String statusMsg = this._patchAction.getStatusMessage(this._patchTarget, PatchActionStatus.incomplete);
                if (statusMsg == null) {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString("LocalPatchActionRunner.executing.action", this._patchAction.getPatchSession().getCurrentGoal(), this._patchAction.getDisplayName(), this._patchTarget.toReportingString()));
                } else {
                    Reporting.report((String)statusMsg);
                }
                PatchTracking.updateAction(this._patchAction, this._patchTarget, PatchActionStatus.incomplete);
            }
            this._patchActionResult = this._isRequiredCheck ? new PatchActionResult(this._patchAction.isActionRequired(this._patchTarget)) : this._patchAction.execute(this._patchTarget);
            if (!this._isRequiredCheck) {
                this._patchAction.postExecute(this._patchTarget, this._patchActionResult);
                PatchTracking.updateAction(this._patchAction, this._patchTarget, this._patchActionResult.getResult());
            }
        }
        catch (Throwable t) {
            this._patchActionResult = new PatchActionResult(t);
        }
        try {
            if (!this._isRequiredCheck) {
                String statusMessage = null;
                if (this._patchActionResult != null) {
                    statusMessage = this._patchAction.getStatusMessage(this._patchTarget, this._patchActionResult.getResult());
                }
                if (statusMessage == null) {
                    statusMessage = this.getDefaultMessage();
                }
                Reporting.report(statusMessage);
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Failed to report patch action execution result.", t);
        }
    }

    private String getDefaultMessage() {
        String result = OPatchAutoHelper.getLocalizedString("LocalPatchActionRunner.unexpected.result", new Object[0]);
        if (this._patchActionResult != null) {
            if (this._patchActionResult.isSuccess()) {
                result = OPatchAutoHelper.getLocalizedString("LocalPatchActionRunner.successfully", new Object[0]);
            } else if (this._patchActionResult.isFailure()) {
                result = OPatchAutoHelper.getLocalizedString("LocalPatchActionRunner.with.failure", new Object[0]);
            } else if (this._patchActionResult.isWarning()) {
                result = OPatchAutoHelper.getLocalizedString("LocalPatchActionRunner.with.warning", new Object[0]);
            }
        }
        return OPatchAutoHelper.getLocalizedString("LocalPatchActionRunner.action.completed", this._patchAction.getPatchSession().getCurrentGoal(), this._patchAction.getDisplayName(), this._patchTarget.toReportingString(), result);
    }
}

