/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.tracking;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.oracle.cie.common.util.RandomStringGenerator;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.MutablePatchTarget;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.tracking.PatchTrackingException;
import com.oracle.glcm.patch.auto.tracking.bindings.ActionType;
import com.oracle.glcm.patch.auto.tracking.bindings.ActionsType;
import com.oracle.glcm.patch.auto.tracking.bindings.ExecutionType;
import com.oracle.glcm.patch.auto.tracking.bindings.ExecutionsType;
import com.oracle.glcm.patch.auto.tracking.bindings.GoalType;
import com.oracle.glcm.patch.auto.tracking.bindings.ObjectFactory;
import com.oracle.glcm.patch.auto.tracking.bindings.OptionType;
import com.oracle.glcm.patch.auto.tracking.bindings.OptionsType;
import com.oracle.glcm.patch.auto.tracking.bindings.PatchTrackingType;
import com.oracle.glcm.patch.auto.tracking.bindings.StatusType;
import com.oracle.glcm.patch.auto.tracking.bindings.TargetType;
import com.oracle.glcm.patch.auto.tracking.bindings.TargetsType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class PatchTracking {
    private static final Logger _log = Logger.getLogger(PatchTracking.class.getName());
    public static final String SESSIONS_DIR_PROPERTY = "opatchauto.tracking.sessions.dir";
    public static final String SESSIONS_DIR = "inventory/opatchauto/sessions";
    public static final String PERSIST_XML_PROPERTY = "opatchauto.tracking.persist.xml";
    public static final String SESSION_FILE_EXTENSION_JSON = ".json";
    public static final String SESSION_FILE_EXTENSION_XML = ".xml";
    private static final String EXCLUDED_IDS_RESOURCE = "/resources/opatchauto/excludedids.txt";
    private static ObjectMapper _objectMapper;
    private static ObjectWriter _objectWriter;
    private static List<String> _excludedIds;
    private PatchTrackingType _patchTracking;
    private File _sessionFile;
    private int _executionId;
    private boolean _isExisting;
    private boolean _persistXml = Boolean.getBoolean("opatchauto.tracking.persist.xml");
    private Map<PatchTarget, TargetType> _targetMap = new HashMap<PatchTarget, TargetType>();

    private static ObjectMapper getObjectMapper() {
        if (_objectMapper == null) {
            _objectMapper = new ObjectMapper();
            _objectMapper.registerModule((Module)new JaxbAnnotationModule());
            _objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return _objectMapper;
    }

    private static ObjectWriter getObjectWriter() {
        if (_objectWriter == null) {
            _objectWriter = PatchTracking.getObjectMapper().writer(SerializationFeature.INDENT_OUTPUT);
        }
        return _objectWriter;
    }

    public static String generateSessionId() throws PatchTrackingException {
        String home;
        if (_excludedIds == null) {
            InputStream is = PatchTracking.class.getResourceAsStream(EXCLUDED_IDS_RESOURCE);
            if (is == null) {
                throw new PatchTrackingException("68110", EXCLUDED_IDS_RESOURCE);
            }
            _excludedIds = new ArrayList<String>();
            try {
                String s;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((s = br.readLine()) != null) {
                    if ((s = s.trim()).length() <= 0) continue;
                    _excludedIds.add(s);
                }
            }
            catch (IOException e) {
                throw new PatchTrackingException("68111", (Throwable)e, EXCLUDED_IDS_RESOURCE);
            }
        }
        try {
            home = OPatchAutoHelper.getOPatchAutoHome();
        }
        catch (OPatchAutoException e) {
            throw new PatchTrackingException(e);
        }
        String sessionId = null;
        RandomStringGenerator randomStringGenerator = new RandomStringGenerator();
        boolean valid = false;
        while (!valid) {
            File sessionFile;
            sessionId = randomStringGenerator.syncGenerate(4);
            if (_excludedIds.contains(sessionId) || (sessionFile = PatchTracking.getSessionFile(home, sessionId)).exists()) continue;
            valid = true;
        }
        return sessionId;
    }

    public static File getSessionDir(String home) {
        String patchSessionDir = System.getProperty(SESSIONS_DIR_PROPERTY);
        return StringUtil.isNullOrEmpty((String)patchSessionDir, (boolean)true) ? new File(home, SESSIONS_DIR) : new File(patchSessionDir);
    }

    public static File getSessionFile(String home, String sessionId) {
        return new File(PatchTracking.getSessionDir(home), sessionId + SESSION_FILE_EXTENSION_JSON);
    }

    public static void updateActions(PatchAction patchAction, Set<PatchTarget> patchTargets, Map<PatchTarget, PatchActionResult> results) {
        if (patchTargets != null) {
            Iterator<PatchTarget> it = patchTargets.iterator();
            while (it.hasNext()) {
                PatchTarget patchTarget = it.next();
                PatchActionResult result = results != null ? results.get(patchTarget) : null;
                PatchActionStatus status = result != null ? result.getResult() : PatchActionStatus.incomplete;
                PatchTracking.updateAction(patchAction, patchTarget, status, !it.hasNext());
            }
        }
    }

    public static void updateAction(PatchAction patchAction, PatchTarget patchTarget, PatchActionStatus status) {
        PatchTracking.updateAction(patchAction, patchTarget, status, true);
    }

    private static void updateAction(PatchAction patchAction, PatchTarget patchTarget, PatchActionStatus status, boolean save) {
        if (patchAction != null) {
            PatchTracking patchTracking;
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Updating patch tracking action status for action " + patchAction + " target " + patchTarget + " status " + (Object)((Object)status));
            }
            if ((patchTracking = patchAction.getPatchSession().getPatchTracking()) != null) {
                patchTracking.updateAction(patchAction, patchTarget, patchAction.getPatchSession().getCurrentGoal(), status);
                if (save) {
                    try {
                        patchTracking.save();
                    }
                    catch (PatchTrackingException e) {
                        _log.log(Level.SEVERE, "Failed to save patch session file.", e);
                    }
                }
            }
        }
    }

    public PatchTracking(String sessionId) throws OPatchAutoException {
        this(sessionId, OPatchAutoHelper.getOPatchAutoHome(), OPatchAutoHelper.getOPatchAutoHost(), null);
    }

    public PatchTracking(String sessionId, OPatchAutoCommand command) throws OPatchAutoException {
        this(sessionId, OPatchAutoHelper.getOPatchAutoHome(), OPatchAutoHelper.getOPatchAutoHost(), command);
    }

    public PatchTracking(String sessionId, String home, String host, OPatchAutoCommand command) throws PatchTrackingException {
        if (StringUtil.isNullOrEmpty((String)sessionId, (boolean)true)) {
            throw new PatchTrackingException("68112", new Object[0]);
        }
        if (StringUtil.isNullOrEmpty((String)home, (boolean)true)) {
            throw new PatchTrackingException("68113", new Object[0]);
        }
        if (StringUtil.isNullOrEmpty((String)host, (boolean)true)) {
            throw new PatchTrackingException("68114", new Object[0]);
        }
        sessionId = sessionId.toUpperCase();
        this._sessionFile = PatchTracking.getSessionFile(home, sessionId);
        if (this._sessionFile.exists()) {
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Located existing patch tracking session for " + sessionId + " at " + this._sessionFile);
            }
            this._isExisting = true;
            try {
                this._patchTracking = (PatchTrackingType)PatchTracking.getObjectMapper().readValue(this._sessionFile, PatchTrackingType.class);
            }
            catch (IOException e) {
                throw new PatchTrackingException("68115", (Throwable)e, this._sessionFile);
            }
        } else {
            this._patchTracking = new PatchTrackingType();
            this._patchTracking.setSessionId(sessionId);
            this._patchTracking.setHome(home);
            this._patchTracking.setHost(host);
            this._patchTracking.setStatus(StatusType.INCOMPLETE);
            if (command != null) {
                this._patchTracking.setCommand(command.name());
            }
        }
    }

    protected PatchTrackingType getPatchTracking() {
        return this._patchTracking;
    }

    public String getSessionId() {
        return this.getPatchTracking().getSessionId();
    }

    public OPatchAutoCommand getCommand() {
        String command = this.getPatchTracking().getCommand();
        return !StringUtil.isNullOrEmpty((String)command, (boolean)true) ? OPatchAutoCommand.valueOf(command) : OPatchAutoCommand.apply;
    }

    public File getSessionFile() {
        return this._sessionFile;
    }

    public int getExecutionId() {
        return this._executionId;
    }

    public boolean isExistingSession() {
        return this._isExisting;
    }

    public void initSessionExecution(OPatchAutoOptions options) throws PatchTrackingException {
        this.addExecution();
        this.updateOptions(options, false);
        this.save();
    }

    public void updateOptions(OPatchAutoOptions options) throws PatchTrackingException {
        this.updateOptions(options, true);
    }

    public void updateOptions(OPatchAutoOptions options, boolean save) throws PatchTrackingException {
        if (!this.isExistingSession()) {
            this.setOptions(options);
            if (save) {
                this.save();
            }
        }
    }

    public void initPatchTargets(Set<PatchTarget> patchTargets) throws PatchTrackingException {
        if (this.isExistingSession()) {
            this.populateTargetMap(patchTargets);
        } else {
            this.addTargets(patchTargets);
        }
        this.save();
    }

    public void save() throws PatchTrackingException {
        File sessionFile = this.getSessionFile();
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Saving patch tracking session to " + sessionFile);
        }
        try {
            File parent = sessionFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            PatchTracking.getObjectWriter().writeValue(sessionFile, (Object)this.getPatchTracking());
        }
        catch (IOException e) {
            throw new PatchTrackingException("68116", (Throwable)e, this.getSessionFile());
        }
        if (this._persistXml) {
            File xmlSessionFile = new File(this.getSessionFile() + SESSION_FILE_EXTENSION_XML);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchTrackingType.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal(new ObjectFactory().createPatchTracking(this.getPatchTracking()), xmlSessionFile);
            }
            catch (Exception e) {
                throw new PatchTrackingException("68116", (Throwable)e, xmlSessionFile);
            }
        }
    }

    public void addExecution() throws PatchTrackingException {
        PatchTrackingType patchTracking = this.getPatchTracking();
        ExecutionsType executionsType = patchTracking.getExecutions();
        if (executionsType == null) {
            executionsType = new ExecutionsType();
            patchTracking.setExecutions(executionsType);
        }
        List<ExecutionType> executions = executionsType.getExecution();
        this._executionId = 1;
        if (!executions.isEmpty()) {
            for (ExecutionType execution : executions) {
                int id = execution.getId();
                if (id <= this._executionId) continue;
                this._executionId = id;
            }
            ++this._executionId;
        }
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Adding new execution with id " + this._executionId + " to patch tracking session " + patchTracking.getSessionId());
        }
        ExecutionType execution = new ExecutionType();
        execution.setId(this._executionId);
        try {
            execution.setDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException e) {
            throw new PatchTrackingException("68117", (Throwable)e, new Object[0]);
        }
        executions.add(execution);
    }

    public void setOptions(OPatchAutoOptions options) throws PatchTrackingException {
        if (options != null) {
            PatchTrackingType patchTracking = this.getPatchTracking();
            OptionsType optionsType = patchTracking.getOptions();
            if (optionsType == null) {
                optionsType = new OptionsType();
                patchTracking.setOptions(optionsType);
            }
            List<OptionType> trackingOptions = optionsType.getOption();
            Set<OPatchAutoOption> allOptions = options.getAllOptions();
            if (allOptions != null) {
                for (OPatchAutoOption option : allOptions) {
                    try {
                        String value;
                        if (!option.isTracked() || !option.hasValue()) continue;
                        OptionType trackingOption = null;
                        for (OptionType optionType : trackingOptions) {
                            if (!option.getKey().equals(optionType.getKey())) continue;
                            trackingOption = optionType;
                            break;
                        }
                        if (trackingOption == null) {
                            trackingOption = new OptionType();
                            trackingOption.setKey(option.getKey());
                            trackingOptions.add(trackingOption);
                        }
                        if (option.isPassword()) {
                            value = "";
                            char[] password = option.getPasswordValue();
                            if (password != null) {
                                Arrays.fill(password, '*');
                                value = new String(password);
                            }
                        } else {
                            value = option.getValue();
                        }
                        trackingOption.setValue(value);
                    }
                    catch (OPatchAutoException e) {
                        throw new PatchTrackingException("68118", (Throwable)e, option);
                    }
                }
            }
        }
    }

    public void addTargets(Set<PatchTarget> patchTargets) {
        if (patchTargets != null) {
            for (PatchTarget patchTarget : patchTargets) {
                this.addTarget(patchTarget);
            }
        }
    }

    public synchronized void addTarget(PatchTarget target) {
        if (target != null) {
            PatchTrackingType patchTracking = this.getPatchTracking();
            TargetType trackingTarget = new TargetType();
            trackingTarget.setType(target.getProductType().getSupportType().name());
            trackingTarget.setHome(target.getHome().getLocation());
            if (target.getProductType().getSupportType().isInstance()) {
                trackingTarget.setInstance(target.getInstance().getLocation());
            }
            trackingTarget.setHost(target.getHost().getHost());
            trackingTarget.setProductType(target.getType());
            TargetsType targetsType = patchTracking.getTargets();
            if (targetsType == null) {
                targetsType = new TargetsType();
                patchTracking.setTargets(targetsType);
            }
            targetsType.getTarget().add(trackingTarget);
            this._targetMap.put(target, trackingTarget);
        }
    }

    protected void populateTargetMap(Set<PatchTarget> patchTargets) {
        if (patchTargets != null) {
            PatchTrackingType patchTracking = this.getPatchTracking();
            TargetsType targetsType = patchTracking.getTargets();
            if (targetsType == null) {
                targetsType = new TargetsType();
                patchTracking.setTargets(targetsType);
            }
            ArrayList<TargetType> targetTypes = new ArrayList<TargetType>(targetsType.getTarget());
            for (PatchTarget patchTarget : patchTargets) {
                boolean found = false;
                String type = patchTarget.getProductType().getSupportType().name();
                String home = patchTarget.getHome().getLocation();
                String instance = null;
                if (patchTarget.getProductType().getSupportType().isInstance()) {
                    instance = patchTarget.getInstance().getLocation();
                }
                String host = patchTarget.getHost().getHost();
                String productType = patchTarget.getType();
                Iterator it = targetTypes.iterator();
                while (it.hasNext()) {
                    TargetType targetType = (TargetType)it.next();
                    if (!type.equals(targetType.getType()) || !home.equals(targetType.getHome()) || !host.equals(targetType.getHost()) || !productType.equals(targetType.getProductType()) || (instance == null || !instance.equals(targetType.getInstance())) && (instance != null || targetType.getInstance() != null)) continue;
                    if (!StringUtil.isNullOrEmpty((String)targetType.getHomeclone())) {
                        Home cloneHome = patchTarget.getHome().getShallowCopy();
                        cloneHome.setLocation(targetType.getHomeclone());
                        ((MutablePatchTarget)patchTarget).setHomeClone(cloneHome);
                        patchTarget.setUsingHomeClone(targetType.isUsingclone());
                    }
                    this._targetMap.put(patchTarget, targetType);
                    it.remove();
                    found = true;
                    break;
                }
                if (found) continue;
                this.addTarget(patchTarget);
            }
        }
    }

    public synchronized void updateAction(PatchAction action, PatchTarget target, Goal goal, PatchActionStatus status) {
        if (action != null && target != null && goal != null) {
            TargetType trackingTarget = this._targetMap.get(target);
            if (trackingTarget == null) {
                this.addTarget(target);
                trackingTarget = this._targetMap.get(target);
            }
            if (target.getHomeClone() != null) {
                trackingTarget.setHomeclone(target.getHomeClone().getLocation());
                trackingTarget.setUsingclone(target.isUsingHomeClone());
            }
            GoalType trackingGoal = null;
            ActionsType actionsType = trackingTarget.getActions();
            if (actionsType == null) {
                actionsType = new ActionsType();
                trackingTarget.setActions(actionsType);
            }
            List<GoalType> trackingGoals = actionsType.getGoal();
            for (GoalType tg : trackingGoals) {
                if (!goal.getPhaseGoal().equals(tg.getName())) continue;
                trackingGoal = tg;
            }
            if (trackingGoal == null) {
                trackingGoal = new GoalType();
                trackingGoal.setName(goal.getPhaseGoal());
                trackingGoals.add(trackingGoal);
            }
            ActionType trackingAction = null;
            List<ActionType> trackingActions = trackingGoal.getAction();
            for (ActionType ta : trackingActions) {
                if (!action.getClass().getName().equals(ta.getName()) || ta.getExecution() != this.getExecutionId()) continue;
                trackingAction = ta;
            }
            if (trackingAction == null) {
                trackingAction = new ActionType();
                trackingAction.setName(action.getClass().getName());
                trackingAction.setExecution(this.getExecutionId());
                trackingActions.add(trackingAction);
            }
            if (status != null) {
                trackingAction.setStatus(StatusType.valueOf(status.name().toUpperCase()));
            }
        }
    }

    public void populatePreviousSessionOptionValues(OPatchAutoOptions options) throws PatchTrackingException {
        this.populatePreviousSessionOptionValues(options, false);
    }

    public void populatePreviousSessionOptionValues(OPatchAutoOptions options, boolean keepExistingValues) throws PatchTrackingException {
        PatchTrackingType patchTracking = this.getPatchTracking();
        OptionsType optionsType = patchTracking.getOptions();
        if (optionsType != null) {
            List<OptionType> trackingOptions = optionsType.getOption();
            for (OptionType optionType : trackingOptions) {
                try {
                    OPatchAutoOption option = options.getOption(optionType.getKey());
                    if (!option.isPassword()) {
                        if (keepExistingValues && option.hasValue() && !option.isUsingDefault()) continue;
                        option.setValue(optionType.getValue());
                        continue;
                    }
                    option.setRequired(true);
                }
                catch (OPatchAutoException e) {
                    throw new PatchTrackingException("68119", (Throwable)e, optionType.getKey());
                }
            }
        }
    }

    public PatchActionStatus getPreviousActionExecutionStatus(PatchAction action, PatchTarget target, Goal goal) {
        ActionsType actionsType;
        TargetType trackingTarget;
        if (action != null && target != null && goal != null && (trackingTarget = this._targetMap.get(target)) != null && (actionsType = trackingTarget.getActions()) != null) {
            List<GoalType> trackingGoals = actionsType.getGoal();
            for (GoalType trackingGoal : trackingGoals) {
                if (!goal.getPhaseGoal().equals(trackingGoal.getName())) continue;
                ActionType latestActionEntry = null;
                List<ActionType> trackingActions = trackingGoal.getAction();
                for (ActionType trackingAction : trackingActions) {
                    if (!action.getClass().getName().equals(trackingAction.getName()) || latestActionEntry != null && trackingAction.getExecution() <= latestActionEntry.getExecution()) continue;
                    latestActionEntry = trackingAction;
                }
                if (latestActionEntry == null) break;
                return PatchActionStatus.valueOf(latestActionEntry.getStatus().value());
            }
        }
        return PatchActionStatus.incomplete;
    }

    public void updateSessionStatus(StatusType statusType) {
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Updating session status into the patch tracking object. Current session status : " + (Object)((Object)statusType));
        }
        PatchTrackingType patchTrackingType = this.getPatchTracking();
        patchTrackingType.setStatus(statusType);
        try {
            this.save();
        }
        catch (PatchTrackingException e) {
            _log.log(Level.SEVERE, "Failed to save status into patch session file.", e);
        }
    }

    public StatusType getSessionStatus() {
        return this.getPatchTracking().getStatus();
    }
}

