/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.oplan;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanUserException;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class IOUtils {
    private static Logger logger = Logger.getLogger(IOUtils.class.getName());

    public static void copyOwnerGroup(File src, File dst) {
        try {
            String ownerSrcFile = OUIDriver.checkFileOwner((File)src);
            String groupSrcFile = OUIDriver.checkFileGroup((File)src);
            logger.config("Copying owner/group: " + ownerSrcFile + "/" + groupSrcFile + "of " + src.getAbsolutePath() + " to " + dst.getAbsolutePath());
            ProcessBuilder chown = new ProcessBuilder(new String[0]);
            chown.command("chown", ownerSrcFile + ":" + groupSrcFile, dst.getAbsolutePath());
            Process ch = chown.start();
            int chown_failed = ch.waitFor();
            if (chown_failed != 0) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_OWNER", dst.getAbsolutePath());
            }
        }
        catch (InterruptedException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
    }

    public static void chmodTo775(File file, byte[] passwd) {
        if (!ComdevHelper.isWindows()) {
            logger.fine("Change the permission of the file " + file.getAbsolutePath() + "to 775");
            String ownerSrcFile = OUIDriver.checkFileOwner((File)file);
            GISystemCall.ExecReturn retVal = GISystemCall.process("chmod 775 " + file.getAbsolutePath(), ownerSrcFile, passwd);
            if (!retVal.isOK()) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
            }
        }
    }

    public static void chmodTo775WithSuPrevilage(File file) {
        if (!ComdevHelper.isWindows()) {
            logger.fine("Change the permission of the file " + file.getAbsolutePath() + "to 775");
            byte[] pwd = null;
            GISystemCall.ExecReturn retVal = GISystemCall.process("chmod 775 " + file.getAbsolutePath(), null, pwd);
            if (!retVal.isOK()) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
            }
        }
    }

    public static void chmodAllFilesOfDirectory(File directory, String permission, String homeOwner, byte[] passwd) throws OPatchAutoException {
        if (!ComdevHelper.isWindows() && directory.isDirectory()) {
            logger.fine("Changing the permission of the directory " + directory.getAbsolutePath() + " to " + permission + " as " + homeOwner);
            String command = "chmod -R " + permission.trim() + " " + directory.getAbsolutePath();
            GISystemCall.ExecReturn retVal = GISystemCall.process(command, homeOwner, passwd);
            if (!retVal.isOK()) {
                throw new OPatchAutoException(Integer.toString(72149), new Object[]{directory});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] buff = new byte[1024];
            int bytesread = is.read(buff);
            while (bytesread != -1) {
                os.write(buff, 0, bytesread);
                bytesread = is.read(buff);
            }
        }
        finally {
            is.close();
            if (!os.equals(System.out)) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IOUtils.writeStream(is, os);
    }

    public static void copyFile(File in, File out) throws IOException {
        IOUtils.copyStream(new FileInputStream(in), new FileOutputStream(out));
    }

    public static void tryCopyFile(File in, File out) {
        try {
            IOUtils.copyFile(in, out);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to copy file", e);
        }
    }
}

