/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator;

import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import dbmodel.common.AbstractBaseTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap<Class<? extends AbstractBaseTarget>, List<? extends AbstractBaseTarget>> map = new HashMap();
    HashMap<String, List<? extends AbstractBaseTarget>> nameMap = new HashMap();
    HashMap<String, Object> properties = new HashMap();
    AbstractBaseTarget primary;

    public void setPrimaryTarget(AbstractBaseTarget t) {
        this.primary = t;
        this.putTarget(t);
    }

    public AbstractBaseTarget getPrimaryTarget() {
        return this.primary;
    }

    public void putTarget(AbstractBaseTarget target) {
        this.map.put(target.getClass(), Collections.singletonList(target));
        this.nameMap.put(target.getLeafClassName(), Collections.singletonList(target));
    }

    public void putTargets(List<? extends AbstractBaseTarget> targets) {
        if (targets.size() == 0) {
            throw new PatchPlanInternalException("Expected at least one target in putTargets");
        }
        Class<?> c = targets.get(0).getClass();
        for (AbstractBaseTarget abstractBaseTarget : targets) {
            if (abstractBaseTarget.getClass() == c) continue;
            throw new PatchPlanInternalException("Expected objects of the same type");
        }
        this.map.put(c, targets);
        this.nameMap.put(targets.get(0).getLeafClassName(), targets);
    }

    public <T extends AbstractBaseTarget> T getTarget(Class<T> c) {
        List<? extends AbstractBaseTarget> t = this.map.get(c);
        if (t == null || t.size() == 0) {
            t = this.lookTargetsOfSubclass(c);
        }
        if (t == null || t.size() == 0) {
            throw new PatchPlanInternalException("No target of type " + c.getName() + " in context");
        }
        if (t.size() != 1) {
            throw new PatchPlanInternalException("Expected one target of type " + c.getName() + " in context");
        }
        return (T)((AbstractBaseTarget)c.cast(t.get(0)));
    }

    public <T extends AbstractBaseTarget> List<T> getTargets(Class<T> c) {
        List<? extends AbstractBaseTarget> t = this.map.get(c);
        if (t == null || t.size() == 0) {
            t = this.lookTargetsOfSubclass(c);
        }
        if (t == null || t.size() == 0) {
            throw new PatchPlanInternalException("No target of type " + c.getName() + " in context");
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (AbstractBaseTarget abstractBaseTarget : t) {
            ret.add(c.cast(abstractBaseTarget));
        }
        return ret;
    }

    private List<? extends AbstractBaseTarget> lookTargetsOfSubclass(Class c) {
        List<? extends AbstractBaseTarget> t = null;
        for (Map.Entry<Class<? extends AbstractBaseTarget>, List<? extends AbstractBaseTarget>> pairs : this.map.entrySet()) {
            Class<? extends AbstractBaseTarget> cls = pairs.getKey();
            if (!c.isAssignableFrom(cls)) continue;
            t = pairs.getValue();
            break;
        }
        return t;
    }

    public <T extends AbstractBaseTarget> T getFirstTarget(Class<T> c) {
        List<? extends AbstractBaseTarget> t = this.map.get(c);
        if (t == null || t.size() == 0) {
            t = this.lookTargetsOfSubclass(c);
        }
        if (t == null || t.size() == 0) {
            throw new PatchPlanInternalException("No target of type " + c.getName() + " in context");
        }
        return (T)((AbstractBaseTarget)c.cast(t.get(0)));
    }

    public <T extends AbstractBaseTarget> T getLastTarget(Class<T> c) {
        List<? extends AbstractBaseTarget> t = this.map.get(c);
        if (t == null || t.size() == 0) {
            t = this.lookTargetsOfSubclass(c);
        }
        if (t == null || t.size() == 0) {
            throw new PatchPlanInternalException("No target of type " + c.getName() + " in context");
        }
        return (T)((AbstractBaseTarget)c.cast(t.get(t.size() - 1)));
    }

    public AbstractBaseTarget getFirstTarget(String typeName) {
        List<? extends AbstractBaseTarget> t = this.nameMap.get(typeName);
        if (t == null || t.size() == 0) {
            throw new PatchPlanInternalException("No target of type " + typeName + " in context");
        }
        return t.get(0);
    }

    public boolean hasTarget(Class c) {
        if (!this.map.containsKey(c)) {
            List<? extends AbstractBaseTarget> t = this.lookTargetsOfSubclass(c);
            return t != null && !t.isEmpty();
        }
        return true;
    }

    public List<String> getPatchIDs() {
        return (List)this.getProperty("patchIDs");
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

