/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.VariableResolver;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class GenericShellCommand
extends SimpleShellCommand {
    protected List<Command> automationCommands;

    public GenericShellCommand(CommandAction commandAction) {
        super((ActionType)commandAction);
        this.automationCommands = commandAction.getCommand();
    }

    public GenericShellCommand(ActionType automationAction, List<Command> automationCommands) {
        super(automationAction);
        this.automationCommands = automationCommands;
    }

    String getCmdString(Command c) {
        StringBuilder str = new StringBuilder();
        for (Command.EnvVar e : c.getEnvVar()) {
            str.append("export " + e.getName() + "=" + e.getValue() + "; ");
        }
        if (c.getCurrentWorkingDir() != null) {
            str.append("cd " + c.getCurrentWorkingDir() + "; ");
        }
        str.append(this.getSource(c));
        for (String arg : c.getParameter()) {
            str.append(" ").append(arg.trim());
        }
        return str.toString();
    }

    protected String getSource(Command c) {
        return c.getSource().getValue().trim();
    }

    protected String replaceParams(String cmd, CommandContext context) {
        cmd = VariableResolver.replaceContextProperties(cmd, context);
        return cmd;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        for (Command c : this.automationCommands) {
            String cmd = this.getCmdString(c);
            cmds.add(this.replaceParams(cmd, context));
        }
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<GenericShellCommand> {
        @Override
        public GenericShellCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || a.getType() == null || !a.getType().equals(CommandActionType.shell.toString())) {
                return null;
            }
            GenericShellCommand gsc = new GenericShellCommand((CommandAction)a);
            return gsc;
        }
    }
}

