/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatchTargetFilter {
    public Map<String, List<Home>> filter(Topology topology, ConfigGraph graph) {
        HashMap<String, List<Home>> filterdHomeList = new HashMap<String, List<Home>>();
        Set hosts = topology.getHosts();
        for (Host host : hosts) {
            for (Home home : host.getHomes()) {
                String version = home.getVersion();
                if (version == null) continue;
                if (filterdHomeList.containsKey(version)) {
                    ((List)filterdHomeList.get(version)).add(home);
                    continue;
                }
                ArrayList<Home> sortedHomes = new ArrayList<Home>();
                sortedHomes.add(home);
                filterdHomeList.put(version, sortedHomes);
            }
        }
        return filterdHomeList;
    }

    public Map<String, Home> findReferenceOpatchHome(Map<String, List<Home>> filteredHomeList, Home currentOpatchAutoHome) {
        HashMap<String, Home> opatchReferenceHomeList = new HashMap<String, Home>();
        Set<String> versionList = filteredHomeList.keySet();
        for (String version : versionList) {
            List<Home> tmpList = filteredHomeList.get(version);
            if (tmpList.size() == 1) {
                opatchReferenceHomeList.put(version, tmpList.get(0));
                continue;
            }
            if (currentOpatchAutoHome != null && tmpList.contains(currentOpatchAutoHome)) {
                opatchReferenceHomeList.put(version, currentOpatchAutoHome);
                continue;
            }
            boolean isFound = false;
            for (Home tmpHome : tmpList) {
                try {
                    boolean isLocalHost = !tmpHome.getHost().isRemote();
                    if (!isLocalHost) continue;
                    opatchReferenceHomeList.put(version, tmpHome);
                    isFound = true;
                    break;
                }
                catch (OPatchAutoException e) {
                }
            }
            if (isFound) continue;
            opatchReferenceHomeList.put(version, tmpList.get(0));
        }
        return opatchReferenceHomeList;
    }
}

