/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.CRSShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

public class GIStartupAction
extends CRSShutDownStartupAction {
    public GIStartupAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    @Override
    public List<ExecutionStep> generateCRSSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateCRSSteps(patchTarget);
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        boolean isRollback = this.getPatchSession().isRollback();
        boolean actsOnclone = false;
        ServiceStatus serviceStatus = ServiceStatus.UP;
        if (patchTarget.getHomeClone() != null) {
            actsOnclone = true;
            serviceStatus = ServiceStatus.DOWN;
            if (!isRollback) {
                String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
                generatedSteps.addAll(this.getUpdateBootStrappingInClone(patchTarget, targetHome));
            }
        }
        List<ExecutionStep> steps = null;
        if (!actsOnclone) {
            steps = this.getRootAddRDBMSCommandExecutionSteps(this.configGraph, patchTarget, "crs");
            generatedSteps.addAll(steps);
        }
        ArrayList<String> readMeMsg = new ArrayList<String>();
        if (isTwelveVersion) {
            if (isRollback) {
                readMeMsg.add("Rootcrs-Postpatch-Rollback-Title");
                readMeMsg.add("Rootcrs-Postpatch-Rollback-Reboot-Message");
                steps = primarypatchVersion.startsWith("12.1.0.1") ? this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnclone, DBCommandParameters.POSTPATCH.getValue()) : this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnclone, DBCommandParameters.POSTPATCH.getValue(), DBCommandParameters.ROLLBACK.getValue());
            } else {
                readMeMsg.add("Rootcrs-Postpatch-Title");
                readMeMsg.add("Rootcrs-Postpatch-Reboot-Message");
                steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnclone, DBCommandParameters.POSTPATCH.getValue());
            }
            generatedSteps.addAll(steps);
        } else {
            readMeMsg.add("Rootcrs-Patch-Title");
            readMeMsg.add("Rootcrs-Patch-Message");
            steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, CommandActionType.shell.toString(), false, DBCommandParameters.PATCH.getValue());
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isSuccess() && this.getPatchSession().getPatchTracking() != null && !DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions()) && DBCommandUtils.isGIAndRACPatchingRequested()) {
            boolean isInstanceUpdateRequired = false;
            List<RACDatabase> racDBs = PatchPlanner.getInstance().getConfigGraph().getTargets(RACDatabase.class);
            for (RACDatabase racDB : racDBs) {
                if (!racDB.getType().equals("policyManaged")) continue;
                isInstanceUpdateRequired = true;
                break;
            }
            if (isInstanceUpdateRequired) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    this._logger.warning("InterruptedException: " + e.getMessage());
                }
                this.refreshOracleSIDForPolicyDB(patchTarget);
            }
        }
    }

    private void refreshOracleSIDForPolicyDB(PatchTarget patchTarget) throws OPatchAutoException {
        String crsHome = patchTarget.getHome().getLocation();
        String resultObjectLocation = crsHome + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "latestDB.obj";
        boolean isSIRefreshed = false;
        String command = this.getCommandToQueryLatestDB(crsHome, resultObjectLocation);
        Credential cred = this.getCredentials(patchTarget);
        GISystemCall.ExecReturn ret = GISystemCall.process(command, patchTarget.getHome().getOwner(), cred);
        if (ret.isOK()) {
            try {
                List refreshedRACDBList = (List)FileUtility.deserializeDataObj((String)resultObjectLocation);
                new File(resultObjectLocation).delete();
                block5: for (RACDatabase db : refreshedRACDBList) {
                    List<RACDatabase> racDBList = PatchPlanner.getInstance().getConfigGraph().getTargets(RACDatabase.class);
                    for (RACDatabase racDB : racDBList) {
                        if (!racDB.getDatabaseName().equals(db.getDatabaseName())) continue;
                        boolean isRefresh = this.refreshInstance(db.getDbInstances(), racDB.getDbInstances());
                        if (!isRefresh || isSIRefreshed) continue block5;
                        isSIRefreshed = true;
                        continue block5;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                this._logger.warning("ClassNotFoundException: " + e.getMessage());
                throw new OPatchAutoException((Throwable)e);
            }
            catch (IOException e) {
                this._logger.warning("IOException: " + e.getMessage());
                throw new OPatchAutoException((Throwable)e);
            }
        } else {
            throw new OPatchAutoException("OPatchauto failed to refresh the system configuration details due to " + ret.getErrorMessage(), new Object[0]);
        }
        this._logger.info("isSIRefreshed: " + isSIRefreshed);
        if (isSIRefreshed) {
            try {
                PatchPlanner.getInstance().getSystemInstance().writeFile(new File(PatchPlanner.getInstance().getSystemInstanceFilePath()));
            }
            catch (FileNotFoundException e) {
                this._logger.warning("FileNotFoundException: " + e.getMessage());
                throw new OPatchAutoException((Throwable)e);
            }
        }
    }

    private Credential getCredentials(PatchTarget patchTarget) throws OPatchAutoException {
        String owner = patchTarget.getHome().getOwner();
        CredentialManager credentialMgr = this.getPatchSession().getCredentialManager();
        Credential cred = null;
        if (null != owner && !"root".equals(owner)) {
            cred = credentialMgr.getCredential(patchTarget.getHost().getHost(), null, owner);
        }
        if (cred == null) {
            String currentUser = System.getProperty("user.name");
            cred = credentialMgr.getCredential(patchTarget.getHost().getHost(), null, currentUser);
        }
        return cred;
    }

    private boolean refreshInstance(List<RACDBInstance> dbInstList, List<RACDBInstance> racDBInst) {
        boolean refreshInstance = false;
        block0: for (RACDBInstance dbInst : dbInstList) {
            String nodeName = dbInst.getHostName();
            String instName = dbInst.getInstanceName();
            this._logger.finest("nodeName: " + nodeName);
            this._logger.finest("instName: " + instName);
            for (RACDBInstance inst : racDBInst) {
                this._logger.finest("inst node: " + inst.getHost().getHostName());
                this._logger.finest("inst name: " + inst.getInstanceName());
                if (!nodeName.equals(inst.getHost().getHostName())) continue;
                if (instName.equals(inst.getInstanceName())) continue block0;
                inst.setInstanceName(instName);
                inst.setName(instName);
                refreshInstance = true;
                continue block0;
            }
        }
        this._logger.finest("refreshInstance: " + refreshInstance);
        return refreshInstance;
    }

    private String getCommandToQueryLatestDB(String gridHomePath, String objLoc) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(gridHomePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder command = new StringBuilder();
        command.append((CharSequence)perlPath);
        command.append(gridHomePath);
        command.append(ProductDriverConstants.OPATCHAUTO_BIN);
        command.append("OPatchAutoHelper.pl ");
        command.append(" -ACTION=").append("getPolicyDB");
        command.append(" -GRID_HOME=").append(gridHomePath);
        command.append(" -OBJECTLOC=").append(objLoc);
        command.append(" -JVM_HANDLER=com/oracle/glcm/patch/auto/db/integration/controller/CrsConfigurationHelper ");
        this._logger.info("command: " + command.toString());
        return command.toString();
    }
}

