/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.patch;

import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.patch.PatchCollectionException;
import com.oracle.glcm.patch.auto.db.product.patch.BundlePatchObject;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchInformationInitializer {
    private static PatchInformationInitializer _instance;
    private BundlePatchObject bundlePatchObj;
    private static final Logger _log;

    private PatchInformationInitializer() {
    }

    public static PatchInformationInitializer getInstance() {
        if (_instance == null) {
            _instance = new PatchInformationInitializer();
        }
        return _instance;
    }

    public PatchPackagesBag createPatch(PatchInfo patchInfo) throws PatchCollectionException {
        this.bundlePatchObj = null;
        try {
            this.bundlePatchObj = new BundlePatchObject(patchInfo);
        }
        catch (Exception e) {
            PatchCollectionException pce = new PatchCollectionException(e.getMessage());
            pce.setStackTrace(e.getStackTrace());
            throw pce;
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest(this.bundlePatchObj.toString());
        }
        return this.bundlePatchObj.getPatchPackagesBag();
    }

    public BundlePatchObject getBundlePatchObject() {
        return this.bundlePatchObj;
    }

    public List<File> getPatchList(String productType) {
        List<File> patchList = new ArrayList<File>();
        if (this.bundlePatchObj != null) {
            patchList = productType.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || productType.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()) ? this.bundlePatchObj.getCRSPatchList() : this.bundlePatchObj.getRACPatchList();
        }
        return patchList;
    }

    public List<String> getPatchIDList(String productType) {
        List<String> patchIDList = new ArrayList<String>();
        if (this.bundlePatchObj != null) {
            patchIDList = productType.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || productType.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()) ? this.bundlePatchObj.getCRSPatchIDList() : this.bundlePatchObj.getDBPatchIDList();
        }
        return patchIDList;
    }

    static {
        _log = Logger.getLogger(PatchInformationInitializer.class.getName());
    }
}

